.if t .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W October 18th, 1994\"
.TH SND_STOP PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
SND_STOP troff documentation \- Version 1(7) 18\-Oct\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.SH Name
.br
snd_stop,  snd_buf_stop \- Stops the sound output or stops recording.

.SH Syntax
.br
.B void far snd_stop((short) 0, time);
.br
.B unsigned short time;
.br
.B void far snd_buf_stop(pSound);
.br
.B SNDHDR far *pSound;
.br

.SH Description
\fISnd_stop\fR terminates any recording or playback operation that is
in progress immediately or at a designated elapsed time.

If \fItime\fR is \fB0\fR, the player or recorder stops within 100 milliseconds
of its current position.  If a file record is being performed, the remaining
sound data will be written to the file and the file header is 
updated.

If \fItime\fR is non-zero, the player or recorder will stop within 100
milliseconds of the specified time.  \fITime\fR is specified in hundreds
of milliseconds.

\fISnd_buf_stop\fR can cause playback to be terminated when a particular
sound buffer is about to be played.  This is useful if several sounds
are queued for playback and then some of the audio is not to be played.
If sound buffers contained individual words or sentences, playback can be
terminated cleanly between words or sentences.

\fISnd_buf_stop\fR calls \fIsnd_flush\fR(PSSJ) internally to
start the player and force any remaining audio into the play buffers.
Once the player starts, sound output continues until the specified sound
buffer is encountered, and then output stops.  If \fIsnd_buf_stop\fR
is called and the sound is not in the play queue because it has already
played or was never in the queue, \fIsnd_buf_stop\fR output stops within
100 milliseconds of the current position.

If \fIsnd_flush\fR(PSSJ) is not called before \fIsnd_buf_stop\fR is called
and \fIpSound\fR points to a sound that is within the last 100 milliseconds
of sound passed to \fIsnd_play\fR(PSSJ), \fIsnd_buf_stop\fR may not find it.
If not, \fIsnd_buf_stop\fR will stop within 100 milliseconds.

After the player stops due to a \fIsnd_stop\fR or \fIsnd_buf_stop\fR
call, all unplayed sounds are removed from the play queue.

\fISnd_buf_stop\fR halts recording operations immediately.
.if n .bp
.if t .sp
When \fIsnd_stop\fR or \fIsnd_buf_stop\fR stop a recording, up to
100 milliseconds of the most recently recorded sound will be discarded.
The length of the sound stored in the current record buffer is set,
and if an additional buffer provided by a call to \fIsnd_record\fR(PSSJ)
was standing by, the length field in that buffer is set to zero (meaning, 
no contents).

.SH Notes
Note that during recording that if the threshold mode is enabled,
the elapsed recording time used by \fIsnd_stop\fR to determine when
to stop does not change during periods of silence since they
are not written to disk.  The \fIsnd_stop\fR can block an indefinite
amount of time if silence is being detected and deleted.  See
\fIsnd_record\fR(PSSJ) and \fIsnd_file_record\fR(PSSJ) for more
information.
.if t .bp
.if n .sp
The ability to synchronize on a sound structure using \fIsnd_buf_stop\fR
returns meaningless results when used during \fIsnd_file_play\fR(PSSJ)
and \fIsnd_file_record\fR(PSSJ) calls, and should not be used.

The longest recording that \fIsnd_stop\fR can time is 6553.4 seconds, or
1.8 hours.  While in play mode, if \fIpSound\fR is NULL and the player
is running, output stops within 100 milliseconds.  If \fIpSound\fR is NULL and
the player is not running, no sound will be output.  If \fIpSound\fR is
not NULL, the player is not running, and the first sound in the queue is
the one that is to be the stopping point, no sound is output.

.SH Return Values
None.

.SH See Also
snd_play(PSSJ), snd_file_play(PSSJ),
snd_record(PSSJ), snd_file_record(PSSJ),
snd_flush(PSSJ)

.SH Credit
\fISnd_stop\fR(PSSJ) and \fIsnd_buf_stop\fR(PSSJ) are part of the PSSJ
Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro\fR(PSSJ) for
restrictions.
.br
\-\-\-\-\-\-
.br
410187
