;------------------------------------------------------------------------
;                                                                        
; CSRKEYS.INC Key Codes Include File for DMCSR
;                                                                        
;------------------------------------------------------------------------

; CTRL'ed A-Z 
CTRL_A      equ (CTRL_TAG+'A'-40h)
CTRL_B      equ (CTRL_TAG+'B'-40h)
CTRL_C      equ (CTRL_TAG+'C'-40h)
CTRL_D      equ (CTRL_TAG+'D'-40h)
CTRL_E      equ (CTRL_TAG+'E'-40h)
CTRL_F      equ (CTRL_TAG+'F'-40h)
CTRL_G      equ (CTRL_TAG+'G'-40h)
CTRL_H      equ (CTRL_TAG+'H'-40h)
CTRL_I      equ (CTRL_TAG+'I'-40h)
CTRL_J      equ (CTRL_TAG+'J'-40h)
CTRL_K      equ (CTRL_TAG+'K'-40h)
CTRL_L      equ (CTRL_TAG+'L'-40h)
CTRL_M      equ (CTRL_TAG+'M'-40h)
CTRL_N      equ (CTRL_TAG+'N'-40h)
CTRL_O      equ (CTRL_TAG+'O'-40h)
CTRL_P      equ (CTRL_TAG+'P'-40h)
CTRL_Q      equ (CTRL_TAG+'Q'-40h)
CTRL_R      equ (CTRL_TAG+'R'-40h)
CTRL_S      equ (CTRL_TAG+'S'-40h)
CTRL_T      equ (CTRL_TAG+'T'-40h)
CTRL_U      equ (CTRL_TAG+'U'-40h)
CTRL_V      equ (CTRL_TAG+'V'-40h)
CTRL_W      equ (CTRL_TAG+'W'-40h)
CTRL_X      equ (CTRL_TAG+'X'-40h)
CTRL_Y      equ (CTRL_TAG+'Y'-40h)
CTRL_Z      equ (CTRL_TAG+'Z'-40h)

; ALT'ed A-Z 
ALT_A       equ (ALT_TAG+'A')
ALT_B       equ (ALT_TAG+'B')
ALT_C       equ (ALT_TAG+'C')
ALT_D       equ (ALT_TAG+'D')
ALT_E       equ (ALT_TAG+'E')
ALT_F       equ (ALT_TAG+'F')
ALT_G       equ (ALT_TAG+'G')
ALT_H       equ (ALT_TAG+'H')
ALT_I       equ (ALT_TAG+'I')
ALT_J       equ (ALT_TAG+'J')
ALT_K       equ (ALT_TAG+'K')
ALT_L       equ (ALT_TAG+'L')
ALT_M       equ (ALT_TAG+'M')
ALT_N       equ (ALT_TAG+'N')
ALT_O       equ (ALT_TAG+'O')
ALT_P       equ (ALT_TAG+'P')
ALT_Q       equ (ALT_TAG+'Q')
ALT_R       equ (ALT_TAG+'R')
ALT_S       equ (ALT_TAG+'S')
ALT_T       equ (ALT_TAG+'T')
ALT_U       equ (ALT_TAG+'U')
ALT_V       equ (ALT_TAG+'V')
ALT_W       equ (ALT_TAG+'W')
ALT_X       equ (ALT_TAG+'X')
ALT_Y       equ (ALT_TAG+'Y')
ALT_Z       equ (ALT_TAG+'Z')

; These defines allow a swap for 1987 compatibility 
OLD_CTRL_UP_ARROW       equ (WDG_TAG+13h)
OLD_CTRL_DOWN_ARROW     equ (WDG_TAG+14h)
OLD_PGUP_KEY            equ (SYS_TAG+49h)
OLD_PGDN_KEY            equ (SYS_TAG+51h)

; Arrow keys 
UP_ARROW                equ (SYS_TAG+48h)
DOWN_ARROW              equ (SYS_TAG+50h)
LEFT_ARROW              equ (SYS_TAG+4Bh)
RIGHT_ARROW             equ (SYS_TAG+4Dh)

SHFT_UP_ARROW           equ (WDG_TAG+0Fh)
SHFT_DOWN_ARROW         equ (WDG_TAG+12h)
SHFT_LEFT_ARROW         equ (WDG_TAG+10h)
SHFT_RIGHT_ARROW        equ (WDG_TAG+11h)

CTRL_UP_ARROW           equ OLD_PGUP_KEY
CTRL_DOWN_ARROW         equ OLD_PGDN_KEY
CTRL_LEFT_ARROW         equ (SYS_TAG+73h)
CTRL_RIGHT_ARROW        equ (SYS_TAG+74h)

ALT_UP_ARROW            equ (WDG_TAG+15h)
ALT_DOWN_ARROW          equ (WDG_TAG+16h)
ALT_LEFT_ARROW          equ (WDG_TAG+17h)
ALT_RIGHT_ARROW         equ (WDG_TAG+18h)

SHFT_CTRL_UP_ARROW      equ (WDG_TAG+1Bh)
SHFT_CTRL_DOWN_ARROW    equ (WDG_TAG+1Ch)
SHFT_CTRL_LEFT_ARROW    equ (WDG_TAG+1Dh)
SHFT_CTRL_RIGHT_ARROW   equ (WDG_TAG+1Fh)

; Function keys 
SHFT_F1     equ (SYS_TAG+54h)
SHFT_F2     equ (SYS_TAG+55h)
SHFT_F3     equ (SYS_TAG+56h)
SHFT_F4     equ (SYS_TAG+57h)
SHFT_F5     equ (SYS_TAG+58h)
SHFT_F6     equ (SYS_TAG+59h)
SHFT_F7     equ (SYS_TAG+5Ah)
SHFT_F8     equ (SYS_TAG+5Bh)
SHFT_F9     equ (SYS_TAG+5Ch)
SHFT_F10    equ (SYS_TAG+5Dh)

F1          equ (SYS_TAG+3Bh)
F2          equ (SYS_TAG+3Ch)
F3          equ (SYS_TAG+3Dh)
F4          equ (SYS_TAG+3Eh)
F5          equ (SYS_TAG+3Fh)
F6          equ (SYS_TAG+40h)
F7          equ (SYS_TAG+41h)
F8          equ (SYS_TAG+42h)
F9          equ (SYS_TAG+43h)
F10         equ (SYS_TAG+44h)
F11         equ SHFT_F1

CTRL_F1     equ (SYS_TAG+5Eh)
CTRL_F2     equ (SYS_TAG+5Fh)
CTRL_F3     equ (SYS_TAG+60h)
CTRL_F4     equ (SYS_TAG+61h)
CTRL_F5     equ (SYS_TAG+62h)
CTRL_F6     equ (SYS_TAG+63h)
CTRL_F7     equ (SYS_TAG+64h)
CTRL_F8     equ (SYS_TAG+65h)
CTRL_F9     equ (SYS_TAG+66h)
CTRL_F10    equ (SYS_TAG+67h)

ALT_F1      equ (SYS_TAG+68h)
ALT_F2      equ (SYS_TAG+69h)
ALT_F3      equ (SYS_TAG+6Ah)
ALT_F4      equ (SYS_TAG+6Bh)
ALT_F5      equ (SYS_TAG+6Ch)
ALT_F6      equ (SYS_TAG+6Dh)
ALT_F7      equ (SYS_TAG+6Eh)
ALT_F8      equ (SYS_TAG+6Fh)
ALT_F9      equ (SYS_TAG+70h)
ALT_F10     equ (SYS_TAG+71h)

; HOME, END, PGUP and PGDN keys 
HOME_KEY            equ (SYS_TAG+47h)
END_KEY             equ (SYS_TAG+4Fh)
PGUP_KEY            equ OLD_CTRL_UP_ARROW
PGDN_KEY            equ OLD_CTRL_DOWN_ARROW

SHFT_HOME_KEY       equ (WDG_TAG+0Eh)
SHFT_END_KEY        equ (WDG_TAG+0Dh)
SHFT_PGUP_KEY       equ (WDG_TAG+0Bh)
SHFT_PGDN_KEY       equ (WDG_TAG+0Ch)

CTRL_HOME_KEY       equ (SYS_TAG+77h)
CTRL_END_KEY        equ (SYS_TAG+75h)
CTRL_PGUP_KEY       equ (WDG_TAG+00h)
CTRL_PGDN_KEY       equ (SYS_TAG+76h)

SHFT_CTRL_HOME_KEY  equ (WDG_TAG+20h)
SHFT_CTRL_END_KEY   equ (WDG_TAG+21h)
SHFT_CTRL_PGUP_KEY  equ (WDG_TAG+22h)
SHFT_CTRL_PGDN_KEY  equ (WDG_TAG+23h)

; INSERT and DELETE keys 
INSERT_KEY          equ (SYS_TAG+52h)
DELETE_KEY          equ (SYS_TAG+53h)

SHFT_INSERT_KEY     equ (WDG_TAG+24h)
SHFT_DELETE_KEY     equ (WDG_TAG+25h)

CTRL_INSERT_KEY     equ (WDG_TAG+19h)
CTRL_DELETE_KEY     equ (WDG_TAG+1Ah)

; SPACEBAR, BACKSPACE and TAB keys 
SPACE_KEY           equ (ASCII_TAG+20h)
BKSPACE_KEY         equ (ASCII_TAG+08h)
TAB_KEY             equ (ASCII_TAG+09h)

SHFT_SPACE_KEY      equ (WDG_TAG+04h)
SHFT_BKSPACE_KEY    equ (WDG_TAG+01h)
SHFT_TAB_KEY        equ (SYS_TAG+0Fh)

CTRL_SPACE_KEY      equ (WDG_TAG+05h)

ALT_TAB_KEY         equ (SYS_TAG+8Eh)
ALT_BKSPACE_KEY     equ (WDG_TAG+26h)

; Miscellaneous keys 
SHFT_RETURN_KEY     equ (WDG_TAG+02h)
BRK_KEY             equ (SYS_TAG+80h)
PRINT_KEY           equ (ASCII_TAG+10h)
ABORT_KEY           equ CSR_ERROR
ALT_EQUAL           equ (SYS_TAG+83h)

; Big select keys 
BIG_SLCT_UP_ARROW       equ (BIG_TAG+0Bh)
BIG_SLCT_DOWN_ARROW     equ (BIG_TAG+0Ch)
BIG_SLCT_LEFT_ARROW     equ (BIG_TAG+4Bh)
BIG_SLCT_RIGHT_ARROW    equ (BIG_TAG+4Dh)
BIG_SLCT_HOME_KEY       equ (BIG_TAG+0Eh)
BIG_SLCT_END_KEY        equ (BIG_TAG+0Dh)

; Extended key codes 
EC_PREVIOUS         equ ALT_P
EC_NEXT             equ ALT_N
EC_FIRST            equ ALT_F
EC_LAST             equ ALT_L

EC_INSERT_MODE      equ ALT_I
EC_OVERTYPE_MODE    equ ALT_O

EC_SAVE             equ ALT_S
EC_QUIT             equ ESC_KEY

EC_MOVE_FOCUS_FWRD  equ TAB_KEY
EC_MOVE_FOCUS_BKWD  equ SHFT_TAB_KEY

EC_SELECT           equ SPACE_KEY
EC_CANCEL           equ ESC_KEY

EC_TAB_CURSOR       equ TAB_KEY
EC_BACKSPACE        equ BKSPACE_KEY
EC_BACK_TAB         equ SHFT_TAB_KEY

EC_INSERT           equ INSERT_KEY
EC_DELETE           equ DELETE_KEY

EC_HOME_CURSOR      equ CTRL_HOME_KEY
EC_END_CURSOR       equ CTRL_END_KEY
EC_LINE_START       equ HOME_KEY
EC_LINE_END         equ END_KEY

EC_CURSOR_UP        equ UP_ARROW
EC_CURSOR_DOWN      equ DOWN_ARROW
EC_CURSOR_LEFT      equ LEFT_ARROW
EC_CURSOR_RIGHT     equ RIGHT_ARROW

EC_SELECT_UP        equ SHFT_UP_ARROW
EC_SELECT_DOWN      equ SHFT_DOWN_ARROW
EC_SELECT_LEFT      equ SHFT_LEFT_ARROW
EC_SELECT_RIGHT     equ SHFT_RIGHT_ARROW

EC_SELECT_HOME      equ SHFT_CTRL_HOME_KEY
EC_SELECT_END       equ SHFT_CTRL_END_KEY
EC_SEL_LINE_START   equ BIG_SLCT_HOME_KEY
EC_SEL_LINE_END     equ BIG_SLCT_END_KEY

EC_GROUP_SEL_UP     equ SHFT_CTRL_UP_ARROW
EC_GROUP_SEL_DOWN   equ SHFT_CTRL_DOWN_ARROW
EC_GROUP_SEL_LEFT   equ SHFT_CTRL_LEFT_ARROW
EC_GROUP_SEL_RIGHT  equ SHFT_CTRL_RIGHT_ARROW

EC_PAGE_SEL_UP      equ BIG_SLCT_UP_ARROW
EC_PAGE_SEL_DOWN    equ BIG_SLCT_DOWN_ARROW
EC_PAGE_SEL_LEFT    equ SHFT_CTRL_PGUP_KEY
EC_PAGE_SEL_RIGHT   equ SHFT_CTRL_PGDN_KEY

EC_PAGE_UP          equ PGUP_KEY
EC_PAGE_DOWN        equ PGDN_KEY
EC_PAGE_LEFT        equ CTRL_PGUP_KEY
EC_PAGE_RIGHT       equ CTRL_PGDN_KEY

EC_CUT              equ SHFT_DELETE_KEY
EC_PASTE            equ SHFT_INSERT_KEY
EC_COPY             equ CTRL_INSERT_KEY
EC_CLEAR            equ DELETE_KEY

EC_ALT_UP           equ ALT_UP_ARROW
EC_ALT_DOWN         equ ALT_DOWN_ARROW
EC_ALT_LEFT         equ ALT_LEFT_ARROW
EC_ALT_RIGHT        equ ALT_RIGHT_ARROW

EC_GO               equ RETURN_KEY

EC_GROUP_UP         equ CTRL_UP_ARROW
EC_GROUP_DOWN       equ CTRL_DOWN_ARROW
EC_GROUP_LEFT       equ CTRL_LEFT_ARROW
EC_GROUP_RIGHT      equ CTRL_RIGHT_ARROW

;end of CSRKEYS.INC
