/*------------------------------------------------------------------------*/
/*                                                                        */
/* CSRKEYS.H Key Codes Include File for DMCSR                             */
/*                                                                        */
/*------------------------------------------------------------------------*/

#ifndef CSRKEYS_INCLUDED
#define CSRKEYS_INCLUDED 1

/* CTRL'ed A-Z */
#define CTRL_A      (CTRL_TAG+'A'-0x40)
#define CTRL_B      (CTRL_TAG+'B'-0x40)
#define CTRL_C      (CTRL_TAG+'C'-0x40)
#define CTRL_D      (CTRL_TAG+'D'-0x40)
#define CTRL_E      (CTRL_TAG+'E'-0x40)
#define CTRL_F      (CTRL_TAG+'F'-0x40)
#define CTRL_G      (CTRL_TAG+'G'-0x40)
#define CTRL_H      (CTRL_TAG+'H'-0x40)
#define CTRL_I      (CTRL_TAG+'I'-0x40)
#define CTRL_J      (CTRL_TAG+'J'-0x40)
#define CTRL_K      (CTRL_TAG+'K'-0x40)
#define CTRL_L      (CTRL_TAG+'L'-0x40)
#define CTRL_M      (CTRL_TAG+'M'-0x40)
#define CTRL_N      (CTRL_TAG+'N'-0x40)
#define CTRL_O      (CTRL_TAG+'O'-0x40)
#define CTRL_P      (CTRL_TAG+'P'-0x40)
#define CTRL_Q      (CTRL_TAG+'Q'-0x40)
#define CTRL_R      (CTRL_TAG+'R'-0x40)
#define CTRL_S      (CTRL_TAG+'S'-0x40)
#define CTRL_T      (CTRL_TAG+'T'-0x40)
#define CTRL_U      (CTRL_TAG+'U'-0x40)
#define CTRL_V      (CTRL_TAG+'V'-0x40)
#define CTRL_W      (CTRL_TAG+'W'-0x40)
#define CTRL_X      (CTRL_TAG+'X'-0x40)
#define CTRL_Y      (CTRL_TAG+'Y'-0x40)
#define CTRL_Z      (CTRL_TAG+'Z'-0x40)

/* ALT'ed A-Z */
#define ALT_A       (ALT_TAG+'A')
#define ALT_B       (ALT_TAG+'B')
#define ALT_C       (ALT_TAG+'C')
#define ALT_D       (ALT_TAG+'D')
#define ALT_E       (ALT_TAG+'E')
#define ALT_F       (ALT_TAG+'F')
#define ALT_G       (ALT_TAG+'G')
#define ALT_H       (ALT_TAG+'H')
#define ALT_I       (ALT_TAG+'I')
#define ALT_J       (ALT_TAG+'J')
#define ALT_K       (ALT_TAG+'K')
#define ALT_L       (ALT_TAG+'L')
#define ALT_M       (ALT_TAG+'M')
#define ALT_N       (ALT_TAG+'N')
#define ALT_O       (ALT_TAG+'O')
#define ALT_P       (ALT_TAG+'P')
#define ALT_Q       (ALT_TAG+'Q')
#define ALT_R       (ALT_TAG+'R')
#define ALT_S       (ALT_TAG+'S')
#define ALT_T       (ALT_TAG+'T')
#define ALT_U       (ALT_TAG+'U')
#define ALT_V       (ALT_TAG+'V')
#define ALT_W       (ALT_TAG+'W')
#define ALT_X       (ALT_TAG+'X')
#define ALT_Y       (ALT_TAG+'Y')
#define ALT_Z       (ALT_TAG+'Z')

/* These defines allow a swap for 1987 compatibility */
#define OLD_CTRL_UP_ARROW       (WDG_TAG+0x13)
#define OLD_CTRL_DOWN_ARROW     (WDG_TAG+0x14)
#define OLD_PGUP_KEY            (SYS_TAG+0x49)
#define OLD_PGDN_KEY            (SYS_TAG+0x51)

/* Arrow keys */
#define UP_ARROW                (SYS_TAG+0x48)
#define DOWN_ARROW              (SYS_TAG+0x50)
#define LEFT_ARROW              (SYS_TAG+0x4B)
#define RIGHT_ARROW             (SYS_TAG+0x4D)

#define SHFT_UP_ARROW           (WDG_TAG+0x0F)
#define SHFT_DOWN_ARROW         (WDG_TAG+0x12)
#define SHFT_LEFT_ARROW         (WDG_TAG+0x10)
#define SHFT_RIGHT_ARROW        (WDG_TAG+0x11)

#define CTRL_UP_ARROW           OLD_PGUP_KEY
#define CTRL_DOWN_ARROW         OLD_PGDN_KEY
#define CTRL_LEFT_ARROW         (SYS_TAG+0x73)
#define CTRL_RIGHT_ARROW        (SYS_TAG+0x74)

#define ALT_UP_ARROW            (WDG_TAG+0x15)
#define ALT_DOWN_ARROW          (WDG_TAG+0x16)
#define ALT_LEFT_ARROW          (WDG_TAG+0x17)
#define ALT_RIGHT_ARROW         (WDG_TAG+0x18)

#define SHFT_CTRL_UP_ARROW      (WDG_TAG+0x1B)
#define SHFT_CTRL_DOWN_ARROW    (WDG_TAG+0x1C)
#define SHFT_CTRL_LEFT_ARROW    (WDG_TAG+0x1D)
#define SHFT_CTRL_RIGHT_ARROW   (WDG_TAG+0x1F)

/* Function keys */
#define SHFT_F1     (SYS_TAG+0x54)
#define SHFT_F2     (SYS_TAG+0x55)
#define SHFT_F3     (SYS_TAG+0x56)
#define SHFT_F4     (SYS_TAG+0x57)
#define SHFT_F5     (SYS_TAG+0x58)
#define SHFT_F6     (SYS_TAG+0x59)
#define SHFT_F7     (SYS_TAG+0x5A)
#define SHFT_F8     (SYS_TAG+0x5B)
#define SHFT_F9     (SYS_TAG+0x5C)
#define SHFT_F10    (SYS_TAG+0x5D)

#define F1          (SYS_TAG+0x3B)
#define F2          (SYS_TAG+0x3C)
#define F3          (SYS_TAG+0x3D)
#define F4          (SYS_TAG+0x3E)
#define F5          (SYS_TAG+0x3F)
#define F6          (SYS_TAG+0x40)
#define F7          (SYS_TAG+0x41)
#define F8          (SYS_TAG+0x42)
#define F9          (SYS_TAG+0x43)
#define F10         (SYS_TAG+0x44)
#define F11         SHFT_F1

#define CTRL_F1     (SYS_TAG+0x5E)
#define CTRL_F2     (SYS_TAG+0x5F)
#define CTRL_F3     (SYS_TAG+0x60)
#define CTRL_F4     (SYS_TAG+0x61)
#define CTRL_F5     (SYS_TAG+0x62)
#define CTRL_F6     (SYS_TAG+0x63)
#define CTRL_F7     (SYS_TAG+0x64)
#define CTRL_F8     (SYS_TAG+0x65)
#define CTRL_F9     (SYS_TAG+0x66)
#define CTRL_F10    (SYS_TAG+0x67)

#define ALT_F1      (SYS_TAG+0x68)
#define ALT_F2      (SYS_TAG+0x69)
#define ALT_F3      (SYS_TAG+0x6A)
#define ALT_F4      (SYS_TAG+0x6B)
#define ALT_F5      (SYS_TAG+0x6C)
#define ALT_F6      (SYS_TAG+0x6D)
#define ALT_F7      (SYS_TAG+0x6E)
#define ALT_F8      (SYS_TAG+0x6F)
#define ALT_F9      (SYS_TAG+0x70)
#define ALT_F10     (SYS_TAG+0x71)

/* HOME, END, PGUP and PGDN keys */
#define HOME_KEY            (SYS_TAG+0x47)
#define END_KEY             (SYS_TAG+0x4F)
#define PGUP_KEY            OLD_CTRL_UP_ARROW
#define PGDN_KEY            OLD_CTRL_DOWN_ARROW

#define SHFT_HOME_KEY       (WDG_TAG+0x0E)
#define SHFT_END_KEY        (WDG_TAG+0x0D)
#define SHFT_PGUP_KEY       (WDG_TAG+0x0B)
#define SHFT_PGDN_KEY       (WDG_TAG+0x0C)

#define CTRL_HOME_KEY       (SYS_TAG+0x77)
#define CTRL_END_KEY        (SYS_TAG+0x75)
#define CTRL_PGUP_KEY       (WDG_TAG+0x00)
#define CTRL_PGDN_KEY       (SYS_TAG+0x76)

#define SHFT_CTRL_HOME_KEY  (WDG_TAG+0x20)
#define SHFT_CTRL_END_KEY   (WDG_TAG+0x21)
#define SHFT_CTRL_PGUP_KEY  (WDG_TAG+0x22)
#define SHFT_CTRL_PGDN_KEY  (WDG_TAG+0x23)

/* INSERT and DELETE keys */
#define INSERT_KEY          (SYS_TAG+0x52)
#define DELETE_KEY          (SYS_TAG+0x53)

#define SHFT_INSERT_KEY     (WDG_TAG+0x24)
#define SHFT_DELETE_KEY     (WDG_TAG+0x25)

#define CTRL_INSERT_KEY     (WDG_TAG+0x19)
#define CTRL_DELETE_KEY     (WDG_TAG+0x1A)

/* SPACEBAR, BACKSPACE and TAB keys */
#define SPACE_KEY           (ASCII_TAG+0x20)
#define BKSPACE_KEY         (ASCII_TAG+0x08)
#define TAB_KEY             (ASCII_TAG+0x09)

#define SHFT_SPACE_KEY      (WDG_TAG+0x04)
#define SHFT_BKSPACE_KEY    (WDG_TAG+0x01)
#define SHFT_TAB_KEY        (SYS_TAG+0x0F)

#define CTRL_SPACE_KEY      (WDG_TAG+0x05)

#define ALT_TAB_KEY         (SYS_TAG+0x8E)
#define ALT_BKSPACE_KEY     (WDG_TAG+0x26)

/* Miscellaneous keys */
#define SHFT_RETURN_KEY     (WDG_TAG+0x02)
#define BRK_KEY             (SYS_TAG+0x80)
#define PRINT_KEY           (ASCII_TAG+0x10)
#define ABORT_KEY           CSR_ERROR
#define ALT_EQUAL           (SYS_TAG+0x83)

/* Big select keys */
#define BIG_SLCT_UP_ARROW       (BIG_TAG+0x0B)
#define BIG_SLCT_DOWN_ARROW     (BIG_TAG+0x0C)
#define BIG_SLCT_LEFT_ARROW     (BIG_TAG+0x4B)
#define BIG_SLCT_RIGHT_ARROW    (BIG_TAG+0x4D)
#define BIG_SLCT_HOME_KEY       (BIG_TAG+0x0E)
#define BIG_SLCT_END_KEY        (BIG_TAG+0x0D)

/* Extended key codes */
#define EC_PREVIOUS         ALT_P
#define EC_NEXT             ALT_N
#define EC_FIRST            ALT_F
#define EC_LAST             ALT_L

#define EC_INSERT_MODE      ALT_I
#define EC_OVERTYPE_MODE    ALT_O

#define EC_SAVE             ALT_S
#define EC_QUIT             ESC_KEY

#define EC_MOVE_FOCUS_FWRD  TAB_KEY
#define EC_MOVE_FOCUS_BKWD  SHFT_TAB_KEY

#define EC_SELECT           SPACE_KEY
#define EC_CANCEL           ESC_KEY

#define EC_TAB_CURSOR       TAB_KEY
#define EC_BACKSPACE        BKSPACE_KEY
#define EC_BACK_TAB         SHFT_TAB_KEY

#define EC_INSERT           INSERT_KEY
#define EC_DELETE           DELETE_KEY

#define EC_HOME_CURSOR      CTRL_HOME_KEY
#define EC_END_CURSOR       CTRL_END_KEY
#define EC_LINE_START       HOME_KEY
#define EC_LINE_END         END_KEY

#define EC_CURSOR_UP        UP_ARROW
#define EC_CURSOR_DOWN      DOWN_ARROW
#define EC_CURSOR_LEFT      LEFT_ARROW
#define EC_CURSOR_RIGHT     RIGHT_ARROW

#define EC_SELECT_UP        SHFT_UP_ARROW
#define EC_SELECT_DOWN      SHFT_DOWN_ARROW
#define EC_SELECT_LEFT      SHFT_LEFT_ARROW
#define EC_SELECT_RIGHT     SHFT_RIGHT_ARROW

#define EC_SELECT_HOME      SHFT_CTRL_HOME_KEY
#define EC_SELECT_END       SHFT_CTRL_END_KEY
#define EC_SEL_LINE_START   BIG_SLCT_HOME_KEY
#define EC_SEL_LINE_END     BIG_SLCT_END_KEY

#define EC_GROUP_SEL_UP     SHFT_CTRL_UP_ARROW
#define EC_GROUP_SEL_DOWN   SHFT_CTRL_DOWN_ARROW
#define EC_GROUP_SEL_LEFT   SHFT_CTRL_LEFT_ARROW
#define EC_GROUP_SEL_RIGHT  SHFT_CTRL_RIGHT_ARROW

#define EC_PAGE_SEL_UP      BIG_SLCT_UP_ARROW
#define EC_PAGE_SEL_DOWN    BIG_SLCT_DOWN_ARROW
#define EC_PAGE_SEL_LEFT    SHFT_CTRL_PGUP_KEY
#define EC_PAGE_SEL_RIGHT   SHFT_CTRL_PGDN_KEY

#define EC_PAGE_UP          PGUP_KEY
#define EC_PAGE_DOWN        PGDN_KEY
#define EC_PAGE_LEFT        CTRL_PGUP_KEY
#define EC_PAGE_RIGHT       CTRL_PGDN_KEY

#define EC_CUT              SHFT_DELETE_KEY
#define EC_PASTE            SHFT_INSERT_KEY
#define EC_COPY             CTRL_INSERT_KEY
#define EC_CLEAR            DELETE_KEY

#define EC_ALT_UP           ALT_UP_ARROW
#define EC_ALT_DOWN         ALT_DOWN_ARROW
#define EC_ALT_LEFT         ALT_LEFT_ARROW
#define EC_ALT_RIGHT        ALT_RIGHT_ARROW

#define EC_GO               RETURN_KEY

#define EC_GROUP_UP         CTRL_UP_ARROW
#define EC_GROUP_DOWN       CTRL_DOWN_ARROW
#define EC_GROUP_LEFT       CTRL_LEFT_ARROW
#define EC_GROUP_RIGHT      CTRL_RIGHT_ARROW

#endif

/* end of CSRKEYS.H */
