
; ***** Routine to set printer
; J. M. Teixeira

; Define some values
;

CR      EQU 0DH                 ;Define carr. ret.
LF      EQU 0AH                 ;Define line feed character for screen
BEEP    EQU 07H                 ;Define bell character

;************************************************************************

; Print prompt to screen

TOP     MOV AH, 9                 ;specify DOS function 9
        MOV DX, OFFSET(PROMPT)    ;get address of string
        INT 21H                   ;call DOS

;Get input
;
       mov     ah, 01H              ;call for kybd input- one key
       int     21H                  ;with dos call
;
;COMPARE
;
        CMP al, 31H             ;compare key input condense code
        JE conden               ;Jump to CONDEN
        CMP al, 32H             ;compare key input ELITE code
        JE ELITE                ;Jump to ELITE
        CMP al, 33H             ;compare key input STANDARD code
        JE STAND                ;Jump to STAND
        JMP NO_GOOD             ;If not valid code jump NO_GOOD
;
;
; SETS PRINTER TO CONDENSED MODE

CONDEN  MOV AH, 5       ; SET INT 21H FOR PRINTER
        MOV DL, 1BH     ; SEND ESC TO PRN
        INT 21H
        MOV DL, 14H     ; SEND 14H TO PRN
        INT 21H
        JMP END         ; GOTO END


; SETS PRINTER TO ELITE MODE

ELITE   MOV AH, 5       ; SET INT 21H FOR PRINTER
        MOV DL, 1BH     ; SEND ESC TO PRN
        INT 21H
        MOV DL, 17H     ; SEND 17H TO PRN
        INT 21H
        JMP END        ;GOTO END


; SETS PRINTER TO STANDARD CHARACTER MODE

STAND   MOV AH, 5       ; SET INT 21H FOR PRINTER
        MOV DL, 1BH     ; SEND ESC TO PRN
        INT 21H
        MOV DL, 13H     ; SEND 13H TO PRN
        INT 21H
        JMP END         ;GOTO END
;
; STARTS OVER IF NOT  VALID CODE 

NO_GOOD MOV AH, 9                 ;specify DOS function 9

        MOV DX, OFFSET(BAD)     ;get address of string
        INT 21H                   ;call DOS
        JMP TOP                 ;START OVER

;
END    INT 20H                  ; return to dos
        

PROMPT  DB    cr,lf,'Select code: ' 
        DB    CR,LF,'1: Condense Mode'
        DB    cr,lf,'2: Elite' 
        DB    CR,LF,'3: Standard Mode'             
        DB    cr,lf
        DB    cr,lf,'$'


BAD     DB     BEEP,CR,LF,'BAD CODE',CR,LF,'TRY AGAIN',CR,LF,'$'


