/*
    Memmgr.h

    Header file for the memory manager routines in Memmgr.asm.
*/

#ifndef MEMMGR_H
#define MEMMGR_H

/*************************************************************************/
/*                                                                       */
/* Macros.                                                               */
/*                                                                       */
/*************************************************************************/



/*************************************************************************/
/*                                                                       */
/* Types.                                                                */
/*                                                                       */
/*************************************************************************/



/*************************************************************************/
/*                                                                       */
/* Global variables.                                                     */
/*                                                                       */
/*************************************************************************/

extern unsigned emsframeseg;    /* EMS page frame segment address */
extern char emsenable;          /* 1 if EMS usage enabled */


/*************************************************************************/
/*                                                                       */
/* Function prototypes.                                                  */
/*                                                                       */
/*************************************************************************/

    /* initialization routine for this module */
int cdecl initmem( void );
    /* allocates a DMA buffer */
unsigned cdecl allocdma( void );
    /* gets a block of memory */
unsigned cdecl getblock( unsigned nparas );
    /* releases a block of memory */
int cdecl freeblock( unsigned segaddr, unsigned nparas );
    /* moves a block as low in memory as possible */
unsigned cdecl movedown( unsigned segaddr, unsigned nparas );
    /* checks memory integrity */
int cdecl checkmem( void );
    /* finalization routine for this module */
void cdecl endmem( void );
    /* gets a block of expanded memory */
unsigned cdecl getemsblock( unsigned nparas );
    /* releases a block of expanded memory */
int cdecl freeemsblock( unsigned handle );
    /* maps in the 1st 64k of an EMS block */
void pascal mapems1st( unsigned handle );
    /* maps in the 2nd 64k of an EMS block */
void pascal mapems2nd( unsigned handle );

#endif
