100 REM PROGRAM TO CONVERT DESKMATE FILER FILES
110 '
120 ' THE DATA BASE FILES CREATED BY FILER HAVE
130 ' THE FOLLOWING STRUCTURE (AS DETERMINED BY
140 '  LOOKING THROUGH THE FILE)
150 '
160 ' ALL NUMBER REPRESENTATION IN THE FILE IS IN AN ASCII
170 ' HEX FORM. NUMBERS ARE IN BASE 16 + 48. IE., THE
180 ' CHARACTERS 0123456789:;<=>? FORM A HEX NUMBER SCALE
190 ' RELATED TO 0123456789ABCDEF.
200 '
210 ' FOR EXAMPLE, THE BYTE STRING IN THE FILE 3:< REPRESENTS
220 ' THE HEX VALUE 3AC OR DECIMAL 940.
230 '
240 ' BYTES     CONTENTS
250 ' -----     --------
260 '  0-5      TOTAL LENGTH OF VALID RECORDS PLUS
270 '           HEADER
280 '  6-11     TOTAL LENGTH OF DELETED RECORDS
290 ' 12-15     NUMBER OF VALID RECORDS
300 ' 16-19     TOTAL NUMBER OF RECORDS
310 ' 20-23     START OF RECORDS ( -24 DECIMAL)
320 ' 24        H (ASCII 72)
330 '
340 ' THE NEXT NREC BYTES ARE A,B,C,D... ONE FOR EACH
350 ' FIELD, TAB TERMINATED (ASCII 9)
360 '
370 ' IMMEDIATELY FOLLOWING IS NFIELD BYTE PAIRS CONTAINING
380 ' THE MAXIMUM DATA FIELD LENGTH FOR EACH FIELD IN THE
390 ' FILE
400 '
410 ' TAB DELIMITER
420 '
430 ' A REPEAT OF THE A,B,C,D.... SEQUENCE FOR EACH FIELD
440 '
450 ' TAB DELIMITER
460 '
470 ' LISTING OF THE FIELD PROMPT TEXT, TAB DELIMITED
480 ' SPACES ARE INDICATED BY A \ (ASCII 92). EACH FIELD
490 ' DESCRIPTOR CONTAINS THE *: END, AND HAS A TAB
500 ' DELIMITER AT THE END. TOTAL LENGTH FOR EACH FIELD,
510 ' INCLUDING THE TAB DELIMITER IS 21 + THE MAXIMUM LENGTH
520 ' OF THE FIELD.
530 '
540 ' THE DATA RECORDS IMMEDIATELY FOLLOW. EACH VALID RECORD
550 ' STARTS WITH AN A (ASCII 65), IS TAB DELIMITED INTERNALLY
560 ' WITH A CLOSING CR DELIMITER (ASCII 13).
570 '
580 ' THIS CONTINUES TO THE END OF THE RECORDS. THE LAST RECORD
590 ' (WHICH IS A NULL RECORD), IS PREFIXED WITH A D (ASCII 68)
600 ' AND IS NOT COUNTED. THE REMAINDER OF THE BLOCK IS THEN
610 ' SPACE PADDED (ASCII 32).
620 '
630 ' THE BLOCK(S) IMMEDIATELY FOLLOWING THE LAST DATA BLOCK
640 ' CONTAIN THE INDEX FOR THE FILE IN THE ORDER SORTED. EACH
650 ' NUMBER IS A 6 BYTE VALUE.
660 '
670 ' VARIABLE DEFINITIONS
680 '
690 '   NFLD            NUMBER OF FIELDS
700 '   MFLDL           MAXIMUM FIELD LENGTH
710 '   LFLDL           LONGEST FIELD IN FILE
720 '   FLDD$           ARRAY OF FIELD DESCRIPTOR DESCRIPTIVE TEXT
730 '   FLD$            ARRAY OF FIELD DESCRIPTORS
740 '
750 '   ASTRT           STARTING RECORD ADDRESS IN FILE
760 '   AEND            ENDING RECORD ADDRESS IN FILE
770 '   AREC            STARTING ADDRESSES OF RECORDS
780 '   ALREC           LENGTH OF RECORDS IN FILE
790 '   ALDREC          LENGTH OF DELETED RECORDS
800 '   ANR             TOTAL NUMBER OF RECORDS
810 '   ANRA            NUMBER OF VALID RECORDS
820 '
830 '  COLOR SELECTION AND DISPLAY VARIABLES
840 '
850 '  IC0             BACKGROUND COLOR
860 '  IC1             INFORMATIVE TEXT
870 '  IC2             USER PROMPTS
880 '  IC3             NON-CHANGING STATUS DISPLAYS
890 '  IC4             CHANGING STATUS DISPLAYS
900 '  IC5             USER KEYED IN INPUT
910 '
920 '   VARIABLE TYPING AND DIMENSIONS
930 '
940 DEFINT I-N
950 DIM FLDD$(24), FLD$(24), MFLDL(24), LFLDL(24)
960 DIM AREC(2000)
970 '
980 '   VARIABLE TYPING
990 '
1000 DLM$=CHR$(13)+CHR$(10)
1010 IM1=18
1020 IM2=24
1030 IC0=1
1040 IC1=15
1050 IC2=10
1060 IC3=13
1070 IC4=13
1080 IC5=14
1090 '
1100 '   START OF MAIN PROGRAM
1110 '
1120 KEY OFF
1130 COLOR IC2,IC0
1140 CLS
1150 LOCATE 5,10
1160 COLOR IC2,IC0
1170 PRINT "Enter the FILER input file ";
1180 COLOR IC5,IC0
1190 INPUT A$
1200 GOSUB 6190
1210 FLI$=A$+".FIL"
1220 OPEN "R",1,FLI$,128
1230 FIELD 1, 128 AS F$
1240 '
1250 '  ******  MAIN MENU  ******
1260 '
1270 COLOR IC2,IC0
1280 CLS
1290 LOCATE 5,IM1
1300 PRINT "Enter option:" ;
1310 LOCATE 7,IM2
1320 PRINT "1)  Display file statistics";
1330 LOCATE 8,IM2
1340 PRINT "2)  Convert FILER file to ASCII";
1350 LOCATE 9,IM2
1360 PRINT "3)  Convert ASCII file to FILER";
1370 LOCATE 11,IM2
1380 PRINT "0)  Exit program";
1390 A$=INKEY$
1400 IF A$="" THEN 1390
1410 IF A$="0" THEN KEY ON:COLOR IC1,IC0:CLS:END
1420 IF A$="1" THEN GOSUB 1480:GOTO 1280
1430 IF A$="2" THEN GOSUB 1780:GOTO 1280
1440 IF A$="3" THEN GOSUB 2500:GOTO 1280
1450 BEEP
1460 GOTO 1390
1470 '
1480 ' GENERATE STATISTICS ON FILE AND DISPLAY
1490 '
1500 '  READ IN FILE DATA
1510 '
1520 GOSUB 4810
1530 '  DISPLAY IT TO THE SCREEN
1540 '
1550 COLOR IC1,IC0
1560 CLS
1570 PRINT
1580 PRINT
1590 PRINT USING "Number of active records  ########      Length ###,###,###";ANRA;ALREC-ASTRT
1600 PRINT USING "Number of deleted records ########      Length ###,###,###";ANR-ANRA;ALDREC
1610 PRINT USING "Total number of records   ########      Length ###,###,###";ANR;ALDREC+ALREC-ASTRT
1620 PRINT
1630 PRINT USING "Number of fields in file   ####";NFLD
1640 PRINT
1650 PRINT "Field number    Descriptive text       Maximum length      Longest used"
1660 PRINT "------------    ----------------       --------------      ------------"
1670 FOR I=1 TO NFLD
1680 PRINT USING "   #####        \                \          ####                ####";I;FLDD$(I);MFLDL(I);LFLDL(I)
1690 NEXT I
1700 PRINT
1710 COLOR IC2,IC0
1720 PRINT "Hit any key to continue";
1730 IF INKEY$="" THEN 1730
1740 ' END OF ROUTINE
1750 '
1760 RETURN
1770 '
1780 '  CONVERT FILER FILE TO COMMA DELIMITED FILE
1790 '
1800 '  READ IN HEADER AND INDEX
1810 '
1820 GOSUB 4810
1830 GOSUB 5590
1840 '
1850 CLS
1860 LOCATE 5,10
1870 COLOR IC2,IC0
1880 PRINT "Enter file name for ASCII output file ";
1890 COLOR IC5,IC0
1900 INPUT FO$
1910 OPEN FO$ FOR OUTPUT AS 2
1920 '
1930 CLS
1940 LOCATE 10,20
1950 COLOR IC3,IC0
1960 PRINT "Writing out record";
1970 COLOR IC4,IC0
1980 '
1990 FOR IREC=1 TO ANRA
2000 LOCATE 10,40
2010 PRINT IREC;
2020 '
2030 AA=AREC(IREC)+1
2040 IB=INT(AA/128)+1
2050 ISEP=0
2060 '
2070 GET 1,IB
2080 II=AA-(IB-1)*128+1
2090 '
2100 IF II<129 THEN 2170
2110 ' NEED NEXT RECORD
2120 '
2130 IB=IB+1
2140 GET 1,IB
2150 II=1
2160 '
2170 B$=MID$(F$,II,1)
2180 IF B$=CHR$(13) THEN 2380
2190 IF B$=CHR$(9) THEN 2290
2200 '  NORMAL CHARACTER
2210 '
2220 '  IF START OF A NEW FIELD, PUT OUT A DELIMITER
2230 '
2240 IF ISEP THEN ISEP=0:PRINT#2,DLM$;
2250 PRINT#2,B$;
2260 II=II+1
2270 GOTO 2100
2280 '
2290 '  NORMAL SEPARATOR
2300 '
2310 '  IF NULL FIELD, PUT OUT TWO SEPARATORS
2320 '
2330 IF ISEP=1 THEN PRINT#2,DLM$;
2340 ISEP=1
2350 II=II+1
2360 GOTO 2100
2370 '
2380 ' END OF THIS RECORD
2390 '
2400 PRINT#2,
2410 '
2420 NEXT IREC
2430 '  CLOSE ASCII FILE
2440 '
2450 CLOSE 2
2460 '  END OF ROUTINE
2470 '
2480 RETURN
2490 '
2500 '  CONVERT ASCII FILE TO FILER FILE
2510 '
2520 '  READ IN OLD FILE HEADER
2530 '
2540 GOSUB 4810
2550 CLS
2560 LOCATE 5,10
2570 COLOR IC2,IC0
2580 PRINT "Enter name of ASCII input file ";
2590 COLOR IC5,IC0
2600 INPUT FA$
2610 CLS
2620 OPEN FA$ FOR INPUT AS 2
2630 LOCATE 5,10
2640 COLOR IC2,IC0
2650 PRINT "Enter name for FILER output file ";
2660 COLOR IC5,IC0
2670 INPUT G$
2680 CLS
2690 OPEN "R",3,G$,128
2700 FIELD 3, 128 AS FD$
2710 '  PUT OUT WORKING HEADER
2720 '
2730 LOCATE 10,20
2740 COLOR IC3,IC0
2750 PRINT "Converting record";
2760 COLOR IC4,IC0
2770 '  INITIALIZE LENGTH INFO
2780 '
2790 FOR I=1 TO NFLD
2800 LFLDL(I)=0
2810 NEXT I
2820 '  SET UP STARTING LOCATION
2830 '
2840 IB=INT(ASTRT/128)+1
2850 II=ASTRT-(IB-1)*128+1
2860 '  COPY OVER HEADER INFORMATION TO NEW FILE
2870 '
2880 FOR I=1 TO IB
2890 GET 1,I
2900 LSET FD$=F$
2910 PUT 3,I
2920 NEXT I
2930 '
2940 F1$=F$
2950 ANR=0
2960 '
2970 IF EOF(2) THEN 3600
2980 LINE INPUT#2,A$
2990 IFLD=1
3000 LFLD=0
3010 ANR=ANR+1
3020 '  PUT OUT USER MESSAGE
3030 '
3040 LOCATE 10,40:PRINT USING "###,###";ANR;
3050 LOCATE 12,18:PRINT SPACE$(50);
3060 LOCATE 12,18
3070 IF LEN(A$)<40 THEN PRINT A$; ELSE PRINT LEFT$(A$,40);
3080 '
3090 IJ=1
3100 AREC(ANR)=II+(IB-1)*128-1
3110 '  PUT AN A (ASCII 65) AT THE START OF EACH
3120 '  RECORD TO INDICATE A VALID RECORD
3130 '
3140 GOSUB 3510
3150 MID$(F1$,II,1)="A"
3160 II=II+1
3170 '
3180 '  CHECK FOR II OUT OF RANGE
3190 '
3200 GOSUB 3510
3210 '
3220 IF IJ>LEN(A$) THEN 3360
3230 B$=MID$(A$,IJ,1)
3240 LFLD=LFLD+1
3250 IF B$<>DLM$ THEN 3320
3260 B$=CHR$(9)
3270 LFLD=LFLD-1
3280 IF LFLD>LFLDL(IFLD) THEN LFLDL(IFLD)=LFLD
3290 LFLD=0
3300 IFLD=IFLD+1
3310 '
3320 MID$(F1$,II,1)=B$
3330 II=II+1
3340 IJ=IJ+1
3350 GOTO 3180
3360 '  END OF THIS RECORD
3370 '
3380 '  CHECK LAST FIELD LENGTH
3390 '
3400 IF LFLD>LFLDL(IFLD) THEN LFLDL(IFLD)=LFLD
3410 '
3420 MID$(F1$,II,1)=CHR$(9)
3430 II=II+1
3440 GOSUB 3510
3450 MID$(F1$,II,1)=CHR$(13)
3460 II=II+1
3470 '  LOOP BACK FOR THE NEXT RECORD
3480 '
3490 GOTO 2970
3500 '
3510 '  CHECK FOR II IN CURRENT RECORD
3520 '
3530 IF II<129 THEN RETURN
3540 LSET FD$=F1$
3550 PUT 3,IB
3560 IB=IB+1
3570 II=1
3580 RETURN
3590 '
3600 '  END OF ASCII INPUT FILE
3610 '
3620 '  PUT NULL RECORD AT END
3630 '
3640 GOSUB 3510
3650 MID$(F1$,II,1)="D"
3660 II=II+1
3670 '
3680 CLOSE 2
3690 '  SET UP PARAMETERS FOR NEW FILE
3700 '
3710 ANRA=ANR
3720 ALREC=(IB-1)*128+II
3730 ALDREC=0
3740 '  SPACE PAD OUT LAST BLOCK
3750 '
3760 '  MAKE SURE THERE IS AT LEAST ONE BYTE FREE AT END
3770 '  FOR TERMINATING CARRAIGE RETURN
3780 '
3790 II=II+1
3800 GOSUB 3510
3810 IF II>1 THEN II=II-1
3820 '  SPACE PAD OUT THIS BLOCK
3830 '
3840 I=128-II+1
3850 IF I>0 THEN MID$(F1$,II,I)=SPACE$(I)
3860 '  CHECK TO MAKE SURE THIS IS AN EVEN BLOCK NUMBER
3870 '  (SO INDEX STARTS ON FILE 256 BLOCK BOUNDARY)
3880 '
3890 IF INT(IB/2)*2=IB THEN 3950
3900 LSET FD$=F1$
3910 PUT 3,IB
3920 IB=IB+1
3930 F1$=SPACE$(128)
3940 '
3950 MID$(F1$,128,1)=CHR$(13)
3960 LSET FD$=F1$
3970 PUT 3,IB
3980 '
3990 '  OUTPUT NEW DATA TO FILE
4000 '
4010 GET 1,1
4020 F1$=F$
4030 '  BYTE LENGTH INFO
4040 '
4050 AVAL=ALREC
4060 GOSUB 6290
4070 MID$(F1$,1,6)=H$
4080 AVAL=ALDREC
4090 GOSUB 6290
4100 MID$(F1$,7,6)=H$
4110 AVAL=ANRA
4120 GOSUB 6290
4130 MID$(F1$,13,4)=RIGHT$(H$,4)
4140 '
4150 AVAL=ANR
4160 GOSUB 6290
4170 MID$(F1$,17,4)=RIGHT$(H$,4)
4180 '
4190 II=NFLD+25
4200 FOR J=1 TO NFLD
4210 AVAL=LFLDL(J)
4220 GOSUB 6290
4230 IJ=J*2+II
4240 MID$(F1$,IJ,2)=RIGHT$(H$,2)
4250 NEXT J
4260 '
4270 LSET FD$=F1$
4280 PUT 3,1
4290 '
4300 '  OUTPUT THE INDEX
4310 '
4320 F1$=STRING$(128,0)
4330 '
4340 COLOR IC3,IC0
4350 T$="Writing out the file index"
4360 CLS
4370 LOCATE 10,40-LEN(T$)/2
4380 PRINT T$;
4390 IB=INT(ALREC/256)+1
4400 IB=IB*2+1
4410 '  SET UP FIRST VALUE
4420 '
4430 AVAL=24
4440 GOSUB 6290
4450 MID$(F1$,1,6)=H$
4460 II=7
4470 '
4480 FOR IREC=1 TO ANR
4490 AVAL=AREC(IREC)
4500 GOSUB 6290
4510 '
4520 IF II<128-4 THEN 4640
4530 '  NEED NEXT RECORD
4540 '
4550 IJ=128-II+1
4560 IF IJ>0 THEN MID$(F1$,II,IJ)=LEFT$(H$,IJ)
4570 LSET FD$=F1$
4580 PUT 3,IB
4590 IB=IB+1
4600 IJ=6-IJ
4610 MID$(F1$,1,IJ)=RIGHT$(H$,IJ)
4620 II=IJ+1
4621 GOTO 4680
4630 '
4640 '
4650 MID$(F1$,II,6)=H$
4660 II=II+6
4670 '
4680 NEXT IREC
4690 '
4700 '  OUTPUT LAST BLOCK
4710 '
4720 LSET FD$=F1$
4730 PUT 3,IB
4740 '  CLOSE NEW FILE
4750 '
4760 CLOSE 3
4770 '  END OF ROUTINE
4780 '
4790 RETURN
4800 '
4810 '  READ IN FILE HEADER INFORMATION
4820 '
4830 CLS
4840 COLOR IC3,IC0
4850 T$="Reading in file header"
4860 LOCATE 10,40-LEN(T$)/2
4870 PRINT T$;
4880 '
4890 GET 1,1
4900 A$=F$
4910 IST=1
4920 LST=6
4930 GOSUB 5990
4940 ALREC=AVAL
4950 IST=7
4960 GOSUB 5990
4970 ALDREC=AVAL
4980 IST=13
4990 LST=4
5000 GOSUB 5990
5010 ANRA=AVAL
5020 IST=17
5030 GOSUB 5990
5040 ANR=AVAL
5050 IST=21
5060 GOSUB 5990
5070 ASTRT=AVAL+24
5080 '  FIND NUMBER OF FIELDS
5090 '
5100 IF MID$(A$,25,1)<>"H" THEN 6450
5110 I=ASC(MID$(A$,26+NFLD,1))
5120 IF I=9 THEN 5170
5130 NFLD=NFLD+1
5140 IF I-64<>NFLD THEN 6450
5150 GOTO 5110
5160 '
5170 II=25+NFLD
5180 FOR J=1 TO NFLD
5190 IST=II+J*2
5200 LST=2
5210 GOSUB 5990
5220 LFLDL(J)=AVAL
5230 NEXT J
5240 '
5250 '  READ IN THE FIELD DESCRIPTORS
5260 '
5270 IR=1
5280 II=29+NFLD*4
5290 FOR I=1 TO NFLD
5300 IJ=0
5310 FLD$(I)=""
5320 FLDD$(I)=""
5330 IF II=129 THEN IR=IR+1:GET 1,IR:A$=F$:II=1
5340 B$=MID$(A$,II,1)
5350 IF B$=CHR$(9) THEN 5430
5360 '  ADD CHARACTER TO FIELD DESCRIPTOR
5370 '
5380 IJ=IJ+1
5390 IF IJ<21 THEN FLDD$(I)=FLDD$(I)+B$ ELSE FLD$(I)=FLD$(I)+B$
5400 II=II+1
5410 GOTO 5330
5420 '
5430 II=II+1
5440 NEXT I
5450 '  FIND LENGTHS OF MAXIMUM LENGTHS OF FIELDS
5460 '
5470 FOR I=1 TO NFLD
5480 II=0
5490 FOR J=2 TO LEN(FLD$(I))
5500 IF MID$(FLD$(I),J,1)="\" THEN II=II+1
5510 NEXT J
5520 MFLDL(I)=II
5530 NEXT I
5540 '
5550 '  END OF ROUTINE
5560 '
5570 RETURN
5580 '
5590 '  READ IN THE INDEX FOR THE FILE
5600 '
5610 CLS
5620 COLOR IC3,IC0
5630 T$="Reading in file index"
5640 LOCATE 10,40-LEN(T$)/2
5650 PRINT T$;
5660 '  COMPUTE STARTING BLOCK NUMBER FOR INDEX
5670 '
5680 IB=INT((ALREC+ALDREC)/256)+1
5690 IB=IB*2+1
5700 GET 1,IB
5710 A$=F$
5720 '
5730 IST=1
5740 LST=6
5750 FOR II=1 TO ANRA
5760 '
5770 IST=IST+6
5780 '  CHECK FOR IN THIS BLOCK
5790 '
5800 IF IST<LEN(A$)-4 THEN 5910
5810 ' READ IN NEXT BLOCK, AND APPEND REMAINDER FROM
5820 ' OLD A$ TO START OF IT
5830 '
5840 IB=IB+1
5850 GET 1,IB
5860 IJ=LEN(A$)-IST+1
5870 IF IJ=0 THEN A$="" ELSE A$=RIGHT$(A$,IJ)
5880 A$=A$+F$
5890 IST=1
5900 '
5910 GOSUB 5990
5920 AREC(II)=AVAL
5930 '
5940 NEXT II
5950 '  END OF ROUTINE
5960 '
5970 RETURN
5980 '
5990 '  PROCESS STRING IN MODIFIED HEX FORM TO A NUMBER
6000 '
6010 '  PASSED IN VARIABLES:
6020 '
6030 '  A$      STRING CONTAINING DATA
6040 '  IST     START OF NUMBER
6050 '  LST     LENGTH OF NUMBER
6060 '
6070 '  RETURNED:
6080 '
6090 '  AVAL    NUMERIC VALUE
6100 '
6110 AVAL=0!
6120 FOR I=0 TO LST-1
6130 AVAL=AVAL*16+ASC(MID$(A$,I+IST,1))-48
6140 NEXT I
6150 '  END OF ROUTINE
6160 '
6170 RETURN
6180 '
6190 ' CONVERT A$ TO A VALID, NO EXTENSION FILE NAME
6200 '
6210 I=INSTR(A$,":")
6220 J=INSTR(I+1,A$,"\")
6230 IF J>0 THEN I=J:GOTO 6220
6240 J=INSTR(I+1,A$,".")
6250 IF J>0 THEN A$=LEFT$(A$,J-1)
6260 IF LEN(A$)-I>8 THEN A$=LEFT$(A$,I+8)
6270 RETURN
6280 '
6290 '  CONVERT AVAL TO A HEX STRING (H$)
6300 '
6310 ATMP=AVAL
6320 H$="000000"
6330 FOR ITMP=1 TO 6
6340 ATMP1=INT(ATMP/16)
6350 JTMP=ATMP-ATMP1*16
6360 MID$(H$,7-ITMP,1)=CHR$(48+JTMP)
6370 IF ATMP1=0 THEN 6410
6380 ATMP=ATMP1
6390 NEXT ITMP
6400 '
6410 '  END OF ROUTINE
6420 '
6430 RETURN
6440 '
6450 '  ERROR WHEN PROCESSING FILE
6460 '
6470 COLOR IC1,IC0
6480 PRINT
6490 PRINT "Error reading file invalid FILER format"
6500 PRINT
6510 END
6520 '
