#include <stdio.h>
#define IBLEN 16000 /* >19 */
#define OBLEN 80
#define PRE_ECHO 40
#define HOTKEY ((Shift&3)!=3)
typedef unsigned char uc;
extern uc screen[16][64], Shift, ShiftLoc;
extern uc *cursor, *H4013, *H401E;
uc *start_echo=0, len_echo, pre_echo[PRE_ECHO];
uc printit=0, i_mask=127;
uc *old_rst38h, *old_vid;
int c;

#define ILINE 1
#define DLINE 2
#define ICHAR 3
#define DCHAR 4
#define GOTO 5
#define HGOTO 6

int main() {
cls();
    memcpy(screen, "Unix Terminal...         By  Mike Stump",
	   39);
    cursor=screen[1];
    init();
    connect();
    deinit();
    return 0;
}

void connect() {
    do {
    	checkout();
	checkin();
    } while (HOTKEY);
}

void checkout() {
    if (c=getkb()) switch (c) {
	case 31:
	    while ((c=getkb())==0) ;
	    switch (c) {
	    case '7': i_mask=127; return;
	    case '8': i_mask=255; return;
	    case 'r': printit=1; return;
	    case 't': printit=0; return;
	    case 13: trans('_'); return;
	    case '\b': trans('\x7f'); return;
	    case ' ': trans('\x00'); return; 
	    case '+': trans('~'); return;
	    case ';': trans('^'); return;
	    case '/': trans('\\'); return;
	    case '?': trans('|'); return;
	    case ',': trans('['); return;
	    case '.': trans(']'); return;
	    case '<': trans('{'); return;
	    case '>': trans('}'); return;
	    }
	    return;
	default:
            trans(c);
    }
}

void checkin() {
    uc c1, *sc;
    if (recieve(&c1)==0) return;
    if (c1==('t'&31)) { printit=0; return; }
    if (printit) {
	ptrans(c1);
	return;
    }
    if (start_echo) {
        if (*start_echo==c1) {
	    ++start_echo;
	    memcpy(pre_echo, pre_echo+1, --len_echo);
	    if (len_echo==0) start_echo=0;
	    return;
	}
	shutdown_cursor();
	memcpy(start_echo, pre_echo, len_echo);
	cursor=start_echo;
	startup_cursor();
	start_echo=0;
    }
    switch (c1) {
    case '\b': putchar(0x18); return;
    case '\t':
    	shutdown_cursor();
	if ((cursor=((cursor+8)&~7)) > &screen[16][63])
	    cursor=&screen[0][0];
	startup_cursor();
	return;
    case '\x0a':
	if (cursor < screen[15]) putchar(0x1a);
	else {
	    sc=cursor; putchar(0x0d);
	    shutdown_cursor(); cursor=sc;
	    startup_cursor();
	}
	return;
    case '\x0d': putchar(0x1d); return;
    case '\f': putchar(0x1c); putchar(0x1f); return;
    case '\a': fputc('\a', printer); return;
    case ILINE:
	shutdown_cursor();
    	memrcpy(&screen[15][63], &screen[14][63],
		&screen[15][63]-(cursor|63));
	memset(cursor&~63, ' ', 64);
	startup_cursor();
	return;
    case DLINE:
	shutdown_cursor();
	memcpy(cursor&~63, (cursor&~63)+64,
	       screen[15]-(cursor&~63));
	memset(screen[15], ' ', 64);
	startup_cursor();
	return;
    case DCHAR:
    	shutdown_cursor();
    	memcpy(cursor, cursor+1, 63-(cursor&63));
        *(uc *)(cursor|63)=' ';
	startup_cursor();
	return;
    case ICHAR:
	shutdown_cursor();
    	memrcpy(cursor|63, (cursor|63)-1, 63-(cursor&63));
        *(uc *)(cursor)=' ';
	startup_cursor();
	return;
    case GOTO:
	while (recieve(&c1)==0) checkout();
	shutdown_cursor();
	cursor=(cursor&~63) + (c1&63);
	startup_cursor();
	while (recieve(&c1)==0) checkout();
	shutdown_cursor();
	cursor=(cursor&~(15<<6)) + ((c1&15)<<6);
	startup_cursor();
	return;
    case HGOTO:
	while (recieve(&c1)==0) checkout();
	shutdown_cursor();
	cursor=(cursor&~63) + (c1&63);
	startup_cursor();
	return;
    case 'r'&31:
	printit=1; return;
    default:
    	putchar(c1);
    }
}

asm
screen: EQU 15360
cursor: EQU 16416
Shift: EQU 14464
ShiftLoc: EQU 16409

E0: EQU 224
EA: EQU 234
EB: EQU 235
H0474: EQU 1140
H35C5: EQU 13765
H35F1: EQU 13809
H4013: EQU 16403
H401E: EQU 16414
H4022: EQU 16418
H4023: EQU 16419
H4213: EQU 16915
endasm

void ptrans(c) {
asm
	POP	BC
	POP	HL
	PUSH	HL
	PUSH	BC
PLoop:	DEFB	219	; IN A,(0F8H)
	DEFB	248
	BIT	7,A
	JP	NZ,PLoop
	LD	A,L
	DEFB	211	; OUT (0F8H),A
	DEFB	248
endasm
}

uc obuf[OBLEN], *oipos, *oopos;

void trans(c) {
if (c>=' '&&c<='~'&&cursor<&screen[15][63]
	&&len_echo<PRE_ECHO) {
	if (start_echo==0) start_echo=cursor, len_echo=0;
	shutdown_cursor();
	pre_echo[len_echo++]=*cursor;
	*cursor++=c;
	startup_cursor();
}
*oipos=c;
if (++oipos==&obuf[OBLEN]) oipos=&obuf[0];
asm
	LD A,52		;4+32+16
LD (H4213),A ;BASIC OUTS THIS TO E0
DEFB 211		; OUT (0E0H),A
DEFB 224		; (enable RO intr)
endasm
}

void ROINT() {
if (oopos!=oipos) {
	asm
	LD	HL,(oopos)
	LD	A,(HL)
	DEFB	211	; OUT (0EBH),A
	DEFB	235
	endasm
	if (++oopos==&obuf[OBLEN]) oopos=&obuf[0];
	return;
}
asm
	LD	A,(H4213)
	RES	4,A
;	LD	A,36		;4+32
LD (H4213),A ;BASIC OUTS THIS TO E0
DEFB 211		; OUT (0E0H),A
DEFB 224		; (disable RO intr)
endasm
}

getkb() {
asm
	CALL 43
	LD L,A
	LD H,0
	RET
endasm
}

uc *ibuf, *iipos, *iopos;

void RIINT() {
*iipos=getrin();
/* if ((iipos<iopos && iipos+10>iopos) ||
	(iipos>=iopos && iipos+(10-IBLEN)>iopos)) {
	trans('s'&31);
} */
if (++iipos==&ibuf[IBLEN]) iipos=&ibuf[0];
}

int recieve(c) uc *c; {
if (iopos!=iipos) {
	*c=*iopos & i_mask;
	if (++iopos==&ibuf[IBLEN]) iopos=&ibuf[0];
	return 1;
} else return 0;
}

init() {
cursor_on();
ShiftLoc=0;
ibuf=calloc(IBLEN, sizeof(char));
iopos=iipos=ibuf;
oopos=oipos=obuf;
old_vid=H401E;
H401E=VIDDRV;
old_rst38h=H4013;
H4013=RST38H;
}

deinit() {
ShiftLoc=1;
H4013=old_rst38h;
H401E=old_vid;
}

asm
;-----------------------
shutdown_cursor:
	LD	A,(H4022)
	OR	A
	RET	Z
	LD	HL,(cursor)
	LD	(HL),A
	RET
;-----------------------
startup_cursor:
	LD	A,(H4022)
	OR	A
	RET	Z
	LD	HL,(cursor)
	LD	A,(HL)
	LD	(H4022),A
	LD	A,(H4023)
	LD	(HL),A
	RET
;-----------------------
getrin:
	DEFB	219	; IN A,(0EBH)
	DEFB	235
	LD	L,A
	LD	H,0
	RET
;-----------------------
VIDDRV:
	PUSH	AF
	LD	A,(H4213)
	RES	2,A
	LD	(H4213),A
	DEFB	211	; OUT (0E0H),A
	DEFB	224
	POP	AF
	CALL	H0474
	LD	A,(H4213)
	SET	2,A
	LD	(H4213),A
	DEFB	211	; OUT (0E0H),A
	DEFB	224
	RET
;-----------------------
RST38H: PUSH AF
DEFB 219 ; IN A,(0E0H)
DEFB 224
   AND 15
CP 15
JP NZ,H35C5
PUSH BC
PUSH DE
PUSH HL
PUSH IX
PUSH IY
LD HL,H35F1
PUSH HL
DEFB 219 ; IN A,(0E0H)
DEFB 224
BIT 5,A ;RCV INT
JP Z,RIINT
BIT 4,A
RET NZ
; ROINT
	JP	ROINT
endasm

  