VERFIL ;VERFILE/S
 VIDEO	EQU	33H
 LINEIN	EQU	40H
 CURSOR	EQU	4020H
 OPEN	EQU	4424H
 READ	EQU	4436H
 ERROR	EQU	4409H
 DOS	EQU	402DH
 
 	ORG	5200H
 START	LD	HL,TITLE
 	CALL	LINOUT		; Display title message
 ; The program starts by prompting for a filespec.
 ; If <Enter> keyed by itself then exit to Dos
 ; otherwise the file is opened and read sequentially.
 ; Each record number is displayed prior to attempting
 ; to read the sector and any Dos error, except EOF
 ; is reported.
 ; On error or EOF then go back for the next filespec.
 
 MAIN	LD	HL,PROMPT
 	CALL	LINOUT		; Display filespec prompt
 
 ; Get filespec from keyboard
 
 	LD	HL,KEYBUF	; Set up buffer for input
 	LD	B,23		; maximum = filespec/ext.password:d
 	CALL	LINEIN		; Rom routine common Models 1 & 3
 	JP	C,DOS		; <Break> key
 	INC	B		; test if B is zero
 	DEC	B		; i.e. just <Enter> keyed
 	JP	Z,DOS		; if so exit
 
 ; Move filespec to DCB
 
 	LD	BC,24		; max filespec + 0DH
 	LD	HL,KEYBUF	; prepare to move
 	LD	DE,DCB		; to the DCB
 	LDIR			; move it !
 
 ; Set counter to zero and open file
 
 	LD	(SECTOR),BC	; conveniently BC = 0 after LDIR
 	LD	HL,INBUFF	; Input buffer for file
 	LD	DE,DCB
 	LD	B,0		; for logical record length = 256
 	CALL	OPEN
 	JR	NZ,DERROR	; report any errors
 ; File opened successfully
 
 ; Display reading message and save cursor location
 
 	LD	HL,READNG
 	CALL	LINOUT
 	CALL	SAVCUR
 
 ; This section is executed repetatively until error.
 ; The cursor is restored and record number displayed.
 
 READLP	CALL	PUTCUR		; cursor location restored
 	LD	HL,(SECTOR)	; get sector count
 	INC	HL		; add one
 	LD	(SECTOR),HL	; save it and print it
 	CALL	PRTSEC		; Basic record # = Dos sector + 1
 	LD	A,(3840H)
 	BIT	2,A
 	JP	NZ,DOS
 
 	LD	DE,DCB		; prepare for file read
 	CALL	READ		; read record
 	JR	Z,READLP		; OK do it again
 	CP	28		; was the error = EOF
 	JR	Z,MAIN		; file finished
 	CP	29		; was sector after EOF
 	JR	Z,MAIN		; file finished
 
 ; Dos error condition reporting
 
 DERROR	PUSH	AF		; save error code
 	LD	A,0DH		; print Carriage Return
 	CALL	VIDEO
 	POP	AF		; recover error code
 	OR	0C0H		; set bits 6 & 7 for error message
 	CALL	ERROR		; Dos error reporter
 	JR	MAIN		; go for next file
 
 ; Print record number in decimal
 ; HL registers hold number for printing
 ; Conversion done by successive subtraction with
 ; answer stored in BUFFER for printing by LINOUT
 
 PRTSEC	LD	DE,BUFFER	; DE is used as pointer
 	LD	IY,DECMAL	; so is IY to table of decimals
 	LD	C,0		; C = leading zero suppression flag
 
 ; Subtraction loop
 
 HD1	PUSH	DE		; save pointer
 	LD	A,'0'		; counting up from Ascii 0
 	LD	D,(IY+1)	; load DE registers with decimal
 	LD	E,(IY+0)	; values pointed to by IY
 
 ; Now do subtractions until Carry condition
 
 HD2	OR	A		; clear Carry flag
 	SBC	HL,DE		; subtract decimal value from HL
 	JR	C,HD3		; gone too far !
 	INC	A		; keep count of subtractions
 	JR	HD2		; do it again
 
 ; correct for 1 too many & prepare for next position
 
 HD3	ADD	HL,DE		; add it back
 	INC	IY		; move to next value in DECMAL
 	INC	IY		; note each value is 2 bytes
 	CP	'0'		; is this answer a "0"
 	JR	NZ,HD4		; if not no trouble
 	INC	C		; if yes then check if leading zero
 	DEC	C		; by testing C = 0 ?
 	JR	NZ,HD5		; not leading zero so jump
 	LD	A,' '		; replace "0" by " "
 	JR	HD5		; skip altering C to non-zero
 HD4	LD	C,A		; cancel zero suppression flag
 
 ; Test if current value in E is 1, i.e. decimal units
 ; as if so then conversion complete, but do not react
 ; immediately as value has to be put in the buffer
 
 HD5	DEC	E		; if E=1 then set Zero flag
 	POP	DE		; recover pointer to buffer
 	LD	(DE),A		; store decimal Ascii character
 	INC	DE		; move pointer to next position
 	JR	NZ,HD1		; go back for more subtractions
 
 ; Nearly finished but if leading zero suppression
 ; still on then answer all blank, so check and if so
 ; move pointer back to end of buffer and put in a "0".
 
 	INC	C		; leading zero suppr. ?
 	DEC	C
 	JR	NZ,HD6		; no so skip next bit
 	DEC	DE		; backstep pointer
 	LD	A,'0'		; put Ascii 0
 	LD	(DE),A		; into end of buffer.
 
 ; All finished so prepare to print buffer
 HD6	LD	HL,BUFFER
 
 ; Drop through to print line of Ascii characters
 ; terminated with binary 0.
 
 LINOUT	LD	A,(HL)		; get character pointed to by HL
 	INC	HL		; bump the pointer
 	OR	A		; is it a zero
 	RET	Z		; if so then finished
 	PUSH	DE		; save DE as the Rom alters value
 	CALL	VIDEO		; call Rom output routine
 	POP	DE		; restore DE
 	JR	LINOUT		; go back for another character
 
 ; Routines used to save current cursor location
 ; & restore it before printing record number
 
 SAVCUR	PUSH	HL		; save HL
 	LD	HL,(CURSOR)	; get cursor position
 	LD	(CURSAV),HL	; save it
 	POP	HL		; restore HL
 	RET			; done
 
 PUTCUR	PUSH	HL		; same again in reverse
 	LD	HL,(CURSAV)
 	LD	(CURSOR),HL
 	POP	HL
 	RET
 
 SECTOR	DEFW	0		; Sector count
 CURSAV	DEFW	0		; Cursor save
 
 ; Table of decimal values
 DECMAL	DEFW	10000
 	DEFW	1000
 	DEFW	100
 	DEFW	10
 	DEFW	1
 
 ; Messages, 28 = Home cursor
 ;           31 = Clear to end of screen
 ;           13 = CR/LF
 ;           14 = Cursor on
 TITLE	DEFB	28
 	DEFB	31
 	DEFM	'     V E R F I L E'
 	DEFB	13
 	DEFM	' File verifying utility'
 	DEFB	13
 	DEFM	'(c) 1983  Laurie Shields'
 	DEFB	13
 	DEFB	0
 PROMPT	DEFB	14
 	DEFB	13
 	DEFM	'Filespec : '
 	DEFB	0
 READNG	DEFM	'Reading Record : '
 	DEFB	0
 
 ; Buffer for decimal output ending with 0
 BUFFER	DEFM	'     '
 	DEFB	0
 ; other buffers
 KEYBUF	DEFS	24		; keyboard input
 INBUFF	DEFS	256		; Dos input
 DCB	DEFS	50		; Model 3 TRSDOS needs 50 bytes
 	END	START
