TRSDIR ;******************************************************
 ;**     	      TRSDIR 		    	     **
 ;**  Model III TRSDOS Directory from NEWDOS 80 V2.0  **
 ;**    Original version copyright 1983 T. Domigan    **
 ;**              P.O.  Box  150 		     **
 ;**         Thomastown, Victoria, 3074 	 	     **
 ;**		    Australia.			     **
 ;**   This version has been modified by Jack Decker  **
 ;**   to run on Model I or Model III, and to allow   **
 ;**   40 track disks to be read on 80 track drives.  **
 ;******************************************************
 ;
 ;
 	ORG	5300H		;Anywhere above 5300H
 ;
 ;	** Test for Model (I or III) **
 ;
 START	LD	A,(54H)		;Get byte from ROM
 	DEC	A		;Determine if Mod 1 or 3
 	JR	NZ,DRVSPC	;Go if Model III
 ;
 ;	** Modify Program for Model I **
 ;
 	PUSH	HL		;Save input buffer pntr
 	LD	HL,0553H	;Mod I scrn scroll rtne
 	LD	(GOSCRL+1),HL	;Store it in program
 	LD	HL,4371H	;Mod I PDRIVE table loc
 	LD	(PDPTR1+1),HL	;Store it in program
 	LD	(INITZ+1),HL
 	LD	(PDPTR2+1),HL
 	LD	HL,4630H	;Mod I sector read rtne
 	LD	(RSEC+1),HL	;Store it in program
 	XOR	A		;A=0
 	LD	(TBL2),A	;Store in PDRIVE4 table
 	LD	A,33H
 	LD	(TBL1),A	;Also in PDRIVE4 table
 	POP	HL		;Restore buffer pointer
 ;
 ;	** Check if Drivespec Given **
 ;
 DRVSPC	PUSH	HL		;For possible user restrt
 	LD	A,(HL)		;Get char after filespec
 	CP	0DH		;Drive no. specified?
 	JR	Z,DZERO		;Drive 0 assumed if not
 	AND	0DFH		;Lowercase = uppercase
 	CP	'S'		;Skip track parameter?
 	JR	Z,SKPTRK	;If skipping tracks
 	LD	A,(HL)		;Restore original char
 	CP	3AH		;Is char a colon?
 	JR	NZ,NOTCOL	;If not a colon
 	INC	HL		;Bump buffer pointer
 	LD	A,(HL)		;Get char after colon
 NOTCOL	CP	34H		;Drive No. too high ?
 	JR	C,NOERR		;Go if not too high
 ;
 ;	** Error Exit for Invalid Drivespec **
 ;
 DRVERR	LD	A,20H		;Illegal/missing drv code
 ERREXT	JP	4409H		;Abort with error message
 ;
 ;	** Check for Drive 0 or Invalid Drivespec **
 ;
 NOERR	CP	30H		;Drive 0 ?
 	JR	C,DRVERR	;Error if invalid char
 ;
 ;	** Check for "S" (Skip Track Argument) **
 ;
 	INC	HL		;Bump buffer pointer
 SKPTRK	PUSH	AF		;Save drive no., Z flag
 LPBACK	LD	A,(HL)		;Get char at HL
 	CP	0DH		;Was it ENTER?
 	JR	Z,ENTFND	;Go if ENTER found
 	INC	HL		;Bump buffer pointer
 	CP	20H		;Was it a space char?
 	JR	Z,LPBACK	;Try next char if so
 	AND	0DFH		;Lowercase = uppercase
 	CP	'S'		;Skip track parameter?
 	LD	A,34H		;Error message number
 	JR	NZ,ERREXT	;If not skip trk flag
 	LD	A,15H		;Byte to change
 	LD	(TBL3),A	;Store in PDRIVE4 table
 ENTFND	POP	AF		;Restore drive no./Z flag
 	JR	NZ,POSTD	;Go if not drive 0
 ;
 ;	** Drive Zero Routine **
 ;
 DZERO	CALL	01C9H		;Clear screen
 	LD	HL,ZERMSG	;Point to Drive 0 msg
 	CALL	4467H		;Display msg
 GETKEY	CALL	49H		;Wait til key pressed
 	DEC	A		;Was BREAK key pressed?
 	JR	NZ,NOABRT	;Go if no abort
 	LD	A,39H		;Operator abort err code
 	JR	ERREXT		;Display msg and exit
 NOABRT	CP	0CH		;Was ENTER pressed?
 	JR	NZ,GETKEY	;Try again if not
 	LD	A,30H		;Drive No. in A reg
 ;
 ;	** Post the Drivespec **
 ;
 POSTD	LD	(MSG1+6),A	;Store Ascii Drive No.
 	SUB	30H		;Calc. binary drive no.
 ;
 ;	** Select Drive **
 ;
 	CALL	445EH		;Select & rotate drive
 	JR	NZ,ERREXT	;Err if disk not mounted
 	CALL	01C9H		;Clear screen
 	LD	HL,MSG1		;Pt to Title
 	CALL	4467H		;Display Title
 ;
 ;******** Swap Mem/TRSDOS PDRIVES ***********************
 ;
 ;	** Store Original PDRIVES **
 ;
 INITZ	LD	HL,4291H	;Pt to PDRIVES in mem
 	LD	DE,PDVSTO	;Pt to storage area
 	LD	BC,28H		;Length of PDRIVE
 	LDIR			;Xfer it
 ;
 ;	** Replace each PDRIVE with PDRIVE 4 **
 ;
 PSWAP	LD	B,04H		;4 drives to PDRIVE
 PDPTR2	LD	DE,4291H	;start of PDRIVE area
 QFLOOP	PUSH	BC		;Save Drive No.
 	LD	HL,PDRIV4	;TRSDOS PDRIVE 4
 	LD	BC,0AH		;Length of PDRIVE 4
 	LDIR			;XFER IT
 	POP	BC		;Restore drive number
 	DJNZ	QFLOOP		;Loop for 4 drives
 ;
 ;******** Read a Sector *********************************
 ;
 	CALL	SREAD		;Read sector to buffer
 ;
 ;******** Decode and Display GAT Sector ***************
 ;
 ;	** Disk Name **
 ;
 	LD	HL,52D0H	;Pt to Disk Name
 	LD	DE,3C15H	;Pt to Screen
 	LD	BC,8		;8 characters in name
 	LDIR			;Xfer name to screen
 ;
 ;	** Disk Date **
 ;
 	LD	DE,3C1FH	;Pt to screen
 	LD	BC,8		;8 characters in date
 	LDIR			;Xfer to screen
 ;
 ;	** Free Granules **
 ;
 	LD	DE,5200H	;Pt to G.A.T.
 	LD	HL,0000H	;Zero Free Grans counter
 	LD	C,40		;40 tracks assumed
 OLOOP	LD	A,(DE)		;Get allocation byte
 	LD	B,6		;6 bits to check
 ILOOP	RRCA			;Is granule allocted
 	JR	C,NOADD		;Bump count if not
 	INC	L		;Bump free gran counter
 NOADD	DJNZ	ILOOP		;Loop for 6 bits
 NEXT	INC	DE		;Bump memory pointer
 	DEC	C		;Decrement track count
 	JR	NZ,OLOOP	;Loop for 40 tracks
 	CALL	0A9AH		;No. free grans to ACCUM
 	XOR	A		;Specify non-format edit
 	CALL	1034H		;Setup edit flag & buffer
 	OR	L		;Set NZ flag
 	CALL	0FD9H		;Change to numeric string
 	LD	L,30H		;HL=4130H = string start
 	LD	DE,3C29H	;Pt to screen
 	LD	BC,6		;6 figures maximum
 	LDIR			;Xfer free grans 
 	LD	HL,3C31H	;Pt to screen
 	LD	(4020H),HL	;Load cursor with address
 	LD	HL,MSG2		;Pt to free granules msg
 	CALL	4467H		;Display msg
 ;
 ;******** Update Sector Number **************************
 ;
 	XOR	A		;Zero DIR page count
 UPSECT	LD	HL,SECTOR	;Relative sector number
 	INC	(HL)		;Bump sector number
 ;
 ;***** Loop to Read, Decode & Print each FPDE page ******
 ;
 	INC	A		;Increment DIR page
 	CP	17		;All read yet ?
 	JR	Z,QLOOP		;Exit if so
 	PUSH	AF		;Store DIR page number
 	DEC	A		;Is it HIT sector
 	JR	NZ,NONO		;Jump if not
 	INC	(HL)		;Increment past HIT sect.
 NONO	CALL	SREAD		;Read sector to buffer
 	LD	IY,(HZPT)	;Pt to print @ posn
 ;
 ;******** Decode FPDE Page ******************************
 ;
 	LD	IX,5200H	;Pt to input buffer
 	LD	HL,5205H	;Pt to filespec posn
 	LD	(SCE),HL	;Store filespec pointer
 	LD	B,05H		;Filespecs per DIR page
 DILOOP	PUSH	BC		;Save FPDE counter
 	LD	A,(IX+0)	;Get status byte
 	OR	A		;Is it an active FPDE
 	JR	Z,SKIP2		;Skip if FPDE inactive
 	CALL	DISP		;Go to display routine
 SKIP1	LD	BC,0030H	;Increment to next Fspec
 	ADD	IX,BC		;Update FPDE pointer
 	POP	BC		;Restore FPDE counter
 	DJNZ	DILOOP		;Loop till page done
 	POP	AF		;Restore DIR page number
 	JR	UPSECT		;Update sector pointer
 SKIP2	LD	HL,(SCE)	;Pt to filespec
 	LD	BC,0030H	;Increment to next Fspec
 	ADD	HL,BC		;Bump Fspec pointer
 	LD	(SCE),HL	;Store pointer
 	JR	SKIP1
 ;
 ;******** Replace PDRIVES and Exit to DOS ***************
 ;
 QLOOP	LD	HL,PDVSTO	;Pt to orig. PDRIVES
 PDPTR1	LD	DE,4291H	;Pt to PDRIVE area in RAM
 	LD	BC,28H		;Length of PDRIVE
 	LDIR			;Replace orig. PDRIVES
 	LD	HL,3F40H	;Pt to 3rd bottom line
 	LD	(4020H),HL	;Store as cursor posn
 	CALL	49H		;Hit a key to continue
 	AND	0DFH		;Lowercase=uppercase
 	CP	'R'		;Repeat ?
 	JP	NZ,402DH	;Exit to DOS if no repeat
 	LD	HL,ITLVAL	;HL=reinitialization tbl
 	LD	DE,PCOUNT	;DE=area to reinitialize
 	LD	BC,12		;No. bytes to move
 	LDIR			;Re-initialize program
 	POP	HL		;Restore input buffer ptr
 	JP	DRVSPC
 ;
 ;******* Display an Active Filespec *********************
 ;
 DISP	LD	HL,(SCE)	;Pt to filespec
 	CALL	SCPOS		;Screen posn check
 	LD	B,8		;8 characters in Fspec
 DELOOP	LD	A,(HL)		;Get ASCII character
 	CP	20H		;Is it a space ?
 	JR	Z,PASS		;Skip if so
 	LD	(DE),A		;Display if not a space
 	INC	DE		;Bump screen pointer
 PASS	INC	HL		;Bump pointer
 	DJNZ	DELOOP		;Loop to end of filename
 	LD	A,(HL)		;Get next character
 	CP	20H		;Is it a space ?
 	JR	Z,MISS		;No extent if so
 	LD	A,'/'		;Add delimeter
 	LD	(DE),A		;Display a slash
 	INC	DE		;Bump screen pointer
 MISS	LD	BC,3		;Length of extent
 	LDIR			;Display extent
 	LD	A,(PCOUNT)	;Get program counter
 	INC	A		;Increment program number
 	LD	(PCOUNT),A	;Store counter
 	CP	4BH		;75 programs displayed ?
 	JR	Z,SCROLL	;Scroll screen up if so
 	CP	50H		;Last FPDE has files ?
 	RET	Z		;Modify print if so
 	LD	BC,25H		;Screen increment
 	ADD	HL,BC		;Calc. new mem pointer
 	LD	(SCE),HL	;Store mem pointer
 	RET
 SCROLL	LD	HL,3FC0H	;Last line of display
 	LD	(VIDEO),HL	;Store it
 	LD	(HZPT),HL	;Redefine screen pointer
 	XOR	A		;Zero posn in line
 	LD	(SPOINT),A	;Store as first posn
 GOSCRL	JP	0587H		;Scroll up
 SCPOS	LD	A,(SPOINT)	;Print posn
 	LD	IY,(HZPT)	;Get print @ posn
 	OR	A		;First file position ?
 	JR	Z,GETOUT	;Exit if so
 	CP	05H		;Last file position ?
 	JR	Z,CR		;Cr if so
 	LD	BC,13		;Increment 
 	ADD	IY,BC		;Calc. new pointer
 GETOUT	INC	A		;Bump screen/file posn
 	LD	(SPOINT),A	;Store file position
 	LD	(HZPT),IY	;Store print @ posn
 	PUSH	IY		;Move print @ posn
 	POP	DE		;to DE register
 	RET
 CR	LD	BC,40H		;1 line of video
 	LD	IY,(VIDEO)	;Get current line
 	ADD	IY,BC		;Calc. new video line
 	LD	(VIDEO),IY	;Store new line reference
 	XOR	A		;First file position
 	JR	GETOUT
 ;
 ;******** Read a Sector ********************************
 ;
 SREAD	LD	HL,5200H	;Input buffer
 	LD	DE,(SECTOR)	;Sector to read
 RSEC	JP	45DBH		;Read sector
 ;
 ;******** Strings to Display to Screen ******************
 ;
 ZERMSG	DEFB	0AH
 	DEFM	'Press ENTER when TRSDOS disk is in Drive 0'
 	DEFB	0DH
 MSG1	DEFM	'Drive 0  TRSDOS --> '
 	DEFB	03H
 MSG2	DEFM	'Free Granules'
 	DEFB	0AH
 	DEFB	0DH
 ;
 ;***** Initialization Values for Storage Locations ******
 ;
 ITLVAL	DEFW	0000H
 	DEFW	5205H		;Filespec pointer
 	DEFW	3C40H		;Screen pointer
 	DEFW	3C40H		;Screen pointer
 	DEFW	0132H
 ;
 ;******* Constants, Counters and Storage ****************
 ;
 PCOUNT	NOP
 SPOINT	NOP
 SCE	DEFW	5205H		;Filespec pointer
 VIDEO	DEFW	3C40H		;Screen pointer
 HZPT	DEFW	3C40H		;Screen pointer
 SECTOR	DEFW	0132H
 PDRIV4	DEFW	2811H		;PDRIVE 4 = TRSDOS
 TBL1	DEFB	27H
 	DEFB	28H
 	DEFW	0612H
 TBL2	DEFB	0FEH
 TBL3	DEFB	11H
 	DEFW	0211H
 PDVSTO	DEFS	28H		;Store PDRIVE here
 	END	START
