; vdisk/asm - kjw/bqsd - version 0.00
;
; created 03/29/83 - kjw
; revised 03/30/83 - kjw
;
	TITLE	'<VDISK - Virtual Disk Utility>'
;
	SUBTTL	'<by Kim Watt - (C) Copyright 1983 - Breeze/QSD, Inc. - Dallas, Texas>'
;
TRS13	EQU	-1
TRS2	EQU	0
;
;	system equates
;
	IF	TRS13
CODE	EQU	5200H
BOL	EQU	01DH
EOL	EQU	01EH
NFOUND	EQU	024
BREAK	EQU	003H
	ENDIF
;
	IF	TRS2
CODE	EQU	2200H
UFEED	EQU	00BH
EOL	EQU	017H
NFOUND	EQU	031
BREAK	EQU	001H
	ENDIF
;
CR	EQU	00DH
ETX	EQU	003H
	PAGE
;
	ORG	CODE
;
ENTRY	CALL	@SETUP		;setup for normal exit
	PUSH	HL		;save input pointer
	LD	HL,HELLO	;sign on message
	CALL	@VDLINE		;display message
	POP	HL		;restore input pointer
	CALL	@POSHL		;any input?
	JP	Z,PROMPT	;nope, prompt for input
;
;	parse input command line
;
PARSE	LD	DE,DBLOCK	;init data pointer
	LD	B,3		;3 drives to scan
;
SCAN	CALL	GETDRV		;get drive #
	JP	C,PERROR	;param error
	LD	(DE),A		;save drive #
	INC	DE		;bump pointer
	DJNZ	SCAN		;go for 3 entries
;
;	parameters complete, open INDEX file for access
;
	LD	(IDRV),A	;pass drive # to filename
	LD	DE,IFCB		;index file block
	LD	HL,IBUFF	;index I/O buffer
	XOR	A		;LRL
	LD	B,A		;pass to BC
	LD	C,A		;EODAD address
	CALL	@OPEN		;open the file
	JP	NZ,ERROR	;go if error
	CALL	@READ		;read first sector
	JP	NZ,ERROR	;go if error
;
;	check header to assure a valid index file
;
	LD	DE,HEADER	;header ID string
	LD	B,HEADERL	;header length
	CALL	@COMP		;match?
	JP	NZ,IERROR	;index ID error
;
;	check for nil file
;
	LD	IX,IBUFF+20H	;start index buffer
	LD	A,(IX+0)
	OR	(IX+1)
	OR	(IX+2)
	JP	Z,NERROR	;nil file error
;
;	save bucket table
;
	LD	HL,IBUFF+30H	;start bucket table
	LD	DE,BTABLE	;save it here
	LD	BC,26*8		;table length
	LDIR			;move it in!
;
;	check for sufficient memory for driver
;
	LD	BC,CSIZE	;size needed in topmem
	CALL	@FETMEM		;fetch memory
	JR	NZ,MERROR	;memory error
;
	PUSH	BC		;save program length
	PUSH	HL		;save new address
	LD	DE,CSTART	;start of relo code
	PUSH	DE		;save current address
	OR	A		;clear carry flag
	SBC	HL,DE		;HL = offset factor
;
;	fetch old open vector, reset new vector
;
	PUSH	HL		;save offset factor
	LD	BC,CENTRY	;program entry point
	ADD	HL,BC		;HL = new vector
	EX	DE,HL		;DE = new vector
;
	IF	TRS13
	LD	HL,(4425H)	;get old vector
	LD	(4425H),DE	;save new vector
	ENDIF
;
	IF	TRS2
	LD	HL,(0250H)	;get old vector
	LD	(0250H),DE	;save new vector
	ENDIF
;
	LD	(OPEN1),HL	;pass old vector
	LD	(OPEN2),HL
	LD	(OPEN3),HL
	POP	BC		;get offset factor
	LD	IX,CTABLE	;offset table
;
;	resolve program addresses
;
RESOL	LD	L,(IX+0)	;get address
	LD	H,(IX+1)
	LD	A,H		;table terminator?
	AND	L		;HL = FFFFH?
	INC	A		;yes?
	JR	Z,RESOK		;yes, resolve done!
	LD	A,(HL)		;get LSB address
	ADD	A,C		;add to LSB offset
	LD	(HL),A		;update vector
	INC	HL		;bump pointer
	LD	A,(HL)		;get MSB address
	ADC	A,B		;add to MSB offset
	LD	(HL),A		;update vector
	INC	IX		;bump resolve table
	INC	IX		;2 byte entries
	JR	RESOL		;continue next address
;
RESOK	POP	HL		;get current address
	POP	DE		;get new address
	POP	BC		;get program length
	LDIR			;move program up
;
;	code installed, return back to DOS
;
@EXIT	LD	SP,$		;reset stack pointer
STACK	EQU	$-2
	PUSH	BC		;save BC
	LD	BC,$		;get interrupt flags
INTLAT	EQU	$-2
	PUSH	BC		;pass to AF
	POP	AF		;F = interrupt status
	POP	BC		;restore BC
	JP	PO,$+4		;go if interrupts off
	EI			;else re-enable them
	XOR	A		;return Z
	RET			;back to next sub-level
;
;	setup for normal program exit
;
@SETUP	POP	AF		;restore stack to level
	LD	(STACK),SP	;save stack pointer
	PUSH	AF		;caller back to stack
	LD	A,I		;get interrupt register
	PUSH	BC		;save BC
	PUSH	AF		;pass AF => BC
	POP	BC		;saved
	LD	(INTLAT),BC	;save for interrupt rest.
	POP	BC		;restore stack
	XOR	A		;return Z
	RET			;init done!
;
;	error vectors
;
ERROR	CALL	@ERROR		;display error message
	JR	PROMPT		;prompt for input
;
IERROR	LD	HL,ERRMSGI	;error text
	JR	DSPERR		;display and continue
;
NERROR	LD	HL,ERRMSGN	;error text
	JR	DSPERR		;continue
;
MERROR	LD	HL,ERRMSGM	;memory error
	CALL	@VDLINE		;display error
	JP	@EXIT		;abort program
;
PERROR	LD	HL,ERRMSGP	;error text
;
DSPERR	CALL	@VDLINE		;display error message
;
;	prompt for input parameters
;
PROMPT	LD	HL,PTEXT	;prompt text
	LD	DE,KEYBUFF	;key input buffer
	LD	B,63		;keyboard input length
	CALL	@VIDKEY		;display and keyboard
	JP	C,@EXIT		;exit program on BREAK
	CALL	@POSHL		;any input?
	JP	NZ,PARSE	;yes, parse it out
;
	LD	HL,HELP		;help text
	CALL	@VDLINE		;display help
	JR	PROMPT		;re-prompt for input
;
;	fetch drivespec from input string
;
GETDRV	CALL	@POSHL		;point to input char
	SCF			;C = error
	RET	Z		;nil input!
	CP	':'		;drive marker?
	JR	NZ,$+3		;go if not
	INC	HL		;bump past colon
	LD	A,(HL)		;get input char
	INC	HL		;bump pointer
	CP	'0'		;in range?
	RET	C		;nope, return C
	CP	'9'		;0-8?
	CCF			;reverse carry
	RET			;C = error!
;
;	position to significant input chars
;
	INC	HL		;bump pointer
@POSHL	LD	A,(HL)		;get a char
	CP	' '		;separator?
	JR	Z,@POSHL-1	;ignore if yes
	CP	','		;separator?
	JR	Z,@POSHL-1	;ignore if yes
	CP	CR		;terminator?
	RET	Z		;yes, go!
	CP	ETX		;terminator?
	RET			;Z = nil text
;
;	display error message
;
@ERROR	EQU	$
;
	IF	TRS13
	OR	0C0H		;normal message
	JP	4409H		;display message
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save BC
	AND	7FH		;assure a return
	LD	B,A		;pass error code
	LD	A,39		;SVC # error
	RST	8		;display error
	POP	BC		;restore stack
	RET			;done!
	ENDIF
;
;	video display + keyboard input
;
@VIDKEY	CALL	@VDLINE		;display video text
	EX	DE,HL		;swap registers
;
;	fetch input string from keyboard
;
@KBLINE	EQU	$
;
	IF	TRS13
	CALL	0040H		;get input line
	LD	A,0		;init error
	INC	A		;set Z flag
	DEC	A		;but leave C flag
	RET			;done!
	ENDIF
;
	IF	TRS2
	LD	A,5		;SVC # kbline
	RST	8		;get input line
	RET			;done!
	ENDIF
;
;	fetch top memory for program driver
;
@FETMEM	PUSH	DE		;save
	PUSH	HL
;
	CALL	@HIMEM		;get high memory
	OR	A		;clear carry flag
	LD	(OLDMEM),HL	;save old high memory
	SBC	HL,BC		;HL = new low memory
	EX	DE,HL		;DE = new hi memory
	LD	HL,PGMEND	;program end
	OR	A		;clear carry
	SBC	HL,DE		;pgmend < new hi mem?
	JR	NC,FETERR	;insufficient memory!
	EX	DE,HL		;HL = new himem
	CALL	@SETMEM		;set high memory
;
FETOK	EX	(SP),HL		;put HL on stack
	POP	HL		;restore stack
	POP	DE		;restore
	XOR	A		;return Z for OK
	RET			;done!
;
FETERR	POP	HL		;unstack
	POP	DE
	OR	-1		;set NZ for error
	RET			;done!
;
;	fetch high memory
;
@HIMEM	EQU	$
;
	IF	TRS13
	LD	A,(0125H)	;check ROM for model
	CP	'I'		;mod III?
	LD	HL,4411H	;topmem III
	JR	Z,$+5		;go if III
	LD	HL,4049H	;topmem I
	LD	(TOPADD),HL	;save address
	LD	(TOPSET),HL	;save for update
	LD	HL,($)		;get topmem
TOPADD	EQU	$-2
	RET			;done
	ENDIF
;
	IF	TRS2
	LD	HL,0173H	;topmem II
	LD	(TOPSET),HL	;save for update
	LD	HL,(0173H)	;read topmem
	RET			;return it
	ENDIF
;
@SETMEM	LD	($),HL		;update topmem
TOPSET	EQU	$-2
	RET			;done!
;
;##
;
;	relocation table
;
CTABLE	DEFW	RELO1
	DEFW	RELO2
	DEFW	RELO3
	DEFW	RELO4
	DEFW	RELO5
	DEFW	RELO6
	DEFW	RELO7
	DEFW	RELO8
	DEFW	RELO9
	DEFW	RELO10
	DEFW	RELO11
	DEFW	RELO12
	DEFW	RELO13
	DEFW	RELO14
	DEFW	RELO15
	DEFW	RELO16
	DEFW	RELO17
	DEFW	RELO18
	DEFW	RELO19
	DEFW	RELO20
	DEFW	RELO21
	DEFW	RELO22
	DEFW	RELO23
	DEFW	RELO24
	DEFW	RELO25
	DEFW	RELO26
	DEFW	RELO27
	DEFW	RELO28
	DEFW	RELO29
	DEFW	RELO30
	DEFW	RELO31
	DEFW	RELO32
	DEFW	RELO33
	DEFW	RELO34
	DEFW	RELO35
	DEFW	RELO36
	DEFW	RELO37
	DEFW	RELO38
	DEFW	RELO39
	DEFW	RELO40
	DEFW	RELO41
	DEFW	RELO42
	DEFW	RELO43
	DEFW	RELO44
	DEFW	RELO45
	DEFW	RELO46
	DEFW	RELO47
	DEFW	RELO48
	DEFW	RELO49
	DEFW	RELO50
	DEFW	RELO51
	DEFW	RELO52
	DEFW	RELO53
	DEFW	RELO54
	DEFW	RELO55
	DEFW	RELO56
	DEFW	RELO57
	DEFW	RELO58
	DEFW	RELO59
	DEFW	RELO60
	DEFW	RELO61
	DEFW	RELO62
	DEFW	RELO63
	DEFW	RELOA
	DEFW	RELOB
;
	IF	TRS2
	DEFW	REL201
	DEFW	REL202
	DEFW	REL203
	DEFW	REL204
	DEFW	REL205
	DEFW	REL206
	DEFW	REL207
	DEFW	REL208
	DEFW	REL209
	DEFW	REL210
	DEFW	REL211
	DEFW	REL212
	DEFW	REL213
	ENDIF
	DEFW	-1		;table terminator
;
KEYBUFF	DEFM	'................................'
	DEFM	'................................'
;
HELLO	DEFB	CR
	DEFM	'VDISK - '
	DEFM	'Virtual Disk Utility - '
	DEFM	'by Kim Watt - '
	DEFM	'Version 0.00'
	DEFB	CR
	DEFM	'(C) Copyright 1983 - '
	DEFM	'Breeze/QSD, Inc. - '
	DEFM	'Dallas, Texas'
	DEFB	CR
	DEFB	CR
	DEFB	ETX
;
HEADER	DEFM	'Virtual  Archive'
	DEFM	'Breeze/QSD, Inc.'
HEADERL	EQU	$-HEADER
;
ERRMSGI	DEFM	'Index Identity Error'
	DEFB	CR
	DEFB	ETX
;
ERRMSGN	DEFM	'Nil Index File'
	DEFB	CR
	DEFB	ETX
;
ERRMSGP	DEFM	'Parameter Error'
	DEFB	CR
	DEFB	ETX
;
ERRMSGM	DEFM	'Insufficient Memory'
	DEFB	CR
	DEFB	ETX
;
PTEXT	DEFB	CR
	DEFM	'*'
	DEFB	ETX
;
HELP	DEFB	CR
	DEFM	'Source, Destination, Index'
	DEFB	CR
	DEFB	ETX
;
FNAME	DEFM	'xxxxxxxxxxx'
;
CLRLIN	EQU	$
	IF	TRS13
	DEFB	BOL
	DEFB	EOL
	DEFB	ETX
	ENDIF
	IF	TRS2
	DEFB	CR
	DEFB	UFEED
	DEFB	EOL
	DEFB	ETX
	ENDIF
;
;
	PAGE
;
;	actual relocated program code
;
CSTART	EQU	$		;start relocatable code
;
;	upper memory header
;
CENTRY	JR	CBEGIN		;actual entry point
OLDMEM	DEFW	$		;original highmem
	DEFB	HEADL		;header length
HEAD	DEFM	'VDISK'
HEADL	EQU	$-HEAD
;
CBEGIN	CALL	$		;call original open
OPEN1	EQU	$-2
	RET	Z		;OK, return
	CP	NFOUND		;not found error?
	RET	NZ		;nope, return error
;
	CALL	CRACK		;crack filespec
RELO1	EQU	$-2
	RET	NZ		;go if error
	CALL	ININDEX		;file listed in index?
RELO2	EQU	$-2
	RET	NZ		;nope, return error
	CALL	MOUNT		;mount required disk
RELO3	EQU	$-2
	CP	BREAK		;break key?
	JP	Z,@EXIT		;yes, go!
RELOB	EQU	$-2
	CALL	COPY		;copy the file
RELO4	EQU	$-2
	RET	NZ		;go if disk error
	JP	$		;go original open
OPEN2	EQU	$-2
;
;	check to see if file listed in index
;
ININDEX	CALL	@SAVREG		;save registers
RELO5	EQU	$-2
	LD	HL,BTABLE	;bucket table
RELO6	EQU	$-2
	LD	A,(DE)		;get first char filename
	SUB	'A'		;compute index posit
	JR	NC,$+4		;go if in range
	LD	A,25		;else use Z slot
	CP	26		;0-25?
	JR	C,$+4		;go if in range
	LD	A,25		;else force in range to Z
	LD	B,A		;pass entry number
	LD	C,8		;8 bytes / entry
	CALL	@POINT		;point to bucket entry
RELO7	EQU	$-2
	PUSH	HL		;pass to IY
	POP	IY		;IY => bucket data
;
;	check for nil bucket
;
	LD	A,(IY+0)	;get # entries in bucket
	OR	(IY+1)		;anything?
	JR	Z,NOINDEX	;nope, not in index
;
;	fetch starting thread record #
;
	LD	B,(IY+2)	;get start bucket record
	LD	H,(IY+3)
	LD	L,(IY+4)	;BHL = record #
;
INDLOOP	CALL	READIND		;read index record
RELO8	EQU	$-2
	RET	NZ		;go if disk error
	CALL	RECMAT		;record match?
RELO9	EQU	$-2
	RET	Z		;yes, have the file!
	LD	B,(IY+13)	;get next entry address
	LD	H,(IY+14)
	LD	L,(IY+15)
	LD	A,B		;BHL = 000000H?
	OR	H
	OR	L		;terminator?
	JR	NZ,INDLOOP	;check more if not
;
NOINDEX	LD	A,NFOUND	;not found
	OR	A		;return NZ
	RET			;return in error
;
;	point to table entry
;
@POINT	INC	B		;request 0?
POINT1	DEC	B		;done?
	RET	Z		;yes, go!
	LD	A,C		;get offset
	ADD	A,L		;add LSB table
	LD	L,A		;update
	JR	NC,POINT1	;go if no carry
	INC	H		;else bump MSB
	JR	POINT1		;continue
;
;	read index record
;
READIND	PUSH	DE		;save filename pointer
	LD	C,16		;# entries / sector
	CALL	@DIVID		;divide BHL / C
RELO10	EQU	$-2
	LD	(INDOFF),A	;save remainder
RELO11	EQU	$-2
	CALL	@INC		;increment BHL
RELO12	EQU	$-2
	LD	IY,RECORD	;start record storage
RELOA	EQU	$-2
	LD	(IY+0),B	;load MSB
	LD	(IY+1),H	;load NSB
	LD	(IY+2),L	;load LSB
	PUSH	IY		;pass to BC
	POP	BC		;BC => record #
	LD	DE,IFCB		;index FCB
RELO13	EQU	$-2
	CALL	@POSN		;position to record
RELO14	EQU	$-2
	JR	NZ,READERR	;read error!
	CALL	@READ		;read the record
RELO15	EQU	$-2
	JR	NZ,READERR	;read error!
	LD	HL,0		;get index offset
INDOFF	EQU	$-2
	ADD	HL,HL		;*2
	ADD	HL,HL		;*4
	ADD	HL,HL		;*8
	ADD	HL,HL		;*16
	LD	BC,IBUFF	;index I/O buffer
RELO16	EQU	$-2
	ADD	HL,BC		;HL => record
	PUSH	HL		;pass to IY
	POP	IY		;IY => entry
	XOR	A		;no error
READERR	POP	DE		;restore stack
	RET			;return status
;
;	compare current record with desired one
;
RECMAT	LD	B,11		;11 chars to check
	LD	DE,FNAME	;stored filename
RELO17	EQU	$-2
;
@COMP	LD	A,(DE)		;get a byte
	CP	(HL)		;match?
	RET	NZ		;nope, continue
	INC	DE		;bump pointers
	INC	HL
	DJNZ	@COMP		;go for length
	RET			;done!
;
;	crack filespec to normalize it
;
CRACK	CALL	@SAVREG		;save registers
RELO18	EQU	$-2
	LD	HL,FNAME	;filespec
RELO19	EQU	$-2
	LD	B,11		;11 chars in name
	PUSH	HL		;save start
;
CRACK1	LD	(HL),' '	;set to nil
	INC	HL		;bump pointer
	DJNZ	CRACK1		;finish initing
	POP	HL		;restore pointer start
	EX	DE,HL		;HL => filespec
	LD	B,8		;8 chars in name
	CALL	GETFLD		;get field
RELO20	EQU	$-2
	LD	C,A		;save term char
	LD	A,B		;get length
	CP	8		;anything?
	JR	NZ,CRACK2	;go if yes
;
CRACKNO	LD	A,NFOUND	;set error code
	OR	A		;set NZ
	RET			;go!
;
CRACK2	LD	A,C		;get term char
	CP	'/'		;extension?
	JR	Z,CRACK3	;yes, fetch it
	XOR	A		;else done!
	RET			;cracked!
;
CRACK3	LD	B,3		;3 chars to move
	LD	DE,FNAME+8	;place it here
RELO21	EQU	$-2
	CALL	GETFLD		;get field
RELO22	EQU	$-2
	LD	A,B		;anything?
	CP	3		;nil?
	JR	Z,CRACKNO	;yes, invalid!
	XOR	A		;else return Z
	RET			;done!
;
;	fetch field from part filespec
;
GETFLD	LD	A,(HL)		;get a char
	CALL	VALCHAR		;valid fspec char?
RELO23	EQU	$-2
	INC	HL		;bump pointer
	RET	Z		;invalid, return!
	CALL	@UCASE		;make upper case
RELO24	EQU	$-2
	LD	(DE),A		;to name saver
	INC	DE		;bump pointer
	DJNZ	GETFLD		;go for length
	LD	A,(HL)		;get term char
	INC	HL		;bump pointer
	RET			;return with char
;
;	check for valid filespec char
;
VALCHAR	PUSH	HL		;save HL/BC
	PUSH	BC
	LD	HL,CHRTBL	;invalid char list
RELO25	EQU	$-2
	LD	BC,CHRTBLL	;table length
	CPIR			;find it!
	POP	BC		;unstack
	POP	HL
	RET			;Z = invalid char!
;
CHRTBL	DEFM	'('
	DEFM	')'
	DEFM	','
	DEFM	'.'
	DEFM	'/'
	DEFM	';'
	DEFM	' '
	DEFM	':'
	DEFM	'@'
	DEFM	'*'
	DEFM	'='
	DEFM	'"'
	DEFB	27H
	DEFB	03H
	DEFB	0DH
	DEFB	7BH
	DEFB	7DH
CHRTBLL	EQU	$-CHRTBL
;
;	request user to mount desired disk
;
MOUNT	CALL	@SAVREG		;save registers
RELO26	EQU	$-2
	LD	H,(IY+11)	;get disk #
	LD	L,(IY+12)
	LD	IX,MNTDISK	;text to place ascii
RELO27	EQU	$-2
	CALL	@BINASC		;binary => ascii
RELO28	EQU	$-2
;
;	flash message, wait for a key
;
MOUNTOF	LD	HL,CLRLIN	;clear current line
RELO29	EQU	$-2
	JR	MOUNTFL		;display and wait
;
MOUNTON	LD	HL,MNTMSG	;mount prompt
RELO30	EQU	$-2
;
MOUNTFL	CALL	@VDLINE		;display prompt
RELO31	EQU	$-2
MOUNTWT	CALL	@KBCHAR		;scan keyboard
RELO32	EQU	$-2
	JR	Z,MOUNTEN	;have one, go!
;
	LD	A,0		;get flash count
FCOUNT	EQU	$-1
	DEC	A		;less one
	LD	(FCOUNT),A	;update
RELO33	EQU	$-2
	JR	NZ,MOUNTWT	;wait for a key
;
	LD	A,0		;get flash code
FWHICH	EQU	$-1
	XOR	1		;reverse bit 0
	LD	(FWHICH),A	;update
RELO34	EQU	$-2
	JR	Z,MOUNTON	;go if ON
	JR	MOUNTOF		;go if OFF
;
MOUNTEN	CP	BREAK		;break key?
	JR	Z,MOUNTQ	;yes, quit!
	CP	CR		;carriage return
	JR	NZ,MOUNTWT	;wait for one if not
MOUNTQ	PUSH	AF		;save key
	LD	HL,CLRLIN	;text
RELO35	EQU	$-2
	CALL	@VDLINE		;display
RELO36	EQU	$-2
	POP	AF		;restore key
	RET			;done!
;
;	copy file from data disk to dest drive
;
COPY	CALL	@SAVREG		;save registers
RELO37	EQU	$-2
	LD	DE,SFCB		;source file block
RELO38	EQU	$-2
	LD	BC,(DBLOCK+0)	;get source drive #
RELO39	EQU	$-2
	CALL	COPYSET		;move into filespec
RELO40	EQU	$-2
	CALL	COPYOPE		;open file
RELO41	EQU	$-2
	RET	NZ		;go if error
	LD	DE,DFCB		;dest file block
RELO42	EQU	$-2
	LD	BC,(DBLOCK+1)	;get dest drive #
RELO43	EQU	$-2
	CALL	COPYSET		;move into filespec
RELO44	EQU	$-2
	CALL	COPYINT		;open/create file
RELO45	EQU	$-2
	RET	NZ		;go if error
;
;	get LRL/EOFB from source and save them
;	set LRL to 00 for both source and dest
;
	LD	IX,SFCB		;source file block
RELO46	EQU	$-2
;
	IF	TRS13
	SET	7,(IX+1)	;sector operations
	LD	A,(IX+8)	;get EOF byte
	LD	(EOFB),A	;save it
RELO47	EQU	$-2
	LD	A,(IX+9)	;get LRL
	LD	(LRL),A		;save it
RELO48	EQU	$-2
	LD	(IX+9),0	;set LRL to 0
	ENDIF
;
	IF	TRS2
	SET	7,(IX+1)	;sector operations
	LD	A,(IX+14)	;get end of byte byte
	LD	(EOFB),A	;save it
RELO47	EQU	$-2
	LD	A,(IX+15)	;get LRL
	LD	(LRL),A		;save it
RELO48	EQU	$-2
	LD	(IX+15),0	;set LRL to 0
	ENDIF
;
	LD	IX,DFCB		;dest file block
RELO49	EQU	$-2
;
	IF	TRS13
	SET	7,(IX+1)	;sector operations
	LD	(IX+9),0	;set LRL = 0
	ENDIF
;
	IF	TRS2
	SET	7,(IX+1)	;sector operations
	LD	(IX+15),0	;set LRL = 0
	ENDIF
;
;	setup loop to transfer file
;
COPYLP	LD	DE,SFCB		;source FCB
RELO50	EQU	$-2
	CALL	@READ		;read the sector
RELO51	EQU	$-2
	JR	NZ,COPYEN	;go if error
	LD	DE,DFCB		;dest FCB
RELO52	EQU	$-2
	CALL	@WRITE		;write the sector
RELO53	EQU	$-2
	RET	NZ		;go if error!
	JR	COPYLP		;else continue
;
COPYEN	CP	1CH		;end of file?
	RET	NZ		;nope, return error
;
;	reset EOFB and LRL into dest FCB before close
;
	LD	IX,DFCB		;dest file block
RELO54	EQU	$-2
	LD	BC,0		;get EOFB and LRL
EOFB	EQU	$-2
LRL	EQU	$-1
;
	IF	TRS13
	LD	(IX+8),C	;pass EOFB
	LD	(IX+9),B	;pass LRL
	ENDIF
;
	IF	TRS2
	LD	(IX+14),C	;pass EOFB
	LD	(IX+15),B	;pass LRL
	ENDIF
;
	LD	DE,DFCB		;dest file block
RELO55	EQU	$-2
;
;	close file
;
@CLOSE	EQU	$
;
	IF	TRS13
	JP	4428H		;close file
	ENDIF
;
	IF	TRS2
	LD	A,42		;SVC # close
	RST	8		;close file
	RET			;return status
	ENDIF
;
;	setup filespec for copy open
;
COPYSET	PUSH	DE		;save FCB start
	LD	B,8		;8 chars name
	LD	HL,FNAME	;start filename
RELO56	EQU	$-2
	CALL	COPYMOV		;move field in
RELO57	EQU	$-2
	LD	B,3		;3 char extension
	LD	A,(HL)		;get next char
	CP	' '		;blank?
	CALL	NZ,COPYMOV	;move in if extension
RELO58	EQU	$-2
	EX	DE,HL		;HL => fcb field
	LD	(HL),':'	;load drive specifier
	INC	HL		;bump pointer
	LD	(HL),C		;load drive #
	INC	HL		;bump pointer
	LD	(HL),ETX	;end of text
	POP	DE		;restore start
	RET			;done!
;
COPYMOV	LD	A,(HL)		;get a char
	INC	HL		;bump pointer
	CP	' '		;blank char?
	JR	Z,COPYMVN	;skip if yes
	LD	(DE),A		;to FCB
	INC	DE		;bump pointer
COPYMVN	DJNZ	COPYMOV		;go for length
	RET			;done!
;
;	open file for copy
;
COPYOPE	LD	HL,SDBUFF	;source dest I/O buffer
RELO59	EQU	$-2
;
	IF	TRS13
	PUSH	BC		;save
	LD	B,0		;LRL
	CALL	$		;open file
OPEN3	EQU	$-2
	POP	BC		;unstack
	RET			;return status
	ENDIF
;
	IF	TRS2
	XOR	A		;LRL
	LD	(OLISTL),A	;pass LRL
REL201	EQU	$-2
	LD	(OLISTI),HL	;pass I/O buffer
REL202	EQU	$-2
	LD	(OLISTT),A	;create code
REL203	EQU	$-2
	PUSH	HL		;save HL
	LD	HL,OLIST	;start param list
REL204	EQU	$-2
	CALL	$		;open file
OPEN3	EQU	$-2
	POP	HL		;restore HL
	RET			;return status
	ENDIF
;
;	open/create new file
;
COPYINT	LD	HL,SDBUFF	;source/dest I/O buffer
RELO60	EQU	$-2
;
	IF	TRS13
	PUSH	BC		;save it
	LD	B,0		;LRL
	CALL	4420H		;open/create file
	POP	BC		;restore BC
	RET			;return status
	ENDIF
;
	IF	TRS2
	XOR	A		;LRL
	LD	(OLISTL),A	;pass LRL
REL205	EQU	$-2
	LD	(OLISTI),HL	;pass I/O buffer
REL206	EQU	$-2
	LD	A,2		;creation code
	LD	(OLISTT),A	;pass code
REL207	EQU	$-2
	PUSH	HL		;save HL
	LD	HL,OLIST	;start param list
REL208	EQU	$-2
	LD	A,40		;SVC # open
	RST	8		;open file
	POP	HL		;unstack
	RET			;return status
	ENDIF
;
;	open existing file
;
@OPEN	EQU	$
;
	IF	TRS13
	PUSH	BC		;save
	LD	B,A		;pass LRL
	CALL	4424H		;open file
	POP	BC		;restore
	RET			;return status
	ENDIF
;
	IF	TRS2
	LD	(OLISTL),A	;pass LRL
REL209	EQU	$-2
	LD	(OLISTI),HL	;pass I/O buffer
REL210	EQU	$-2
	LD	(OLISTB),HL	;pass EODAD
REL211	EQU	$-2
	PUSH	HL		;save it
	LD	HL,OLIST	;start of list
REL212	EQU	$-2
	XOR	A		;open code
	LD	(OLISTT),A	;pass it
REL213	EQU	$-2
	LD	A,40		;SVC # open
	RST	8		;open file
	POP	HL		;restore HL
	RET			;return status
;
OLIST	EQU	$
OLISTI	DEFW	0000H		;I/O buffer
OLISTB	DEFW	0000H		;blocking buffer
	DEFW	0000H		;EODAD
	DEFB	'W'		;access type write
OLISTL	DEFB	0		;LRL
	DEFB	'E'		;open mode
OLISTT	DEFB	0		;creation code
	DEFB	0		;list terminator
	ENDIF
;
;	read file record
;
@READ	EQU	$
;
	IF	TRS13
	JP	4436H		;read record
	ENDIF
;
	IF	TRS2
	LD	A,34		;SVC # readnx
	RST	8		;read record
	RET			;return status
	ENDIF
;
;	write record
;
@WRITE	EQU	$
;
	IF	TRS13
	JP	4439H		;write record
	ENDIF
;
	IF	TRS2
	LD	A,43		;SVC # writnx
	RST	8		;write record
	RET			;return status
	ENDIF
;
;	position to logical record
;
@POSN	EQU	$
;
	IF	TRS13
	PUSH	BC		;save
	PUSH	HL		;save
	LD	H,B		;pass BC => HL
	LD	L,C		;HL => record #
	INC	HL		;ignore MSB
	LD	B,(HL)		;get NSB
	INC	HL		;bump pointer
	LD	C,(HL)		;get LSB
	POP	HL		;restore HL
	CALL	4442H		;position
	POP	BC		;restore BC
	RET			;return status
	ENDIF
;
	IF	TRS2
	LD	A,79		;SVC # posit
	RST	8		;position to record
	RET			;return status
	ENDIF
;
;	display string to video
;
@VDLINE	PUSH	HL		;save string start
VDLINY	LD	A,(HL)		;get string char
	CP	ETX		;end of text?
	JR	Z,VDLINZ	;go if yes
	CALL	@VDCHAR		;send char to video
RELO61	EQU	$-2
	JR	NZ,VDLINZ	;go if error
	INC	HL		;bump pointer
	JR	VDLINY		;go next char
VDLINZ	POP	HL		;restore string start
	RET	NZ		;go if error
	XOR	A		;else return ZERO
	RET			;done!
;
;	character to video
;
@VDCHAR	EQU	$
;
	IF	TRS13
	PUSH	DE		;save
	PUSH	IY		;save
	CALL	0033H		;char to video
	POP	IY		;restore
	POP	DE		;restore
	RET			;return status
	ENDIF
;
	IF	TRS2
	PUSH	BC		;save BC
	LD	B,A		;pass char to B
	LD	A,8		;SVC # vdchar
	RST	8		;char to video
	POP	BC		;restore stack
	RET			;return status
	ENDIF
;
;	fetch char from keyboard
;
@KBCHAR	EQU	$
;
	IF	TRS13
	PUSH	DE		;save
	PUSH	IY		;save
	CALL	002BH		;scan keyboard
	POP	IY		;restore
	POP	DE		;restore
	OR	A		;any chars?
	JR	Z,$+4		;go if not
	CP	A		;set Z for have char
	RET			;return Z
	OR	8		;set NZ no char
	RET			;return NZ
	ENDIF
;
	IF	TRS2
	LD	A,4		;SVC # kbchar
	RST	8		;scan keyboard
	RET			;return Z if char
	ENDIF
;
;	preserve registers
;
@SAVREG	POP	AF		;get caller address
	PUSH	IY		;save registers
	PUSH	IX
	PUSH	HL
	PUSH	DE
	PUSH	BC
	PUSH	HL
	LD	HL,SAVREG1	;return vector
RELO62	EQU	$-2
	EX	(SP),HL		;get HL, leave vector
	PUSH	AF		;put caller back
	RET			;back to caller
;
SAVREG1	POP	BC		;unstack 'em
	POP	DE
	POP	HL
	POP	IX
	POP	IY
	RET			;A returned intact
;
;	convert character to upper case
;
@UCASE	CP	'a'		;already upper?
	RET	C		;yes, no change
	CP	'z'+1		;in lower range?
	RET	NC		;nope, no change
	SUB	20H		;make upper case
	RET			;done!
;
;	divide - BHLrA = BHL/C
;
@DIVID	PUSH	DE		;save it
	LD	D,C		;D = divisor
	LD	E,24		;precision
	XOR	A		;init LSB bits
;
DIVD1	ADD	HL,HL		;shift left (*2)
	RL	B		;shift left (*2)
	RLA			;any overflow?
	JR	C,DIVD2		;go if yes
	CP	D		;at divisor?
	JR	C,DIVD3		;go if not
;
DIVD2	SUB	D		;less divisor
	INC	L		;quotient +1
;
DIVD3	DEC	E		;less precision counter
	JR	NZ,DIVD1	;go for precision
	POP	DE		;unstack
	RET			;done!
;
;	increment BHL
;
@INC	INC	L		;bump LSB
	RET	NZ		;not FF => 00
	INC	H		;bump NSB
	RET	NZ		;not FF => 00
	INC	B		;bump MSB
	RET			;BHL = BHL + 1
;
;	convert binary BHL => ascii (IX)
;
@BINASC	LD	IY,TENTBL	;lookup table
RELO63	EQU	$-2
;
BINASC1	LD	(IX+0),'0'	;init digit
	LD	E,(IY+0)	;get 10's place
	LD	D,(IY+1)	;DE = max value for digit
;
BINASC2	OR	A		;clear carry
	SBC	HL,DE		;less place
	JR	C,BINASC3	;go if digit found
	INC	(IX+0)		;bump ascii digit
	JR	BINASC2		;continue
;
BINASC3	ADD	HL,DE		;add last overflow back
	INC	IX		;bump string pointer
	INC	IY		;bump 10's table
	INC	IY		;2 byte entries
	DEC	E		;last digit?
	JR	NZ,BINASC1	;go if more
	RET			;else done!
;
TENTBL	DEFW	10000		;define decimal places
	DEFW	1000
	DEFW	100
	DEFW	10
	DEFW	1
;
;##
;
IFCB	DEFM	'VDISK/IND:'
IDRV	DEFM	'x'
	DEFB	ETX
	DEFM	'xxxxxxxxxxxxxxxxxxx'
	DEFM	'xxxxxxxxxxxxxxxxxxx'
;
MNTMSG	DEFM	'Mount Disk # '
MNTDISK	DEFM	'xxxxx'
	DEFB	ETX
;
DBLOCK	DEFB	0,0,0
RECORD	DEFB	0,0,0
;
IBUFF	DEFS	256
;
SFCB	DEFS	50
DFCB	DEFS	50
SDBUFF	DEFS	256
BTABLE	DEFS	26*8
;
CEND	EQU	$
CSIZE	EQU	CEND-CSTART
PGMEND	EQU	$
;
	END	ENTRY
