; supatchm/asm - kjw/bqsd - 02/83
;
; revised 06/08/83 - dwh
;
	TITLE		'<Patch File MAX>'
;
;	program equates
;
PATCHES	EQU	9D59H		;start patch area
PATCH	DEFL	PATCHES		;label for patches
TEMP1	EQU	1050H		;temp storage 1
TEMP5	EQU	1058H		;temp storage 5
;
;	** Patch 1 ** 03/28/83 ** kjw/rbr **
;
; Correct incorrect placement of user track count
; from the 'use configuration' prompt in formatting
;
	ORG	5F4BH
PATCH1	DEFB	00		;(IY+1) => (IY+0)
;
;	** Patch 2 ** 03/28 83 ** kjw/rbr **
;
; Correct invalid calculation of GAT table bytes
; on double sided dosplus diskettes
;
	ORG	5D17H
PATCH2	DEFB	00,00,00	;LD A,(IY+7)
	DEFB	00,00		;CP 7
	DEFB	00,00		;JR C,MNYGRN3
	DEFB	00,00		;CP 10
	DEFB	00,00		;JR C,MNYGRN1
;
;	** Patch 3 ** 03/28/83 ** kjw/rbr **
;
; Improve disk end detection during formatting
;
	ORG	607FH
PATCH3	DEFB	30H		;JR Z => JR NC
;
;	** Patch 4 ** 03/28/83 ** kjw/rbr **
;
; Corrects format without erase using R specifier
;
	ORG	601EH
PATCH4	DEFB	00,00		;AND 0E7H
	CALL	PATCH4A		;execute patch
;
	ORG	6088H
	CALL	PATCH4B		;restore saved config
;
	ORG	PATCH
PATCH4A	PUSH	AF		;save unmasked A
	AND	0E7H		;reset rel sectoring
	LD	(IY+6),A	;update DCT
	LD	A,(IY+8)	;highest sector 0
	LD	(TEMP5),A	;save it
	LD	A,(IY+9)	;highest sector disk
	LD	(TEMP5+1),A	;save it
	POP	AF		;restore config
	BIT	3,A		;relative engaged?
	RET	Z		;nope, go!
	BIT	7,(IY+6)	;double den track 0?
	CALL	PATCH4C		;load 10/18
	LD	(IY+8),A	;highest sector 0
	BIT	6,(IY+6)	;double den disk?
	CALL	PATCH4C		;load 10/18
	LD	(IY+9),A	;highest sector disk
	RET			;continue!
;
PATCH4C	LD	A,9		;highest sector single
	RET	Z		;go if single
	LD	A,17		;highest sector double
	RET			;go double
;
PATCH4B	LD	A,(TEMP5)	;get saved config
	LD	(IY+8),A	;save it
	LD	A,(TEMP5+1)	;second part
	LD	(IY+9),A	;save it
	LD	A,(TEMP1)	;get saved config
	RET			;continue!
PATCH	DEFL	$		;next patch address
;
;	** Patch 5 ** 03/28/83 ** kjw/rbr **
;
; Correct directory length computation during format
;
	ORG	61DFH
PATCH5	CALL	PATCH5A		;CALL GETDIR
;
	ORG	PATCH
PATCH5A	CALL	2484H		;CALL $GETDIR
	DEC	A		;adjust for compare
	RET			;return new value
PATCH	DEFL	$		;next patch
;
;	** Patch 6 ** 03/28/83 ** kjw/rbr **
;
; Resets 'continuous' mode after all operations
;
	ORG	295AH
PATCH6	CALL	PATCH6A		;CALL TASKDRV
;
	ORG	PATCH
PATCH6A	CALL	2E3EH		;CALL $INITBAD
	JP	32A2H		;JP $TASKDRV
PATCH	DEFL	$		;next patch
;
;	** Patch 7 ** 03/28/83 ** kjw/rbr **
;
; Informational patch on Backup using R specifier
;
;	** Patch 8 ** 03/28/83 ** kjw/rbr **
;
; Corrects configuration O/F parameters if both used
;
	ORG	99E6H
PATCH8	CALL	PATCH8A		;new code
;
	ORG	PATCH
PATCH8A	LD	A,(DE)		;get string value
	CP	0DH		;terminator?
	RET	Z		;yes, go!
	CP	' '		;separator?
	JR	Z,PATCH8B	;go if yes
	CP	','		;separator?
	RET	NZ		;nope, resume
PATCH8B	EX	(SP),HL		;put HL on stack
	POP	HL		;dummy pop call address
	JP	99EDH		;continue parse
PATCH	DEFL	$		;next patch
;
;	** Patch 9 ** 04/04/83 ** kjw **
;
;	Corrects subroutine to compute the number
;	of sectors on an 8" disk
;
	ORG	2FC2H		;$CNTOTAL
PATCH9	PUSH	BC		;save
	PUSH	DE		;save
	LD	C,(IY+0)	;C = # tracks physical
	DEC	C		;minus one
	LD	B,0		;BC = tracks -1
	LD	H,B		;init HL => 0000
	LD	L,B		;HL = 0000
	LD	D,1		;set non track 0
	CALL	29E1H		;$FIRSTS - A = secs/track
CNTLP	ADD	HL,BC		;HL = HL + # tracks
	DEC	A		;less sector count
	JR	NZ,CNTLP	;go for count
	DEC	D		;D = 0
	CALL	29E1H		;$FIRSTS - A = secs/track
	LD	C,A		;BC = # sectors / track
	ADD	HL,BC		;HL = total
	POP	DE		;unstack
	POP	BC		;unstack
	BIT	0,(IY+5)	;2 sides?
	RET	Z		;nope, done!
	ADD	HL,HL		;else twice as many
	RET			;HL = count
;
;	** Patch 10 ** 04/04/83 ** kjw **
;
; Corrects loss of 8" bit in special backup
;
	ORG	7084H		;near $UTFMT0
PATCH10	DEFB	44H		;AND 40H => 44H
;
;	** Patch 11 ** 04/04/83 ** kjw **
;
; Extends tolerance to disk motor variation
; during $DRVCHK operations
;
	ORG	7C56H
PATCH11	DEFB	0C0H		;BC,6000H => C000H
;
;	** Patch 12 ** 05/17/83 ** dwh **
;
; corrects subroutine reset of 8 inch bit at CKCONF
; when X not specified
;
	ORG	32D7H
PATCH12	DEFB	00,00,00,00	;RES 2,(IY+5)
	ORG	3304H		;U
	CALL	PATCH12A
	ORG	330DH		;T
	CALL	PATCH12A
	ORG	332BH		;L
	CALL	PATCH12A
	ORG	3343H		;D
	CALL	PATCH12A
	ORG	3359H		;M
	CALL	PATCH12A
	ORG	336FH		;N
	CALL	PATCH12A
	ORG	3385H		;B
	CALL	PATCH12A
;
	ORG	PATCH
PATCH12A
	RES	2,(IY+5)	;set 5" drive
	JP	3436H		;CKSET density/model
PATCH	DEFL	$
;
;	** Patch 13 ** 05/17/83 ** dwh **
;
; corrects rare exit error
;
	ORG	3188H
PATCH13	XOR	A		;destroy it
;
;	** Patch 14 ** 05/17/83 ** dwh
;
; corrects Mod III repair boot sector
;
	ORG	95D3H
PATCH14	DEFB	21H		;LD BC -> LD HL
	ORG	95FFH
	OUT	(0F0H),A	;issue command
	ORG	9609H
	PUSH	HL
	ORG	961FH
	DEFB	00,00		;LD H,B:LD L,C
	ORG	9625H
	DEFB	00,00		;OUT (C),A
	ORG	9634H
	PUSH	HL
	LD	HL,43E5H	;NMI disk return vector
	LD	(404AH),HL	;save it
	POP	HL
	LD	A,0C0H		;allow interrupt
	OUT	(0E4H),A	;NMI on
	LD	A,80H		;read command
	DEFB	00		;,A
	ORG	9662H
	IN	A,(0F0H)	;read status
	ORG	9669H
	OUT	(0F0H),A	;send to port
;
;	** Patch 15 ** 05/17/83 ** kjw/dwh **
;
; Corrects T1D default password encoding
;
	ORG	57C5H
PATCH15	CALL	PATCH15A
	ORG	57CEH
	CALL	PATCH15B
	ORG	PATCH
PATCH15A
	CALL	PATCH15C
	DEFW	40CDH		;t1d blank
	DEFW	5CEFH		;t3d
PATCH15B
	CALL	PATCH15C
	DEFW	0CC13H		;t1d PASSWORD
	DEFW	8FD3H		;t3d
PATCH15C
	EX	(SP),HL		;t1d pw
	LD	A,(IY+7)	;get dos type
	CP	2		;t1d?
	JR	Z,$+4
	INC	HL
	INC	HL		;HL => t3d pw
	LD	C,(HL)		;lsb
	INC	HL
	LD	B,(HL)		;msb
	POP	HL		;normal pw
	RET
PATCH	DEFL	$
;
;	** Patch 16 ** 05/17/83 ** kjw **
;
;	Corrects format error detection
;
	ORG	2F5DH
PATCH16	DEFW	PATCH16A
	ORG	PATCH
PATCH16A
	CALL	2C2DH		;$SHOWST
	JP	291FH		;$GOBACK
PATCH	DEFL	$
;
;	** Patch 17 ** 05/19/83 ** dwh **
;
;	Corrects copy from FXDE files
;
	ORG	9266H
PATCH17	LD	IX,(TEMP5)	;start of records
	ADD	IX,DE		;IX => next entry
	NOP			;IX
;
;	** Patch 18 ** 05/25/83 ** dwh **
;
; Corrects loss of 8 inch bit in build format
;
	ORG	6E45H
PATCH18	DEFB	44H		;40H => 44H
;
;	** Patch 19 ** 05/25/83 ** dwh **
;
; Corrects no directory in copy files source
;
	ORG	8CB8H
PATCH19	DEFW	PATCH19A
	ORG	PATCH
PATCH19A
	CALL	5018H		;DIRLSTC
	RET	Z		;okay
	JP	291FH		;GOBACK
PATCH	DEFL	$
;
;	** Patch 20 ** 05/26/83 ** kjw **
;
; Corrects T1D length of file
;
	ORG	5402H
PATCH20	DEFB	28H		;JR NZ => JR Z
	ORG	82EFH
	DEFB	18H		;JR Z => JR
;
;	** Patch 21 ** 06/08/83 ** dwh **
;
; Corrects T1D repair boot
;
	ORG	94EFH
PATCH21	DEFB	43H		;4400 > 4300
;
	END	0000H		;retain original entry
