; sucopy1/asm - kjw/bqsd - 02/83
;
; revised 03/17/83 - kjw
;
;	system equates
;
CLS	EQU	0CH
CR	EQU	0DH
LF	EQU	0AH
ETX	EQU	03H
BREAK	EQU	01H
UARR	EQU	5BH
DARR	EQU	5CH
LARR	EQU	5DH
RARR	EQU	5EH
BACKSP	EQU	5DH
CLEAR	EQU	5FH
SPACE	EQU	20H
BOL	EQU	1DH
;
;	system data table, IY => it
;
SYSTEM	DEFB	00		;+0 - current track
	DEFB	35		;+1 - track count
	DEFB	03		;+2 - disk retry init
	DEFB	03		;+3 - retry current
	DEFB	00		;+4 - source drive
	DEFB	01		;+5 - select code
	DEFB	00		;+6 - current binary drv.
	DEFB	00		;+7 - step rate
	DEFB	00		;+8 - density
	DEFB	00		;+9 - bits
;7 - 1 = write operation else read
;6
;5
;4
;3
;2
;1
;0
;
	DEFB	00		;+10 - temp storage
	DEFB	00		;+11 - temp storage
CURSOR	DEFW	3C00H		;cursor posit
CTRACK	DEFB	0,0,0,0		;current track drives
ATABLE	DEFB	0,-1,-1,-1	;dest drives
LTABLE	DEFB	0,-1,-1,-1	;active this loop
;
SERNOS	DEFW	SERIAL0		;drive 0
	DEFW	SERIAL1		;drive 1
	DEFW	SERIAL2		;drive 2
	DEFW	SERIAL3		;drive 3
;
TABLES	DEFW	TABLE0		;0 - boot data
	DEFW	TABLE1		;1 - loaders
	DEFW	TABLEC8		;2 - 80 track checker
	DEFW	TABLE2		;3 - special formatter
	DEFW	TABLEC4		;4 - 40 track checker
	DEFW	TABLE2		;5 - protection checker
	DEFW	TABLE3		;6 - start program
	DEFW	TABLE3		;7
	DEFW	TABLE3		;8
	DEFW	TABLE3		;9
	DEFW	TABLE3		;10
	DEFW	TABLE3		;11
	DEFW	TABLE3		;12
	DEFW	TABLE3		;13
	DEFW	TABLE3		;14
	DEFW	TABLE3		;15
	DEFW	TABLE3		;16
	DEFW	TABLE3		;17
	DEFW	TABLE3		;18
	DEFW	TABLE3		;19
	DEFW	TABLE3		;20
	DEFW	TABLE3		;21
	DEFW	TABLE3		;22
	DEFW	TABLE3		;23
	DEFW	TABLE3		;24
	DEFW	TABLE3		;25
	DEFW	TABLE3		;26
	DEFW	TABLE3		;27
	DEFW	TABLE3		;28
	DEFW	TABLE3		;29
	DEFW	TABLE3		;30
	DEFW	TABLE3		;31
	DEFW	TABLE3		;32
	DEFW	TABLE3		;33
	DEFW	TABLE3		;34
	DEFW	TABLE2		;35
	DEFW	TABLE2		;36
	DEFW	TABLE2		;37
	DEFW	TABLE2		;38
	DEFW	TABLE2		;39
;
SERIAL0	DEFM	'                                '
	DEFB	ETX
SERIAL1	DEFM	'                                '
	DEFB	ETX
SERIAL2	DEFM	'                                '
	DEFB	ETX
SERIAL3	DEFM	'                                '
	DEFB	ETX
;
;	table structure for creating track images
;
;	+00       - # sectors on track
;	+01 - +02 - pointer to single den byte count
;
;	repeat following for each sector
;
;	+03 - +04 - preid gap
;	+05 - +06 - preid sync
;	+07 - +08 - preid sync
;	+09       - track
;	+10       - head
;       +11       - sector
;	+12       - sector length
;	+13       - CRC byte
;	+14 - +15 - predata gap
;	+16 - +17 - predata sync
;	+18 - +19 - predata sync
;	+20       - data length / 256
;	+21       - data fill byte
;	+22       - CRC byte
;
;	NOTE:	gap and sync fields are specified
;		as BYTE, BYTE COUNT
;
;
TABLE0	DEFW	2697		;length of single density
;
;01
	DEFB	16,0FFH		;post-index
	DEFB	06,000H
	DEFB	01,0FCH
;
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,000H
	DEFB	01,000H
	DEFB	01,000H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0EEH
	DEFB	01,0F7H
;02
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,000H
	DEFB	01,000H
	DEFB	01,006H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0EEH
	DEFB	01,0F7H
;03
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,000H
	DEFB	01,000H
	DEFB	01,002H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0EEH
	DEFB	01,0F7H
;04
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,000H
	DEFB	01,000H
	DEFB	01,007H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0EEH
	DEFB	01,0F7H
;05
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,000H
	DEFB	01,000H
	DEFB	01,003H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0EEH
	DEFB	01,0F7H
;06
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,000H
	DEFB	01,000H
	DEFB	01,008H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0EEH
	DEFB	01,0F7H
;07
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,000H
	DEFB	01,000H
	DEFB	01,004H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0EEH
	DEFB	01,0F7H
;08
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,000H
	DEFB	01,000H
	DEFB	01,009H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0EEH
	DEFB	01,0F7H
;09
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,000H
	DEFB	01,000H
	DEFB	01,005H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0EEH
	DEFB	01,0F7H
;
	DEFB	12,0FFH		;gap before change
;10
	DEFB	22,04EH		;pre-id
	DEFB	12,000H
	DEFB	03,0F5H
	DEFB	01,0FEH
	DEFB	01,000H
	DEFB	01,000H
	DEFB	01,001H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	24,04EH		;pre-data
	DEFB	08,000H
	DEFB	03,0F5H
	DEFB	01,0FBH
	DEFB	00,0EEH
	DEFB	01,0F7H
	DEFB	22,04EH
;
	DEFB	00,04EH		;filler
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	-1,-1		;terminator
;
TABLE1	DEFW	1689		;length single den
;
	DEFB	16,0FFH		;post-index
	DEFB	06,000H
	DEFB	01,0FCH
;01
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,020H
	DEFB	01,020H
	DEFB	01,020H
	DEFB	01,002H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0DDH
	DEFB	00,0DDH
	DEFB	01,0F7H
;02
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,030H
	DEFB	01,030H
	DEFB	01,030H
	DEFB	01,002H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0DDH
	DEFB	00,0DDH
	DEFB	01,0F7H
;03
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,025H
	DEFB	01,025H
	DEFB	01,025H
	DEFB	01,002H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0DDH
	DEFB	00,0DDH
	DEFB	01,0F7H
;
	DEFB	12,0FFH		;gap before change
;04 - double
	DEFB	22,04EH		;pre-id
	DEFB	12,000H
	DEFB	03,0F5H
	DEFB	01,0FEH
	DEFB	01,040H
	DEFB	01,040H
	DEFB	01,040H
	DEFB	01,002H
	DEFB	01,0F7H
	DEFB	24,04EH		;pre-data
	DEFB	08,000H
	DEFB	03,0F5H
	DEFB	01,0FBH
	DEFB	00,0DDH
	DEFB	00,0DDH
	DEFB	01,0F7H
;05
	DEFB	22,04EH
	DEFB	12,000H
	DEFB	03,0F5H
	DEFB	01,0FEH
	DEFB	01,050H
	DEFB	01,050H
	DEFB	01,050H
	DEFB	01,002H
	DEFB	01,0F7H
	DEFB	24,04EH
	DEFB	08,000H
	DEFB	03,0F5H
	DEFB	01,0FBH
	DEFB	00,0DDH
	DEFB	00,0DDH
	DEFB	01,0F7H
;06
	DEFB	22,04EH
	DEFB	12,000H
	DEFB	03,0F5H
	DEFB	01,0FEH
	DEFB	01,045H
	DEFB	01,045H
	DEFB	01,045H
	DEFB	01,002H
	DEFB	01,0F7H
	DEFB	24,04EH		;pre-data
	DEFB	08,000H
	DEFB	03,0F5H
	DEFB	01,0FBH
	DEFB	00,0DDH
	DEFB	00,0DDH
	DEFB	01,0F7H
;
;	filler
;
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	-1,-1		;terminator
;
TABLE2	DEFW	1144		;length single density
;
;01
	DEFB	16,0FFH		;post-index
	DEFB	06,000H
	DEFB	01,0FCH
;
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,011H
	DEFB	01,011H
	DEFB	01,011H
	DEFB	01,002H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
;
;	protection again SU+ special backup
;
	DEFB	-2,-2		;serial #!
	DEFB	00,0CCH
	DEFB	02,0FFH
;02
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,022H
	DEFB	01,022H
	DEFB	01,022H
	DEFB	01,002H
	DEFB	02,0FFH
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0CCH
	DEFB	00,0CCH
	DEFB	02,0FFH
;
	DEFB	16,0FFH		;gap before change
;
;03
	DEFB	22,04EH		;pre-id
	DEFB	12,000H
	DEFB	03,0F5H
	DEFB	01,0FEH
	DEFB	01,033H
	DEFB	01,033H
	DEFB	01,033H
	DEFB	01,002H
	DEFB	01,0F7H
	DEFB	24,04EH		;pre-data
	DEFB	08,000H
	DEFB	03,0F5H
	DEFB	01,0FBH
;
;	protection against SU+ special backup
;
	DEFB	-2,-2		;prot id
	DEFB	00,0CCH
	DEFB	02,0FFH
;04
	DEFB	22,04EH		;pre-id
	DEFB	12,000H
	DEFB	03,0F5H
	DEFB	01,0FEH
	DEFB	01,044H
	DEFB	01,044H
	DEFB	01,044H
	DEFB	01,002H
	DEFB	02,0FFH
	DEFB	24,04EH		;pre-data
	DEFB	08,000H
	DEFB	03,0F5H
	DEFB	01,0FBH
	DEFB	00,0CCH
	DEFB	00,0CCH
	DEFB	02,0FFH
;
	DEFB	00,04EH		;filler
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	-1,-1
;
TABLE3	DEFW	1809		;length single den -2
;
;01
	DEFB	16,0FFH		;post-index
	DEFB	06,000H
	DEFB	01,0FCH
;
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,040H
	DEFB	01,040H
	DEFB	01,040H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0AAH
	DEFB	01,0F7H
;
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,048H
	DEFB	01,048H
	DEFB	01,048H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0AAH
	DEFB	01,0F7H
;
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,050H
	DEFB	01,050H
	DEFB	01,050H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0AAH
	DEFB	01,0F7H
;
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,058H
	DEFB	01,058H
	DEFB	01,058H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0AAH
	DEFB	01,0F7H
;
	DEFB	12,0FFH
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,060H
	DEFB	01,060H
	DEFB	01,060H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-data
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0AAH
	DEFB	01,0F7H
;
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,068H
	DEFB	01,068H
	DEFB	01,068H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	10,0FFH		;pre-id
	DEFB	04,000H
	DEFB	01,0FBH
	DEFB	00,0AAH
	DEFB	01,0F7H
;
	DEFB	12,0FFH		;before change gap
;
;02
	DEFB	22,04EH		;pre-id
	DEFB	12,000H
	DEFB	03,0F5H
	DEFB	01,0FEH
	DEFB	01,040H
	DEFB	01,040H
	DEFB	01,040H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	24,04EH		;pre-data
	DEFB	08,000H
	DEFB	03,0F5H
	DEFB	01,0FBH
	DEFB	00,0AAH
	DEFB	01,0F7H
;
	DEFB	22,04EH		;pre-id
	DEFB	12,000H
	DEFB	03,0F5H
	DEFB	01,0FEH
	DEFB	01,048H
	DEFB	01,048H
	DEFB	01,048H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	24,04EH		;pre-data
	DEFB	08,000H
	DEFB	03,0F5H
	DEFB	01,0FBH
	DEFB	00,0AAH
	DEFB	01,0F7H
;
	DEFB	22,04EH		;pre-id
	DEFB	12,000H
	DEFB	03,0F5H
	DEFB	01,0FEH
	DEFB	01,050H
	DEFB	01,050H
	DEFB	01,050H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	24,04EH		;pre-data
	DEFB	08,000H
	DEFB	03,0F5H
	DEFB	01,0FBH
	DEFB	00,0AAH
	DEFB	01,0F7H
;
	DEFB	22,04EH
	DEFB	12,000H
	DEFB	03,0F5H
	DEFB	01,0FEH
	DEFB	01,058H
	DEFB	01,058H
	DEFB	01,058H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	24,04EH		;pre-data
	DEFB	08,000H
	DEFB	03,0F5H
	DEFB	01,0FBH
	DEFB	00,0AAH
	DEFB	01,0F7H
;
	DEFB	22,04EH		;pre-id
	DEFB	12,000H
	DEFB	03,0F5H
	DEFB	01,0FEH
	DEFB	01,060H
	DEFB	01,060H
	DEFB	01,060H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	24,04EH		;pre-data
	DEFB	08,000H
	DEFB	03,0F5H
	DEFB	01,0FBH
	DEFB	00,0AAH
	DEFB	01,0F7H
;
	DEFB	22,04EH		;pre-id
	DEFB	12,000H
	DEFB	03,0F5H
	DEFB	01,0FEH
	DEFB	01,068H
	DEFB	01,068H
	DEFB	01,068H
	DEFB	01,001H
	DEFB	01,0F7H
	DEFB	24,04EH		;pre-data
	DEFB	08,000H
	DEFB	03,0F5H
	DEFB	01,0FBH
	DEFB	00,0AAH
	DEFB	01,0F7H
;
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	-1,-1
;
;	checker for 40 tracks
;
TABLEC4	DEFW	85		;length single den -2
;
	DEFB	16,0FFH		;post index
	DEFB	06,000H
	DEFB	01,0FCH
;
	DEFB	12,0FFH		;pre-id
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,001H
	DEFB	01,001H
	DEFB	01,001H
	DEFB	01,001H
	DEFB	01,0F7H
;
	DEFB	12,0FFH		;again for easy read
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,001H
	DEFB	01,001H
	DEFB	01,001H
	DEFB	01,001H
	DEFB	01,0F7H
;
	DEFB	12,0FFH
;
	DEFB	22,04EH
	DEFB	12,000H
	DEFB	03,0F5H
	DEFB	01,0FEH
	DEFB	01,001H
	DEFB	01,001H
	DEFB	01,001H
	DEFB	01,001H
	DEFB	01,0F7H
;
	DEFB	22,04EH
	DEFB	12,000H
	DEFB	03,0F5H
	DEFB	01,0FEH
	DEFB	01,001H
	DEFB	01,001H
	DEFB	01,001H
	DEFB	01,001H
	DEFB	01,0F7H
;
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	-1,-1		;terminator
;
;	checker track for 80 track drives
;
TABLEC8	DEFW	85		;SD length -2
;
	DEFB	16,0FFH		;post index
	DEFB	06,000H
	DEFB	01,0FCH
;
	DEFB	12,0FFH
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,002H
	DEFB	01,002H
	DEFB	01,002H
	DEFB	01,002H
	DEFB	01,0F7H
;
	DEFB	12,0FFH
	DEFB	06,000H
	DEFB	01,0FEH
	DEFB	01,002H
	DEFB	01,002H
	DEFB	01,002H
	DEFB	01,002H
	DEFB	01,0F7H
;
	DEFB	12,0FFH
;
	DEFB	22,04EH
	DEFB	12,000H
	DEFB	03,0F5H
	DEFB	01,0FEH
	DEFB	01,002H
	DEFB	01,002H
	DEFB	01,002H
	DEFB	01,002H
	DEFB	01,0F7H
;
	DEFB	22,04EH
	DEFB	12,000H
	DEFB	03,0F5H
	DEFB	01,0FEH
	DEFB	01,002H
	DEFB	01,002H
	DEFB	01,002H
	DEFB	01,002H
	DEFB	01,0F7H
;
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	00,04EH
	DEFB	-1,-1		;term
;
;	input for keyboard
;
STRING	DEFM	'                '
	DEFM	'                '
	DEFB	CR
;
	DEFM	'                '
	DEFM	'                '
	DEFM	'                '
	DEFM	'                '
STACK	EQU	$
;
