; subt1 - kjw/bqsd - 02/83
;
; revised 04/07/83 - kjw
;
	TITLE	'<Super-Utility 3.0 Boot I>'
;
	SUBTTL	'<by Kim Watt - (c)(p) Copyright 1983 Breeze/QSD, Inc. - Dallas, TX>'
;
;	This program will locate at Track 0/Sector 0
;	in single density.  It will read in a rather
;	'unusual' manner the 'true' loader which
;	will reside on track 1, at sectors 20H & 40H
;	The sectors will be have Track/Head/Sector
;	numbers all the same
;
;	equivalences
;
FDC	EQU	37ECH		;FDC command/status reg.
TRACK	EQU	37EDH		;FDC track register
SECTOR	EQU	37EEH		;FDC sector register
XFER	EQU	37EFH		;FDC transfer register
SELFDC	EQU	37E1H		;FDC select register
;
DRIVE	EQU	001H		;drive select code
RESTORE	EQU	00BH		;restore command
SEEK	EQU	01BH		;seek command
SREAD	EQU	088H		;read command
AREAD	EQU	0C0H		;read ID marks
CLEAR	EQU	0D0H		;clear FDC
;
	ORG	4200H		;Mod I loader
;
ENTRY	DI
	LD	A,03H		;for dir kill
;
	LD	SP,STACK	;reset stack
	POP	HL		;get I/O buffer
	CALL	FIG4080		;figure 40/80 track drive
;
;	move head to loader track
;
	CALL	$SEEK		;seek track #
;
;	all register data loaded via POP's
;
	LD	B,3		;3 sectors to read
;
READER	POP	HL		;get I/O buffer
	POP	DE		;get track/sector
	PUSH	BC		;save loop counter
	CALL	$READ		;read the sector
	POP	BC		;get loop
	DJNZ	READER		;go for sector count
	RET			;go loader!
;
;	actual read routine
;	return/entry point on stack
;
;	ENT	HL => I/O buffer to use
;		DE = track/sector (from ID field)
;
;	EXT	return made via stack
;		first pass a CALL is on stack
;		last pass, stack overflow fetchs
;		the entry point from init table
;
$READ	LD	IX,READ1	;subroutine
	JR	READ		;go common
;
$READA	LD	IX,READA	;subroutine
;
READ	LD	(CALL),IX	;pass sub vector
	LD	A,10		;init retry counter
;
READL	PUSH	HL		;save buffer address
	EX	AF,AF'		;save retry count
	CALL	$		;try once
CALL	EQU	$-2
	POP	HL		;restore buffer
	RET	Z		;no error, return
	EX	AF,AF'		;get retry counter
	DEC	A		;less this count
	JR	NZ,READL	;go if more tries left!
	HALT			;re-boot!
;
READ1	CALL	SELECT		;select drive 0
	LD	A,E		;get sector
	LD	(SECTOR),A	;to FDC sector reg
	LD	A,D		;get track
	LD	(TRACK),A	;to FDC track reg
;
	LD	A,SREAD		;read command
	CALL	SLOW		;issue and delay
;
RDL1	LD	A,(FDC)		;read FDC status
	BIT	1,A		;byte ready?
	JR	NZ,RDL2		;get it if yes
	RRCA			;still in progress?
	JR	C,RDL1		;continue if yes
;
;	command done, fetch status
;
	LD	A,(FDC)		;fetch status
	JR	RDL5		;go exit
;
RDL2	LD	A,(XFER)	;read FDC byte
	RRD			;put into buffer
;
RDL3	LD	A,(FDC)		;read a byte
	BIT	1,A		;byte ready?
	JR	NZ,RDL4		;go if yes
	RRCA			;command pending?
	JR	C,RDL3		;wait if yes
	OR	-1		;else set error!
	JR	RDL5		;go exit
;
RDL4	LD	A,(XFER)	;read FDC byte
	RRD			;move into buffer
	DEC	L		;less buffer
	JR	NZ,RDL1		;go next byte
	INC	H		;else bump MSB
	JR	RDL1		;continue
;
RDL5	PUSH	AF		;save error
	LD	A,CLEAR		;FDC reset
	LD	(FDC),A		;issue reset
	POP	AF		;restore error code
	OR	A		;set flags
	RET			;return status
;
READA	CALL	SELECT		;select drive
	LD	A,AREAD		;disk command
	CALL	SLOW		;issue command
	JR	READA2		;continue
;
READA1	RRCA			;check bit 0
	JR	NC,RDL5		;go if done!
READA2	LD	A,(FDC)		;get status
	BIT	1,A		;byte ready?
	JR	Z,READA1	;go if not
	LD	A,(XFER)	;get the byte
	LD	(HL),A		;to buffer
	INC	HL		;bump pointer
	JR	READA2		;continue
;
;	read ID marks
;
FIG4080	LD	A,4		;track to seek
	CALL	$SEEK		;move head there
	CALL	$READA		;read ID marks
	LD	B,3		;4 bytes total
	LD	A,(HL)		;get a byte
FIGIT	INC	HL		;for 4 bytes
	OR	(HL)		;merge
	DJNZ	FIGIT		;go for 2 more
	LD	(4200H),A	;save it!
	RET			;1=40tk, 2=80tk
;
;	seek track A
;
$SEEK	PUSH	AF		;save track #
	CALL	SELECT		;select drive
	LD	A,RESTORE	;move head to track 0
	CALL	SLOW		;issue command
SEEK1	CALL	SELECT		;select drive
	RRCA			;command done?
	JR	C,SEEK1		;wait if not
	POP	AF		;restore track #
	LD	(XFER),A	;pass to FDC
	LD	A,SEEK		;fdc command
	CALL	SLOW		;issue command
SEEK2	CALL	SELECT		;select drive
	RRCA			;command done?
	JR	C,SEEK2		;wait if not
	RET			;else done!
;
;	issue FDC command and delay for valid status
;
SLOW	LD	(FDC),A		;issue command
	LD	A,10		;delay count
SLOW1	DEC	A		;less count
	JR	NZ,SLOW1	;finish
	RET			;else OK to continue
;
;	select drive and return with FDC status
;
SELECT	LD	A,DRIVE		;drive select code
	LD	(SELFDC),A	;select reg FDC
	LD	A,(FDC)		;read status
	RET			;return with status
;
;	following is the real stack area
;
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
	DEFW	-1
;
;	stack area follows, registers popped here
;
STACK	DEFW	4400H		;buffer address
	DEFW	4400H		;buffer address
	DEFW	2020H		;track/sector
	DEFW	4500H		;buffer address
	DEFW	2525H		;track sector
	DEFW	4600H		;buffer
	DEFW	3030H		;track/sector
	DEFW	4400H		;loader entry point!
;
	END	ENTRY
