; maildisk/asm - kjw/bqsd - version 2.00 - 01/83
;
; revised 05/19/83 - kjw
;
	IF	MOD13
@ROM	EQU	0125H		;rom to detect model
@ROM3	EQU	'I'		;test byte = III
@HIGH1	EQU	4049H		;topmem mod I
@HIGH3	EQU	4411H		;topmem mod III
@OPEN	EQU	4424H		;open existing file
@RUN	EQU	4433H		;run program
@CLOSE	EQU	4428H		;close file
@ERROR	EQU	4409H		;display error message
@READ	EQU	4436H		;read record
@POSN	EQU	4442H		;position to record
@WRITE	EQU	4439H		;write record
@EXIT	EQU	402DH		;exit to dos
@KILL	EQU	442CH		;kill file
@INIT	EQU	4420H		;create/open file
@PRT	EQU	003BH		;char to printer
@DSP	EQU	0033H		;char to video
@KBD	EQU	002BH		;char from keyboard
	ENDIF
;
	IF	DP2
SVC	EQU	08H		;execute SVC call
@HIGH2	EQU	0173H		;topmem mod II
@OPEN	EQU	40		;open file
@CLOSE	EQU	42		;close file
@RUN	EQU	85		;run program
@ERROR	EQU	39		;display error message
@DIRRD	EQU	35		;direct read
@DIRWT	EQU	44		;direct write
@READ	EQU	34		;read next record
@POSN	EQU	79		;position to record
@WRITE	EQU	43		;write next record
@EXIT	EQU	57		;exit to dos
@KILL	EQU	41		;delete file
@DIRWR	EQU	44		;direct record write
@KBD	EQU	04		;keyboard char
@VDCHAR	EQU	08		;char to video
@VDGRAF	EQU	10		;video graphics
@VDREAD	EQU	11		;read cursor address
@PRCTRL	EQU	95		;printer control
@PRCHAR	EQU	18		;char to printer
	ENDIF
;
	IF	PDOS
SVC	EQU	08H		;execute SVC call
@HIGH	EQU	59		;fetch high memory
@OPEN	EQU	40		;open file
@CLOSE	EQU	42		;close file
@RUN	EQU	85		;run program
@ERROR	EQU	39		;display error message
@DIRRD	EQU	35		;direct read
@DIRWT	EQU	44		;direct write
@READ	EQU	34		;read next record
@POSN	EQU	79		;position to record
@WRITE	EQU	43		;write next record
@EXIT	EQU	31		;exit to dos
@KILL	EQU	41		;delete file
@DIRWR	EQU	44		;direct record write
@KBD	EQU	04		;keyboard char
@VDCHAR	EQU	08		;char to video
@VDGRAF	EQU	10		;video graphics
@VDREAD	EQU	11		;read cursor address
@PRCTRL	EQU	95		;printer control
@PRCHAR	EQU	18		;char to printer
@VSEL	EQU	89		;select video memory
@VDSEL	EQU	90		;de-select video memory
@MULT	EQU	71		;24 bit multiply
@DIVID	EQU	72		;24 bit divide
@ADD24	EQU	102		;24 bit add
@SUB24	EQU	103		;24 bit subtract
@INC24	EQU	104		;24 bit increment
@DEC24	EQU	105		;24 bit decrement
@CMP24	EQU	106		;24 bit compare
@BOOT	EQU	108		;hardware reset
@LOCDEV	EQU	60		;locate DCB
@VALUE	EQU	65		;fetch input value
	ENDIF
;
	IF	MOD4
SVC	EQU	28H		;SVC executor
@DSP	EQU	02		;char to video
@PRT	EQU	06		;char to printer
@KBD	EQU	08		;read keyboard
@EXIT	EQU	22		;exit to dos
@ERROR	EQU	26		;display error message
@KILL	EQU	57		;kill file
@INIT	EQU	58		;init file
@OPEN	EQU	59		;open file
@CLOSE	EQU	60		;close file
@POSN	EQU	66		;position to file
@READ	EQU	67		;read record
@WRITE	EQU	75		;write record
@RUN	EQU	77		;run program
@HIGH	EQU	100		;fetch topmem
@VDCTL	EQU	15		;video control
@BOOT	EQU	00		;software reset
	ENDIF
;
	PAGE
;
;	open file
;
;	ENTRY	DE =>	filespec to open
;		HL =>	I/O buffer
;		B  =	'W' or 'R' for read/write access
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
	IF	MOD13
OPEN$	EQU	$
	LD	B,0		;logical record length
	JP	@OPEN		;open the file
	ENDIF
;
	IF	DP2.OR.PDOS
OPEN$	EQU	$
	LD	A,3		;open code type
	JR	OPNCMM		;go common
	ENDIF
;
	IF	MOD4
OPEN$	EQU	$
	LD	B,0		;LRL
	LD	A,@OPEN		;SVC #
	RST	SVC		;open file!
	RET
	ENDIF
;
;	open/create new file
;
	IF	MOD13
INIT$	EQU	$
	LD	B,0		;LRL
	JP	@INIT		;init file
	ENDIF
;
	IF	DP2.OR.PDOS
INIT$	EQU	$
	LD	A,2		;open type
;
OPNCMM	LD	(OLIST+9),A	;save open type
	LD	(OLIST+1),HL	;save I/O buffer
	LD	A,B		;get read/write
	LD	(OLIST+6),A	;set read/write
	LD	HL,OLIST	;start param list
	LD	A,@OPEN		;SVC #
	RST	SVC		;open the file
	RET
	ENDIF
;
	IF	MOD4
INIT$	EQU	$
	LD	B,0		;LRL
	LD	A,@INIT		;SVC #
	RST	SVC		;open/create file
	RET
	ENDIF
;
;	position to logical record
;
	IF	MOD13
;
;	since the Mod I/III systems cannot address
;	3 byte logical records, we must drop MSB
;
POSN$	EQU	$
	LD	H,B		;pass pointer to HL
	LD	L,C		;HL => 3 byte record #
	INC	HL		;skip MSB
	LD	B,(HL)		;get NSB
	INC	HL		;bump
	LD	C,(HL)		;get LSB
	JP	@POSN		;position to record
	ENDIF
;
	IF	DP2.OR.PDOS
POSN$	EQU	$
	LD	A,@POSN		;SVC#
	RST	SVC		;position!
	RET
	ENDIF
;
	IF	MOD4
POSN$	EQU	$
	LD	H,B		;pass to HL
	LD	L,C
	INC	HL		;skip MSB
	LD	B,(HL)		;get NSB
	INC	HL		;bump
	LD	C,(HL)		;get LSB
	LD	A,@POSN		;SVC #
	RST	SVC		;position to record
	RET
	ENDIF
;
;	read next logical record
;
	IF	MOD13
READ$	EQU	$
	JP	@READ		;read next record
	ENDIF
;
	IF	DP2.OR.PDOS.OR.MOD4
READ$	EQU	$
	LD	A,@READ		;SVC #
	RST	SVC		;read next
	RET
	ENDIF
;
;	write next record
;
	IF	MOD13
WRITE$	EQU	$
	JP	@WRITE		;write next record
	ENDIF
;
	IF	DP2.OR.PDOS.OR.MOD4
WRITE$	EQU	$
	LD	A,@WRITE	;SVC #
	RST	SVC		;write next
	RET
	ENDIF
;
;	close file
;
	IF	MOD13
CLOSE$	EQU	$
	JP	@CLOSE		;close file
	ENDIF
;
	IF	DP2.OR.PDOS.OR.MOD4
CLOSE$	EQU	$
	LD	A,@CLOSE	;SVC #
	RST	SVC		;close file
	RET
	ENDIF
;
;	delete existing file
;
	IF	MOD13
KILL$	EQU	$
	JP	@KILL		;delete file
	ENDIF
;
	IF	DP2.OR.PDOS.OR.MOD4
KILL$	EQU	$
	LD	A,@KILL		;SVC #
	RST	SVC		;delete file
	RET
	ENDIF
;
;	run program file
;
	IF	MOD13
RUN$	EQU	$
	JP	@RUN		;run program
	ENDIF
;
	IF	DP2.OR.PDOS.OR.MOD4
RUN$	EQU	$
	LD	A,@RUN		;SVC #
	RST	SVC		;run program
	RET
	ENDIF
;
;	exit program to DOS READY
;
	IF	MOD13
EXIT$	EQU	$
	JP	@EXIT		;exit to dos
	ENDIF
;
	IF	DP2.OR.PDOS
EXIT$	EQU	$
	LD	A,@EXIT		;SVC #
	RST	SVC		;exit to dos
	RET
	ENDIF
;
	IF	MOD4
EXIT$	EQU	$
	LD	HL,0		;set no error
	LD	A,@EXIT		;SVC #
	RST	SVC		;exit to dos
	RET
	ENDIF
;
;	display error message
;
	IF	MOD13
ERROR$	EQU	$
	OR	0C0H		;set bits 7/6
	JP	@ERROR		;display error message
	ENDIF
;
	IF	DP2.OR.PDOS
ERROR$	EQU	$
	PUSH	BC		;save
	AND	7FH		;assure a return
	LD	B,A		;pass error code
	LD	A,@ERROR	;SVC #
	RST	SVC		;display message
	POP	BC		;restore
	RET
	ENDIF
;
	IF	MOD4
ERROR$	EQU	$
	PUSH	BC		;save BC
	OR	0C0H		;set bits 7/6
	LD	C,A		;pass error code
	LD	A,@ERROR	;SVC #
	RST	SVC		;display error message
	POP	BC		;restore stack
	RET
	ENDIF
;
;	fetch top memory
;
	IF	MOD13
TOPMEM$	EQU	$
	LD	HL,@HIGH3	;topmem III
	LD	A,(@ROM)	;read rom address
	CP	@ROM3		;mod III?
	JR	Z,$+5		;go if yes
	LD	HL,@HIGH1	;topmem I
	LD	(DY@MEM),HL	;save topmem address
	LD	HL,($)		;read topmem
DY@MEM	EQU	$-2
	RET
	ENDIF
;
	IF	DP2
TOPMEM$	EQU	$
	LD	HL,(@HIGH2)	;get topmem II
	RET
	ENDIF
;
	IF	PDOS
TOPMEM$	EQU	$
	PUSH	DE		;save used
	PUSH	BC
	LD	A,@HIGH		;SVC #
	LD	HL,0		;init high
	LD	D,H		;pass to DE
	LD	E,L		;HL & DE = 0000H
	LD	BC,0<8+5	;bank + command
	RST	SVC		;fetch high$
	POP	BC		;restore
	POP	DE
	RET			;done, HL = (HIGH)
	ENDIF
;
	IF	MOD4
TOPMEM$	EQU	$
	LD	A,@HIGH		;SVC #
	LD	HL,0		;command
	PUSH	BC		;save
	LD	B,H		;set HIGH flag
	RST	SVC		;fetch topmem
	POP	BC		;restore
	RET
	ENDIF
;
;	send char to display device
;
	IF	MOD13
VOUT$	EQU	$
	PUSH	IY		;must save
	PUSH	DE
	CALL	@DSP		;to display
	POP	DE		;restore
	POP	IY
	RET
	ENDIF
;
	IF	DP2.OR.PDOS
VOUT$	EQU	$
	PUSH	BC		;save
	LD	B,A		;pass char
	LD	A,@VDCHAR	;SVC #
	RST	SVC		;char to video
	POP	BC		;restore
	RET
	ENDIF
;
	IF	MOD4
VOUT$	EQU	$
	PUSH	DE		;save
	PUSH	BC		;save
	LD	C,A		;pass character
	LD	A,@DSP		;SVC #
	RST	SVC		;display char
	POP	BC		;restore
	POP	DE		;restore
	RET
	ENDIF
;
;	send character to printer device
;
	IF	MOD13
POUT$	EQU	$
	PUSH	IY		;save
	PUSH	DE
	CALL	@PRT		;print character
	POP	DE		;restore
	POP	IY
	RET
	ENDIF
;
	IF	DP2.OR.PDOS
POUT$	EQU	$
	PUSH	BC		;save
	LD	B,A		;pass character
	LD	A,@PRCHAR	;SVC #
	RST	SVC		;print char
	POP	BC		;restore
	RET
	ENDIF
;
	IF	MOD4
POUT$	EQU	$
	PUSH	BC		;save
	PUSH	DE		;save
	LD	C,A		;pass character
	LD	A,@PRT		;SVC#
	RST	SVC		;print char
	POP	DE		;restore
	POP	BC		;restore
	RET
	ENDIF
;
;	fetch character from keyboard
;
	IF	MOD13
KEYIN$	EQU	$
	PUSH	IY		;save
	PUSH	DE
	CALL	@KBD		;scan keyboard
	POP	DE		;unstack
	POP	IY
	OR	A		;set flags
	RET
	ENDIF
;
	IF	DP2.OR.PDOS
KEYIN$	EQU	$
	PUSH	BC		;save
	LD	A,@KBD		;SVC #
	RST	SVC		;read keyboard
	LD	A,0		;init nil key
	JR	NZ,$+3		;go if no key
	LD	A,B		;else get key
	POP	BC		;restore stack
	OR	A		;set flags
	RET
	ENDIF
;
	IF	MOD4
KEYIN$	EQU	$
	PUSH	DE		;save
	LD	A,@KBD		;SVC #
	RST	SVC		;scan keyboard
	POP	DE		;restore
	OR	A		;anything?
	RET
	ENDIF
;
;	enable video memory for specific model
;
	IF	MOD13
VIDON$	RET			;always selected
	ENDIF
;
	IF	DP2
VIDON$	JP	@VIDON		;select video
	ENDIF
;
	IF	PDOS
VIDON$	LD	A,@VSEL		;SVC #
	RST	SVC		;select video
	RET			;done
	ENDIF
;
	IF	MOD4
VIDON$	PUSH	IY		;save
	LD	A,101		;@FLAGS
	RST	SVC
	LD	A,(IY+14)	;get mask
	AND	0FEH
	LD	(IY+14),A	;update
	OUT	(84H),A		;select!
	POP	IY		;restore
	RET
	ENDIF
;
;	de-select video memory bank
;
	IF	MOD13
VIDOFF$	RET			;always selected
	ENDIF
;
	IF	DP2
VIDOFF$	JP	@VIDOFF		;de-select video
	ENDIF
;
	IF	PDOS
VIDOFF$	LD	A,@VDSEL	;SVC #
	RST	SVC		;de-select video
	RET			;done
	ENDIF
;
	IF	MOD4
VIDOFF$	PUSH	IY		;save
	LD	A,101		;@FLAGS
	RST	SVC
	LD	A,(IY+14)	;get
	OR	1
	LD	(IY+14),A	;update
	OUT	(84H),A		;deselect!
	POP	IY
	RET
	ENDIF
;
;	3 bytes of 00's for REWIND call
;
REWIND	DEFB	0,0,0
;
;	open param lists for Mod II SVC's
;
	IF	DP2.OR.PDOS
OLIST	DEFW	0		;buffer address
	DEFW	0		;record address
	DEFW	0		;EODAD
	DEFB	0		;read/write access
	DEFB	0		;LRL
	DEFB	'E'		;extended file
	DEFB	0		;set at open/init
	DEFB	0		;list terminator
	ENDIF
;
