; maildd/asm - kjw/bqsd - version 2.00 - 01/83
;
;	revised 06/02/83 - kjw
;
;	system data usage
;
;	+7,8,9		- logical record # adder
;	+10,11,12	- physical record # adder
;	+13		- offset into I/O buffer
;	+14,15,16	- logical record # data
;	+17,18,19	- physical record # data
;	+20		- offset into data I/O buff
;	+21		- current drive #
;
	PAGE
;
COMBINE	CALL	INITCNT		;clear counters
	LD	(IY+1),0	;clear all flags
	LD	A,(IY+4)	;check if any records
	OR	(IY+5)
	OR	(IY+6)		;=000000?
	LD	HL,MSGD1A	;nil file
	JP	Z,CANNOT	;cannot combine
;
	LD	HL,MSGD1	;'combine adder => data'
	CALL	GETDRV		;get drive # from user
	JP	C,MENU		;go on BREAK
	LD	(IY+21),A	;save drive #
	CALL	LOCFCB		;find the file block
	BIT	7,(IX+0)	;file open?
	JR	Z,COMBINE	;nope, cannot use it
;
;	check if sufficient space to add it
;
	LD	B,(IX+7)	;get # recs available
	LD	H,(IX+8)
	LD	L,(IX+9)
	LD	C,(IX+10)	;get # recs used
	LD	D,(IX+11)
	LD	E,(IX+12)
	CALL	SUBIT		;BHL = free records
	LD	C,(IY+4)	;get # recs in adder
	LD	D,(IY+5)
	LD	E,(IY+6)
	CALL	CMPBHL		;compare BHL <> CDE
	JR	NC,COMBOK	;OK, continue
;
;	insufficient space to merge files!
;
	LD	HL,MSGD3	;'insufficient space'
	JP	CANNOT		;cannot combine!
;
;	setup loop to transfer files
;
COMBOK	LD	HL,MSGD6	;'apply flag mask?'
	CALL	DISPLAY		;display prompt
	LD	B,1		;single key input
	CALL	GETSTR		;from keyboard
	JP	C,MENU		;go on BREAK
	JR	NZ,$+4		;go if any input
	LD	A,'N'		;default NO
	CALL	UCASE		;make upper case
	CP	'X'		;alternate BREAK?
	JP	Z,MENU		;go if yes
	CP	'N'		;no?
	RES	0,(IY+0)	;set NO mask
	JR	Z,COMBOKX	;continue
	CP	'Y'		;yes?
	JR	NZ,COMBOK	;neither, ask again
	SET	0,(IY+0)	;set YES mask
;
;	read flag mask into buffer
;
	LD	E,(IX+15)	;get fcb pointer
	LD	D,(IX+16)	;DE => fcb
	LD	BC,REWIND	;3 00's
;
	CALL	POSN$		;rewind file!
	JP	NZ,DERROR	;go if error
	CALL	READ$		;read first record
	JP	NZ,DERROR	;go on error
;
	LD	L,(IX+17)	;get buffer pointer
	LD	H,(IX+18)
	LD	DE,15H		;offset to flag mask
	ADD	HL,DE		;HL => flag mask
	LD	DE,FLAGMSK	;buffer to store it
	LD	BC,6		;mask length
	LDIR			;saved!
;
;	ask if adder records to be deleted after merge
;
COMBOKX	LD	HL,MSGD7	;'delete adder ?'
	CALL	DISPLAY		;display prompt
	LD	B,1		;one char input
	CALL	GETSTR		;get from keyboard
	JP	C,MENU		;go on BREAK
	JR	NZ,$+4		;go if any input
	LD	A,'N'		;default NO
	CALL	UCASE		;make upper case
	CP	'X'		;alternate BREAK?
	JP	Z,MENU		;go if yes!
	RES	3,(IY+0)	;set NO delete
	CP	'N'		;no?
	JR	Z,COMBOKY	;go if no
	CP	'Y'		;yes?
	JR	NZ,COMBOKX	;go if neither
	SET	3,(IY+0)	;set YES delete
;
COMBOKY	LD	HL,MSGD4	;'merging'
	CALL	DISPLAY		;display header
	LD	B,(IY+4)	;get # records in adder
	LD	H,(IY+5)
	LD	L,(IY+6)
	CALL	DECBHL		;adjust to last rec #
	LD	(IY+7),B	;set current record
	LD	(IY+8),H
	LD	(IY+9),L
	LD	B,(IX+10)	;get current record data
	LD	(IY+14),B	;pass to block
	LD	H,(IX+11)
	LD	(IY+15),H
	LD	L,(IX+12)
	LD	(IY+16),L
;
;	load first record of DATA for quick writes
;
	CALL	COMPSEC		;compute phys sector
	LD	(IY+20),A	;save data offset
	PUSH	AF		;save offset
	LD	C,(IX+4)	;get start record #
	LD	D,(IX+5)
	LD	E,(IX+6)
	CALL	ADDIT		;add CDE => BHL
	LD	(IY+17),B	;update current record
	LD	(IY+18),H
	LD	(IY+19),L
	SET	6,(IY+1)	;set rec in memory
	POP	AF		;restore offset
	OR	A		;at 0?
	JR	Z,COMBLP	;go if yes!
;
	LD	E,(IX+15)	;get FCB address
	LD	D,(IX+16)
	LD	BC,SYSTEM+17	;point to phys record
;
	CALL	POSN$		;position file
	JP	NZ,DERROR	;go on error!
	CALL	READ$		;load I/O buffer
	JP	NZ,DERROR	;go on disk error!
;
COMBLP	CALL	STROBE		;strobe keyboard
	CP	BREAK		;break key?
	JP	Z,ABORT		;yes, abort operation
;
	CALL	COMADD		;read current adder
	JP	NZ,DERROR	;combine error!
	CALL	COMDAT		;write to data file
	JP	NZ,DERROR	;go if error!
	CALL	ADDCNTA		;bump counter A
;
;	increment record #'s
;
	LD	B,(IY+7)	;get record # adder
	LD	H,(IY+8)
	LD	L,(IY+9)
	CALL	DECBHL		;decrement BHL
	LD	A,B		;check for FFFFFFH
	AND	H
	AND	L
	INC	A		;A = 0?
	PUSH	AF		;save flag
	LD	(IY+7),B	;update block
	LD	(IY+8),H
	LD	(IY+9),L
	LD	B,(IY+14)	;get record # data
	LD	H,(IY+15)
	LD	L,(IY+16)
	CALL	INCBHL		;increment BHL
	LD	(IY+14),B	;update block
	LD	(IY+15),H
	LD	(IY+16),L
	LD	B,(IX+10)	;get # records used data
	LD	H,(IX+11)
	LD	L,(IX+12)
	CALL	INCBHL		;increment BHL
	LD	(IX+10),B	;update block
	LD	(IX+11),H
	LD	(IX+12),L
	RES	6,(IX+0)	;set NOT SORTED
	BIT	3,(IY+0)	;delete record from adder
	JR	Z,COMBYY	;go if not
	LD	B,(IY+4)	;get # records in adder
	LD	H,(IY+5)
	LD	L,(IY+6)
	CALL	DECBHL		;decrement BHL
	LD	(IY+4),B	;update
	LD	(IY+5),H
	LD	(IY+6),L
COMBYY	POP	AF		;get flags back
	JP	NZ,COMBLP	;go if more to do
;
;	write back last partial buffer
;
	LD	BC,SYSTEM+17	;point to rec #
	LD	E,(IX+15)	;get FCB address
	LD	D,(IX+16)
;
	CALL	POSN$		;position file
	JP	NZ,DERROR	;go on error
	CALL	WRITE$		;write the record
	JP	NZ,DERROR	;go on disk error!
;
;	load specifics into string
;
	LD	DE,MSGDXA	;start of message
	LD	B,(IY+32)	;get # records moved
	LD	H,(IY+33)
	LD	L,(IY+34)
	CALL	BINASC		;binary => ascii
	LD	HL,MSGDX	;'completed'
	JR	CANNOT		;continue
;
;	error on combine
;
DERROR	CALL	ERROR		;display error message
	LD	HL,MSG2		;'<KEY> to continue
;
CANNOT	CALL	DISPLAY		;display prompt
	CALL	ENKEY		;wait for a key
	JP	MENU		;back to menu!
;
;	compute physical sector from relative sector
;
COMPSEC	SRL	B		;half
	RR	H		;half
	RR	L		;BHL = BHL / 2
	LD	A,0		;byte offset
	RET	NC		;go if even page
	LD	A,80H		;byte offset
	RET			;BHL/A = sector/byte ofst
;
;	read record from ADDER file
;
COMADD	LD	B,(IY+7)	;get record #
	LD	H,(IY+8)
	LD	L,(IY+9)	;BHL = record #
	CALL	COMPSEC		;compute sector #
	LD	(IY+13),A	;save sector offset
	CALL	INCBHL		;past index record
	BIT	7,(IY+1)	;record in memory?
	RES	7,(IY+1)	;set no record
	JR	Z,COMADD1	;go if no record
;
	LD	C,(IY+10)	;get current rec in mem
	LD	D,(IY+11)
	LD	E,(IY+12)
	CALL	CMPBHL		;compare BHL <> CDE
	JR	Z,COMADD2	;go if in memory
;
COMADD1	LD	(IY+10),B	;update current record
	LD	(IY+11),H
	LD	(IY+12),L
	LD	BC,SYSTEM+10	;point to rec #
	LD	DE,FCBA		;adder FCB address
;
	CALL	POSN$		;position file
	RET	NZ		;go if error
	CALL	READ$		;read record
	RET	NZ		;go if error
;
COMADD2	SET	7,(IY+1)	;set record in memory
	XOR	A		;return Z
	RET			;done, record loaded
;
;	write record to data file
;
COMDAT	LD	B,(IY+14)	;get record #
	LD	H,(IY+15)
	LD	L,(IY+16)
	CALL	COMPSEC		;compute sector
	LD	(IY+20),A	;save data offset
	LD	C,(IX+4)	;get start rec #
	LD	D,(IX+5)
	LD	E,(IX+6)
	CALL	ADDIT		;add CDE to BHL
;
	LD	(IY+17),B	;update current record
	LD	(IY+18),H
	LD	(IY+19),L
;
	LD	HL,BUFFA	;adder buffer
	LD	C,(IY+13)	;offset for data
	LD	B,0		;BC = offset
	ADD	HL,BC		;HL => adder record
;
;	check if flag mask to be applied
;
	BIT	0,(IY+0)	;yes?
	JR	Z,COMDAT3	;go if not
	PUSH	HL		;save start
	PUSH	IX		;save
	LD	DE,125		;offset to flags
	ADD	HL,DE		;HL => first flag
	LD	IX,FLAGMSK	;mask buffer
	LD	B,3		;3 bytes of flags
COMDAF	LD	A,(IX+3)	;get mask bits
	CPL			;reverse bits
	AND	(HL)		;keep rest
	OR	(IX+0)		;set correct bits
	LD	(HL),A		;update
	INC	HL		;bump data
	INC	IX		;bump mask
	DJNZ	COMDAF		;go for 3 bytes
	POP	IX		;unstack
	POP	HL
;
COMDAT3	PUSH	HL		;save on stack
	LD	L,(IX+17)	;get buffer pointer
	LD	H,(IX+18)	;HL => data I/O buffer
	PUSH	DE		;save
	PUSH	HL
	LD	BC,128		;RL
	ADD	HL,BC		;next record
	LD	D,H
	LD	E,L
	INC	DE		;+1
	LD	(HL),-1		;FF
	DEC	BC		;count
	LDIR			;fill
	POP	HL		;restore
	POP	DE
	LD	C,(IY+20)	;get offset data
	LD	B,0		;BC = offset
	ADD	HL,BC		;HL => data record
;
	EX	DE,HL		;DE => data
	POP	HL		;HL => adder
	LD	BC,128		;record length
	LDIR			;move it in
	LD	A,(IY+20)	;get byte offset
	OR	A		;offset = 0?
	RET	Z		;yes, done!
;
	LD	E,(IX+15)	;get FCB back
	LD	D,(IX+16)
	LD	BC,SYSTEM+17	;point to rec #
;
	CALL	POSN$		;position file
	RET	NZ		;go if error
	CALL	WRITE$		;write the buffer
	RET	NZ		;go if error
;
	SET	6,(IY+1)	;set data in buffer
	XOR	A		;set no error
	RET			;done!
;
;	fetch drive # from user
;
GETDRV	CALL	DISPLAY		;display header
GETDAGN	LD	HL,MSGD2	;drive #
	CALL	DISPLAY		;display prompt
	LD	B,1		;one key
	CALL	GETSTR		;from keyboard
	RET	C		;go on BREAK
	JR	Z,GETDAGN	;no default
	CALL	UCASE		;make upper case
	CP	'X'		;alternate BREAK?
	SCF			;C = yes
	RET	Z		;go if yes!
	SUB	'0'		;remove ascii
	JR	C,GETDAGN	;go if invalid
	CP	DRIVES		;in range?
	JR	NC,GETDAGN	;go if invalid
	CP	A		;set Z flag, NC
	RET			;return A = drive #
;
	PAGE
;
MSGD1	DEFB	SETCUR
	DEFB	01,038
	DEFB	EOL
	DEFM	'<< Merge Files >>'
;
	DEFB	SETCUR
	DEFB	12,00
	DEFB	EOF
;
	DEFM	'Merging ADDER => DATA'
	DEFB	CR
	DEFB	ETX
;
MSGD1A	DEFB	SETCUR
	DEFB	12,00
	DEFB	EOF
;
	DEFM	'Cannot Merge, Adder file EMPTY, '
	DEFM	'<ENTER>:'
	DEFB	ETX
;
MSGD2	DEFB	SETCUR
	DEFB	14,00
	DEFB	EOF
;
	DEFM	'Drive number (0-7) ? '
	DEFB	ETX
;
MSGD3	DEFB	SETCUR
	DEFB	14,00
	DEFB	EOF
;
	DEFM	'Insufficient File Space, <ENTER>:'
	DEFB	ETX
;
MSGD4	DEFB	SETCUR
	DEFB	14,00
	DEFB	EOF
;
	DEFM	'Merging - '
	DEFB	ETX
;
MSGD5	DEFM	'Completed, <ENTER>:'
	DEFB	ETX
;
MSGDX	DEFB	SETCUR
	DEFB	14,00
	DEFB	EOF
MSGDXA	DEFM	'........ Records Merged, <ENTER>:'
	DEFB	ETX
;
MSGD6	DEFB	SETCUR
	DEFB	14,00
	DEFB	EOF
	DEFM	'Apply Flag Mask to Records ? '
	DEFB	ETX
;
MSGD7	DEFB	SETCUR
	DEFB	14,00
	DEFB	EOF
	DEFM	'Delete Records from '
	DEFM	'Adder after Merge ? '
	DEFB	ETX
;
