; maila/asm - kjw/bqsd - version 2.00 - 01/83
;
;	revised 05/23/83 - kjw
;
	TITLE	'<PowerMAIL - 2.00 Source>'
;
	SUBTTL	'<Copyright (C) 1983 - Breeze/QSD, Inc. - Dallas, Texas>'
;
*GET	MAILEQU			;local/memory equates
;
	ORG	CODE
*GET	MAILDISK		;I/O drivers
*GET	MAILDVRS		;I/O drivers
*GET	MAILMATH		;math subroutines
;
	PAGE
;
ENTRY	LD	IY,SYSTEM	;reset system pointer
	CALL	INTEG		;check sys integrety
	LD	A,(IY+31)	;get init flag
	CP	'*'		;initialized?
	JP	NZ,CORRUPT	;nope! run PMAIL only!
;
MENU	LD	IY,SYSTEM	;reset data pointer
	LD	L,(IY+2)	;fetch stack pointer
	LD	H,(IY+3)	;HL = init stack
	LD	SP,HL		;reset it
;
	LD	HL,MSG1		;menu options
	CALL	DISPLAY		;display options
	LD	B,1		;single key input
	CALL	GETSTR		;fetch from keyboard
	JP	C,EXIT		;go if BREAK
	JR	Z,MENU		;go if nil entry
	LD	HL,TABLE1	;menu jump table
	CALL	UCASE		;make upper case
	CALL	GOTABLE		;go vector if valid entry
	JR	MENU		;invalid, ask again
;
	PAGE
;
;	init PMAIL/ADD file
;
INITA	LD	HL,MSG2		;'creating ADDER'
	CALL	DISPLAY		;display header
	BIT	7,(IY+0)	;adder open now?
	JR	Z,INITA1	;go if not available
;
BAD2X	LD	HL,MSG2X	;'exists, delete, reuse
	CALL	DISPLAY		;display prompt
	LD	B,1		;one key input
	CALL	GETSTR		;get from keyboard
	JP	C,MENU		;go on break
	JR	Z,BAD2X		;go if nil input
	CALL	UCASE		;make upper case
	CP	'X'		;abort?
	JP	Z,MENU		;go if yes!
	CP	'R'		;re-use?
	JP	Z,REUSEIT	;yes, go!
	CP	'D'		;delete?
	JR	NZ,BAD2X	;neither, go!
;
;	kill existing file
;
	LD	DE,FCBA		;current adder FCB
	CALL	KILL$		;delete adder
	RES	7,(IY+0)	;set NOT AVAILABLE
	LD	(IY+4),0	;# records in adder
	LD	(IY+5),0
	LD	(IY+6),0
	JP	NZ,AERROR	;go if any errors
;
;	create new adder file
;
INITA1	CALL	GETDRV		;fetch drive #
	JP	C,MENU		;go on BREAK
	LD	C,A		;save drive #
	LD	HL,AFILEA	;end filename
	CALL	INSPASS		;insert password
	LD	(HL),':'	;drive indicator
	INC	HL		;bump pointer
	LD	(HL),C		;drive #
	INC	HL		;bump pointer
	LD	(HL),ETX	;end of filespec
	LD	HL,AFILE	;start of text
	LD	DE,FCBA		;adder FCB
	LD	BC,32		;max length
	PUSH	DE		;save fcb start
	LDIR			;move it in
	POP	DE		;DE => fcb
	LD	HL,BUFFA	;adder I/O buffer
;
	LD	B,'R'		;open for READ
	CALL	OPEN$		;open file
	JR	NZ,INITA2	;go if not found/error
;
;	adder file exists on specified drive
;
	CALL	EXISTS		;see if to be replaced
	JP	C,MENU		;go if BREAK
	JP	Z,MENU		;go if NO
;
;	delete existing file
;
	LD	DE,FCBA		;adder FCB
	CALL	KILL$		;delete file
	JR	NZ,AERROR	;go if error
;
;	init new file on specified drive
;
INITA2	LD	HL,AFILE	;adder filespec
	LD	DE,FCBA		;adder fcb
	LD	BC,32		;max name length
	PUSH	DE		;save fcb
	LDIR			;move in the name
	LD	HL,BUFFA	;adder I/O buffer
	POP	DE		;adder FCB
;
	LD	B,'R'		;open for read
	CALL	INIT$		;create file
	JR	NZ,AERROR	;go if error
	CALL	CLOSE$		;close file
	JR	NZ,AERROR	;go if error
;
	PUSH	DE		;save
	LD	HL,AFILE	;filespec
	LD	BC,32		;max length
	LDIR			;reset filespec
	POP	DE		;DE => filespec
	LD	B,'W'		;open for write
	LD	HL,BUFFA	;I/O buffer
	CALL	OPEN$		;re-open regular
	JR	NZ,AERROR	;go if error!
;
;	load in header ID text
;
	LD	HL,BUFFA	;I/O buffer
	CALL	PUTID		;load data/ID to sector
;
;	set 0 records in file and write first sector
;
	LD	HL,0		;set 000000
	LD	(BUFFA),HL	;save MSB
	LD	(BUFFA+1),HL	;save NSB, LSB
;
	LD	DE,FCBA		;adder FCB
	CALL	WRITE$		;write record
	JR	NZ,AERROR	;go if error
	LD	(IY+4),0	;set # records in file
	LD	(IY+5),0
	LD	(IY+6),0
	SET	7,(IY+0)	;set file available
	LD	HL,MSG5		;'created, key'
;
BAKMENU	CALL	DISPLAY		;display prompt
	CALL	ENKEY		;wait for a key
	JP	MENU		;back to menu
;
;	error occured, abort operation
;
AERROR	PUSH	AF		;save error code
	LD	HL,MSG6		;'create/expand error'
	CALL	DISPLAY		;display prompt
	POP	AF		;restore error
	CALL	ERROR		;display message
	LD	HL,MSG7		;'key to continue'
	JR	BAKMENU		;back to menu
;
;	reuse existing adder file, reset count
;
REUSEIT	LD	(IY+4),0	;reset # records in adder
	LD	(IY+5),0
	LD	(IY+6),0
	JP	MENU		;that's all!
;
	PAGE
;
;	expand existing data file
;
EXPAND	SET	2,(IY+0)	;set EXPAND flag
	LD	HL,MSG8		;'expanding'
	JR	EXPINIT		;go common
;
;	create new data file
;
INITD	RES	2,(IY+0)	;set CREATE flag
	LD	HL,MSG9		;'creating'
;
EXPINIT	CALL	DISPLAY		;display header message
	CALL	GETDRV		;fetch drive #
	JP	C,MENU		;go on BREAK
	LD	C,A		;save drive #
	LD	HL,DFILEA	;end filename
	CALL	INSPASS		;insert password
	LD	(HL),':'	;drive marker
	INC	HL		;bump pointer
	LD	(HL),C		;drive #
	INC	HL		;bump pointer
	LD	(HL),ETX	;terminate filespec
	LD	A,C		;get drive # back
	SUB	'0'		;remove ascii
	CALL	LOCFCB		;locate the FCB
;
;	if EXPAND, make sure file exists
;
	BIT	2,(IY+0)	;create?
	JR	Z,INITD0	;go if yes
;
	BIT	7,(IX+0)	;file open?
	LD	HL,MSG10	;'not available'
	JP	Z,BAKMENU	;back to menu if not
	JP	INITD3		;else continue
;
INITD0	BIT	7,(IX+0)	;file open?
	JR	Z,INITD1	;go if closed
;
	CALL	EXISTS		;see if to be deleted
	JP	C,MENU		;go if BREAK
	JP	Z,MENU		;go if NO
;
;	kill existing file
;
	LD	E,(IX+15)	;fetch FCB pointer
	LD	D,(IX+16)	;DE => fcb
	CALL	KILL$		;delete file
	LD	(IX+0),0	;set file closed
	JP	NZ,AERROR	;go if error!
;
;	create new data file
;
INITD1	LD	HL,DFILE	;data filespec
	LD	E,(IX+15)	;fetch FCB
	LD	D,(IX+16)	;DE => FCB
;
;	move name into FCB
;
	LD	BC,32		;max file length
	PUSH	DE		;save FCB pointer
	LDIR			;move into FCB
	POP	DE		;DE => name
	LD	L,(IX+17)	;fetch buffer
	LD	H,(IX+18)	;HL => I/O buffer
;
	LD	B,'R'		;open for READ
	CALL	OPEN$		;open file
	JR	NZ,INITD2	;go if doesn't exist
	SET	7,(IX+0)	;flag open
;
;	file exists, see if to be replaced
;
	PUSH	DE		;save FCB pointer
	CALL	EXISTS		;file exists, replace?
	POP	DE		;restore FCB
	JP	C,MENU		;go if BREAK
	JP	Z,MENU		;go if NO!
;
	CALL	KILL$		;delete file
	LD	(IX+0),0	;set not open
	JP	NZ,AERROR	;go if error
;
;	create new file
;
INITD2	LD	HL,DFILE	;data file
	LD	E,(IX+15)	;fetch FCB
	LD	D,(IX+16)	;DE => fcb
	LD	BC,32		;max length
	PUSH	DE		;save fcb pointer
	LDIR			;move name into FCB
	POP	DE		;DE => fcb
;
	LD	L,(IX+17)	;fetch I/O buffer
	LD	H,(IX+18)	;HL => I/O buffer
;
	LD	B,'W'		;open for write
	CALL	INIT$		;create file
	JP	NZ,AERROR	;go if error on create
	XOR	A		;load zero
	LD	(IX+1),A	;set ERN to 0
	LD	(IX+2),A
	LD	(IX+3),A
	LD	(IX+4),A	;set SRN data to 0
	LD	(IX+5),A
	LD	(IX+6),A
	LD	(IX+7),A	;set # records to 0
	LD	(IX+8),A
	LD	(IX+9),A
	LD	(IX+10),A	;set # records used to 0
	LD	(IX+11),A
	LD	(IX+12),A
	RES	6,(IX+0)	;set NOT SORTED
	SET	7,(IX+0)	;flag as open
;
;	fetch name of disk
;
INITD3A	LD	HL,MSG11X	;'disk name?'
	CALL	DISPLAY		;display prompt
	LD	B,16		;16 char input
	CALL	GETSTR		;get from keyboard
	JP	C,MENU		;go on BREAK
	JR	NZ,$+5		;continue if input
	LD	HL,HEADER	;default disk name
	LD	DE,DISKNAM	;storage here
	LD	BC,16		;16 chars
	LDIR			;move it in
;
;	file created, fetch # records to allocate
;
INITD3	LD	HL,MSG11	;# records to allocate
	CALL	DISPLAY		;display prompt
	LD	B,8		;8 char input
	CALL	GETSTR		;fetch from keyboard
	JP	C,MENU		;go on BREAK
	JR	Z,INITD3	;go if nil input
	CALL	UCASE		;make upper case
	CP	'X'		;alt break?
	JP	Z,MENU		;go if yes
	CALL	VALUE		;fetch input value
	JR	NZ,INITD3	;go if invalid input
;
;	ABC = # records, compute # sectors
;
	LD	L,C		;move into BHL
	LD	H,B
	LD	B,A		;BHL = # records needed
	OR	L		;check for nil file
	OR	H		;BHL = 000000?
	JR	Z,INITD3	;yes, ask again
;
	BIT	2,(IY+0)	;expand file?
	JR	Z,INITD4	;nope, continue
;
;	check for greater than current size
;
	PUSH	BC		;save result
	PUSH	HL		;size on stack
	LD	C,(IX+7)	;fetch current #
	LD	D,(IX+8)
	LD	E,(IX+9)	;CDE = current size
	CALL	SUBIT		;compare BHL <> CDE
	POP	HL		;unstack
	POP	BC
	JR	C,INITD3	;go if invalid input
	JP	BIGGER		;make the file bigger
;
;	create file, BHL = # records needed
;
INITD4	CALL	SIZE		;compute # records needed
;
;	allocate needed # records
;
	LD	(IY+7),B	;pass 3 byte value
	CALL	DECBHL		;adjust relative
	LD	(IY+8),H
	LD	(IY+9),L
;
;	fill buffer with -1 and write file
;
	LD	L,(IX+17)	;fetch buffer pointer
	LD	H,(IX+18)	;HL => buffer
	LD	A,-1		;fill with FF
	CALL	FILL		;fill sector
;
	LD	E,(IX+15)	;fetch FCB
	LD	D,(IX+16)	;DE => fcb
	LD	BC,SYSTEM+7	;point to vector
;
	CALL	POSN$		;position to record
	JR	Z,INITD5	;go if OK
	CP	1CH		;out of range?
	JR	Z,INITD5	;go if yes
	CP	1DH		;beyond file?
	JP	NZ,AERROR	;go if neither!
INITD5	CALL	WRITE$		;write the sector
	JP	NZ,AERROR	;go if error!
;
;	move data particulars into FCB block
;
	PUSH	IX		;pass IX to DE
	POP	DE		;DE => fcb block
	INC	DE		;+1
	LD	HL,STRING	;stored data
	LD	BC,14		;stored length
	LDIR			;move into block
;
;	rewind file to beginning
;
	LD	E,(IX+15)	;fetch FCB again
	LD	D,(IX+16)	;DE => fcb
	LD	BC,REWIND	;3 00's
;
	CALL	POSN$		;rewind file
	JP	NZ,AERROR	;go if error!
;
	LD	B,(IX+1)	;fetch ERN
	LD	H,(IX+2)
	LD	L,(IX+3)	;BHL = ERN
;
INITD7	LD	A,B		;fetch MSB
	OR	H		;any bits on
	OR	L		;BHL = 0?
	JR	Z,INITD8	;yes, done!
;
;	check for ABORT key (BREAK)
;
	CALL	STROBE		;strobe keyboard
	CP	BREAK		;break key?
	JP	Z,ABORT		;yes, abort operation
;
	PUSH	BC		;save
	PUSH	HL		;save
;
	CALL	WRITE$		;write next record
	POP	HL		;unstack
	POP	BC		;unstack
	JP	NZ,AERROR	;go if any error!
;
;	dec # records to write
;
	CALL	DECBHL		;decrement BHL
	JR	INITD7		;continue
;
;	file created, load data to sector
;
INITD8	LD	BC,REWIND	;record #
	CALL	POSN$		;position file
	JP	NZ,AERROR	;go if error
	LD	L,(IX+17)	;fetch buffer start again
	LD	H,(IX+18)	;HL => I/O buffer
	PUSH	DE		;save fcb
	PUSH	HL		;save buffer
	CALL	PUTID		;load ID field
	POP	DE		;restore buffer
	PUSH	IX		;pass IX to HL
	POP	HL		;HL => fcb data
	LD	A,(IX+0)	;fetch flags
	AND	87H		;save drive # only
	LD	(IX+0),A	;update flags
	LD	BC,15		;15 byte block
	LDIR			;move into sector
	POP	DE		;DE => fcb
;
	CALL	WRITE$		;write first sector
	JP	NZ,AERROR	;go if error
;
;	file created and inited
;
INITEND	LD	B,(IX+7)	;MSB # records available
	LD	H,(IX+8)
	LD	L,(IX+9)
	LD	DE,MSG12A	;text
	CALL	BINASC		;binary to ascii
	LD	HL,MSG12	;start of message
	SET	6,(IY+0)	;set data as available
	JP	BAKMENU		;done, back to menu
;
	PAGE
;
;	exit program back to main menu
;
CORRUPT	EQU	$
	CALL	VIDON$		;enable video
	LD	HL,MSG99	;error text
	LD	DE,@VIDEO	;start video memory
	LD	BC,MSG99L	;length of message
	LDIR			;move to video
DEAD	JP	DEAD		;abort!
;
EXIT	LD	HL,PGM1		;PMAILM/CMD
	LD	BC,RUNERR	;error vector
	JP	RUNPGM		;run program!
;
;	error on run attempt
;
RUNERR	CALL	ERROR		;display error message
	LD	HL,MSG7		;'key to continue'
	JP	BAKMENU		;display and go menu
;
	PAGE
;
;	display author
;
SHOWWHO	LD	HL,WHOMSG	;author text
	CALL	DISPLAY		;display it
	CALL	ENKEY		;wait for a key
	JP	MENU		;back to menu
;
WHOMSG	DEFB	SETCUR
	DEFB	01,038
	DEFB	EOL
	DEFM	'<< Author Credits >>'
;
	DEFB	SETCUR
	DEFB	12,00
	DEFB	EOF
	DEFM	'System Authors: '
	DEFB	CR
	DEFM	'Kim Watt, Dennis Brent, Renato Reyes, Doug Hogarth'
	DEFB	CR
	DEFM	'Copyright (C) 1983 - '
	DEFM	'Breeze/QSD, Inc. - '
	DEFM	'Dallas, Texas'
	DEFB	CR
	DEFM	'All Rights Reserved, <ENTER>:'
	DEFB	ETX
;
;	load ID data into sector HL =>
;
PUTID	PUSH	HL		;save buffer start
	XOR	A		;load 00
	CALL	FILL		;fill the sector
	POP	HL		;restore start
	LD	DE,020H		;offset to disk name
	ADD	HL,DE		;HL => sector header
	LD	DE,DISKNAM	;DE => disk name
	LD	BC,16		;length
	EX	DE,HL		;DE=> sector
	LDIR			;move in the header
	LD	HL,HEADER	;file header
	LD	C,16		;length
	LDIR			;move it in
	LD	H,D		;pass DE => HL
	LD	L,E		;HL/DE => buff +40h
	INC	DE		;+1
	LD	(HL),' '	;load blank
	LD	BC,24*8-1	;flag length -1
	LDIR			;fill sector
	RET			;done
;
	LD	A,-1		;fill with FF
FILL	LD	B,0		;256 bytes
FILLLP	LD	(HL),A		;load char
	INC	HL		;bump pointer
	DJNZ	FILLLP		;go till end
	RET			;buffer filled
;
;	expand existing data file
;
BIGGER	JP	MENU		;nil for now
;
	PAGE
;
;	fetch 24 bit ascii value into ABC
;
	IF	MOD13.OR.MOD4.OR.DP2
VALUE	PUSH	HL		;save input pointer
	CALL	POSEND		;find terminator
;
	LD	HL,ADDHEX	;hex adder
	LD	B,16		;base
	CP	'H'		;hex?
	JR	Z,GOVAL		;yes, go
;
	LD	HL,ADDOCT	;set up for oct
	LD	B,8		;base
	CP	'O'		;octal?
	JR	Z,GOVAL		;yes, go
	CP	'Q'		;octal?
	JR	Z,GOVAL		;yes, go
;
	LD	HL,ADDBIN	;binary adder
	LD	B,2		;base
	CP	'B'		;binary?
	JR	Z,GOVAL		;yes, go
;
	LD	HL,ADDEC	;decimal adder
	LD	B,10		;base
	CP	'D'		;decimal?
	JR	Z,GOVAL		;yes, go!
;
	XOR	A		;load no base specifier
GOVAL	LD	(ADDCALL),HL	;adder call to code
	LD	(ADDTERM),A	;alt terminator
	LD	A,B		;get base
	LD	(ADDMAX),A	;save max digit +1
	POP	HL		;point to string again
;
	XOR	A		;load MSB
	LD	B,A		;load NSB
	LD	C,A		;load LSB
;
;	looper to evaluate numeric input
;
VALLP	EX	AF,AF'		;save MSB number
	LD	A,(HL)		;pick up a digit
	CALL	UCASE		;convert to upper case
	CP	CR		;CR?
	JR	Z,VALOK		;yes, done!
	CP	ETX		;terminator?
	JR	Z,VALOK		;yes, done!
	INC	HL		;bump to next digit
	CP	0		;base specifier?
ADDTERM	EQU	$-1
	JR	Z,VALOK		;yes, done!
	CP	SPACE		;space?
	JR	Z,VALOK		;yes, go!
	CP	COMMA		;comma?
	JR	Z,VALOK		;yes, go!
;
;	conversion is done here
;
	CALL 	CONVCHR		;convert ascii => binary
	RET	NZ		;error, return
;
	EX	AF,AF'		;get MSB digit back
	PUSH	HL		;save string pointer
	LD	H,B		;pass subtotal to HL
	LD	L,C		;HL = subtotal
	CALL	$		;add subtotal
ADDCALL	EQU	$-2
	EX	AF,AF'		;get new digit back
	LD	C,A		;C = digit
	LD	B,0		;BC = digit
	EX	AF,AF'		;get MSB back
	ADD	HL,BC		;add new digit
	ADC	A,0		;catch the carry
	LD	B,H		;re-pass subtotal
	LD	C,L		;BC = subtotal
	POP	HL		;restore string pointer
	JR	VALLP		;go next char
;
VALOK	EX	AF,AF'		;get MSB digit back
	CP	A		;set Z flag
	RET			;done, ABC = value
;
;	digit to binary conversion
;
CONVCHR	SUB	'0'		;remove ascii
	JR	C,CHBAD		;go if error
	CP	10		;0-9?
	JR	C,CHOK		;yes, go!
	SUB 	7		;adjust for A-F
	JR	C,CHBAD		;go if error
CHOK	CP	0		;0 to base-1?
ADDMAX	EQU	$-1
	JR	NC,CHBAD	;nope, error
	CP	A		;set Z flag, clear carry
	RET			;done!
;
CHBAD	OR	-1		;set NZ for error
	RET			;back to caller with err
;
;	HEX/Octal adder
;
ADDHEX	ADD	HL,HL		;*02
	RLA			;catch carry
ADDOCT	ADD	HL,HL		;*04 - *02
	RLA			;catch carry
	ADD	HL,HL		;*08 - *04
	RLA			;catch carry
	ADD	HL,HL		;*16 - *08
	RLA			;catch carry
	RET			;AHL = new result
;
;	Decimal/Binary adder
;
ADDEC	LD	(ADDECX),A	;must save MSB
	ADD	HL,HL		;*2
	RLA			;catch carry
	ADD	HL,HL		;*4
	RLA			;catch carry
	ADD	HL,BC		;*5
	ADC	A,0
ADDECX	EQU	$-1
;
ADDBIN	ADD	HL,HL		;*10 - *02
	RLA			;catch carry
	RET
;
;	Fetch base specifier from string
;
	INC	HL		;bump pointer
POSEND	LD	A,(HL)		;fetch a byte
	CP	CR		;terminator?
	JR	Z,ENDHAV	;yes, go!
	CP	ETX		;terminator?
	JR	Z,ENDHAV	;yes, go!
	CP	SPACE		;separator?
	JR	Z,ENDHAV	;yes, go!
	CP	COMMA		;separator?
	JR	NZ,POSEND-1	;nope, go next char
;
ENDHAV	DEC	HL		;backspace string
	LD	A,(HL)		;fetch last char
	JP	UCASE		;convert ucase and return
	ENDIF
;
	IF	PDOS
VALUE	LD	A,@VALUE	;SVC #
	RST	SVC		;fetch value
	RET			;return with status
	ENDIF
;
	PAGE
;
;	compute size of file from # records
;
SIZE	PUSH	IY		;save sys pointer
	LD	IY,STRING-1	;start string -1
	LD	(IY+7),B	;MSB # records
	LD	(IY+8),H	;NSB
	LD	(IY+9),L	;LSB
	LD	(IY+10),0	;MSB # records used
	LD	(IY+11),0
	LD	(IY+12),0
	LD	(IY+13),-1	;sort field #1
	LD	(IY+14),-1	;sort field #2
;
;	BHL = # records, compute file size
;
	PUSH	BC		;save on stack
	PUSH	HL
	LD	A,2		;divide in half
	CALL	TDIVD		;divide in half
	OR	A		;remainder?
	CALL	NZ,INCBHL	;even record number
	LD	A,B		;pass result to CDE
	LD	D,H
	LD	E,L		;CDE = # data sectors
	POP	HL		;restore # records
	POP	BC		;BHL = # records
	LD	C,A		;pass MSB
	LD	A,11		;divide / 11
	CALL	TDIVD		;BHL = # index sectors
	OR	A		;remainder?
	CALL	NZ,INCBHL	;partial sector needed
	CALL	INCBHL		;+1 for information
	LD	(IY+4),B	;save start data
	LD	(IY+5),H
	LD	(IY+6),L
	CALL	ADDIT		;add CDE to BHL
	LD	(IY+1),B	;save ending record #
	LD	(IY+2),H
	LD	(IY+3),L	;BHL = ending record #
	POP	IY		;restore IY
	RET			;done!
;
	PAGE
;
;	display error message
;
ERROR	JP	ERROR$		;display message
;
;	file exists, ask if to be deleted
;
EXISTS	LD	HL,MSG3		;'exists, delete?'
	CALL	DISPLAY		;display prompt
	LD	B,1		;single key input
	CALL	GETSTR		;fetch from keyboard
	RET	C		;return if BREAK
	JR	Z,EXISTS	;no defaults
	CALL	UCASE		;first char to ucase
	CP	'X'		;abort?
	SCF			;simulate carry flag
	RET	Z		;go if yes!
	CP	'N'		;no?
	RET	Z		;yes, return with Z
	CP	'Y'		;yes?
	JR	NZ,EXISTS	;neither, ask again
	OR	-1		;set NC, NZ
	RET			;return YES
;
;	fetch drive number from user
;
GETDRV	LD	HL,MSG4		;'drive number?'
	CALL	DISPLAY		;display prompt
	LD	B,1		;single key input
	CALL	GETSTR		;fetch from keyboard
	RET	C		;return if break
	JR	Z,GETDRV	;no defaults
	CALL	UCASE		;make upper case
	CP	'X'		;abort?
	SCF			;simulate BREAK
	RET	Z		;go if yes!
	CP	'0'		;check for valid drive
	JR	C,GETDRV	;out of range
	CP	DRIVES+'0'	;0-drives?
	JR	NC,GETDRV	;invalid, ask again
	OR	A		;clear carry flag
	RET			;else A = ascii drive #
;
;	abort init operation with BREAK key
;
ABORT	LD	HL,ABMSG	;abort message
	CALL	DISPLAY		;display message
	CALL	ENKEY		;wait for a key
	JP	MENU		;back to menu
;
;	insert user defined password
;
INSPASS	PUSH	DE		;save
	LD	DE,PASSWRD	;password stored here
	LD	A,(DE)		;get a char
	CP	'.'		;anything?
	JR	NZ,INSPAS3	;go if not
	JR	INSPAS2		;else load char
;
INSPAS1	LD	A,(DE)		;get a char
	CP	'.'		;terminator?
	JR	Z,INSPAS3	;yes, return
;
INSPAS2	LD	(HL),A		;to user string
	INC	HL		;bump pointer
	INC	DE		;bump password
	JR	INSPAS1		;go till term found
;
INSPAS3	POP	DE		;restore DE
	RET			;done!
;
	PAGE
;
ABMSG	DEFB	SETCUR
	DEFB	12,00
	DEFB	EOF
	DEFB	CR
	DEFB	CR
	DEFM	'Operation ABORTED, <ENTER>:'
	DEFB	ETX
;
HEADER	DEFM	' PowerMAIL PLUS '
DISKNAM	DEFM	'disknamediskname'
;
MSG1	DEFB	SETCUR
	DEFB	01,038
	DEFB	EOL
	DEFM	'<< Initialize Files >>'
;
	DEFB	SETCUR
	DEFB	12,000
	DEFB	EOF
;
	DEFM	'(1) Init Adder File'
	DEFB	SETCUR
	DEFB	12,COLS/2
	DEFM	'(3) Return to Menu'
	DEFB	CR
;
	DEFM	'(2) Init Data File'
	DEFB	CR
;
	DEFM	'Choice ? '
	DEFB	ETX
;
MSG2	DEFB	SETCUR
	DEFB	12,000
	DEFB	EOF
;
	DEFM	'Creating Adder File'
	DEFB	CR
	DEFB	ETX
;
MSG2X	DEFB	SETCUR
	DEFB	13,00
	DEFB	EOF
;
	DEFM	'File Exists, (D)elete or (R)e-use ? '
	DEFB	ETX
;
MSG3	DEFB	SETCUR
	DEFB	13,000
	DEFB	EOF
;
	DEFM	'File Exists, Delete (Y/N) ? '
	DEFB	ETX
;
MSG4	DEFB	SETCUR
	DEFB	13,000
	DEFB	EOF
;
	DEFM	'Drive # for File (0-7) ? '
	DEFB	ETX
;
MSG5	DEFB	SETCUR
	DEFB	13,000
	DEFB	EOF
;
	DEFM	'File Created, <ENTER>:'
	DEFB	ETX
;
MSG6	DEFB	SETCUR
	DEFB	13,000
	DEFB	EOF
;
	DEFM	'Create/Expand Error - '
	DEFB	ETX
;
MSG7	DEFM	'<ENTER> to continue:'
	DEFB	ETX
;
MSG8	DEFB	SETCUR
	DEFB	12,000
	DEFB	EOF
;
	DEFM	'Expanding Data File'
	DEFB	CR
	DEFB	ETX
;
MSG9	DEFB	SETCUR
	DEFB	12,000
	DEFB	EOF
;
	DEFM	'Creating Data File'
	DEFB	CR
	DEFB	ETX
;
MSG10	DEFM	'File NOT AVAILABLE, <ENTER>:'
	DEFB	ETX
;
MSG11	DEFB	SETCUR
	DEFB	13,000
	DEFB	EOF
;
	DEFM	'# records to allocate ? '
	DEFB	ETX
;
MSG11X	DEFB	SETCUR
	DEFB	13,00
	DEFB	EOF
	DEFM	'File Title (0-16 chars) ? '
	DEFB	ETX
;
MSG12	DEFB	SETCUR
	DEFB	13,000
	DEFB	EOF
;
	DEFM	'Created, '
MSG12A	DEFM	'........ Records Available, <ENTER>:'
	DEFB	ETX
;
MSG99	DEFM	'RUN PMAIL/CMD ONLY!'
MSG99L	EQU	$-MSG99
;
	PAGE
;
TABLE1	DEFB	'1'
	DEFW	INITA		;init adder
	DEFB	'2'
	DEFW	INITD		;init data
	DEFB	'3'
	DEFW	EXIT		;back to menu
	DEFB	'W'		;who?
	DEFW	SHOWWHO		;yes, display text!
	DEFB	'X'
	DEFW	EXIT		;return to menu
	DEFB	ETBL		;end of table
;
;	program name to link back to menu
;
PGM1	DEFM	'PMAILM'
	EXTEN$
	DEFB	ETX
;
AFILE	DEFM	'PMAIL/ADD'
AFILEA	DEFM	'.........:.'
	DEFB	ETX
;
DFILE	DEFM	'PMAIL/DAT'
DFILEA	DEFM	'.........:.'
	DEFB	ETX
;
PGMEND	EQU	$
;
	END	ENTRY
