; sys8/asm - kjw/bqsd - 06/02/83
;
;	created 06/02/83	- kjw/bqsd
;	revised 06/02/83	- kjw
;
*GET	DOSEQU			;external equivalences
;
JRC	EQU	38H		;JR C opcode
JRNC	EQU	30H		;JR NC opcode
;
	TITLE	'<PowerDOS - SYS08/SYS>'
;
	SUBTTL	'<Copyright (C) 1983 - Breeze/QSD, Inc. - Dallas, Texas>'
;
;	$PARSER	- SVC 46	- parse command line
;	$FILPTR	- SVC 58	- fetch file pointers
;	$SORT	- SVC 56	- sort memory block
;	$SORT2	- SVC 112	- alternate sort entry
;
	PAGE
;
	ORG	$LOSYS		;low overlay
;
VECTORS	DEFW	$RETURN		;1 - load and return
	DEFW	$PARSER		;2 - parse command string
	DEFW	$FILPTR		;3 - fetch file pointers
	DEFW	$SORT		;4 - sort memory
	DEFW	$SORT2		;5 - alternate sort entry
	DEFW	$UNDEF		;6 - undefined
	DEFW	$UNDEF		;7 - undefined
	DEFW	$UNDEF		;8 - undefined
	DEFW	$UNDEF		;9 - undefined
	DEFW	$UNDEF		;10 - undefined
	DEFW	$UNDEF		;11 - undefined
	DEFW	$UNDEF		;12 - undefined
	DEFW	$UNDEF		;13 - undefined
	DEFW	$UNDEF		;14 - undefined
	DEFW	$UNDEF		;15 - undefined
	DEFW	$UNDEF		;16 - undefined
;
	PAGE
;
;	undefined system call
;
$UNDEF	LD	A,_ERR01	;'bad function call'
	OR	A		;set NZ
	RET			;back to caller in error
;
	PAGE
;
;	$FILPTR - SVC 58 - fetch file pointers
;
;	ENTRY	DE =>	open FCB
;
;	EXIT	C  =	LFN
;		B  =	drive #
;
$FILPTR	LD	A,(DE)		;get flags
	CPL			;reverse bits
	AND	@BIT7		;file open?
	LD	A,_ERR38	;'unopen file'
	RET	NZ		;go if not open!
;
	PUSH	HL		;save HL
	LD	HL,16		;offset to drive
	ADD	HL,DE		;HL => drive #
	LD	B,(HL)		;get drive #
	INC	HL		;bump FCB
	LD	C,(HL)		;get LFN
	POP	HL		;restore HL
$RETURN	XOR	A		;set NO error
	RET			;return with pointers
;
	PAGE
;
;	$PARSER - SVC 46 - parse command string
;
;	ENTRY	C  =	maximum parse length
;		HL =>	text buffer
;		DE =>	list address block (0=none)
;
;	EXIT	A  =	char preceding field
;		B  =	actual field length
;		C  =	number of bytes remaining
;		D  =	field terminator
;		E  =	displacement pointer
;		HL =>	field position
;
;		Z  =	ended with separator
;		Cy =	trailing blanks
;
$PARSER	CALL	SETBLK		;setup list blocks
	XOR	A		;init flags
	PUSH	AF		;flags to stack
	LD	E,A		;displacement pointer
	LD	B,A		;field length
	DEC	A		;-1
	LD	(TCHR),A	;term char
	LD	(PCHR),A	;previous char
	DEC	HL		;backspace text
	EX	(SP),HL 	;HL = flags
;
;	check for end parsing
;
PARS1	EX	(SP),HL 	;HL => text buffer
	INC	HL		;next address
	INC	C		;dec bytes remaining
	CP	C		;at end of parse?
	JR	NZ,PARS2	;nope, continue
	EX	(SP),HL 	;get flags from stack
	RES	6,L		;term found - NZ
	JR	PARS12		;skip out
;
;	get character from text
;
PARS2	LD	A,(HL)		;get character
	DEC	C		;less parse count
	EX	(SP),HL 	;get flags
	BIT	7,H		;in field?
	JR	Z,PARS3 	;go if not
	INC	E		;displacement pointer
;
;	check for end literal
;
PARS3	BIT	5,H		;in literal?
	JR	Z,PARS4 	;go if not
	CP	D		;terminating literal?
	JR	NZ,PARS7	;go if not
	RES	5,H		;set no literal
	SET	6,H		;set end field
	JR	PARS1		;try again
;
;	check for start literal
;
PARS4	CP	'"'             ;literal?
	JR	Z,PARS5 	;skip if yes
	CP	27H		;literal?
	JR	NZ,PARS6	;go if not
;
PARS5	BIT	7,H		;in field?
	JR	NZ,PARS11	;go if not
	SET	5,H		;set in literal
	LD	D,A		;literal char
	JR	PARS1		;try again
;
;	check for start field
;
PARS6	CALL	CKCHR		;check character
	JR	NZ,PARS9	;term/sep
PARS7	BIT	7,H		;in field?
	JR	NZ,PARS8	;go if yes
	INC	E		;displacement pointer
	EX	(SP),HL 	;HL => text buffer
	DEC	HL		;backspace text
	LD	A,(HL)		;get prev char
	LD	(PCHR),A	;save preceding char
	INC	HL		;correct pointer
	LD	(FPOS),HL	;save pointer posit
	EX	(SP),HL 	;get flags
	SET	7,H		;have field
;
;	check for end field
;
PARS8	BIT	6,H		;end field?
	JR	Z,PARSA 	;go if not
	DEC	E		;displacement pointer
	INC	C		;parse count
	JR	PARS12		;exit
;
PARSA	INC	B		;actual field length
	JR	PARS1		;try again
;
;	skip trailing blanks
;
PARS9	JR	C,PARS10	;if terminator
	CP	' '             ;blank?
	JR	NZ,PARS11	;go if not
	BIT	7,H		;in field?
	JR	Z,PARS1 	;go if not
	SET	6,H		;set end field
	SET	0,L		;trailing blanks - C
	JR	PARS1		;try again
;
;	end of field processing
;
PARS10	RES	6,L		;term found - NZ
PARS11	LD	(TCHR),A	;set term character
	BIT	7,H		;in field?
	JR	NZ,PARS12	;go if yes
	INC	E		;displacement pointer
	EX	(SP),HL 	;get text pointer
	LD	(FPOS),HL	;set field position
	EX	(SP),HL 	;get flags
;
PARS12	EX	(SP),HL 	;get text pointer
	LD	HL,(FPOS)	;HL => field position
	POP	AF		;get flags
	LD	A,(TCHR)	;get term char
	LD	D,A		;D = term char
	LD	A,(PCHR)	;previous char
	RET			;done!
;
;	variables for parser
;
FPOS	DEFW	0		;field position
TCHR	DEFB	0		;term character
PCHR	DEFB	0		;previous character
;
	PAGE
;
;	check if character field/term/separator
;
;	ENTRY	A  =	character
;
;	EXIT	Z/NC if field
;		NZ/C if terminator
;		NZ/NC if separator
;
CKCHR	PUSH	HL		;save registers
	PUSH	BC
	LD	B,0		;MSB count
;
;	check for special terminator
;
CKCHR1	LD	HL,(LIST1)	;term list
	LD	C,(HL)		;char count
	INC	C		;check for nil
	DEC	C		;C = 0?
	JR	Z,CKCHR2	;skip if yes
	INC	HL		;HL => list
	CPIR			;found?
	JR	Z,CKCHR7	;yes, terminator
;
;	check for special field char
;
CKCHR2	LD	HL,(LIST2)	;field list
	LD	C,(HL)		;char count
	INC	C		;nil list?
	DEC	C		;C = 0?
	JR	Z,CKCHR3	;skip if yes
	INC	HL		;HL => list
	CPIR			;in table?
	JR	Z,CKCHR5	;yes, field character
;
;	check default field char
;
CKCHR3	CP	'0'             ;numeric?
	JR	C,CKCHR6	;nope, separator
	CP	'9'+1           ;numeric?
	JR	C,CKCHR4	;yes, field char
	CP	'A'             ;alpha?
	JR	C,CKCHR6	;nope, separator
	CP	'Z'+1           ;alpha?
	JR	C,CKCHR4	;yes, field char
	CP	'a'             ;alpha?
	JR	C,CKCHR6	;nope, separator
	CP	'z'+1           ;alpha?
	JR	NC,CKCHR6	;nope, separator
;
;	check for special separator
;
CKCHR4	LD	HL,(LIST3)	;field list
	LD	C,(HL)		;char count
	INC	C		;check for nil list
	DEC	C		;C = 0?
	JR	Z,CKCHR5	;skip if yes
	INC	HL		;HL => list
	CPIR			;in table?
	JR	Z,CKCHR6	;yes, terminator
;
;	setup for terminating status
;
CKCHR5	CP	A		;Z / NC
	JR	CKCHR8		;skip with field
;
CKCHR6	LD	B,A		;save character
	OR	-1		;NZ / NC
	LD	A,B		;get char
	JR	CKCHR8		;skip with separator
;
CKCHR7	LD	B,A		;save char
	OR	-1		;NZ / NC
	SCF			;NZ / C
	LD	A,B		;get term char
;
CKCHR8	POP	BC		;restore registers
	POP	HL
	RET			;done, return!
;
	PAGE
;
;	setup list block
;
;	ENTRY	DE =>	list address block (0=default)
;
SETBLK	PUSH	HL		;save
	LD	A,D		;check for nil
	OR	E		;DE = 0000?
	JR	NZ,$+5		;go if not nil
	LD	DE,DEFLBA	;default list block
	CALL	GETBLK		;get block address
	LD	(LIST1),HL	;set list 1
	CALL	GETBLK		;get block address
	LD	(LIST2),HL	;set list 2
	CALL	GETBLK		;get block address
	LD	(LIST3),HL	;set list 3
	POP	HL		;restore
	RET			;blocks set
;
;	get list address from list block
;
;	ENTRY	DE =>	list block
;
GETBLK	EX	DE,HL		;HL => list address block
	LD	E,(HL)		;get LSB
	INC	HL		;bump pointer
	LD	D,(HL)		;get MSB
	INC	HL		;bump pointer
	EX	DE,HL		;HL => list block
	LD	A,H		;check for nil
	OR	L		;HL = 0000?
	RET	NZ		;nope, return with addr
	LD	HL,NULL 	;else set null list
	RET			;return null
;
;	default list blocks
;
DEFLBA	DEFW	0		;default term block
	DEFW	0		;default field block
	DEFW	0		;default separator block
;
NULL	DEFB	0		;default list block
;
;	list block addresses
;
LIST1	DEFW	0		;terminator list
LIST2	DEFW	0		;field list
LIST3	DEFW	0		;separator list
;
	PAGE
;
;	$SORT - SVC 56 - sort memory block
;
;	ENTRY	IX =>	first entry in list
;		DE =>	start of last entry in list
;		B  =	position of key
;		C  =	length of each entry
;		L  =	length of sort key
;		H  =	sort flag - 0=ascending
;
;	$SORT2 - SVC 112 - alternate sort entry
;
;	ENTRY	same as $SORT except
;		DE =	entry count
;
$SORT	LD	A,@SAVREG	;SVC #
	RST	$SVC		;save registers
	CALL	NUMENT		;fetch entry count
	JR	SORT0		;go common
;
$SORT2	LD	A,@SAVREG	;SVC #
	RST	$SVC		;save registers
;
SORT0	CALL	SETSORT		;setup sort params
	RET	NZ		;parameter error!
;
;	loop to sort block
;
SORT1	PUSH	IX		;pass low to HL
	POP	HL		;HL => current entry
	LD	D,H		;pass current posit
	LD	E,L		;HL=current, DE=lowest
	PUSH	BC		;save count
	JR	SORT3		;continue
;
SORT2	CALL	CPAIR		;compare HL <-> DE
	JR	Z,SORT3		;go if equal
SORTDIR	JR	NC,SORT3	;go if less/greater
;
;	have new lowest entry
;
	LD	D,H		;pass to DE
	LD	E,L		;DE = current lowest
;
;	bump to start next record
;
SORT3	PUSH	DE		;save lowest
	LD	DE,(ENTLEN)	;get entry length
	LD	D,0		;DE = entry length
	ADD	HL,DE		;HL => next entry
	POP	DE		;restore lowest
;
;	check for completed
;
	DEC	BC		;less counter
	LD	A,B		;get msb
	OR	C		;BC = 0000?
	JR	NZ,SORT2	;nope, continue
;
;	swap lowest entry with current pointer
;
	PUSH	IX		;pass start to HL
	POP	HL		;HL => start char
	LD	B,0		;get entry length
ENTLEN	EQU	$-1
;
SORT4	LD	C,(HL)		;get first char
	LD	A,(DE)		;get second
	LD	(HL),A		;swap one
	LD	A,C		;get first
	LD	(DE),A		;swap two
	INC	HL		;bump pointers
	INC	DE
	DJNZ	SORT4		;go for entry length
;
;	position IX to start of next entry
;
	LD	BC,(ENTLEN)	;get entry length
	LD	B,0		;BC = length
	ADD	IX,BC		;IX => next entry
;
;	check if table completed
;
	POP	BC		;restore entry count
	DEC	BC		;less count
	LD	A,B		;any more?
	OR	C		;BC = 0000?
	JR	NZ,SORT1	;nope, continue
	RET			;else return Z
;
;	compare elements
;
CPAIR	PUSH	BC		;save registers
	PUSH	DE
	PUSH	HL
;
	LD	BC,$-$		;get sort offset
KEYOFF	EQU	$-2
	ADD	HL,BC		;HL => first key
	EX	DE,HL		;swap
	ADD	HL,BC		;HL => second key
	LD	BC,$-$		;get key length
KEYLEN	EQU	$-1
;
CPLOOP	LD	A,(DE)		;get char
	CP	(HL)		;match?
	JR	NZ,CPRET	;nope, go!
	INC	HL		;bump pointers
	INC	DE
	DJNZ	CPLOOP		;go for count
;
CPRET	POP	HL		;unstack 'em
	POP	DE
	POP	BC
	RET
;
;	compute # of entries to sort
;
NUMENT	PUSH	BC		;save
	PUSH	HL		;save
;
	PUSH	IX		;pass start to HL
	POP	HL		;HL => start of list
	EX	DE,HL		;HL=>end, DE=>start
	OR	A		;clear carry
	SBC	HL,DE		;HL = sort space
	LD	B,0		;BHL=length, C=ent length
	LD	A,@DIVID	;SVC #
	RST	$SVC		;HL = entry count
	EX	DE,HL		;DE = entry count
;
	POP	HL		;restore
	POP	BC		;restore
	INC	DE		;correct count
	RET
;
;	setup sort parameters
;
SETSORT CALL	PARSORT 	;check valid params
	OR	A		;any error?
	RET	NZ		;yes, cannot sort!
;
	LD	A,L
	LD	(KEYLEN),A	;set key length
	LD	A,B
	LD	(KEYOFF),A	;set key offset
	LD	A,C
	LD	(ENTLEN),A	;set entry length
;
	LD	A,JRNC		;assume ascending
	INC	H		;check direction
	DEC	H		;H = 0?
	JR	Z,$+4		;yes, ascending
	LD	A,JRC		;else descending
	LD	(SORTDIR),A	;set direction
	LD	B,D		;pass entry count to BC
	LD	C,E
	XOR	A		;set no error
	RET			;table setup
;
;	check for valid parameters
;
PARSORT LD	A,L		;sort field length
	OR	A		;0 ?
	LD	A,4		;invalid code
	RET	Z		;invalid
;
	LD	A,C		;entry length
	OR	A		;0 ?
	LD	A,3		;invalid code
	RET	Z		;invalid
;
	LD	A,B		;key posit
	CP	C		;entry length
	LD	A,2		;invalid code
	RET	NC		;invalid
;
	LD	A,L		;sort length
	ADD	A,B		;add key offset
	DEC	A		;adjust for compare
	CP	C		;key st+len <= ent len
	LD	A,1		;error code
	RET	NC		;invalid
;
	LD	A,D		;see if nil length
	OR	E
	LD	A,5		;error code
	RET	Z		;invalid
	XOR	A		;all OK
	RET
;
_______	EQU	$
;
	END	VECTORS
