; sys7/asm - kjw/bqsd - 05/25/83
;
;	created 05/25/83	- kjw/bqsd
;	revised 05/27/83	- kjw
;
*GET	DOSEQU			;external equivalences
;
	TITLE	'<PowerDOS - SYS07/SYS>'
;
	SUBTTL	'<Copyright (C) 1983 - Breeze/QSD, Inc. - Dallas, Texas>'
;
;	$KBINIT	- SVC 1		- initialize keyboard
;	$VDINIT	- SVC 7		- initialize video
;	$PRINIT - SVC 17	- initialize printer
;	$RS232C - SVC 55	- initialize RS232
;	$DATE	- SVC 45	- fetch/load DATE$
;	$PRCTL	- SVC 95	- printer param control
;	$ACTL	- SVC 100	- SIO ch A control
;	$BCTL	- SVC 101	- SIO ch B control
;	$INITIO	- SVC 0		- init I/O devices
;	$JPINIT	- SVC 109	- init I/O and abort
;
	PAGE
;
	ORG	$LOSYS		;low overlay
;
VECTORS	DEFW	$RETURN		;1 - load and return
	DEFW	$KBINIT		;2 - init keyboard
	DEFW	$VDINIT		;3 - init video
	DEFW	$PRINIT		;4 - init printer
	DEFW	$RS232C		;5 - RS232 control
	DEFW	$DATE		;6 - fetch/load time/date
	DEFW	$PRCTL		;7 - printer control
	DEFW	$ACTL		;8 - comm A control
	DEFW	$BCTL		;9 - comm B control
	DEFW	$INITIO		;10 - init I/O drivers
	DEFW	$JPINIT		;11 - init I/O & exit
	DEFW	$UNDEF		;12 - undefined
	DEFW	$UNDEF		;13 - undefined
	DEFW	$UNDEF		;14 - undefined
	DEFW	$UNDEF		;15 - undefined
	DEFW	$UNDEF		;16 - undefined
;
	PAGE
;
;	undefined system call vector
;
$UNDEF	LD	A,_ERR01	;'bad function call'
	OR	A		;set NZ
	RET			;back to caller
;
	PAGE
;
;	definition of SIO initialization table
;
SIOA	DEFB	3		;# of tables
;
;	setup for SIO ports
;
	DEFB	11		;# entries this table
BPORT	EQU	$-SIOA		;offset to base port
	DEFB	0F6H		;SIO base port address
	DEFB	18H		;channel reset
	DEFB	4		;R4
STOPS	EQU	$-SIOA		;offset to stops
	DEFB	44H		;x16, stop=1
	DEFB	3		;R3
WORD	EQU	$-SIOA		;offset to word length
	DEFB	0E1H		;word=8, RX
	DEFB	5		;R5
TXTYP	EQU	$-SIOA
	DEFB	0EAH		;DTR,W=8,TX,RTS
	DEFB	2		;R2
INTV1	DEFB	0D8H		;int vector
	DEFB	1+10H		;reset int, select R1
	DEFB	1CH		;int all RX chars
;
;	CTC #1 setup
;
	DEFB	3		;# entries this table
CTC1	EQU	$-SIOA		;offset to CTC-0 port
	DEFB	0F0H		;CTC-0 base port address
RXBAUD	EQU	$-SIOA		;offset to RX baud rate
	DEFB	07H		;count, reset
RXCNT	EQU	$-SIOA		;offset to RX count
	DEFB	34H		;default 300 baud
INTV2	DEFB	0D8H+15		;int vector
;
;	CTC #2 setup
;
	DEFB	2		;# entries
CTC2	EQU	$-SIOA		;offset to CTC-1 port
	DEFB	0F1H		;CTC-1 base port
TXBAUD	EQU	$-SIOA		;offset to TX baud
	DEFB	07H		;count, reset
TXCNT	EQU	$-SIOA		;offset to TX baud
	DEFB	34H		;default, 300 baud
;
;	baud table
;
SIOBAUD DEFW	8E07H		;110
	DEFW	6807H		;150
	DEFW	3407H		;300
	DEFW	1A07H		;600
	DEFW	0D07H		;1200
	DEFW	3447H		;2400
	DEFW	1A47H		;4800
	DEFW	0D47H		;9600
;
	PAGE
;
;	$RS232C - SVC 55 - init RS232 channels
;
;	ENTRY	HL => parameter list (6 bytes)
;		B = 0 = turn off channel
;		B >< 0 = turn on channel and define
;
;	EXIT	Z = OK
;		NZ = A = error code
;
;	PARAMETER LIST
;
;	+0	- channel ("A", "a", "B", "b")
;	+1	- baud rate (1-8)
;		1 = 110 baud
;		2 = 150 baud
;		3 = 300 baud
;		4 = 600 baud
;		5 = 1200 baud
;		6 = 2400 baud
;		7 = 4800 baud
;		8 = 9600 baud
;	+2	- word length (5-8)
;	+3	- parity ("O","o","E","e","N","n")
;	+4	- stop bits (1,2)
;	+5	- end list marker (00H)
;
; extended buffer size field
;
;	+5	- 1 (indicates extended field)
;	+6,+7	- start of buffer
;	+8,+9	- end of buffer
;	+10	- end list marker (00H)
;
$RS232C	LD	A,@SAVREG	;SVC #
	RST	$SVC		;save registers
;
;	locate interrupt vector table
;
	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch data block
	LD	A,(IX+32)	;get LSB int table
	LD	(INTV1),A	;pass int table
	ADD	A,15		;offset to CTC int
	LD	(INTV2),A	;pass int table
;
	PUSH	HL		;HL => user parameters
	POP	IY		;load into IY
	INC	B		;see if add/delete
	DEC	B		;B = 0 = delete
	EX	AF,AF'          ;alt A = Z = REMOVE
;
;	check channel number
;
	LD	A,(IY+00)	;get channel #
	CALL	UCASE		;convert to upper case
;
;	channel A?
;
	LD	DE,0F0F1H	;CTC port address
	LD	BC,@CA<8+0F6H	;B=DCB#, C=port
	SUB	'A'             ;remove ascii
	JR	Z,RSCGO 	;have the channel
;
;	channel B?
;
	LD	DE,0F200H	;CTC ports (00=dummy)
	INC	B		;bump DCB #
	INC	C		;bump base port
	DEC	A		;channel B?
	LD	A,_ERR89 	;invalid channel
	RET	NZ		;illegal channel, return
;
;	channel specifics loaded, find DCB
;
RSCGO	LD	IX,SIOA 	;parameter list CH-A/B
	LD	(IX+BPORT),C	;SIO base port
	LD	(IX+CTC1),D	;CTC #1 port
	LD	(IX+CTC2),E	;CTC #2 port
;
	PUSH	BC		;save port address
	LD	C,B		;pass DCB #
	LD	A,@LOCDEV	;SVC #
	RST	$SVC		;fetch DCB block
	POP	BC		;restore port
;
	LD	(IX+17),D	;load CTC ports
	LD	(IX+18),E
	EX	AF,AF'          ;Z = remove channel
	JR	Z,RSCREM	;remove it
;
;	activate channel
;
	CALL	NILBUFF 	;set buffer @ HL, clear
	LD	(IX+16),C	;SIO base port (status)
	CALL	SIOPARM 	;get user parameters
	RET	NZ		;return in error
	LD	HL,SIOA 	;get parameter list
	CALL	SNDDAT		;setup SIO & CTC ports
	RES	1,(IX+5)	;set channel as init'ed
	RES	3,(IX+00)	;turn off nil
	XOR	A		;set Z flag
	RET
;
;	remove channel
;
RSCREM	SET	1,(IX+5)	;turn off channel
	SET	3,(IX+00)	;set as nil device
	LD	C,(IX+16)	;get base port
	LD	A,18H		;channel reset
	OUT	(C),A		;send SIO
	LD	C,(IX+17)	;CTC #1
	LD	A,3		;disable int's, reset
	OUT	(C),A		;send CTC
	LD	C,(IX+18)	;CTC #2
	INC	C		;check if dummy (00)
	DEC	C		;see if nil
	JR	Z,SIO6		;go if nil
	OUT	(C),A		;else reset CTC #2
SIO6	XOR	A		;Z = OK
	RET
;
	PAGE
;
;	following sends data to I/O ports
;
SNDDAT	LD	E,(HL)		;get table count
	INC	HL		;point to data
;
SETSLP	LD	B,(HL)		;get data count
	INC	HL		;point to data
	LD	C,(HL)		;get port #
	INC	C
	DEC	C
	RET	Z		;if dummy port
	INC	HL		;bump pointer
	OTIR			;send block to port
	DEC	E		;more?
	JR	NZ,SETSLP	;go if yes
	RET			;else done
;
	PAGE
;
;	interpret data from user parameter list
;
;	ENTRY	IY =>	user list
;
SIOPARM PUSH	IY		;user list
	POP	HL		;HL => user list
	LD	IY,SIOA 	;IY => config table
;
;	interpret baud rate
;
	INC	HL		;point to baud rate
	LD	A,(HL)		;get baud
	DEC	A		;must be 1-8
	JP	M,RSCERR	;error if 0
	CP	8		;test for max
	JP	NC,RSCERR	;error if >8
;
;	save into DCB mask
;
	PUSH	AF		;save it
	RLCA			;move it over
	RLCA			;3 places
	RLCA
	RLCA			;4 places
	AND	70H		;3 bits only
	LD	(IX+22),A	;save into mask
	POP	AF		;fetch it
;
;	lookup baud rate in table
;
	PUSH	HL		;save param list
	LD	HL,SIOBAUD	;baud rate table
	ADD	A,A		;double for table
	ADD	A,L		;add to LSB
	LD	L,A		;update it
	JR	NC,SIO7 	;page boundary?
	INC	H		;bump page
SIO7	LD	A,(HL)		;get counter select
	INC	HL		;bump pointer
	LD	H,(HL)		;get count
	LD	(IY+RXBAUD),A	;RX baud
	LD	(IY+TXBAUD),A	;TX baud
	LD	(IY+RXCNT),H	;RX count
	LD	(IY+TXCNT),H	;TX count
	POP	HL		;restore pointer
;
;	interpret word length
;
	INC	HL		;point to word length
	LD	A,(HL)		;word length
	CP	5		;must be 5-8
	JP	C,RSCERR	;go if <5
	CP	9		;test for max
	JP	NC,RSCERR	;go if >8
;
;	compute word length mask
;
	LD	B,A		;for loop
	XOR	A		;zero
SIO8	SCF			;set a bit
	RLA			;move into mask
	DJNZ	SIO8		;for word length
	LD	(IX+19),A	;save word mask
;
;	save into DCB mask
;
	LD	A,(HL)		;get again
	SUB	5		;adjust for strange bits
	PUSH	AF		;save status
	RLCA
	RLCA
	OR	(IX+22) 	;with the rest
	LD	(IX+22),A	;put it in
	POP	AF		;get status
;
;	set-up word length
;
	JR	Z,SIO9		;no correct
	CP	3		;ok?
	JR	Z,SIO9		;no correct
	XOR	3		;reverse bits
SIO9	RRCA			;align bits
	RRCA
	RRCA
	OR	8AH		;DTR, TX enable, RTS, len
	LD	(IY+TXTYP),A	;save into TX table
	LD	(IX+21),A	;save for CTL calls (R5)
	RLCA			;align
	OR	21H		;auto trigger, RX enable
	LD	(IY+WORD),A	;put into RX table
;
;	interpret parity
;
	INC	HL		;point to it
	LD	A,(HL)		;get parity
	CALL	UCASE		;make it upper case
	LD	B,40H		;parity mask
	CP	'N'             ;none?
	JR	Z,RSPAR 	;have it
	SET	0,B		;set odd
	CP	'O'             ;odd?
	JR	Z,RSPAR 	;go if yes
	SET	1,B		;set even
	CP	'E'             ;even?
	JR	NZ,RSCERR	;parameter error
RSPAR	LD	A,B		;get result
	AND	3		;low 2 bits only
	OR	(IX+22) 	;set with mask
	LD	(IX+22),A	;put it in
;
;	interpret stop bits
;
	INC	HL		;point to stop bits
	LD	A,(HL)		;stop bits
	CP	4		;must be 0-3
	JR	NC,RSCERR	;error if not
	LD	(IX+20),A	;update it
	RLCA
	RLCA
	OR	B		;merge with mask
	LD	(IY+STOPS),A	;put into param table
;
;	interpret extended field
;
	INC	HL		;bump pointer
	LD	A,(HL)		;fetch param byte
	DEC	A		;01 extended field
	JP	NZ,$RETURN	;nope, done!
;
	INC	HL		;bump pointer
	LD	A,(HL)		;get LSB start
	LD	E,A		;save it
	INC	HL		;bump pointer
	LD	D,(HL)		;MSB start
	INC	HL		;bump pointer
	LD	A,(HL)		;LSB end
	INC	HL		;bump pointer
	LD	H,(HL)		;MSB end
	LD	L,A		;HL=end, DE=start
	OR	A		;clear carry
	SBC	HL,DE		;HL = buff length
	EX	DE,HL		;DE = buff length
	LD	BC,1<8+6	;B=bank#, C=command #
	LD	A,@MEMCTL	;SVC #
	RST	$SVC		;fetch memory
	RET	NZ		;nope, return
;
;	insert new buffer into DCB
;
	LD	(IX+08),L	;buffer start
	LD	(IX+09),H
	LD	(IX+10),E	;buffer size
	LD	(IX+11),D
	CALL	NILBUFF 	;clear it out
;
$RETURN	XOR	A		;set Z for OK
	RET			;parameters OK
;
;	parameter error
;
RSCERR	LD	A,_ERR91 	;illegal data range
	OR	A		;set NZ
	RET			;back to caller
;
	PAGE
;
;	init data for PIO ports
;
PIO	DEFB	2		;2 tables
;
	DEFB	5		;5 entries
	DEFB	0E2H		;port
	DEFB	0		;int vector
	DEFB	0CFH		;bit mode
	DEFB	0F7H		;I/O mask
	DEFB	37H		;int off
	DEFB	0FEH		;int mask
;
	DEFB	3		;data #
	DEFB	0E3H		;port
	DEFB	0		;int vector
	DEFB	0FH		;output mode
	DEFB	7		;no int
;
	PAGE
;
;	$PRINIT - SVC 17 - initialize printer
;
;	ENTRY	B = page length (66 standard)
;		C = printed lines/page (60 standard)
;			if C = 0, no automatic form
;			feed is done.
;		D = max chars/line (132 standard)
;
;	EXIT	Z = OK
;		NZ = A = error code
;
$PRINIT	LD	A,@SAVREG	;SVC #
	RST	$SVC		;save registers
;
;	locate the DCB
;
	PUSH	BC		;save params
	LD	C,@PR 		;DCB number for printer
	LD	A,@LOCDEV	;SVC #
	RST	$SVC		;locate PR DCB
	POP	BC		;restore params
;
	XOR	A		;test for 0 page length
	CP	B		;page length
	JR	Z,PRIN1 	;check both B&C = 0
	CP	C		;printed lines
	JR	NZ,PRIN1	;OK, go
;
	LD	A,B		;length
	CP	C		;printed
	JR	C,PRERR 	;invalid
	LD	E,0		;mask
	JR	PRIN2		;go!
;
PRIN1	OR	B		;both must be 0
	OR	C
	JR	NZ,PRERR	;parameter error
	LD	E,4		;real FF
;
;	setup control byte
;
PRIN2	LD	A,(IX+05)	;get control byte
	AND	11110001B	;bits 1,2,3 off
	OR	E		;set form feed control
	INC	D		;see if 0 max chars
	DEC	D
	JR	NZ,PRIN3	;go if <> 0
	OR	@BIT1		;set real tabs
PRIN3	LD	(IX+05),A	;update control byte
	RES	3,(IX+00)	;turn off nil device
;
;	setup and nil printer buffer
;
	CALL	NILBUFF 	;setup and clear it
	LD	HL,PIO		;PIO data table
	CALL	SNDDAT		;send to the ports
;
;	load parameters into DCB
;
	XOR	A		;set Z flag for OK
	LD	(IX+17),C	;printed lines/page
	LD	(IX+16),B	;page length
	LD	(IX+18),A	;line counter
	LD	(IX+19),D	;max chars/line
	LD	(IX+20),A	;char counter
	RET			;done
;
;	parameter error
;
PRERR	LD	A,_ERR03	;set parameter error
	OR	A		;set NZ
	RET
;
	PAGE
;
;	init data for keyboard CTC ports
;
KBIO	DEFB	2		;2 tables
;
	DEFB	1		;data #
	DEFB	0F0H		;port
INTV3	DEFB	0D8H		;vector
;
	DEFB	2		;data #
	DEFB	0F3H		;port
	DEFB	0C7H		;reset, TC follows
	DEFB	1		;time constant
;
	PAGE
;
;	$KBINIT - SVC 1 - initialize keyboard
;
;	ENTRY	NONE
;
;	EXIT	Z = OK
;		NZ = A = error code
;
$KBINIT	LD	A,@SAVREG	;SVC #
	RST	$SVC		;save registers
	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch data pointer
	LD	A,(IX+32)	;get LSB int table
	ADD	A,15		;offset to CTC table
	LD	(INTV3),A	;pass interrupt vector
;
	LD	C,@KI 		;DCB # for keyboard
	LD	A,@LOCDEV	;SVC #
	RST	$SVC		;fetch DCB
;
;	setup and nill keyboard buffer
;
	LD	HL,KBIO 	;I/O table
	CALL	SNDDAT		;send to ports
	CALL	NILBUFF		;setup and clear
;
;	make sure keyboard hardware is clear
;
	IN	A,(0FCH)	;clear keyboard port
	LD	BC,80H		;make sure its not hard
	LD	A,@DELAY 	;SVC #
	RST	$SVC		;call delay
	IN	A,(0FCH)	;make sure it's clear
;
;	reset flags
;
	LD	A,(IX+05)	;get flags
	AND	@BIT0		;save XLATE only
	LD	(IX+05),A	;put control byte back
	XOR	A		;set Z flag
	RET
;
	PAGE
;
;	$NILBUFF - clear 'spooler' buffer
;
;	ENTRY	IX => DCB
;
;	EXIT	buffer set and cleared to nil
;		A = 0
;
NILBUFF XOR	A		;load with 0
	DI
	LD	(IX+12),A	;clear adder offset
	LD	(IX+13),A
	LD	(IX+14),A	;clear taker offset
	LD	(IX+15),A
	EI
	RET			;done
;
	PAGE
;
;	$VDINIT - SVC 7 - initialize video
;
;	ENTRY	 B =	chars/line switch
;		 C =	normal/reverse switch (=0=reverse
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$VDINIT	LD	A,@SAVREG	;SVC #
	RST	$SVC		;save registers
;
;	clear video for init
;
	PUSH	BC		;save commands
	LD	B,_ESCAPE	;clear screen code
	LD	A,@VDCHAR	;SVC #
	POP	BC		;restore commands
	RET	NZ		;go if error
;
;	set character mode (reverse/normal)
;
VINIT0	PUSH	BC		;save command
	INC	C		;zero?
	DEC	C		;normal mode?
	LD	B,_EM		;set normal mode
	JR	NZ,$+3		;go if normal
	INC	B		;set reverse mode
	LD	A,@VDCHAR	;SVC #
	RST	$SVC		;set normal/reverse
	POP	BC		;restore stack
	RET	NZ		;go if error
;
;	set line mode (single/double wide mode)
;
VINIT1	INC	B		;mode select
	DEC	B		;double wide mode?
	LD	B,_RS		;80 char mode
	JR	NZ,$+3		;go if 80
	INC	B		;40 char mode
	LD	A,@VDCHAR	;SVC #
	RST	$SVC		;init video data tables
	RET			;return with status
;
	PAGE
;
;	$PRCTL	- SVC 95 - setup printer data
;
;	ENTRY	B  = command # 0-10
;
;	EXIT	Z = OK
;		NZ = A = error code
;
;	commands:
;	0	- get status
;	1	- select serial
;	2	- select parallel
;	3	- reset line counter to C
;	4	- reset char counter to C
;	5	- begin transparent
;	6	- end transparent
;	7	- begin dummy
;	8	- end dummy
;	9	- begin auto LF
;	10	- end auto LF
;
$PRCTL	PUSH	IX		;save it
	PUSH	BC		;save command/C
	LD	C,@PR		;printer DCB #
	LD	A,@LOCDEV	;SVC #
	RST	$SVC		;fetch DCB #
	POP	BC		;restore BC
;
;	setup for return from command
;
	PUSH	HL		;save HL
	LD	HL,PRCRET	;return address
	EX	(SP),HL		;get HL, leave vector
;
;	check for valid command
;
	PUSH	HL		;save
	LD	HL,PRCTBL	;command table
	LD	A,@LOOKUP	;SVC #
	RST	$SVC		;see if here
	EX	(SP),HL		;get HL, leave vector
	RET	Z		;go if command!
	LD	A,_ERR01	;else set NOT found!
	RET			;return in error
;
PRCRET	JR	NZ,PRCBAK	;go if error!
	LD	B,(IX+16)	;page length
	LD	C,(IX+17)	;lines/page
	LD	D,(IX+19)	;max chars
	LD	H,(IX+20)	;char count
	LD	L,(IX+18)	;line count
	LD	E,'P'           ;parallel?
	BIT	7,(IX+05)	;yes?
	LD	A,0		;return with a 0
	JR	Z,$+4		;go if yes
	LD	E,'S'           ;serial
;
PRCBAK	POP	IX		;restore stack
	OR	A		;set Z
	RET			;done, return
;
;	command vectors
;
PRC1	SET	7,(IX+05)	;set serial
PRC0	RET
PRC2	RES	7,(IX+05)	;set parallel
	RET
;
PRC3	LD	(IX+18),C	;reset line counter
	RET
PRC4	LD	(IX+20),C	;reset char counter
	RET
;
PRC5	SET	3,(IX+05)	;begin transparent
	RET
PRC6	RES	3,(IX+05)	;end transparent
	RET
;
PRC7	SET	3,(IX+00)	;begin dummy
	RET
PRC8	RES	3,(IX+00)	;end dummy
	RET
;
PRC9	SET	6,(IX+05)	;set LF
	RET
PRC10	RES	6,(IX+05)	;end LF
	RET
;
;	lookup table for printer commands
;
PRCTBL	DEFB	0		;get status
	DEFW	PRC0
	DEFB	1		;select serial
	DEFW	PRC1
	DEFB	2		;select parallel
	DEFW	PRC2
	DEFB	3		;reset line counter to C
	DEFW	PRC3
	DEFB	4		;reset char counter to C
	DEFW	PRC4
	DEFB	5		;begin transparent
	DEFW	PRC5
	DEFB	6		;end transparent
	DEFW	PRC6
	DEFB	7		;begin dummy
	DEFW	PRC7
	DEFB	8		;end dummy
	DEFW	PRC8
	DEFB	9		;begin auto LF
	DEFW	PRC9
	DEFB	10		;end auto LF
	DEFW	PRC10
	DEFB	_ETBL		;terminator
;
;	table of starting days for years 1980-1987
;
STDAY	DEFB	0
	DEFB	2
	DEFB	3
	DEFB	4
	DEFB	5
	DEFB	0
	DEFB	1
	DEFB	2
;
	PAGE
;
;	$DATE - SVC 45 - fetch/load time/date
;
;	ENTRY	B  = 0 = fetch time/date
;		HL => 26 byte buffer to be loaded:
;	+0-+2	- name of day
;	+3-+5	- month
;	+6,+7	- day of month
;	+8-+11	- year
;	+12-+14 - day of year
;	+15-+22 - time (HH:MM:SS)
;	+23,+24 - month number
;	+25	- day of week (monday = day 0)
;
;	ENTRY	B  = 1 = set date
;		HL => 10 byte buffer (MM/DD/YYYY)
;
;	ENTRY	B  = 2 = set time
;		HL => 8 byte buffer (HH:MM:SS)
;
;	EXIT	Z = OK, A=0
;		NZ = A = error code
;
$DATE	LD	A,@SAVREG	;SVC #
	RST	$SVC		;save registers
;
;	fetch TIME$/DATE$ pointer
;
	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch data block
	LD	E,(IX+10)	;get time$
	LD	D,(IX+11)	;DE => ticks
	INC	DE		;DE => time$ seconds
;
	LD	A,B		;get function code
	OR	A		;B = 0?
	JR	Z,GETTD 	;get time/date
	DEC	A		;B = 1?
	JR	Z,SETDATE	;set date
	DEC	A		;B = 2?
	JR	Z,SETTIME	;set time
;
;	parameter error exit
;
DATERR	LD	A,_ERR01 	;bad function call
	JR	DATERET 	;unstack and return
;
;	invalid data provided
;
DATEBAD LD	A,_ERR09	;'bad data provided'
;
;	restore stack, set flags, and return
;
DATERET OR	A		;set flags
	RET			;done
;
;	load DATE$
;
SETDATE	INC	DE		;bump to DATE$
	INC	DE
	INC	DE		;DE => DATE$
	INC	DE		;DE => month
;
;	fetch month
;
	CALL	VALUE		;fetch input value
	JR	C,DATEBAD	;go if no input!
;
	OR	A		;0?
	JR	Z,DATEBAD	;invalid!
	CP	13		;1-12?
	JR	NC,DATEBAD	;invalid!
	DEC	A		;adjust to 0-11
	LD	(DE),A		;set the month
	DEC	DE		;point to day of week
;
;	fetch day of month
;
	CALL	VALUE		;fetch value
	JR	C,DATEBAD	;go if invalid
	OR	A		;zero?
	JR	Z,DATEBAD	;invalid day!
	CP	@DAYS+2		;1-31?
	JR	NC,DATEBAD	;invalid
	DEC	A		;adjust to 0 relative
	LD	(DE),A		;set the day
	INC	DE		;point to year
	INC	DE
;
;	fetch year
;
	CALL	VALUE		;fetch value
	JR	C,DATEBAD	;invalid chars
	JR	Z,DATEZ 	;<256, go!
	LD	H,B		;get the year
	LD	L,C
	LD	C,(IX+53)	;get base year
	LD	B,0		;BC = base year
	SBC	HL,BC		;reduce it
	LD	A,L		;get LSB result
;
DATEZ	AND	7		;force to MOD year
;
DATEY	LD	(DE),A		;put in the year
	XOR	A		;Z = OK
	RET			;done, return
;
;	load TIME$
;
SETTIME INC	DE		;bump pointer
	INC	DE		;DE => hours
;
;	fetch hour
;
	CALL	VALUE		;get the value
	JR	C,DATEBAD	;invalid chars
;
;	check for 12/24 hour clock
;
	BIT	7,(IX+35)	;NZ = 24 hour clock
	JR	NZ,CK24		;go if 24
;
;	check for valid 12 hour clock
;
	OR	A		;0?
	JR	Z,DATEBAD	;yes, out of range
	CP	13		;1-12?
	JR	NC,DATEBAD	;go if too big
	CP	12		;12?
	JR	NZ,HOURSET	;go if not
	XOR	A		;else set 12:00
	JR	HOURSET		;continue
;
CK24	CP	24		;0-23?
	JR	NC,DATEBAD	;go if too big
;
HOURSET	LD	(DE),A		;save hour
	DEC	DE		;point to minutes
;
;	fetch minutes
;
	CALL	VALUE		;get the value
	JR	C,DATEBAD	;invalid chars
	CP	61		;0-60?
	JR	NC,DATEBAD	;invalid
	LD	(DE),A		;set the minute
	DEC	DE		;point to seconds
;
;	fetch seconds
;
	CALL	VALUE		;get the value
	JR	C,DATEBAD	;invalid chars
	CP	61		;0-60?
	JR	NC,DATEBAD	;invalid
	JR	DATEY		;insert, return with Z
;
;	load HL with time and date
;
GETTD	PUSH	DE		;pass TIME$ => IX
	POP	IX		;IX => TIME$+1
	EX	DE,HL		;DE => user string
	CALL	CMPDAYS		;day in year/week
;
;	insert name of day
;
	LD	A,0		;get day # of week
DOW	EQU	$-1		;day of week
	LD	HL,DAYTBL	;day of week table
	CALL	POSTBL		;position the table
	LDIR			;move into user buffer
;
;	insert name of month
;
	LD	A,(IX+04)	;get month #
	LD	HL,MONTBL	;table of months
	CALL	POSTBL		;position the table
	LDIR			;move into user string
;
;	insert day of month
;
	LD	A,(IX+03)	;get day of month
	INC	A		;adjust to 1-31
	CALL	ASCII		;convert to ascii
;
;	insert ascii year
;
	EX	DE,HL		;HL => string
	LD	(HL),'1'        ;insert year prefix
	INC	HL		;bump pointer
	LD	(HL),'9'        ;1900 base year
	INC	HL		;bump pointer
	LD	(HL),'8'        ;put base year
	INC	HL		;bump pointer
	LD	A,(IX+05)	;get the year -1900
	AND	7		;mod 8
	ADD	A,'0'           ;make it ascii
	LD	(HL),A		;put in buffer
	INC	HL		;bump pointer
	EX	DE,HL		;DE => string
;
;	insert day # of year
;
	LD	HL,0		;get day of year
DOY	EQU	$-2		;day of year
	LD	C,1		;precision
	LD	A,@EXPDEC	;SVC#
	RST	$SVC		;load day of year
	INC	DE		;bump 3 places
	INC	DE
	INC	DE
;
;	insert TIME$
;
	LD	A,3		;3 entries for time
	EX	AF,AF'          ;save counter here
	PUSH	IX		;save TIME$ pointer
;
TIMLP	LD	A,(IX+02)	;get data
	DEC	IX		;move pointer down
	CALL	ASCII		;make it ascii decimal
	EX	AF,AF'          ;get counter back
	DEC	A		;done?
	JR	Z,TIMDON	;go if yes
	EX	AF,AF'		;save count
	LD	A,':'		;separator
	LD	(DE),A		;to buffer
	INC	DE		;bump pointer
	JR	TIMLP		;go more!
;
;	insert month number
;
TIMDON	POP	IX		;restore TIME$
	LD	A,(IX+04)	;get month
	CALL	ASCII		;make it ascii
;
;	insert day of week number
;
	LD	A,(DOW) 	;get day of week
	ADD	A,'0'           ;adjust to real ascii
	LD	(DE),A		;put into string
	XOR	A		;set Z flag for OK
	RET			;done!
;
;	$VALUE - compute value from HL string
;
;	ENTRY	HL => string
;
;	EXIT	HL => terminating char
;		BC = value
;		Carry = invalid digits
;		No Carry = OK
;		Z = number <256
;		NZ = number >255
;
;	terminators are : / , . - <SP> <CR> <ETX>
;
VALUE	LD	BC,0		;starting number
;
VALLP	LD	A,(HL)		;fetch a char
;
;	check for terminator
;
	CALL	CKTERM		;terminator?
	JR	Z,VALDN 	;go if yes
	INC	HL		;else bump pointer
;
;	check for separator
;
	CALL	CKSEP		;separator?
	JR	Z,VALDN 	;go if yes
;
;	remove ascii, check for valid digit
;
	SUB	'0'		;remove the ascii
	RET	C		;invalid digit
	CP	10		;must be 0-9
	CCF			;reverse carry flag
	RET	C		;invalid digit
;
;	multiply subtotal times base (10)
;
	PUSH	HL		;save pointer
	LD	H,B		;get subtotal
	LD	L,C		;HL = subtotal
	ADD	HL,HL		;*2
	ADD	HL,HL		;*4
	ADD	HL,BC		;*5
	ADD	HL,HL		;*10
;
;	add new digit
;
	LD	C,A		;pass new digit
	LD	B,0		;BC = new digit
	ADD	HL,BC		;add new digit to subt.
;
;	restore subtotal to BC
;
VAL1	LD	B,H		;put back into BC
	LD	C,L
	POP	HL		;restore pointer
;
	JR	VALLP		;go next character
;
;	value finished, load registers/flags
;
VALDN	LD	A,B		;get MSB value
	OR	A		;set Z flag on this
	LD	A,C		;but return with LSB
	RET			;done
;
	PAGE
;
;	check for terminator
;
CKTERM	PUSH	HL		;save it
	LD	HL,TRMTBL	;terminator table
	JR	CKTBL		;check it out
;
;	check for separator
;
CKSEP	PUSH	HL		;save it
	LD	HL,SEPTBL	;separator table
;
;	check if char in table
;
CKTBL	PUSH	BC		;save subtotal
	LD	BC,6		;# entries per table
	CPIR			;see if in table
	POP	BC		;restore stack
	POP	HL
	RET			;done, Z = yes
;
;	terminator table
;
TRMTBL	DEFB	_CR		;C/R
	DEFB	_ECR             ;C/R
	DEFB	_ETX		;break
	DEFB	0		;dummy
	DEFB	0		;dummy
	DEFB	0		;dummy
;
;	separator table
;
SEPTBL	DEFB	'/'
	DEFB	':'
	DEFB	'.'
	DEFB	' '
	DEFB	','
	DEFB	'-'
;
	PAGE
;
;	ASCII	- convert A to ascii
;
;	ENTRY	A = binary digit to convert
;
;	EXIT	BA = 2 byte ascii representation
;
ASCII	LD	B,'0'           ;start digit
;
;	convert MSB
;
ASC1	SUB	10		;find 10's place
	JR	C,ASC2		;have it
	INC	B		;bump ascii
	JR	ASC1		;go more
;
;	10's and 1's place computed
;
ASC2	ADD	A,3AH		;add 10 + ascii
;
;	PUTASC - insert ascii into string
;
;	ENTRY	BC = ascii digits to insert
;		DE => string to load
;
;	EXIT	DE => next area (start DE+2)
;		BC unchanged
;
PUTASC	EX	DE,HL		;HL => user string
	LD	(HL),B		;put NSB
	INC	HL		;bump pointer
	LD	(HL),A		;put LSB
	INC	HL		;bump pointer
	EX	DE,HL		;DE => new loc
	RET			;done, HL => new loc.
;
;	$POSTBL - position table at HL
;
;	ENTRY	HL => table of 3 byte entries
;		A = entry number to fetch
;
;	EXIT	HL => 3 byte entry specified
;		BC = 3 (for LDIR)
;
POSTBL	LD	B,A		;save entry #
	ADD	A,A		;*2
	ADD	A,B		;*3 (3 byte entries)
	LD	BC,3		;setup for LDIR
	ADD	A,L		;add displace to LSB
	LD	L,A		;update it
	RET	NC		;did not cross page
	INC	H		;bump page
	RET			;done
;
;	table of days of week (3 bytes each)
;
DAYTBL	DEFM	'MonTueWedThuFriSatSun'
;
;	table of months (3 bytes each)
;
MONTBL	DEFM	'JanFebMarAprMayJunJulAugSepOctNovDec'
;
	PAGE
;
;	$COMPDAYS - compute day of year and day of week
;
;	ENTRY	DATE$ contains valid data
;
;	EXIT	(DOW) = day # of the week (byte)
;		(DOY) = day # of the year (word)
;
CMPDAYS	LD	A,@SAVREG	;SVC #
	RST	$SVC		;save registers
	LD	A,(IX+05)	;get year
	PUSH	AF		;save it
	AND	3		;check for leap year
	LD	HL,MONTHS+1	;point to feb
	LD	A,@DAYS-2	;28 days non-leap
	JR	NZ,CMPD1	;go if not
	INC	A		;else feb = 29
CMPD1	LD	(HL),A		;put in table
	DEC	HL		;HL => max days/month
;
	POP	AF		;get year back
	AND	7		;make sure in range
	PUSH	HL		;save table
	LD	HL,STDAY	;start day table
	ADD	A,L		;add current year
	LD	L,A		;update
	JR	NC,CMPD2	;did not cross page
	INC	H		;else bump it
CMPD2	LD	A,(HL)		;get start day this yr
	POP	HL		;get table back
	EX	AF,AF'          ;save it here
	LD	D,(IX+04)	;get month
	LD	BC,0		;start DOY
	LD	E,B		;start relative month
;
CMPLP	LD	A,E		;see if rel mon = curr
	CP	D		;yes?
	JR	Z,CMPLP1	;go if at month
	LD	A,(HL)		;get max this month
	CALL	ADDMTH		;add A # of days
	INC	E		;bump rel month
	INC	HL		;bump table
	JR	CMPLP		;check next month
;
CMPLP1	LD	A,(IX+03)	;get current day
	INC	A		;correct it
	CALL	ADDMTH		;add # days
	LD	(DOY),BC	;save day in year
	EX	AF,AF'          ;get day in week
	LD	(DOW),A 	;save it
	RET			;done, return
;
;	advance date pointers
;
ADDMTH	EX	AF,AF'          ;get relative DOW
	INC	A		;bump it
	CP	7		;end of week?
	JR	C,ADDMTH0	;go if not
	XOR	A		;else reset it
ADDMTH0 EX	AF,AF'          ;put it back
	INC	BC		;bump DOY
	DEC	A		;less # days to count
	JR	NZ,ADDMTH	;go more if any
	RET			;else done
;
	PAGE
;
;	$ACTL	- SVC 100 - SIO A control
;	$BCTL	- SVC 101 - SIO B control
;
;	ENTRY	B  = command
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
;	commands:
;	0	- get status
;	1	- get buff char count
;	2	- turn on request to send
;	3	- turn off request to send
;	4	- send break sequence
;	5	- turn off break sequence
;	6	- reset receive buffer nil
;	7	- reset SIO error condition
;
$ACTL	LD	A,@CA 		;CLA DCB #
	JR	ABCTL		;go common
;
$BCTL	LD	A,@CB	 	;CLB DCB #
;
ABCTL	PUSH	IX		;save registers
	PUSH	HL
	PUSH	BC
;
	LD	C,A		;pass device #
	LD	A,@LOCDEV	;SVC #
	RST	$SVC		;locate DCB
	LD	HL,SIOCTL	;lookup table
	LD	A,@LOOKUP	;SVC #
	RST	$SVC		;find the command
;
	LD	A,_ERR01 	;bad function call
	JR	NZ,SIOCRET	;go if error
;
	LD	A,(IX+21)	;get CTC R5 control
	LD	C,(IX+16)	;get SIO base port
	JP	(HL)		;go vector!
;
SIOC0	CALL	RSTATUS 	;get status
SIOCBAK POP	BC		;get B
	LD	B,A		;put result here
	PUSH	BC		;put it back
	XOR	A		;set Z
;
SIOCRET POP	BC		;unstack
	POP	HL
	POP	IX
	RET			;done
;
SIOC1	LD	A,0		;LSB counter
	JR	SIOCBAK 	;return
;
SIOC2	SET	1,A		;request to send
;
SIOOK	EX	AF,AF'          ;save command
	LD	A,5		;select R5
	OUT	(C),A
	EX	AF,AF'          ;get command
	OUT	(C),A		;send it
	XOR	A		;set Z
	JR	SIOCRET 	;done
;
SIOC3	RES	1,A		;turn off request to send
	JR	SIOOK
;
SIOC4	SET	4,A		;set BREAK
	JR	SIOOK
;
SIOC5	RES	4,A		;reset BREAK
	JR	SIOOK
;
SIOC6	DI			;disable for reset
	CALL	NILBUFF 	;clear out buffer
	EI			;done
	JR	SIOCRET 	;back
;
SIOC7	DI			;disable
	LD	A,30H		;reset, enable char int
	OUT	(C),A
	LD	A,10H		;reset ext/status int
	OUT	(C),A
	LD	A,28H		;reset tx int pend.
	OUT	(C),A
	LD	A,0C0H		;reset tx underrun
	OUT	(C),A
	EI			;done
	XOR	A		;set Z
	JR	SIOCRET 	;back
;
;	lookup table
;
SIOCTL	DEFB	0		;get status
	DEFW	SIOC0
	DEFB	1		;get char counter
	DEFW	SIOC1
	DEFB	2		;request to send ON
	DEFW	SIOC2
	DEFB	3		;request to send OFF
	DEFW	SIOC3
	DEFB	4		;send BREAK
	DEFW	SIOC4
	DEFB	5		;reset BREAK
	DEFW	SIOC5
	DEFB	6		;reset buffer nil
	DEFW	SIOC6
	DEFB	7		;reset SIO error
	DEFW	SIOC7
	DEFB	_ETBL		;terminator
;
;	fetch status of SIO port
;
RSTATUS LD	C,(IX+17)	;get SIO port
	LD	A,10H		;clear latch
	OUT	(C),A
	IN	A,(C)		;read R0
	AND	0ADH		;brk,cts,dcd,tx,rx
	XOR	28H		;reverse cts,dcd
	LD	B,A		;save it
	LD	A,1		;select R1
	OUT	(C),A
	IN	A,(C)		;read R1
	AND	50H		;framing,parity
	OR	B		;mask with last
	LD	B,A		;pass here
	RET
;
	PAGE
;
;	$INITIO - SVC 0 - initialize I/O
;
;	ENTRY	none
;
;	EXIT	Z = OK
;		NZ = A = error code
;
$INITIO	LD	A,@SAVREG	;SVC #
	RST	$SVC		;save registers
	DI			;kill int
;
;	initialize video
;
	LD	BC,-1		;80 column, normal
	CALL	$VDINIT		;initialize video
	RET	NZ		;if error
;
;	initialize keyboard
;
	CALL	$KBINIT		;do it
	RET	NZ		;if error
;
;	initialize printer
;
	LD	BC,423CH	;B=page len, C=ptrd lns
	LD	D,84H		;D=chars/line
	CALL	$PRINIT		;init it
;
	XOR	A		;int vector MSB
	LD	I,A		;set vector
	EI			;int ok
	IN	A,(0FEH)	;clear latch
	RET
;
$JPINIT	CALL	$INITIO		;init all I/O
	LD	A,@ABORT	;SVC #
	RST	$SVC		;abort to dos
;
;	convert character to upper case
;
UCASE	CP	'a'		;in range?
	RET	C		;already upper
	CP	'z'+1		;in range?
	RET	NC		;not lower range
	AND	5FH		;make upper case
	RET			;done!
;
;	table of maximum months
;
MONTHS	DEFB	@DAYS+1		;jan
	DEFB	@DAYS-2		;feb
	DEFB	@DAYS+1		;mar
	DEFB	@DAYS		;april
	DEFB	@DAYS+1		;may
	DEFB	@DAYS		;june
	DEFB	@DAYS+1		;july
	DEFB	@DAYS+1		;aug
	DEFB	@DAYS		;sept
	DEFB	@DAYS+1		;oct
	DEFB	@DAYS		;nov
	DEFB	@DAYS+1		;dec
;
_______	EQU	$
;
	END	VECTORS
