; sys4/asm - kjw/bqsd - 06/02/83
;
;	created 06/02/83	- kjw/bqsd
;	revised 06/02/83	- kjw
;
*GET	DOSEQU			;external equivalences
;
	TITLE	'<PowerDOS - SYS04/SYS>'
;
	SUBTTL	'<Copyright (C) 1983 - Breeze/QSD, Inc. - Dallas, Texas>'
;
;	$DISKID	- SVC 15	- fetch disk name
;	$RAMDIR	- SVC 53	- ram directory
;	$RDDIR	- SVC 32	- read disk record
;	$DIRSET	- SVC 59	- setup for $RDDIR
;	$WILD	- SVC 51	- wild card parser
;
	PAGE
;
	ORG	$LOSYS		;low overlay
;
VECTORS	DEFW	$RETURN		;1 - load and return
	DEFW	$DISKID		;2 - fetch disk names
	DEFW	$RAMDIR		;3 - ram directory
	DEFW	$RDDIR		;4 - directory read
	DEFW	$DIRSET		;5 - setup for rddir
	DEFW	$WILD		;6 - wild card parser
	DEFW	$UNDEF		;7 - undefined
	DEFW	$UNDEF		;8 - undefined
	DEFW	$UNDEF		;9 - undefined
	DEFW	$UNDEF		;10 - undefined
	DEFW	$UNDEF		;11 - undefined
	DEFW	$UNDEF		;12 - undefined
	DEFW	$UNDEF		;13 - undefined
	DEFW	$UNDEF		;14 - undefined
	DEFW	$UNDEF		;15 - undefined
	DEFW	$UNDEF		;16 - undefined
;
	PAGE
;
;	undefined system call
;
$UNDEF	LD	A,_ERR01	;'bad function call'
	OR	A		;set NZ
	RET			;back to caller in error
;
	PAGE
;
;	$DISKID - SVC 15 - read diskette name
;
;	ENTRY	B  =	drive # (=FF = all drives)
;		HL =>	I/O buffer
;
$DISKID	LD	A,@SAVREG	;SVC #
	RST	$SVC		;save registers
;
	EX	DE,HL		;DE => user buffer
	LD	C,B		;C = drive #
	INC	B		;global?
	JR	NZ,DSKID2	;go if single drive
	LD	C,B		;init drive 0
;
;	loop to read ID's from 8 drives
;
DSKID1	CALL	DSKID2		;read ID this drive
	RET	NZ		;go if error!
	INC	C		;bump drive #
	LD	A,@DRVS		;get # drives
	SUB	C		;less current #
	JR	NZ,DSKID1	;go for count
	RET			;else return Z
;
;	fetch disk name on drive C
;
DSKID2	LD	A,@DCHECK	;check drive ready
	RST	$DIO		;ready?
	JR	NZ,DSKID3	;not ready, pad blanks
;
	LD	B,0		;LFN for disk name
	LD	A,@RDLFN	;SVC #
	RST	$SVC		;read LFN
	RET	NZ		;go if disk error
;
;	move disk name into user buffer
;
	PUSH	BC		;save BC
	LD	BC,5		;offset to disk name
	ADD	HL,BC		;HL => disk name
	LD	C,8		;name length
	LDIR			;move to user buffer
	POP	BC		;restore
	RET
;
;	drive does not exist, load blanks
;
DSKID3	LD	B,8		;init count
	LD	A,' '           ;load blank
DSKID4	LD	(DE),A		;to buffer
	INC	DE		;bump user buffer
	DJNZ	DSKID4		;go till done
	XOR	A		;set NO error
	RET			;done
;
	PAGE
;
;	$RAMDIR - SVC 53 - directory record to RAM
;
;	ENTRY	B  =	drive number (0-7)
;		C  =	function switch
;			= 0 = read entire directory
;			= 255 = get free space info
;			= 1-254 = read specific record
;		HL =>	user buffer area
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
;	RAMDIR format (34 bytes)
;
;	+0	':'	mark beginning of each record
;	+1-15	FILENAME/EXT:d<CR>
;	+16	'F' or 'V'	fixed/variable file
;	+17	LRL	(0=LRL 256 or VLR file)
;	+18	# extents (0=NIL file)
;	+19-20	# sectors allocated (0-65535)
;	+21-22	# sectors used by file (0-65535)
;	+23	EOF byte (0-255)
;	+24-25	# records used by file (0-65535)
;	+26	user attribute byte (00)
;	+27	protection level (0-7)
;	+28-30	date created (00/00/00)
;	+31-33	date update (last close date)
;
;	if C=0 on entry, '#' at +0 indicates end
;
;	FREESPACE format
;
;	+0-1	# free granules (lsb,msb)
;	+2-3	# free extents (lsb,msb)
;
$RAMDIR	LD	A,@SAVREG	;SVC #
	RST	$SVC		;save registers
	PUSH	HL		;pass buffer to IX
	POP	IX		;IX => user buffer
	LD	A,C		;get command
	LD	C,B		;pass drive #
	LD	B,A		;B = LFN
;
	LD	A,@LOCDRV	;SVC #
	RST	$SVC		;IY => DCT
	INC	B		;FF = get free space?
	JP	Z,RAMFRE	;yes, go!
	DEC	B		;00 = get whole dir?
	JR	NZ,RAMDR3	;nope, read single record
;
	LD	HL,BUFFER	;I/O buffer
	LD	E,2		;init directory start
;
;	setup loop to read entire directory
;
RAMDR1	LD	B,0		;MSB sector #
	LD	A,@SREAD	;I/O command
	RST	$DIO		;read sector
	RET	NZ		;go if I/O error!
;
RAMDR2	PUSH	DE		;save dir sector
	PUSH	HL		;save buff pointer
	CALL	RAMDR4		;convert record
	POP	HL		;restore
	POP	DE		;restore
	JR	Z,RAMDR2A	;go if no error
	CP	_ERR24		;'file not found'?
	RET	NZ		;nope, real error!
;
RAMDR2A	LD	A,L		;get LSB buffer
	ADD	A,20H		;offset to next
	LD	L,A		;HL => next entry
	JR	NZ,RAMDR2	;go if not sector end
;
	INC	E		;bump sector #
	LD	A,(IY+23)	;get directory length
	SUB	E		;less current sector
	JR	NZ,RAMDR1	;go if not at end
;
	LD	(IX+0),'#'	;to user buffer
	RET			;buffer loaded!
;
;	read directory record for file
;
RAMDR3	LD	A,@RDLFN	;SVC #
	RST	$SVC		;read directory
	RET	NZ		;go if error!
;
;	load file information
;
;	ENTRY	HL =>	directory record
;		IX =>	user buffer
;
RAMDR4	LD	A,(HL)		;get flags
;
;	check for active file and not extension
;
	XOR	@BIT4		;reverse 'active' bit
	AND	@BIT7+@BIT4	;extension + active?
	LD	A,_ERR24	;'file not found'
	RET	NZ		;go if dead or extension
;
	LD	A,':'           ;START RECORD
	LD	(DE),A		;TO BUFF
	INC	DE		;NEXT
	LD	A,5		;offset to name
	ADD	A,L
	LD	L,A		;HL => CRACKED NAME
	LD	B,2		;MAKE NAME
	CALL	WILD		;DO IT!
	JP	NZ,RAMDR7	;IF ERROR
	LD	B,15		;COUNT
RAMDR5	LD	A,(DE)		;GET CHAR
	CP	03		;END NAME?
	JR	Z,RAMDR6	;put in blanks
	INC	DE		;bump pointer
	DJNZ	RAMDR5		;TIL END NAME
;
RAMDR6	LD	A,':'		;drive marker
	LD	(DE),A		;to the buffer
	INC	DE		;bump pointer
	LD	A,C		;get drive number
	ADD	A,'0'		;add ascii
	LD	(DE),A		;to the buffer
	INC	DE		;bump it
	LD	A,CR		;insert terminator
	LD	(DE),A		;to the buffer
	INC	DE		;bump pointer
	DEC	B		;less :
	DEC	B		;less drive #
	DEC	B		;less CR
	JR	Z,RAMDR6C	;nothing to pad!
	LD	A,' '		;pad with spaces
RAMDR6D	LD	(DE),A		;put in buffer
	INC	DE		;bump pointer
	DJNZ	RAMDR6D		;continue
;
;	insert FIXED
;
RAMDR6C	LD	A,'F'		;always fixed
	LD	(DE),A		;to the buffer
	INC	DE		;bump pointer
;
;	insert LRL
;
	LD	A,L		;get LSB pointer
	AND	0E0H		;start of name
	ADD	A,4		;LRL byte
	LD	L,A		;HL => it
	LD	A,(HL)		;get LRL
	LD	(DE),A		;to the buffer
	INC	DE		;bump pointer
;
;	dummy insert zeroes for +19-22
;
	EX	DE,HL		;HL => user buffer
	LD	(HL),0		;# extents
	INC	HL
	LD	(HL),0		;# sectors allocated
	INC	HL
	LD	(HL),0
	INC	HL
;
	INC	HL		;pass over sectors used
	INC	HL
;
;	insert EOF byte
;
	DEC	E		;+3
	LD	A,(DE)		;get it
	LD	(HL),A		;to user buffer
	INC	HL		;bump buffer
;
	LD	A,E		;get LSB pointer
	AND	0E0H		;reset to beginning
	ADD	A,20		;offset to EOF
	LD	E,A		;DE => EOF pair
	LD	A,(DE)		;get LSB
	LD	(IX+22),A	;to the buffer
	INC	HL
	INC	E
	LD	A,(DE)		;get MSB EOF
	LD	(IX+23),A
	INC	HL
;
	LD	(HL),0		;user attribute byte
	INC	HL
;
;	insert protection level
;
	LD	A,E		;get LSB file pointer
	AND	0E0H		;to beginning of entry
	LD	E,A		;DE => first byte
	LD	A,(DE)		;get prot level
	AND	7		;low 3 bits only
	LD	(HL),A		;to the buffer
	INC	HL		;bump pointer
;
;	insert DATE
;
	LD	B,2		;2 rounds of dates
	LD	A,E		;get LSB dir pointer
	AND	0E0H		;to beginning
	ADD	A,2		;offset to flags 3
	LD	E,A		;DE => flags 3
RMDATE	LD	A,(DE)		;get flag
	RLCA			;move year to low bits
	RLCA
	RLCA
	AND	7		;8 year range
	ADD	A,80		;offset to 1980
	LD	(HL),A		;put in buffer
	INC	HL		;bump pointer
	DEC	E		;point to flags 2
	LD	A,(DE)		;get month
	AND	0FH		;low 4 bits
	LD	(HL),A		;to the buffer
	INC	HL		;bump pointer
	INC	E		;point to flags 3
	LD	A,(DE)		;get day of month
	AND	1FH		;low 5 bits
	LD	(HL),A		;to the buffer
	INC	HL		;bump pointer
	DJNZ	RMDATE		;do second year
;
;	advance buffer pointer
;
	LD	DE,34		;length of each entry
	ADD	IX,DE		;IX => next entry
;
RAMDR7A	XOR	A		;return ZERO
RAMDR7	POP	HL		;RESTORE REG
	POP	DE		;restore sector
	POP	BC
	RET
;
;	GET FREE SPACE INFORMATION
;
RAMFRE	LD	HL,BUFFER	;I/O buffer
	LD	E,0		;GAT sector
	LD	B,E		;extended sector
	LD	A,SREAD		;system read
	RST	DISKIO		;read the disk
	RET	NZ		;error, return!
;
	CALL	LOCDCT		;load IY with DCT
	LD	B,(IY+15)	;get # cylinders
;
	LD	DE,0		;starting free grans
RAMGN1	LD	C,(IY+20)	;grans/cylinder
	LD	A,(HL)		;get a GAT byte
RAMGN2	RRA			;shift out a bit
	CALL	NC,INCDE	;count off bits
	DEC	C		;less this gran
	JR	NZ,RAMGN2	;finish this track
	DJNZ	RAMGN1		;finish all tracks
;
;	insert # free grans
;
	LD	(IX),E		;# grans LSB
	LD	(IX+1),D	;# grans MSB
;
;	ignore # extents
;
	LD	A,1		;load with one
	LD	(IX+2),A	;to buffer
	DEC	A		;for MSB
	LD	(IX+3),A	;MSB to buffer
	RET			;return ZERO
;
INCDE	INC	DE		;bump count
	RET
;
;	$WILD	- SVC 51 - setup/compare wildmask
;
;	B = function code
;
;	ENTRY	B  =	0 = set wild card mask
;		HL =>	wildmask
;	EXIT	Z  =	OK
;		NZ =	invalid mask spec
;
;	ENTRY	B  =	1 = compare filespec with mask
;		HL =>	filespec to compare
;	EXIT	Z  =	OK, match
;		NZ =	file does not match mask
;
;	ENTRY	B  =	2 = combine name/ext into fspec
;		HL =>	11 byte buffer (NAME EXT padded)
;		DE =>	13 byte buffer to hold filespec
;	EXIT	Z  =	OK
;		NZ =	invalid filespec chars
;
;	ENTRY	B  =	3 = compare cracked with mask
;		HL =>	cracked filespec to compare
;	EXIT	Z  =	match
;		NZ =	NO match
;
$WILD	LD	A,@SAVREG	;SVC #
	RST	$SVC		;save registers
	XOR	A		;check command
	CP	B		;B = 0?
	JR	Z,WILD0 	;set mask
;
	DEC	B		;B = 1?
	JP	Z,WILD1 	;compare file>mask
;
	DEC	B		;B = 2?
	JR	Z,WILD2 	;un-crack filespec
;
	DEC	B		;B = 3?
	LD	A,_ERR01	;bad function call
	RET	NZ		;error, return
	JP	WILD3		;compare
;
;	combine name and ext into filespec
;
WILD2	LD	B,8		;move 8 chars
	CALL	WILD2M		;move 'em
	RET	NZ		;invalid chars
;
;	check for extension
;
	LD	A,(HL)		;get next char
	CP	_SPACE		;separator?
	JR	Z,WILD2D	;done if yes
;
;	exists, insert an extension marker
;
	LD	A,'/'           ;extension mark
	LD	(DE),A		;put in buffer
	INC	DE		;bump pointer
;
	LD	B,3		;move 3 chars
	CALL	WILD2M		;move 'em
	RET	NZ		;invalid chars
;
;	completed, insert ETX
;
WILD2D	LD	A,_ETX		;insert a CR
	LD	(DE),A		;put it in
;
RETURN	XOR	A		;return Z
	RET			;done
;
;	move chars from HL => DE
;
WILD2M	LD	A,(HL)		;get a char
	CP	_SPACE		;space?
	JR	Z,WILD2N	;next char if yes
;
;	check for valid char
;
	CALL	VALCHR		;valid character?
	JR	NZ,WILD2B	;error, invalid char
	LD	(DE),A		;valid, put in buffer
;
	INC	DE		;bump dest
WILD2N	INC	HL		;bump source
	DJNZ	WILD2M		;check next one
;
	XOR	A		;set Z for OK
	RET			;done
;
;	invalid chars
;
WILD2B	LD	A,_ERR19	;'invalid filespec'
	OR	A		;set NZ
	RET			;done, go back
;
;	set wildmask
;
WILD0	PUSH	HL		;save string pointer
	CALL	WILDMSK		;get wildmask pointer
	PUSH	DE		;save
	LD	H,D		;pass to HL
	LD	L,E
	INC	DE		;DE = HL+1
	LD	BC,10		;11 byte field
	LD	(HL),'?'        ;set to nil
	LDIR			;nil the mask
;
	POP	DE		;DE => wildmask
	POP	HL		;HL => user mask
;
	LD	B,8		;8 chars in name
	CALL	WILD0M		;move it in
	JR	Z,WILD0E	;OK, continue
	CP	'/'             ;this the bad char?
	JR	NZ,WILD2B	;nope, go error
;
WILD0E	LD	B,3		;3 char extension
	CALL	WILD0M		;move it in
	JR	NZ,WILD2B	;nope, error
;
	XOR	A		;else for zero
	RET			;done
;
;	move chars into wildmask field
;
WILD0M	LD	A,(HL)		;fetch a char
	CALL	CKTERM		;terminator?
	JR	Z,WILD0T	;terminator, continue
;
	CALL	VALCHR		;valid character?
	JR	NZ,WILD0B	;nope, check for error
;
	CP	'*'             ;wild card filler?
	JR	Z,WILD0F	;fill it up if yes
	CP	'!'		;wild card filler?
	JR	Z,WILD0F	;yes, fill it up
;
	LD	(DE),A		;else put in wildmask
	INC	DE		;bump pointers
	INC	HL
	DJNZ	WILD0M		;go more
	LD	A,(HL)
	CP	'/'
	JR	NZ,WILD0R
	INC	HL
;
WILD0R	XOR	A		;set Z flag
	RET			;done
;
;	fill remainder of field with blanks
;
WILD0F	LD	A,'?'           ;use to fill
	CALL	WILD0FS 	;fill it up
	LD	A,(HL)		;fetch it back
	CP	'!'		;special filler?
	RET	Z		;yes, return
	INC	HL		;get next char
	LD	A,(HL)		;fetch it
	CALL	CKTERM		;terminator?
	RET	Z		;yes, return
	JR	WILD0B		;else generate error
;
WILD0FS INC	B		;done with field?
	DEC	B
;
WILD0FF JR	Z,WILD0R	;return if yes
	LD	(DE),A		;put in char
	INC	DE		;bump pointer
	DEC	B		;less counter
	JR	WILD0FF 	;fill more?
;
WILD0B	CP	'/'             ;offending char?
	INC	HL		;bump pointer
	RET	NZ		;nope, error
WILD0T	LD	A,' '		;use to fill
	JR	WILD0FS 	;fill rest of field
;
;	compare filespec to mask
;
WILD3	CALL	WILDMSK		;fetch wildmask
	LD	B,11		;11 chars to compare
;
WILD3L	LD	A,(DE)		;get a char
	CP	'?'             ;wild char?
	JR	Z,WILD3N	;force a match
	CP	(HL)		;same one?
	JR	NZ,WILD3R	;nope, return
;
WILD3N	INC	HL		;bump pointers
	INC	DE
	DJNZ	WILD3L		;check next one
;
	XOR	A		;done, return with Z
	JR	WILD3R+2	;continue
;
WILD3R	LD	A,_ERR02	;'not available'
	OR	A		;set flags
	RET			;done
;
WILD1	EX	DE,HL		;DE => filename
	LD	HL,NAME 	;buffer
	PUSH	HL		;save pointer
	CALL	CRACK		;open it up
	POP	HL		;get pointer
	JP	WILD3		;compare it now
;
;	crack open filespec
;
CRACK	LD	B,11		;11 chars to fill
	PUSH	HL		;save start
CRACK1	LD	(HL),' '	;set nil
	INC	HL
	DJNZ	CRACK1		;fill more
	POP	HL		;get pointer back
;
	EX	DE,HL		;HL => filespec
	LD	B,8		;8 chars in name
	CALL	GETFLD		;get the field
	LD	C,A		;save term char
	LD	A,B		;get length
	CP	8		;anything?
	JR	NZ,CRACK2	;go if not
CRACKN	LD	A,_ERR02	;char not available
	OR	A		;set NZ
	RET
;
CRACK2	LD	A,C		;get term
	CP	'/'             ;extension?
	JR	Z,CRACK3	;yes, go
	XOR	A		;else done
	RET
;
CRACK3	LD	B,3		;3 chars to move
	LD	DE,NAME+8	;extension field
	CALL	GETFLD		;get the field
	LD	A,B
	CP	3		;nil?
	JR	Z,CRACKN	;no good
	XOR	A		;else done
	RET
;
GETFLD	LD	A,(HL)		;get a character
	CALL	VALCHR		;valid?
	INC	HL		;bump pointer
	RET	NZ		;no, return
	LD	(DE),A		;put in buffer
	INC	DE		;bump pointer
	DJNZ	GETFLD		;go more
;
	LD	A,(HL)		;get term char
	INC	HL
	RET			;done
;
;	fetch SYS0 wildmask area
;
WILDMSK	PUSH	IX		;save
	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch pointer
	LD	E,(IX+63)	;get LSB
	LD	D,(IX+64)	;get MSB
	POP	IX		;restore
	RET			;done
;
	PAGE
;
;	$VALCHR - check for valid filespec char
;
;	EXIT	NZ =	invalid char
;		Z  =	OK, A = upper case char
;
VALCHR	PUSH	BC		;save BC
	LD	B,A		;pass char
	LD	A,@VALCHR	;SVC #
	RST	$SVC		;valid char?
	LD	A,B		;reset char
	POP	BC		;restore stack
	RET			;Z = OK, NZ=bad
;
;	$CKTERM - check for terminator
;
;	EXIT	Z  =	terminating char
;
CKTERM	CP	_CR		;carriage return?
	RET	Z		;yes, return
	CP	_ECR		;embedded CR?
	RET	Z		;yes, go!
	CP	_ETX		;end of text?
	RET			;Z=yes
;
NAME	DEFM	'           '	;work area for WILD
;
	PAGE
;
_______	EQU	$
;
	END	VECTORS
