; sys15/asm - 05/16/83 - kjw/bqsd
;
;	created 05/16/83	- kjw/bqsd
;	revised 05/27/83	- dwh
;
*GET	DOSEQU			;external equivalences
;
DELAY@	EQU	1000		;prompt flash delay
;
	TITLE	'<PowerDOS - SYS15/SYS>'
;
	SUBTTL	'<Copyright (C) 1983 - Breeze/QSD, Inc. - Dallas, Texas>'
;
;	$CLEAR	- clear file/memory
;	$CREATE	- create file
;	$DUMP	- dump ram to file
;	$BUILD	- create ascii file
;	$LOAD	- load file to ram
;	$RENAME	- rename file/device
;
	PAGE
;
	ORG	$HISYS		;high overlay
;
VECTORS DEFW	$RETURN		;1 - load & return
	DEFW	$CLEAR		;2 - clear file/memory
	DEFW	$CREATE		;3 - create file
	DEFW	$DUMP		;4 - dump ram file
	DEFW	$BUILD		;5 - build ascii file
	DEFW	$LOAD		;6 - load file
	DEFW	$RENAME		;7 - rename file/device
	DEFW	$UNDEF		;8 - undefined
	DEFW	$UNDEF		;9 - undefined
	DEFW	$UNDEF		;10 - undefined
	DEFW	$UNDEF		;11 - undefined
	DEFW	$UNDEF		;12 - undefined
	DEFW	$UNDEF		;13 - undefined
	DEFW	$UNDEF		;14 - undefined
	DEFW	$UNDEF		;15 - undefined
	DEFW	$UNDEF		;16 - undefined
;
	PAGE
;
;	undefined entry
;
$UNDEF	LD	A,_ERR01	;'bad function call'
	OR	A		;set NZ for error
	RET			;return error
;
;	error program exit
;
POSTE	AND	7FH		;assure a return
	LD	B,A		;pass error code
POSTEB	LD	A,@ERROR 	;SVC #
	RST	$SVC		;display error
$RETURN	XOR	A		;return ZERO
	RET			;back to caller
;
	PAGE
;
;	$CLEAR - clear file/memory
;
;	ENTRY	HL =>	command line
;
;	SYNTAX	CLEAR [filespec] [start=] [end=] [data=]
;
$CLEAR	LD	A,-1		;init params
	LD	(DATPAR),A	;data
	LD	(STPAR),A	;start
	LD	(ENDPAR),A	;end
;
	LD	BC,POSTE	;error exit
	PUSH	BC		;leave vector on stack
;
;	fetch CLEAR parameters
;
	LD	DE,PLIST1	;clear param block
	CALL	EVALIT		;evaluate input
	RET	NZ		;error!
;
;	check if file specified
;
	LD	A,(IX+0)	;get eval flags
	AND	6		;bits 2&1
	JR	Z,CLRMEM	;nope, must be memory
;
;	clear data file
;
	LD	DE,DCB@1+1	;DCB to use
;
;	locate the file
;
	LD	BC,3<8+0	;open code + LRL 256
	CALL	OPEN$		;locate file
	RET	NZ		;error
;
	CALL	FCLR		;fill file
	RET	NZ		;error
	POP	AF		;remove error exit
	XOR	A		;return ZERO
	RET
;
;	clear memory
;
CLRMEM	LD	HL,0		;init HL
	LD	D,H		;pass to DE
	LD	E,L		;HL & DE = 0000
	LD	BC,0<8+5	;B=bank, C=command
	LD	A,@MEMCTL	;SVC #
	RST	$SVC		;fetch high/low memory
;
;	check for user input
;
	LD	A,(ENDPAR)	;get end param
	INC	A		;nil input?
	JR	Z,CLRMEM1	;go if yes
	LD	HL,(ENDPAR+1)	;get user input
;
CLRMEM1	LD	A,(STPAR)	;get start param
	INC	A		;nil input?
	JR	Z,CLRMEM2	;go if yes
	LD	DE,(STPAR+1)	;get user input
;
CLRMEM2	OR	A		;clear carry
	PUSH	HL		;save end
	SBC	HL,DE		;check start < end
	POP	HL		;restore end
	LD	A,_ERR91 	;invalid data
	RET	C		;out of range
	EX	DE,HL		;DE=high, HL=low
;
;	fetch fill data
;
	POP	AF		;remove error exit
	LD	BC,0		;init data value
	LD	A,(DATPAR)	;get user input
	INC	A		;nil?
	JR	Z,CLRMEM3	;yes, go!
	LD	BC,(DATPAR+1)	;else get input
;
CLRMEM3	INC	B		;any MSB?
	DEC	B		;B=0?
	JR	NZ,MCLR 	;nope, two byte fill
	LD	B,C		;one byte fill
;
;	fill memory block
;
MCLR	LD	(HL),C		;LSB data
	CALL	CKPARM		;at end?
	RET	Z		;done, return ZERO
	INC	HL		;next address
	LD	(HL),B		;MSB data
	CALL	CKPARM		;at end?
	RET	Z		;done, return ZERO
	INC	HL		;next address
	JR	MCLR		;till end
;
;	check start & end params
;
CKPARM	PUSH	HL		;save current address
	XOR	A		;clear carry
	SBC	HL,DE		;at end?
	POP	HL		;restore current
	RET			;done, Z = at end
;
	PAGE
;
;	fill file
;
;	ENTRY	DE =>	open FCB
;
FCLR	LD	A,(DATPAR)	;get data param
	INC	A		;nil input?
	LD	BC,0		;default value
	JR	Z,FCLR1		;go if nil
	LD	BC,(DATPAR+1)	;get user input
FCLR1	INC	B
	DEC	B		;any MSB?
	JR	NZ,$+3		;go if yes
	LD	B,C		;1 char to fill
	LD	HL,$UBUFF	;HL => user buffer
;
FCLR2	LD	(HL),C		;char to buffer
	INC	L		;next
	LD	(HL),B		;char to buffer
	INC	L		;next
	JR	NZ,FCLR2	;till buffer full
;
;	write nill buffer to file
;
FCLR3	LD	A,@WRITNX	;SVC #
	RST	$SVC		;write a record
	JR	Z,FCLR3		;go till end
	SUB	_ERR28		;end of file?
	RET	Z		;yes, go!
	ADD	A,_ERR28	;restore error
	RET			;done, go!
;
	PAGE
;
;	eval block for $CLEAR
;
PBLOCK	DEFB	0		;FLAGS
	DEFW	DCB@1		;DCB
	DEFW	DCB@1		;DCB
	DEFW	DCB@1		;DCB
	DEFW	PLIST1		;PARAMETER LIST
	DEFB	_EBLOCK		;terminator
;
;	param list for $CLEAR
;
PLIST1	DEFB	_VALUE+3 	;(D)ATA
	DEFW	DATPAR
	DEFM	'DATA'
;
	DEFB	_VALUE+4 	;(S)TART
	DEFW	STPAR
	DEFM	'START'
;
	DEFB	_VALUE+2 	;(E)ND
	DEFW	ENDPAR
	DEFM	'END'
;
	DEFB	_EBLOCK		;END LIST
;
DATPAR	DEFB	0,0,0
STPAR	DEFB	0,0,0
ENDPAR	DEFB	0,0,0
;
	PAGE
;
;	$CREATE - CREATE DISK FILE
;
;	ENT	HL =>	COMMAND LINE
;
;	INITIALIZE PARAMETERS
;
CREATE	LD	BC,@FALSE	;DEFAULT
	LD	(VERPAR),BC	;INIT VERIFY SWITCH
	LD	(KEEPAR),BC	;INIT KEEP SWITCH
	LD	(SIZPAR),BC	;INIT SIZE IN RECDS
	LD	(LRLPAR),BC	;INIT LRL
	LD	(KILPAR),BC	;INIT SIZE IN K
	LD	(GRAPAR),BC	;INIT SIZE IN GRANS
	DEC	BC		;BC = FFFF
	LD	(DATPARN+1),BC	;save for data param
;
	LD	BC,POSTE	;error exit
	PUSH	BC		;leave on stack
;
;	FETCH OPTIONAL PARAMETERS
;
	LD	DE,PLIST2	;PARAMETER BLOCK
	CALL	EVALIT		;evaluate input
	RET	NZ		;error, go!
	LD	A,(IX+0)	;EVAL FLAGS
	AND	6		;ANY FIELD?
	LD	A,_ERR47	;missing filespec
	RET	Z		;go error!
;
;	OPEN/INIT TARGET FILE
;
LRLPAR	EQU	$+1
	LD	BC,0		;DE = LRL
	LD	B,1		;open code, C=LRL mod 256
	LD	DE,DCB@1+1	;DE => FILE DCB
	CALL	OPEN$		;OPEN FILE
	RET	NZ		;error
;
;	ALLOCATE FILE SPACE
;
	CALL	GTSIZE		;GET FILE SIZE
	JR	Z,POPPER	;no records!
	LD	A,@DEC24
	RST	$SVC
	LD	IX,REC		;IX => TEMP STORAGE
	LD	(IX+0),B
	LD	(IX+1),H
	LD	(IX+2),L
	LD	BC,REC		;BC => RECORD
	LD	A,@DIRWR 	;DIRECT WRITE
	RST	$SVC		;DO IT!
	RET	NZ		;i/o error
;
	LD	HL,DCB@1+1+1	;HL => DCB FLAGS
	RES	7,(HL)		;FORCE NOT BLK'D
	LD	A,@REWIND	;REWIND FILE
	RST	$SVC		;DO IT!
	RET	NZ		;if error
;
;	FILL SPACE OPTIONAL DATA
;
	LD	BC,(DATPARN+1)	;DE = DATA
	LD	A,B
	AND	C		;ANY DATA?
	INC	A		;BC = FFFF?
	CALL	NZ,FCLR 	;WRITE DATA!
	RET	NZ		;go error!
;
;	VERIFY ALLOCATED SPACE
;
VERPAR	EQU	$+1
	LD	BC,@FALSE	;VERIFY SWITCH
	INC	C
	DEC	C		;VERIFY?
	JR	Z,CREATE2	;IF NOT
;
;	rewind file to beginning
;
	LD	A,@REWIND	;SVC #
	RST	$SVC		;rewind the file
	RET	NZ		;error!
;
CREATE1 LD	A,@READNX	;READ NEXT RECORD
	RST	$SVC		;DO IT!
	JR	Z,CREATE1	;AGAIN
	CP	_ERR28		;EOF?
	JR	Z,CREATE2	;ALL OK
	CP	_ERR29		;PAST EOF?
	RET	NZ		;I/O error!
;
;	CLOSE TARGET FILE & EXIT
;
KEEPAR	EQU	$+1
CREATE2 LD	BC,@FALSE	;KEEP FLAG
	INC	C
	DEC	C		;KEEP?
	JR	Z,$+7		;IF NOT
	LD	HL,DCB@1+1+2	;HL => DCB FLAGS
	SET	6,(HL)		;KEEP!
	CALL	CLOSER		;close the file
	RET	NZ		;go error!
POPPER	POP	AF		;remove error vector
	XOR	A		;return zero
	RET			;on to the next
;
REC	DEFS	3		;RECORD STORAGE
;
	PAGE
;	GET FILE SIZE IN RECORDS
;
SIZPAR	EQU	$+1
GTSIZE	LD	HL,@ZERO	;SIZE PARAM
	LD	A,H
	OR	L		;ANY SIZE?
	JR	Z,GTSIZ1	;IF NOT
	LD	B,0		;BHL = RECS
	RET
;
;	GET FILE SIZE IN K
;
KILPAR	EQU	$+1
GTSIZ1	LD	HL,@ZERO	;KILO PARAM
	LD	A,H
	OR	L		;ANY KILO?
	JR	Z,GTSIZ2	;IF NOT
	LD	A,4		;SEC/K
	JR	GTSIZ3		;SKIP
;
;	GET FILE SIZE IN GRANS
;
GRAPAR	EQU	$+1
GTSIZ2	LD	HL,@ZERO	;GRANS PARAM
	LD	A,H
	OR	L		;ANY GRANS?
	RET	Z		;IF NOT
	LD	A,(DCB@1+1+16)	;GET DRIVE
	LD	C,A		;C = DRIVE
	LD	A,@LOCDRV
	RST	$SVC
	LD	A,(IY+19)	;SEC/GRAN
;
;	CALCULATE FILE SIZE
;
GTSIZ3	PUSH	DE		;SAVE
	CALL	@_DMULT		;GET SECTORS!
	POP	DE		;RESTORE
	LD	B,H
	LD	H,L
	LD	L,A		;BHL = RECS
	OR	-1		;NZ STATUS
;
;	set non-blocked records for correct allocation
;
	PUSH	HL		;save # recs
	LD	HL,DCB@1+1+1	;point to flag
	RES	7,(HL)		;blocked OFF
	POP	HL		;restore
	RET
;
	PAGE
;
;	$PARAM LIST FOR $CREATE
;
PLIST2	DEFB	_VALUE+3 	;(D)ATA
	DEFW	DATPARN
	DEFM	'DATA'
;
	DEFB	_SWITCH+5 	;(V)ERIFY
	DEFW	VERPAR
	DEFM	'VERIFY'
;
	DEFB	_SWITCH+3 	;(K)EEP
	DEFW	KEEPAR
	DEFM	'KEEP'
;
	DEFB	_VALUE+3 	;(S)IZE
	DEFW	SIZPAR
	DEFM	'SIZE'
;
	DEFB	_VALUE+2 	;(L)RL
	DEFW	LRLPAR
	DEFM	'LRL'
;
	DEFB	_VALUE+3 	;KILO
	DEFW	KILPAR
	DEFM	'KILO'
;
	DEFB	_VALUE+4 	(G)RANS
	DEFW	GRAPAR
	DEFM	'GRANS'
;
	DEFB	_EBLOCK		;END LIST
;
	PAGE
;	GENERAL PURPOSE OPEN ROUTINE
;
;	ENT	 A =	LRL (0-255)
;		 B =	OPEN CODE (0-3)
;		 C =	OPEN TYPE (F,V,E)
;
OPEN$	PUSH	HL		;SAVE
	LD	HL,OLIST+7	;open list
	LD	(HL),C		;set LRL
	INC	HL
	INC	HL
	LD	(HL),B		;open code
	LD	HL,OLIST	;BUFADR
	LD	A,@OPEN		;OPEN FILE
	RST	$SVC		;DO IT!
	POP	HL		;RESTORE
	RET
;
;	$OPEN PARAMETER LIST
;
OLIST	DEFW	$UBUFF		;BUFADR
	DEFW	$UBUFF		;RECADR
	DEFW	@ZERO		;EOFADR
	DEFM	'W'             ;READ/WRITE
	DEFB	0		;LRL = 256
	DEFM	'E'             ;FIXED FILES
	DEFB	0		;OPEN NEW LRL
	DEFB	_EBLOCK		;end of table
;
	PAGE
;
;	$BUILD - copy keyboard lines to file
;
BUILD	LD	BC,@FALSE	;default param
	LD	(APPPAR+1),BC	;append param
;
	LD	BC,POSTE	;error exit
	PUSH	BC		;to the stack
	LD	DE,PLIST3	;build params
	CALL	EVALIT		;evaluate input
	RET	NZ		;display error
;
	LD	A,(IX)		;get params
	AND	6		;any filespecs here?
	LD	A,_ERR47 	;required param
	RET	Z		;error, no channel
;
	LD	DE,DCB@1+1	;DCB area
	LD	HL,TXTEXT	;/TXT extension
	LD	A,@FEXT		;SVC #
	RST	$SVC		;add default extension
	LD	BC,(APPPAR+1)	;get append param
	INC	C		;yes?
	LD	B,0		;existing only if append
	LD	C,B		;set LRL = 0
	JR	Z,$+4		;go if append
	LD	B,2		;open/create
	CALL	OPEN$		;open the file
	RET	NZ		;error!
	LD	A,(APPPAR+1)	;get append param again
	INC	A		;yes?
	JR	NZ,BUILDST	;nope, go!
;
;	operation is APPEND, position file
;
	LD	A,@PEOF		;SVC #
	RST	$SVC		;position to end
	JR	Z,BUILDST	;no error, go!
	CP	_ERR28		;end of file?
	JR	Z,BUILDST	;no error, go!
	CP	_ERR29		;beyond?
	RET	NZ		;display error
;
;	file is set to go, display header message
;
BUILDST LD	HL,BLDMSG	;text
	CALL	LINE$		;display it
	RET	NZ		;display error
;
BUILDLP LD	HL,STRING	;alt input buffer
	LD	B,79		;max chars/line
	LD	A,@KBLINE	;fetch from keyboard
	RST	$SVC		;fetch it
	RET	NZ		;error, abort!
	PUSH	AF		;save flags
	POP	DE		;in DE
	JR	NC,BLDPUT	;not break, go!
	DEC	B		;less last C/R
	JR	Z,CLOSIT	;done, close it up!
	LD	C,-1		;no C/R to end!
;
;	write line to file
;
BLDPUT	LD	A,(HL)		;fetch a character
	CALL	PUTCHR		;write char to file
	INC	HL		;bump pointer
	DJNZ	BLDPUT		;finish off the line
;
;	check if terminator passed to input string
;
	INC	C		;C = 0 ?
	DEC	C
	JR	NZ,BLDFIN	;nope, go!
	LD	A,_CR		;send C/R to file
	CALL	PUTCHR		;write to file
;
BLDFIN	PUSH	DE		;get flags back
	POP	AF		;C = end of file
	JR	NC,BUILDLP	;fetch next line
;
;	completed, close the file
;
CLOSIT	CALL	CLOSER		;close the file
	RET	NZ		;error, display!
	POP	AF		;remove error vector
	XOR	A		;return ZERO
	RET
;
CLOSER	LD	DE,DCB@1+1	;DCB
	LD	A,@CLOSE 	;SVC #
	RST	$SVC		;close the file
	RET
;
PUTCHR	PUSH	BC		;save 'em
	PUSH	DE
	LD	DE,DCB@1+1	;channel DCB
	LD	B,A		;pass char to B
	LD	A,@PUT		;SVC #
	RST	$SVC		;write char to file
	POP	DE		;unstack
	POP	BC
	RET	Z		;return if OK
	EX	(SP),HL		;remove return vector
	POP	HL		;back to next level
	RET			;with error!
;
GETCHR	PUSH	DE
	LD	DE,DCB@1+1	;channel DCB
	LD	A,@GET		;SVC #
	RST	$SVC		;fetch byte
	JR	NZ,GETERR	;error, see why
	LD	A,(DE)		;see if file device
	CPL			;reverse bits
	OR	A		;clear carry
	BIT	7,A		;is it?
	LD	A,B		;get character
	POP	DE		;restore stack
	RET	Z		;file, return
	CP	_ETX		;ETX marker?
	SCF			;carry = end
	RET	Z		;yes, return
	CP	A		;Z, NC
	RET			;return it
;
GETERR	POP	DE		;restore stack
	CP	_ERR28		;end of file?
	SCF
	RET	Z
	CP	_ERR29
	SCF
	RET	Z
	OR	A		;return with error
	RET
;
;	$EVALIT - evaluate user input
;
EVALIT	LD	(PBLOCK+7),DE	;save param pointer
	LD	IX,PBLOCK	;evaluate block
	LD	A,@EVAL		;SVC #
	RST	$SVC		;eval user input
	RET			;return with status
;
;	param list for build
;
PLIST3	DEFB	_SWITCH+5	;switch + length-1
	DEFW	APPPAR		;param vector
	DEFM	'APPEND'        ;param word
;
	DEFB	_EBLOCK		;terminator
APPPAR	DEFB	@FALSE
	DEFW	@FALSE
;
TXTEXT	DEFM	'TXT'           ;build extension
;
BLDMSG	DEFM	'Enter text (79 chars/line)'
	DEFB	_CR
	DEFB	_CR
	DEFB	_ETX
;
	PAGE
;
;	$DUMP - dump memory to channel
;
DUMP	PUSH	HL		;save cmd line
	LD	HL,0
	LD	D,H
	LD	E,L
	LD	B,0<8+5		;bank,command
	LD	A,@MEMCTL
	RST	$SVC
	LD	(ENDPARM+1),HL	;save end param
	LD	(STPARM+1),DE	;save start param
	LD	HL,@ZERO
	LD	(TRAPAR+1),HL	;transfer address
	LD	(DATPARN+1),HL	;data param (core image)
	LD	(RELPAR+1),HL	;relocation address
;
	LD	HL,POSTE	;error exit
	EX	(SP),HL 	;to the stack
;
	LD	DE,PLIST4	;dump param list
	CALL	EVALIT		;evaluate input
	RET	NZ		;error, show why
;
;	check for destination path
;
	LD	A,(IX)		;get eval flags
	AND	6		;source/dest
	LD	A,_ERR47 	;required param
	RET	Z		;error, abort!
;
	LD	DE,DCB@1+1	;point to DCB
	LD	HL,CMDEXT	;/CMD extension
	LD	A,(DATPARN+1)	;get data param
	INC	A		;yes?
	JR	NZ,ADDEXT	;nope, use cmd
	LD	HL,CIMEXT	;/CIM extension
ADDEXT	LD	A,@FEXT		;SVC #
	RST	$SVC		;add extension
;
;	check for valid memory params
;
	LD	HL,(ENDPARM+1)	;get end of dump
	LD	BC,(STPARM+1)	;get start of dump
	OR	A		;clear carry
	SBC	HL,BC		;test start < end
	LD	A,_ERR91 	;illegal data range
	RET	C		;start < end!
;
	LD	BC,2<8+0	;open code + LRL
	CALL	OPEN$		;open the file
	RET	NZ		;abort error!
;
	CALL	WRDATA		;write data to file
	RET	NZ		;display error!
;
	JP	CLOSIT		;close the file!
;
WRDATA	LD	DE,(RELPAR+1)	;relocate param
	LD	A,D		;anything here?
	OR	E
	JR	NZ,WRDAT1	;yes, go!
	LD	DE,(STPARM+1)	;else use actual
WRDAT1	LD	BC,(STPARM+1)	;data start
	LD	HL,(ENDPARM+1)	;get end of data
	PUSH	BC		;save start
	SBC	HL,BC		;get data length
	INC	HL		;+ 1 for inclusive addr's
	LD	B,H		;pass to BC
	LD	C,L		;BC = length to write
	POP	HL		;HL = start of data
;
;	HL = start of data to write
;	DE = address where data is to load
;	BC = length of data
;
WRDAT2	INC	B		;any full pages?
	DEC	B		;B=0?
	JR	NZ,WRDAT3	;full block, do it
;
	INC	C		;any partial pages?
	DEC	C
	JR	Z,WRDAT4	;done!
	CALL	WRDAT5		;write partial block
	RET	NZ		;error!
;
;	all data saved to channel
;
WRDAT4	LD	A,(DATPARN+1)	;core image?
	INC	A		;FF = yes
	RET	Z		;yes, no transfer address
;
;	insert entry block
;
	LD	A,02H
	CALL	PUTCHR		;write to file
	LD	A,02H
	CALL	PUTCHR
	LD	DE,(TRAPAR+1)	;get transfer address
	LD	A,E		;get LSB
	CALL	PUTCHR		;to the file
	LD	A,D		;get MSB
	CALL	PUTCHR		;to the file
	RET			;return status
;
WRDAT3	PUSH	BC		;save counter
	LD	C,0		;one full block
	CALL	WRDAT5		;write it out
	POP	BC		;get counter
	RET	NZ		;error, return
	DEC	B		;less page just written
	JR	WRDAT2		;continue
;
WRDAT5	LD	A,(DATPARN+1)	;core image?
	INC	A		;FF = yes
	JR	Z,WRDAT6	;yes, no load marker
;
;	insert load marker in file
;
	LD	A,01H
	CALL	PUTCHR		;to the file
	LD	A,C		;get length
	ADD	A,02		;+ load address
	CALL	PUTCHR
;
	LD	A,E		;get load address
	CALL	PUTCHR
	LD	A,D		;MSB address
	CALL	PUTCHR
;
WRDAT6	LD	A,(HL)		;get data byte
	CALL	PUTCHR		;write to file
	INC	HL		;bump data pointer
	INC	DE		;bump relocate pointer
	DEC	C		;less counter
	JR	NZ,WRDAT6	;finish it off
	RET			;return zero
;
;	param block for $DUMP
;
PLIST4	DEFB	_VALUE+4	;value + length-1
	DEFW	STPARM		;data vector
	DEFM	'START'         ;param
;
	DEFB	_VALUE+2
	DEFW	ENDPARM
	DEFM	'END'
;
	DEFB	_VALUE+2
	DEFW	TRAPAR
	DEFM	'TRA'
;
	DEFB	_SWITCH+3
	DEFW	DATPARN
	DEFM	'DATA'
;
	DEFB	_VALUE+3
	DEFW	RELPAR
	DEFM	'RELO'
;
	DEFB	_EBLOCK
RELPAR	DEFB	@FALSE
	DEFW	@FALSE
TRAPAR	DEFB	@ZERO
	DEFW	@ZERO
;
CMDEXT	DEFM	'CMD'           ;for command files
CIMEXT	DEFM	'CIM'           ;for core image files
;
	PAGE
;
;	$LOAD - load data/file to memory
;
LOAD	LD	BC,@FALSE
	LD	(PROPAR+1),BC	;prompt
	LD	(RUNPAR+1),BC	;run
	LD	(STPARM+1),BC	;start
	LD	(TRAPAR+1),BC	;transfer
;
	LD	BC,POSTE	;error exit
	PUSH	BC		;save it
;
	LD	DE,PLIST5	;param block
	CALL	EVALIT		;evaluate user input
	RET	NZ		;display error
;
	LD	A,(IX)		;get filled fields
	AND	6		;source/dest
	LD	A,_ERR47 	;required not found
	RET	Z		;display error
	LD	(SAVEHL),HL	;save input pointer
;
;	load in SYS4 in case of single drive load
;
	CALL	FETCH4		;load in sys4
	RET	NZ		;error!
;
	CALL	TMOUNT		;mount target disk
;
	LD	DE,DCB@1+1	;DCB
	LD	HL,(STPARM+1)	;any start address
	LD	A,H		;any bits on?
	OR	L
	LD	HL,CMDEXT	;/CMD extension
	JR	Z,$+5		;no, load file
	LD	HL,CIMEXT	;/CIM extension
	LD	A,@FEXT		;SVC #
	RST	$SVC		;add default extension
;
;	check for core image type load
;
	LD	HL,(STPARM+1)	;get start param
	LD	A,H		;any bits on?
	OR	L
	JR	NZ,LOADCIM	;yes, load core image
;
	LD	A,@LOAD 	;SVC #
	RST	$SVC		;load the file
	RET	NZ		;display error
;
LOADIN	POP	AF		;remove error vector
	PUSH	HL		;save entry
	CALL	SMOUNT
;
	LD	DE,(RUNPAR+1)	;run the file?
	LD	A,E		;get LSB
	OR	A		;zero?
	POP	HL		;get vector
	RET	Z		;yes, return to caller
;
	LD	HL,0
	LD	D,H
	LD	E,L
	LD	B,0<8+5		;bank,command
	LD	A,@MEMCTL
	RST	$SVC
	LD	D,H
	LD	E,L
	PUSH	HL		;save program vector
	LD	HL,(TRAPAR+1)	;get transfer address
	LD	A,H		;anything?
	OR	L
	JR	Z,$+3		;nope, use real address
	EX	(SP),HL 	;put new address
	LD	HL,0		;get input pointer
SAVEHL	EQU	$-2
	RET			;execute program!
;
LOADCIM LD	BC,3<8+0	;open code + LRL
	CALL	OPEN$		;open the file
	RET	NZ		;display why error!
	LD	(SAVADR),HL	;save beginning load addr
;
LOADLP	CALL	GETCHR		;get a character
	RET	NZ		;error!
	JR	C,LOADFE	;done, see if run
	LD	(HL),A		;put into buffer
	CP	(HL)		;still there?
	LD	A,_ERR35 	;memory fault
	RET	NZ		;display error
	INC	HL		;bump pointer
	JR	LOADLP		;get more
LOADFE	LD	HL,@ZERO	;get start vector
SAVADR	EQU	$-2
	JR	LOADIN		;execute!
;
;	param block for $LOAD
;
PLIST5	DEFB	_SWITCH+5	;switch + length-1
	DEFW	PROPAR		;data vector
	DEFM	'PROMPT'
;
	DEFB	_SWITCH+2
	DEFW	RUNPAR
	DEFM	'RUN'
;
	DEFB	_VALUE+4
	DEFW	STPARM
	DEFM	'START'
;
	DEFB	_VALUE+2
	DEFW	TRAPAR
	DEFM	'TRA'
;
	DEFB	_EBLOCK		;end param table
PROPAR	DEFB	@FALSE
	DEFW	@FALSE
RUNPAR	DEFB	@FALSE
	DEFW	@FALSE
;
TMOUNT	LD	HL,TARGET	;target message
	JR	MOUNT		;go common
SMOUNT	LD	HL,SYSTEM	;system message
;
MOUNT	LD	BC,(PROPAR+1)	;get prompt param
	INC	C		;yes?
	RET	NZ		;nope, no need
;
MOUNTL	LD	BC,DELAY 	;delay
	LD	A,(BLINK)	;blink flag
	XOR	_ETB		;erase code
	LD	(BLINK),A	;put it back
	PUSH	AF		;save flag
	CALL	NZ,DSP$ 	;display it
	POP	AF		;restore flag
	PUSH	HL		;save prompt
	CALL	Z,LINE$ 	;display text
	POP	HL		;restore prompt
;
FLASH	LD	A,@KBCHAR	;SVC #
	RST	$SVC		;fetch a key
	LD	A,_ETB		;erase
	JR	Z,DSP$		;clear and return
	DEC	BC		;less counter
	LD	A,B		;any bits left?
	OR	C
	JR	NZ,FLASH	;yes, wait more
	JR	MOUNTL		;reverse message
;
DSP$	PUSH	BC		;save it
	LD	B,A		;pass char
	LD	A,@VDCHAR	;SVC #
	RST	$SVC		;display char
	POP	BC		;restore
	RET			;done
;
LINE$	LD	A,(HL)		;fetch a character
	CP	_ETX		;done?
	RET	Z		;yes, return
	CALL	DSP$		;display the char
	RET	NZ
	INC	HL		;bump pointer
	JR	LINE$		;continue
;
TARGET	DEFM	'Mount TARGET Disk'
	DEFB	_CR
	DEFB	_VT
	DEFB	_ETX
;
SYSTEM	DEFM	'Mount SYSTEM Disk'
	DEFB	_CR
	DEFB	_VT
	DEFB	_ETX
BLINK	DEFB	_ETB		;blink flag
;
;	RESERVED DATA AREAS
;
DCB@1	DEFS	50		;FILE DCB#1
STRING	DEFS	80		;for key input
;
	PAGE
;
;	$RENAME - rename file/device
;
RENAME	LD	A,@POSHL
	RST	$SVC
	LD	DE,DCB@1	;DCB area
	LD	A,@FSPEC 	;SVC #
	RST	$SVC		;fetch file/device
	JR	NZ,POSTEE	;invalid!
;
;	position HL to next field
;
	LD	A,@POSHL
	RST	$SVC
	LD	A,(DE)		;get type
	INC	DE		;point to specifier
	BIT	6,A		;filespec here?
	JR	NZ,RENFILE	;yes, rename the file
;
;	locate source device SLOT
;
	AND	0FH		;get device number
	ADD	A,A		;*2
	ADD	A,A		;*4
	LD	C,A		;pass to C
	LD	B,$DCBTBL<-8	;BC => device name
	PUSH	BC		;pass to IX
	POP	IX		;IX => old name
;
;	check for device/drive
;
	LD	A,(DE)		;get it
	CP	(HL)		;same?
	INC	HL		;bump pointer to name
	LD	A,_ERR48 	;invalid parameter
	JR	NZ,POSTEE	;go error if wrong type!
;
;	check if device exists now
;
	CALL	FINDEV		;find the device
	LD	A,_ERR83 	;device exists
	JP	Z,POSTE 	;go error!
	DEC	DE		;DE => DCB
	LD	A,@FSPEC 	;VALID?
	RST	$SVC
	JP	NZ,POSTE	;IF NOT
	LD	A,(DE)		;GET FLAGS
	INC	DE		;DE => NAME
	AND	11100000B	;fspec flags
	CP	01000000B	;filespec?
	LD	A,_ERR68 	;invalid devicespec
	JR	NZ,POSTEE	;go error if wrong type!
;
;	device is new, change the name
;
	LD	A,(DE)		;get new char
	CALL	UCASE		;make it upper
	LD	(IX+2),A	;put into table
	INC	DE		;bump pointer
	LD	A,(DE)		;get 2'nd char
	LD	(IX+3),' '      ;default to nil
	CP	_ETX		;terminator?
	JR	Z,RENRET	;yes, done!
	CALL	UCASE		;make it upper
	LD	(IX+3),A	;else save 2nd char
RENRET	XOR	A		;return zero
	RET
;
;	rename file routine
;
RENFILE EX	DE,HL		;HL=>old, DE=>new
	CALL	RNAME		;rename file
POSTEE	JP	NZ,POSTE	;error, go!
	JR	RENRET		;else ok, return
;
RNAME	LD	A,_SYS02+_CMD03	;sys 2, #3
	RST	$OVL		;do it!
;
;	check if device exists
;
FINDEV	LD	A,_SYS01+_CMD05	;sys 1, #5
	RST	$OVL		;search device table
;
;	load in SYS4
;
FETCH4	LD	A,_SYS04+_CMD01	;sys 4, #0
	RST	$OVL		;load it!
;
UCASE	CP	'a'
	RET	C
	CP	'z'+1
	RET	NC
	AND	5FH
	RET
;
_______	EQU	$
;
	END	VECTORS
