; sys12/asm - kjw/bqsd - 05/23/83
;
;	created 05/23/83 - kjw/bqsd
;	revised 05/25/83 - dwh
;
*GET	DOSEQU			;external support
;
	TITLE	'<PowerDOS - SYS12/SYS>'
;
	SUBTTL	'<Copyright (C) 1983 - Breeze/QSD, Inc. - Dallas, Texas>'
;
;	$VERIFY	- disk verify ON/OFF
;	$TIME	- fetch/load TIME$
;	$I	- deselect/fetch DCT from disk
;	$ERROR	- display error message
;	$DEBUG	- debugger ON/OFF
;	$DATE	- fetch/load DATE$
;	$AUTO	- set/disable AUTO command
;	$PAUSE	- wait for <KEY> to continue
;	$SCREEN	- send screen to device
;	$LIB    - list LIB commands
;
	PAGE
;
	ORG	$HISYS		;high overlay
;
VECTORS DEFW	$RETURN		;1 - load and return
	DEFW	$VERIFY		;2 - verify after write
	DEFW	$TIME		;3 - set/fetch time
	DEFW	$I		;4 - set drive init
	DEFW	$ERROR		;5 - display errors
	DEFW	$DEBUG		;6 - debugger on/off
	DEFW	$DATE		;7 - fetch/load date
	DEFW	$AUTO		;8 - set bootup auto cmd
	DEFW	$PAUSE		;9 - suspend program
	DEFW	$SCREEN		;10 - video to device
	DEFW	$LIB		;11 - display sys library
	DEFW	$UNDEF		;12 - undefined
	DEFW	$UNDEF		;13 - undefined
	DEFW	$UNDEF		;14 - undefined
	DEFW	$UNDEF		;15 - undefined
	DEFW	$UNDEF		;16 - undefined
;
	PAGE
;
;	undefined system call vector
;
$UNDEF	LD	A,_ERR01	;'bad function call'
	OR	A		;set NZ
	RET			;back to caller
;
	PAGE
;
;	exit vector for LIB commands
;
EXIT	AND	7FH		;assure a return
	LD	B,A		;pass error code here
;
EXITB	LD	A,@ERROR	;SVC #
	RST	$SVC		;call $ERROR
;
$RETURN	XOR	A		;set Z condition
	RET			;done
;
	PAGE
;
;	$LIB - display system library commands
;
;	ENTRY	HL => command input string
;
;	SYNTAX	LIB [to] [channel]
;		(default device @DO)
;
$LIB	LD	A,@DO		;default to display
	CALL	GETCHA		;setup channel
	JR	NZ,EXIT		;error, display it
;
;	set-up loop to display names
;
	CALL	GETLIB		;get library word addr.
;
LIB2	LD	E,8		;# names per line
LIB3	LD	D,10		;chars per name
;
;	fetch a character, check for terminator
;
	LD	A,(HL)		;get a char
	AND	7FH		;remove high bit
	JR	Z,LIBRET	;done, send CR, return
;
LIBLP2	LD	B,(HL)		;fetch a char
	RES	7,B		;turn off high bit
	CALL	OUTPUT		;send to device
	INC	HL		;bump string pointer
	DEC	D		;less byte counter
	BIT	7,(HL)		;start of next word?
	JR	Z,LIBLP2	;get next word if not
;
;	check if end of line
;
	DEC	E		;dec word counter
	JR	Z,NXTLIN	;next line
;
;	else pad rest of word length with spaces
;
	LD	B,' '           ;else send spaces
LIBLP3	CALL	OUTPUT		;to pad this word
	DEC	D		;count this byte
	JR	NZ,LIBLP3	;finish this word
	JR	LIB3		;go next word
;
;	line done, send C/R
;
NXTLIN	CALL	OUTCR		;send a C/R
	JR	LIB2		;go next word
;
;	completed, send CR and close output channel
;
LIBRET	CALL	OUTCR		;send C/R
	LD	DE,DDCB		;device
	JP	DCLOSE		;close the device & ret
;
;	fetch address of LIB commands
;
GETLIB	LD	A,_SYS01+_CMD12	;sys 1, #12
	RST	$OVL		;fetch lib address
;
	PAGE
;
;	$PAUSE	- wait for key input
;
;	ENTRY	HL => pause display message
;
;	SYNTAX	PAUSE [message]
;		(break at prompt will disable chaining)
;
;	turn off chaining to get the key
;
$PAUSE	LD	C,@KI		;keyboard DCB
	LD	A,@LOCDEV	;SVC #
	RST	$SVC		;IX => DCB
	LD	A,(IX+5)	;get flags
	PUSH	AF		;save 'em
	RES	1,(IX+5)	;turn off chaining
;
	LD	HL,PAUMSG	;'<KEY> to continue:'
	LD	DE,BUFADR	;dummy buffer
	LD	BC,PAULEN<8+1	;length + key input
	LD	A,@VIDKEY	;display + key input
	RST	$SVC		;display it
	JR	NC,CONTPAU	;not a break
;
;	BREAK pressed at PAUSE, turn off chaining
;
	POP	AF		;restore stack
	BIT	1,A		;chanining was on?
	JR	Z,CONTPAU+1	;nope, forget it
	LD	L,(IX+16)	;get DCB
	LD	H,(IX+17)
	LD	DE,@BUFLEN+@DCBLEN
	DEC	H		;begin of area
	LD	BC,1<8+7	;bank, command
	LD	A,@MEMCTL	;SVC #
	RST	$SVC		;reclaim memory!
	XOR	A		;set NO error
	RET			;done!
;
CONTPAU	POP	AF		;restore stack
	LD	(IX+5),A	;restore flags
	XOR	A		;set Z
	RET			;done
;
;	message displayed during pause
;
PAUMSG	DEFM	'<ENTER> to continue:'
PAULEN	EQU	$-PAUMSG
;
NOTAUTO	DEFM	'No AUTO Exists'
	DEFB	_CR
	DEFB	_ETX
;
	PAGE
;
;	$CLOCK	- activate/deactivate clock display
;
;	ENTRY	HL => input command string
;
;	SYNTAX	CLOCK [on/off]
;		(default on)
;
$CLOCK	CALL	ONOFF		;check user parameters
;
	JR	NZ,DOCOFF	;turn clock OFF
;
;	turn clock display ON
;
DOCON	LD	B,-1		;setup for ADD
	JR	CLKGO		;go common
;
;	turn clock display OFF
;
DOCOFF	LD	B,0		;setup for REMOVE
;
CLKGO	LD	A,@DPOINT	;SVC #
	RST	$SVC		;locate data block
;
	LD	E,(IX+20)	;task address LSB
	LD	D,(IX+21)	;task address MSB
	LD	C,@SLOTCL	;task slot # for clock
	LD	A,@NMICTL	;SVC #
	RST	$SVC		;enable/disable it
	XOR	A		;set Z
	RET			;done
;
	PAGE
;
;	$DEBUG	- activate/deactivate DEBUGGER
;
;	ENTRY	HL => parameter string
;
;	SYNTAX	DEBUG [on/off] [break=switch]
;		(default ON, no change in break)
;
$DEBUG	LD	A,80H		;set non evaluated
;
;	reset parameter flags
;
	LD	(PON),A		;debug ON flag
	LD	(POFF),A	;debug OFF flag
	LD	(DBGBRK),A	;debug on BREAK flag
;
;	check input parameters
;
	LD	DE,DBGPAR	;debug parameter block
	LD	A,@PARAM 	;get the params
	RST	$SVC		;call $PARAM
	JP	NZ,EXIT		;error, return
;
;	check input
;
;	check user input, check OFF params
;
	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch data block
	LD	A,(POFF)	;get off parameter
	INC	A		;OFF, OFF=YES
	JR	Z,DODOFF	;do debug OFF
	DEC	A		;OFF=NO
	JR	Z,DODON 	;do debug ON
;
;	check for ON params
;
	LD	A,(PON)		;get ON parmeter
	INC	A		;ON, ON=YES
	JR	Z,DODON 	;do debug ON
	DEC	A		;ON=NO
	JR	Z,DODOFF	;do debug off
;
;	turn debugger ON
;
DODON	LD	B,00000011B	;debug on flags
	JR	DODCONT 	;continue
;
;	turn debugger OFF
;
DODOFF	LD	B,00000000B	;debug off flags
;
DODCONT	LD	A,(IX+35)	;get debug flags
	AND	11111100B	;drop old debug flags
	OR	B		;set new flags
;
	LD	BC,(DBGBRK)	;get break flag
	INC	C		;BREAK=ON
	JR	Z,DBGBON	;turn it on
	DEC	C		;BREAK=OFF
	JR	NZ,DBGGO	;continue if neither
;
;	turn off debug trigger with break
;
DBGBOFF SET	2,B		;no debug on BREAK
	JR	DBGGO		;continue
;
;	turn on debug trigger with break
;
DBGBON	RES	2,B		;allow BREAK debug
;
DBGGO	LD	(IX+35),B	;update flags
	XOR	A		;set NO error
	RET			;back to caller
;
	PAGE
;
;	$VERIFY - activate/deactivate disk write verify
;
;	ENTRY	HL =>	command string
;
;	SYNTAX	VERIFY [on/off]
;		(default on)
;
$VERIFY	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch data block
	CALL	ONOFF		;evaluate user input
;
	SET	1,(IX+34)	;turn it on
	RET	Z		;done, return!
;
DOVOFF	RES	1,(IX+34)	;turn it off
	XOR	A		;set Z
	RET			;done
;
	PAGE
;
;	$ERROR	- send error message to channel
;
;	ENTRY	HL =>	command string
;
;	SYNTAX	ERROR [error number]
;		(default last system error posted)
;
$ERROR	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch data block
	LD	A,@POSHL	;SVC #
	RST	$SVC		;any input?
	LD	A,(IX+36)	;use last error if not
	JR	Z,SHOWERR	;display it
;
	LD	A,@VALUE	;else get value
	RST	$SVC		;from user input
	JR	NZ,SHOWERR	;error, display it
	LD	A,E		;get the error num
;
;	display error message in A
;
SHOWERR JP	EXIT		;display error & return
;
	PAGE
;
;	$ONOFF	- check for ON/OFF user parameters
;
;	ENTRY	HL => user parameters
;
;	EXIT	Z  = ON
;		NZ = OFF
;		if invalid parameters found,
;		stack is popped, and an exit
;		is made to $EXIT with the error code
;
ONOFF	LD	A,@NIL		;nil param
;
;	reset parameter flags
;
	LD	(PON),A 	;ON parameter
	LD	(POFF),A	;OFF parameter
;
;	check for input parameters
;
	LD	DE,OFPAR	;ON/OFF param block
	LD	A,@PARAM 	;SVC #
	RST	$SVC		;load param blocks
	JR	NZ,ONOFFB	;bad parameters
;
;	check user input, check for OFF params
;
	LD	A,(POFF)	;get OFF param
	INC	A		;OFF, OFF=YES
	JR	Z,ONOFFN	;set NO
	DEC	A		;OFF=NO
	JR	Z,ONOFFY	;set YES
;
;	nil input, check for ON params
;
	LD	A,(PON) 	;get ON param
	INC	A		;ON, ON=YES
	JR	Z,ONOFFY	;set YES
	DEC	A		;ON=NO
	JR	Z,ONOFFN	;set NO
;
;	no input, default to YES
;
ONOFFY	XOR	A		;set Z for YES
	RET			;return to caller
;
;	set NO
;
ONOFFN	OR	-1		;set NZ for NO
	RET			;return to caller
;
;	invalid parameters
;
ONOFFB	POP	DE		;remove caller return
	JP	EXIT		;back to LIB caller
;
;	extended block for DEBUG use
;
DBGPAR	DEFB	_SWITCH+4	;switch + length-1
	DEFW	DBGBRK		;vector
	DEFM	'BREAK'		;param
;
;	ON/OFF parameter block
;
OFPAR	DEFB	_SWITCH+1	;switch + length
	DEFW	PON		;ON data vector
	DEFM	'ON'            ;parameter
;
	DEFB	_SWITCH+2	;switch + length-1
	DEFW	POFF		;OFF data vector
	DEFM	'OFF'           ;parameter
;
	DEFB	_SWITCH+2	;switch + length
	DEFW	PON		;ON vector
	DEFM	'YES'		;param
;
	DEFB	_SWITCH+1	;switch + length-1
	DEFW	POFF		;OFF vector
	DEFM	'NO'
;
	DEFB	_EBLOCK		;terminator
;
;	data area for params
;
PON	DEFW	@PRESET		;vector for ON
	DEFB	@NIL
POFF	DEFW	@PRESET		;vector for OFF
	DEFB	@NIL
DBGBRK	DEFW	@PRESET		;vector debug on BREAK
	DEFB	@NIL
;
;	param block for I
;
IBLOCK	DEFB	_SWITCH+4	;switch + length
	DEFW	MNTPAR		;data vector
	DEFM	'MOUNT'		;param
	DEFB	_EBLOCK		;terminator
;
MNTPAR	DEFW	@PRESET		;param switch vector
	DEFB	@NIL
;
	PAGE
;
;	$OUTCR	- output CR to device
;
;	$OUTPUT - output B to logical device
;
;	ENTRY	B = character to output
;		(ddcb) loaded with channel
;
;	EXIT	Z  = OK, B sent to device
;		NZ = stack popped and $EXIT
;
;	$INPUT	- input B from logical device number
;
;	ENTRY	(sdcb) loaded with channel
;
;	EXIT	Z  = OK, B = character
;		NZ = A = error code
;
OUTCR	LD	B,_CR		;send C/R
;
;	output B to device
;
OUTPUT	PUSH	DE		;save this
	LD	DE,DDCB+1	;point to DCB
	LD	A,@PUT		;SVC #
	RST	$SVC		;send it
	POP	DE		;restore stack
	RET	Z		;Z = OK, return
;
	POP	DE		;remove call vector
	JP	EXIT		;display error & exit
;
	PAGE
;
;	$OPENO	- open device for output
;	$DCLOSE - close device
;
;	ENTRY	DE => DCB returned by $FSPEC
;
;	EXIT	Z  = OK
;		NZ = A = error code
;
; (NOTE) devices 0-7 (character devices) are not
;	attempted to be opened
;
OPENO	LD	A,(DE)		;get device number
	BIT	6,A		;filespec?
	JR	NZ,OPENFIL	;yes, open it
	AND	0FH		;bits 4-0 = device
	CP	8		;devices 0-7?
	JR	C,OPENOK	;open the device
OPENFIL	INC	DE		;set to normal DCB
	LD	HL,OLIST	;OPEN param list
	LD	A,@OPEN		;SVC #
	RST	$SVC		;call it
	RET			;Z = OK
;
OPENOK	LD	C,A		;device num
	LD	A,@LOCDEV	;find the DCB
	RST	$SVC		;IX => DCB
	LD	(DDCB+4),IX	;save it
	LD	A,@BIT4		;set ROUTE
	LD	(DDCB+1),A	;dummy routed DCB
	XOR	A		;set Z for OK
	RET			;done
;
DCLOSE	LD	A,(DE)		;get device
	BIT	6,A		;filespec?
	JR	NZ,CLOSFIL	;yes, close it!
	AND	0FH		;bits 4-0 = device
	CP	8		;0-7 ?
	JR	C,CLOSEOK	;no need to close it
CLOSFIL	INC	DE		;point to DCB
	LD	A,@CLOSE 	;SVC #
	RST	$SVC		;close the file
	RET	Z		;go if no error
;
	POP	DE		;remove caller address
	JP	EXIT		;display error & exit
;
CLOSEOK XOR	A		;set Z
	RET
;
;	definition of $EVAL param block
;
EBLOCK	DEFB	0		;work byte, +0
	DEFW	DDCB		;source, +1,2
	DEFW	DDCB		;dest, +3,4
	DEFW	BUFADR		;mask, dummy
EPARM	DEFW	0		;parameter list, +7/8
PARNIL	DEFB	_EBLOCK		;nil parameter list
;
;	$OLIST	- $OPEN parameter list
;
OLIST	DEFW	BUFADR		;+0,1 - buffer address
	DEFW	BUFADR		;+2,3 - record address
	DEFW	0		;+4,5 - EODAD
	DEFB	'W'             ;+6 - read/write
	DEFB	0		;+7 - logical record len
	DEFB	'E'             ;+8 - fixed length file
	DEFB	2		;+9 - open type
	DEFB	_EBLOCK		;+10 - param list term.
;
	PAGE
;
;	$EVALIT - evaluate LIB expression
;
;	ENT	HL => command string
;		DE = $PARAM block address
;
;	EXT	(EBLOCK) loaded, and exit to $EVAL
;		Z = OK, EBLOCK loaded
;		NZ = A = error code
;
EVALIT	LD	IX,EBLOCK	;point to eval block
	LD	(EPARM),DE	;insert $PARAM block
	LD	A,@EVAL		;SVC #
	RST	$SVC		;call $EVAL
	RET			;back to caller, Z = OK
;
	PAGE
;
;	$GETCHA	- fetch output channel
;
GETCHA	LD	(DDCB),A	;setup the device
;
;	evaluate user input
;
	LD	DE,PARNIL	;nil parameters
	CALL	EVALIT		;evaluate expression
	RET	NZ		;error, return
;
;	check for valid output channel
;
;	open the channel for ouput
;
	LD	DE,DDCB 	;dest DCB
	JP	OPENO		;open for ouput
;
	PAGE
;
;	$GETDRV	- fetch drive number from string
;
GETDRV	LD	A,@FSPEC	;evaluate the drive #
	LD	DE,DDCB		;use DCB area
	RST	$SVC		;fetch it
	RET	NZ		;error, return
;
;	check for valid drive number
;
	LD	A,(DE)		;get flag byte
	BIT	7,A		;device evaluated?
	JR	Z,IERR		;bad drive number
	AND	0FH		;get device number
	CP	8		;0-7?
	JR	C,IERR		;not a drive number
;
;	have valid device number in A
;
	SUB	@DRVOFF		;make it device 0-7
	LD	C,A		;need it here
	XOR	A		;set Z
	RET			;done, return
;
IERR	LD	A,_ERR32	;illegal drive number
	OR	A		;set NZ
	RET			;back to caller
;
	PAGE
;
;	$TIME	- fetch/load TIME$
;
;	ENTRY	HL =>	command line
;
;	SYNTAX	TIME [time]
;		(default display current time)
;
$TIME	LD	A,@POSHL	;SVC #
	RST	$SVC		;any input?
	JR	Z,SHOTIME	;display time if not
;
;	load TIME$
;
	LD	B,2		;command #
	LD	A,@DATE		;SVC #
	RST	$SVC		;load it
;
	RET	Z		;no error, return
	JP	EXIT		;error, display it
;
;	fetch TIME$
;
SHOTIME	LD	B,0		;command #
	LD	A,@DATE		;SVC #
	LD	HL,BUFADR	;place data here
	RST	$SVC		;fetch it
	JP	NZ,EXIT		;error, display it
;
	LD	DE,15		;offset to time
	ADD	HL,DE		;point to it
	LD	BC,8<8+_CR	;length + term
	LD	A,@VDLINE	;SVC #
	RST	$SVC		;display it
;
	RET	Z		;go if OK
	JP	EXIT		;error, display it
;
	PAGE
;
;	$DATE	- fetch/load DATE$
;
;	ENTRY	HL =>	command line
;
;	SYNTAX	DATE [date]
;		(default display system date)
;
$DATE	LD	A,@POSHL	;SVC #
	RST	$SVC		;any input?
	JR	Z,SHODATE	;display date if not
;
;	load DATE$
;
	LD	B,1		;command #
	LD	A,@DATE		;SVC #
	RST	$SVC		;load it
;
	RET	Z		;go if no error!
	JP	EXIT		;error, exit
;
;	fetch DATE$
;
SHODATE	LD	B,0		;command #
	LD	A,@DATE		;SVC #
	LD	HL,BUFADR	;data goes here
	RST	$SVC		;fetch it
	JP	NZ,EXIT		;error, abort
;
	LD	DE,DATE0	;where it goes
	PUSH	DE		;save string start
	LD	C,3		;3 chars to move
	LDIR			;move name of day
;
	INC	DE		;bump to next field
	INC	DE
	INC	DE
	LD	C,3		;3 chars
	LDIR			;move month name
;
	INC	DE		;next field
	LD	C,2		;2 chars
	LDIR			;move day of month
;
	INC	DE		;next field
	INC	DE
	LD	C,4		;4 chars
	LDIR			;move year
;
	INC	DE		;next field
	INC	DE
	INC	DE
	LD	C,3		;3 chars
	LDIR			;move day number in year
;
;	display it
	POP	HL		;get string start back
	LD	BC,24<8+_CR	;length + term
	LD	A,@VDLINE	;SVC #
	RST	$SVC		;display it
;
	RET	Z		;go if no error!
	JP	EXIT		;error, display it
;
;	date text string
;
DATE0	DEFM	'day - '
DATE1	DEFM	'mon '
DATE2	DEFM	'##, '
DATE3	DEFM	'1980 - '
DATE4	DEFM	'###'
;
	PAGE
;
;	$SCREEN	- send contents of video to device
;
;	ENTRY	HL =>	command line
;
;	SYNTAX	SCREEN [to] [channel]
;		(default device @PR)
;
$SCREEN	LD	A,@PR		;default device
	CALL	GETCHA		;get output channel
	JP	NZ,EXIT		;error, abort
;
	LD	DE,DDCB+1	;point to DCB
	LD	A,@SCREEN	;screen SVC #
	RST	$SVC		;send to device
	JP	NZ,EXIT		;error, abort
;
	LD	DE,DDCB		;point to DCB
	JP	DCLOSE		;close it up
;
	PAGE
;
;	$I	- init disk drives
;
;	ENTRY	HL =>	command line
;
;	SYNTAX	I [drivespec] [mount]
;		(default init for all drives)
;
$I	LD	DE,IBLOCK	;eval block
	LD	A,@NIL		;clear param flag
	LD	(MNTPAR),A	;save it
	CALL	EVALIT		;evaluate it
	JP	NZ,EXIT		;error, abort!
;
	BIT	2,(IX+0)	;source device?
	JR	Z,INITALL	;do 'em all
	LD	A,(DDCB)	;get device number
	LD	B,_ERR32	;'invalid drive'
	BIT	7,A		;device here?
	JP	Z,EXITB		;error, go!
	AND	0FH		;device number
	SUB	@DRVOFF		;check for 8-15
	JP	C,EXITB		;error it not
	LD	C,A		;pass drive number
	CALL	NIL		;nil the drive
;
	XOR	A		;done, return ZERO
	RET
;
;	init all drives
;
INITALL	LD	BC,@DRVS<8+0	;B=looper, C=drive
;
INITL	CALL	NIL		;this drive
	INC	C		;bump drive
	DJNZ	INITL		;do 'em all
;
	XOR	A		;done
	RET
;
NIL	LD	A,@LOCDRV	;SVC #
	RST	$SVC		;IY => DCT
	SET	0,(IY+5)	;force init next time
;
;	check for MOUNT on drive
;
	LD	A,(MNTPAR)	;fetch parameter
	INC	A		;yes?
	RET	NZ		;nope, return
;
	PUSH	BC		;save drive, counter
	LD	E,0		;read GAT
	LD	B,E		;extended sector
	LD	HL,BUFADR	;I/O buffer
	LD	A,@SREAD	;read directory
	RST	$DIO		;read to set DCT
	POP	BC		;restore it
	RET			;done, return
;
	PAGE
;
;	$AUTO	- setup/disable AUTO command
;
;	ENTRY	HL => command line
;
;	SYNTAX	AUTO [drivespec] [command]
;
$AUTO	LD	A,@POSHL	;SVC #
	RST	$SVC		;any input?
	LD	C,0		;turn off drive 0 if yes
	JR	Z,NOAUTO	;go!, no input
;
;	check for drive number
;
	CP	':'		;drive specifier?
	JR	NZ,SETAUTO	;turn it on, use drive 0
;
	CALL	GETDRV		;get the drive number
	JR	NZ,AUTORET	;error, abort
	LD	A,@POSHL	;SVC #
	RST	$SVC		;any more input?
	JR	Z,NOAUTO	;nope, turn auto off
;
;	set auto command, drive number in C (0-7)
;
SETAUTO	CP	'?'		;display auto?
	JR	NZ,GOAUTO	;nope, get user input!
;
;	display existing auto command
;
	CALL	READ		;read sector in drive
	JR	NZ,AUTORET	;disk error!
	LD	HL,$UBUFF+32	;point to auto command
	PUSH	HL		;save start
	LD	BC,80<8+0	;B=counter, C=# chars
;
AUTOLEN	LD	A,(HL)		;get a char
	CP	_CR		;terminator?
	JR	Z,AUTOTRM	;yes, terminate
	INC	HL		;bump pointer
	INC	C		;bump char count
	DJNZ	AUTOLEN		;go for max length
;
AUTOTRM	LD	(HL),_CR	;carriage return to buff
	INC	HL		;bump pointer
	LD	(HL),_ETX	;terminate display
	LD	A,C		;get length
	POP	HL		;restore string start
	OR	A		;anything?
	JR	NZ,$+5		;go if any input
	LD	HL,NOTAUTO	;not any auto command!
	LD	A,@DSPLY	;SVC #
	RST	$SVC		;display message
	RET	Z		;done if no error
	JP	EXIT		;else display & return
;
GOAUTO	LD	DE,BUFADR	;use this area for string
	LD	B,80		;80 chars max
;
FILAUTO	LD	A,(HL)		;get a character
	LD	(DE),A		;pass to dest
	CP	_CR		;terminator?
	JR	Z,AUTOT		;yes, done
;
	INC	HL		;bump pointers
	INC	DE
	DJNZ	FILAUTO		;fill more
	LD	A,_CR		;terminate buffer
;
AUTOT	INC	B		;buffer filled?
FILATO	DEC	B		;yes?
	JR	Z,PUTAUTO	;done, put on disk
	INC	DE		;bump pointer
	LD	(DE),A		;put in a _CR
	JR	FILATO		;go more
;
;	write command to disk
;
PUTAUTO	CALL	READ		;get sector
	JR	NZ,AUTORET	;disk error, abort
;
;	move auto command into buffer
;
	PUSH	BC		;save drive number
	LD	HL,BUFADR	;data is here
	LD	DE,$UBUFF+32	;offset for command
	LD	BC,80		;auto length
PUTBAK	LDIR			;move it in
	POP	BC		;restore drive
;
	CALL	WRITE		;write back to disk
;
AUTORET	PUSH	AF		;save error condition
	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch data block
	LD	L,(IX+18)	;get command pointer
	LD	H,(IX+19)
	LD	(HL),_CR	;terminate pending cmds
	POP	AF		;restore error
	JP	NZ,EXIT		;display error
;
	XOR	A		;force ZERO
	RET			;done
;
;	disable AUTO command
;
NOAUTO	CALL	READ		;read
	JR	NZ,AUTORET	;error, abort
	PUSH	BC		;save drive number
;
	LD	HL,$UBUFF+32	;command start
	LD	DE,$UBUFF+33
	LD	(HL),_CR	;fill with CR's
	LD	BC,79		;length -1
	JR	PUTBAK		;write it back
;
;	read table into (user buffer)
;
READ	LD	A,@DREAD	;disk I/O command
	JR	READWRT		;go common
;
;	write table from (user buffer)
;
WRITE	LD	A,@DWRIT	;disk I/O command
;
READWRT	LD	HL,$UBUFF	;data buffer
	LD	D,0		;cylinder 0
	LD	B,D		;msb sector
	LD	E,3		;lsb sector
	RST	$DIO		;write it back
	RET			;done, return
;
DDCB	DEFS	@DCBLEN		;DCB length
BUFADR	DEFS	@BUFLEN		;I/O buffer
;
_______	EQU	$
;
	END	VECTORS
