; sys0svcr/asm - rbr/bqsd - 05/06/83
;
;	created 05/06/83	- rbr/bqsd
;	revised 05/12/83	- kjw/bqsd
;
	PAGE
;
;	$$LOCDEV - SVC 109 - Locate DCB
;
;	Entry:	C  = Device number (0-15)
;
;	Exit:	Z  = OK, IX => DCB address
;		NZ = Error, A  = error code
;
$$LOCDEV
	LD	A,C		;get device number
	CP	@DEVS		;range check for device
	JR	NC,DEVERR	;error
;
	PUSH	HL		;save HL
	CALL	LOCTBL		;get the reference
	CALL	$GETHL		;load HL with (HL)
	PUSH	HL
	POP	IX		;into IX
	POP	HL		;restore HL
	RET			;done, Z set
;
DEVERR	LD	A,_ERR06	;invalid SVC data
	OR	A		;set Z flag
	RET
;
	PAGE
;
;	$$LOCDRV - SVC 108 - Locate DCT address
;
;	Entry:	C = Drive number (0-7)
;
;	Exit	Z  = Ok, IY = DCT address
;		NZ = Error (invalid drive), A = err. code
;
$$LOCDRV
	LD	A,C		;get drive into A
	ADD	A,@DRVOFF	;offset to drives
;
	PUSH	IX		;save IX
	CALL	$$LOCDEV+1	;locate DCB address
	JR	NZ,DRVBAD	;error, abort!
	PUSH	IX		;pass to IY
	POP	IY		;IY => DCT
DRVBAD	POP	IX		;unstack IX
;
	RET			;return with status
;
;	locate DCB table entry
;
LOCTBL	LD	H,$DCBTBL<-8	;MSB table address
	ADD	A,A		;* 2
	ADD	A,A		;* 4
	LD	L,A		;HL => DCB entry start
	RET
;
	PAGE
;
;	$$GETNAM - SVC 111 - Locate Device name
;
;	Entry:	C = Device number (0-15)
;
;	Exit:	Z = OK, HL = 2-char device name
;		NZ = Error, A = error code
;
$$GETNAM
	LD	A,C		;get device #
	CP	@DEVS		;0-15?
	JR	NC,DEVERR	;error, out of range!
;
	CALL	LOCTBL		;position table
	INC	L		;bump past DCB address
	INC	L		;HL => name
	JR	$GETHL		;fetch name into HL
;
	PAGE
;
;	$$LOCNAM - SVC 110 - Locate Device by Name
;
;	Entry:	HL =	device name
;
;	Exit:	Z  = OK, C = device #
;		NZ = Error, A = Error Code
;
$$LOCNAM
	PUSH	HL		;save
	PUSH	DE		;save
	LD	C,@DEVS-1	;init device #
	EX	DE,HL		;DE = requested name
;
LOCLOOP	CALL	$$GETNAM	;get device name
	SBC	HL,DE		;requested device?
	JR	Z,LOCFND	;found, go!
	DEC	C		;less device #
	JR	NZ,LOCLOOP	;go for device count
	LD	A,_ERR70	;device not found!
;
LOCFND	POP	DE		;restore DE
	POP	HL		;restore HL
	OR	A		;set flags on result
	RET			;done!
;
;	fetch 2 byte vector pointed to by HL
;
$GETHL	LD	A,(HL)		;fetch LSB
	INC	HL		;bump table
	LD	H,(HL)		;fetch MSB
	LD	L,A		;HL = vector
	XOR	A		;set Z flag
	RET			;done!
;
	PAGE
;
;	$$DPOINT - SVC 107 - Locate Data block
;
;	ENTRY: 	none
;
;	EXIT:	IX => start of data block
;
$$DPOINT
	LD	IX,$PBLOCK	;start pointer block
	XOR	A		;set Z for no error
	RET
;
