; sys0svcd - kjw/bqsd - 05/04/83
;
;	created 05/04/83	- kjw/bqsd
; 	revised 05/04/83	- dwh
;	revised 05/12/83	- kjw
;
	PAGE
;
;	$SETUSR - SVC 2 - insert/remove vector SVC table
;
;	ENTRY	B  =	SVC # (0-127)
;		C  =	0 = remove
;		C  <>	0 = add vector
;		HL =>	routine to add (if C <> 0)
;
;	EXIT	Z  =	ok
;		HL =>	routine added or deleted
;		NZ =	A = error code
;
$$SETUSR
	LD	A,B		;get SVC # affected
	ADD	A,A		;see if >127
	JR	NC,SETUS1	;go if valid
;
	LD	A,_ERR06	;parameter error on SVC
	OR	A		;set NZ flag
	RET			;NZ = error
;
;	locate table position
;
SETUS1	PUSH	DE		;save this
	EX	DE,HL		;DE = user vector
	LD	L,A		;L = SVC vector offset
	LD	H,$SVCTBL<-8	;starts on page 2
	XOR	A		;set Z
	CP	C		;Z = remove
	JR	NZ,$+5		;go if ADD
	LD	DE,$$UNDEF	;else REMOVE
;
;	insert vector into table, fetch old vector
;
	LD	A,(HL)		;get previous
	LD	(HL),E		;put LSB new
	LD	E,A		;E = old LSB
	INC	L		;bump pointer
	LD	A,(HL)		;get MSB old
	LD	(HL),D		;put MSB new
	LD	D,A		;DE = old vector
;
;	completed
;
	EX	DE,HL		;HL = old vector
	POP	DE		;restore DE
	XOR	A		;set NO error
	RET			;done
;
	PAGE
;
;	$SETBRK - SVC 3 - insert/remove user BREAK prcsr.
;
;	ENTRY	HL =>	break processor (0=remove)
;
;	EXIT	HL =>	deleted or replaced routine
;		Z  	set
;
; (NOTE) vector does not need to be disabled
;	 before it is changed
;
$$SETBRK
	PUSH	IX		;save
	LD	A,@KI	 	;keyboard device
	CALL	$$LOCDEV+1	;locate DCB
	LD	A,H		;see if remove
	OR	L		;any bits?
	JR	Z,SETBRK1	;remove if 0
;
;	install vector
;
	LD	(IX+18),L	;load LSB vector
	LD	(IX+19),H	;load MSB vector
	SET	5,(IX+5)	;set processor active
	JR	SETBRK2		;return Z
;
;	turn off processor
;
SETBRK1	BIT	5,(IX+5)	;active now?
	LD	A,_ERR66	;function does not exist
	JR	Z,SETBRK3	;return in error
;
	LD	L,(IX+18)	;get prev vector LSB
	LD	H,(IX+19)	;get prev vector MSB
	RES	5,(IX+5)	;turn off processor
;
SETBRK2	RES	3,(IX+5)	;reset break pending
	XOR	A		;set OK
;
SETBRK3 POP	IX		;restore stack
	OR	A		;set flags
	RET			;done
;
	PAGE
;
;	$DELAY - SVC 6 - delay program execution
;
;	ENTRY	BC =	delay factor
;
;	EXIT	A  =	0
;		Z	set
;
; DELAY:	BC = 0 = 426 milliseconds
;		BC >0 = 6.5 * (BC - 1) + 22 microsecs.
;
$$DELAY	PUSH	BC		;don't change it
	DEC	BC		;less 1
	LD	A,B		;see if any left
	OR	C		;BC = 0000?
	JR	NZ,$$DELAY+1	;go more if yes
	POP	BC		;restore original
	RET
;
	PAGE
;
;	$VIDKEY - SVC 12 - display text and get string
;
;	ENTRY	HL =>	text message to display
;		DE =>	text buffer for keyboard input
;		B  =	number chars to display
;		C  =	max chars for key input
;
;	EXIT	Z  =	OK, A=0
;		HL =>	input buffer from keyboard
;		DE =>	displayed text string
;		B  =	number input characters
;		C  =	terminating character  (0 or CR)
;
;		NZ =	A = error code
;		DE =>	input buffer from keyboard
;		HL =>	displayed text string
;		B  =	chars to display
;		C  =	chars to input from keyboard
;
$$VIDKEY
	PUSH	BC		;save char/key count
	LD	C,0		;nil char at display end
	CALL	$$VDLINE	;display line to video
	POP	BC		;restore BC
	RET	NZ		;go if error!
;
VIDKEY1	LD	B,C		;max keys to fetch
	EX	DE,HL		;pass buffer to HL
	JP	$$KBLINE	;get string from keyboard
;
	PAGE
;
;	$STCMP	- SVC 22 - compare two strings
;
;	ENTRY	DE =>	first string
;		HL =>	second string
;		BC =	length to compare
;
;	EXIT	BC, DE, HL preserved
;		Z = strings identical
;		NZ = not identical
;		Cy = DE string less than HL string
;		DE' => first non-match string DE
;		HL' => first non-match string HL
;		BC' = number of chars remaining
;
$$STCMP	PUSH	BC		;pass registers to alt
	PUSH	DE
	PUSH	HL
;
;	load into alternate registers
;
	EXX			;swap sets
	POP	HL		;load 'em up
	POP	DE
	POP	BC
;
STCMP1	LD	A,(DE)		;get first byte
	CP	(HL)		;same as second?
	JR	NZ,STCMP2 	;return if not
	LDI			;advance parameters
	JP	PE,STCMP1 	;go if more left
;
STCMP2	EXX			;swap original back
	RET			;done
;
	PAGE
;
;	$TIMER	- SVC 25 - setup/remove user timer
;
;	ENTRY	HL =>	routine
;		BC =	number of seconds to time
;
;	if HL and BC = 0, timer is turned off
;	if HL = 0, and BC <> 0, reset time to BC
;
;	EXIT	Z =	ok
;		A =	0
;
$$TIMER	CALL	$$SAVREG	;save registers
	LD	A,H		;for compare
	OR	L		;see if 0
	JR	Z,TIMER1 	;timer vector 0000
;
;	initialize timer
;
	LD	($UCVEC),HL	;timer vector
	LD	($UCCNT),BC	;timer counter
	LD	BC,-1<8+@SLOTUT	;B = add, C = slot 7
	LD	DE,($PBLOCK+26)	;user timer task
	JP	$$NMICTL	;add the task
;
;	see if reset or remove
;
TIMER1	LD	A,B		;see if BC = 0
	OR	C
	JR	Z,TIMER2	;remove timer
	LD	($UCCNT),BC	;reset the counter
	XOR	A		;done, return Z
	RET
;
TIMER2	LD	BC,0<8+@SLOTUT	;B = remove, C = slot
	JP	$$NMICTL	;kill it
;
	PAGE
;
;	$LOOKUP - SVC 28 - lookup entry in table
;
;	ENTRY	HL =>	lookup table (FF terminator)
;		B  =	search key
;
;	EXIT	Z =	found, HL = vector (bytes 2&3)
;		NZ =	A = error code (not found)
;			HL restored
;
$$LOOKUP
	PUSH	HL		;save table start
;
LOOK1	LD	A,(HL)		;get an entry
	INC	A		;FF ?
	JR	Z,LOOK3		;not found
	DEC	A		;put it back
	CP	B		;right one?
	INC	HL		;bump to vector
	JR	Z,LOOK2		;have it
	INC	HL		;bump it
	INC	HL		;past 2 byte vector word
	JR	LOOK1		;get next entry
;
;	key found, fetch vector
;
LOOK2	CALL	$GETHL		;load HL with (HL)
	POP	AF		;restore stack
	XOR	A		;set Z for found
	RET			;done
;
;	not found in table
;
LOOK3	LD	A,_ERR50	;'member not found'
	OR	A		;set NZ
	POP	HL		;restore stack
	RET
;
	PAGE
;
;	$HLDKEY - SVC 29 - hold key processor
;
;	ENTRY	B  =	0 = turn off processor
;			(hold generates data 00)
;		B  =	1 = turn on hold processor
;			(hold intercepted by DOS)
;		B  >	1 = check for hold, wait if yes
;
;	EXIT	Z  =	hold processor active
;		NZ =	hold processor off
;
$$HLDKEY
	PUSH	IX		;save
	LD	A,@KI	 	;keyboard device
	CALL	$$LOCDEV+1	;locate DCB
	LD	A,B		;get switch
	OR	A		;B = 0 ?
	JR	Z,HLDKEY3	;turn it off
	DEC	A		;B = 1 ?
	JR	Z,HLDKEY2 	;turn it on
;
;	check for HOLD & wait
;
	BIT	4,(IX+5)	;processor active?
	JR	Z,HLDKEY3	;processor is off!
	BIT	2,(IX+5)	;hold pressed?
	JR	Z,HLDKEY2 	;not pressed!
	RES	2,(IX+5)	;reset hold
;
HLDKEY1 BIT	2,(IX+5)	;wait here for it
	JR	Z,HLDKEY1	;bit will change
;
;	Turn hold on, return Z
;
HLDKEY2	SET	4,(IX+5)	;set active
	XOR	A		;set Z flag
	JR	HLDKEY4		;continue
;
;	Turn  hold off, return NZ
;
HLDKEY3	RES	4,(IX+5)	;*** turn off processor
	OR	-1		;set NZ flag
;
HLDKEY4	RES	2,(IX+5)	;hold pending = no
	POP	IX		;unstack IX
	RET			;return Z/NZ
;
	PAGE
;
;	$STSCAN - SVC 49 - scan block of data for string
;
;	ENTRY	HL =>	text area to search
;		DE =>	string to compare
;		B  =	length of compare
;
;	EXIT	NZ = not found, HL unchanged
;		Z = found, HL => matching string
;
; scan will terminate if a string match is found
;	or on the first 0DH found in (HL)
;
$$STSCAN
	PUSH	BC		;save registers
	PUSH	HL
	LD	C,B		;pass length to C
	LD	B,0		;BC = length
;
STSCAN1	LD	A,(HL)		;get a byte
	CP	_CR		;terminator?
;
STSCAN2	LD	A,_ERR50	;'member not found'
	JR	Z,STSCAN5	;terminate on CR
;
	LD	A,(DE)		;get test byte
	CP	(HL)		;first byte match?
	JR	NZ,STSCAN3	;go if not!
;
	CALL	$$STCMP		;compare strings
	JR	Z,STSCAN4	;go if match!
;
STSCAN3	INC	HL		;bump test block
	LD	A,H		;check for 0000H?
	OR	L		;yes?
	JR	NZ,STSCAN1	;nope, continue
	JR	STSCAN2		;else abort!
;
STSCAN4	XOR	A		;set found!
	EX	(SP),HL		;swap HL
;
STSCAN5	POP	HL		;restore HL
	POP	BC		;restore length
	OR	A		;set flags
	RET			;return Z=found else NZ
;
