; sys0runl/asm - 05/04/83 - kjw/bqsd
;
;	created 05/04/83	- kjw/bqsd
;	revised 05/05/83	- dwh
;	revised 06/02/83	- kjw
;
	PAGE
;
;	$RUN - SVC 85 - load/execute program
;
;	ENTRY	DE =>	DCB
;
;	EXIT	NZ =	A = error code
;		Z  =	loaded file, no exec address!
;
$$RUN	PUSH	HL		;save
	LD	HL,$FLAG1	;system flags
	SET	0,(HL)		;force read
	PUSH	HL		;save flags
	CALL	$$LOAD		;load file
	EX	(SP),HL 	;HL => flags
	RES	0,(HL)		;force read off
	JR	NZ,RUN1 	;I/O error
;
	INC	DE		;FCB flags
	LD	A,(DE)		;get attribute
	AND	7		;low 3 bits only
	INC	HL		;sys flags 2
	BIT	0,(HL)		;DEBUG on?
	LD	BC,($LOMEM)	;BC => low memory
	LD	DE,($HIMEM)	;DE => high memory
	POP	HL		;HL => entry
	EX	(SP),HL 	;HL=pointer, (SP)=entry
	JR	Z,RUN0		;no debug, check prot
;
;	debug ON, check if protection allows
;
	CP	_EXEC		;execute only?
	JR	NC,RUN0		;cannot go debug!
;
;	setup for exit to DEBUG
;
	PUSH	HL		;save string pointer
	LD	HL,$$DEBUG	;debug entry
	EX	(SP),HL		;leave on stack, get HL
;
;	check for execute only file!
;
RUN0	CP	_EXEC		;read access?
	JR	C,GOPGM		;yes, go program!
;
;	execute only file!
;
	PUSH	HL		;save pointer
	LD	HL,$FLAG1	;sys flag #1
	SET	3,(HL)		;memory protected
	INC	HL		;sys flag #2
	SET	2,(HL)		;no debug on BREAK
	POP	HL		;restore stack
;
GOPGM	LD	A,-1		;reset high overlay
	LD	($CUROVH),A	;high overlay gone!
;
RETURN	XOR	A		;set Z for no error
	RET			;go program!
;
RUN1	POP	HL		;ignore
	POP	HL		;GET => CMD line
	RET			;return error code
;
	PAGE
;
;	$LOAD - SVC 86 - load program file
;
;	ENTRY	 DE =>	FILE DCB
;
;	EXIT	NZ =	A = error code
;		Z  =	loaded, DE=>FCB, HL=entry point
;
$$LOAD	LD	HL,$FLAG1	;system flag
	RES	4,(HL)		;NOT system load!
;
	LD	HL,LOADP	;HL => param list
	CALL	$$OPEN		;open file
	JR	Z,LOAD1 	;no error
	CP	_ERR24		;file not found?
	RET	NZ		;if not
	LD	A,_ERR31 	;program not found
	OR	A		;NZ status
	RET
;
LOAD1	LD	A,($FLAG1)	;get system flag
	CPL			;reverse bits
	AND	@BIT7+@BIT4	;system/sysres load?
	LD	A,0C3H		;JP opcode
	LD	HL,GETBYTM	;alternate fetch
	JR	Z,LOAD1X	;go if yes
	XOR	A		;load zero
	LD	H,A		;pass to HL
	LD	L,A		;3 nop's
LOAD1X	LD	(GETBYTE),A	;pass JP/NOP
	LD	(GETBYTE+1),HL	;pass vector/NOP's
;
	LD	C,-1		;init buff loc
LOAD2	CALL	GETBYTE		;get file byte
	CP	20H		;valid mark?
	JR	C,LOAD3		;go if OK
;
;	file format error!
;
	LD	A,_ERR34	;'file format error'
	OR	A		;set NZ
	RET			;return in error
;
LOAD3	LD	H,A		;H = control byte
	CALL	GETBYTE		;get a byte
	LD	B,A		;B = count
	CALL	GETBYTE		;get a byte
	LD	L,A		;L = LSB address
	DEC	H		;01 header?
	JR	Z,LOAD01	;go if yes
	DEC	H		;02 entry?
	JR	Z,LOAD02	;yes, go!
	DEC	H		;03 terminator?
	JR	Z,LOAD03	;yes, go!
;
;	remove remark block
;
LOAD4	DEC	B		;next
	JR	Z,LOAD2		;go if done
	CALL	GETBYTE		;get a byte
	JR	LOAD4		;continue
;
;	load block, fetch it
;
LOAD01	CALL	GETBYTE		;get MSB address
	LD	H,A		;HL = address
	DEC	B		;less length
	DEC	B		;B = load length
;
LOAD6	CALL	GETBYTE		;get a byte
	LD	(HL),A		;to memory
	CP	(HL)		;still there?
	JR	NZ,LOAD13	;memory error!
	INC	HL		;bump position
	DJNZ	LOAD6		;go for count!
	JR	LOAD2		;go next block
;
;	entry block
;
LOAD02	CALL	GETBYTE		;get address
	LD	H,A		;HL = entry
	XOR	A		;set no error
	RET			;done!
;
;	terminator block
;
LOAD03	CALL	GETBYTE		;next address
	LD	H,A		;HL = vector
	LD	DE,($HIMEM)	;get high memory
	LD	BC,($LOMEM)	;get low memory
	EXX			;swap sets
	LD	HL,RETURN	;point to RET opcode
	XOR	A		;return NO error
	RET			;done!
;
;	read 1 byte from file
;
GETBYTE	NOP
	NOP
	NOP
;
	INC	C		;next
	JR	NZ,LOAD11	;no read
	CALL	$$READNX	;read sector
	JR	NZ,LOAD12	;I/O error
;
LOAD11	PUSH	BC		;save B
	LD	B,$SBUFF<-8	;BC => data
	LD	A,(BC)		;get data
	POP	BC		;restore b
	RET
;
GETBYTM	PUSH	BC		;save
	LD	BC,($SYSPNT)	;get buff pointer
	LD	A,(BC)		;get a byte
	INC	BC		;bump pointer
	LD	($SYSPNT),BC	;update pointer
	POP	BC		;unstack
	RET			;done!
;
LOAD12	POP	BC		;ignore caller
	RET			;done
;
LOAD13	LD	A,_ERR35	;memory error!
	RET			;return NZ
;
;	open param list for load
;
LOADP	DEFW	$SBUFF		;bufadr
	DEFW	$SBUFF		;recadr
	DEFW	0		;EODAD
	DEFB	'R'             ;read
	DEFB	0		;LRL
	DEFB	'F'             ;fixed length
	DEFB	3		;open new LRL
	DEFB	_EBLOCK
;
