; sys0nmi/asm - kjw/bqsd - 04/27/83
;
;	created 04/28/83	- kjw/bqsd
;	revised 06/01/83	- kjw
;
	PAGE
;
@ARATE	EQU	3		;'alive' speed
@ACHAR1	EQU	'*'		;'alive' char 1
@ACHAR2	EQU	'#'		;'alive' char 2
;
@PRTIME	EQU	14		;@PR spool timeout count
@PRMAX	EQU	20		;max chars spool/int.
;
;	storage for current time
;
TIME$	EQU	$
	DEFS	4		;ticks,secs,mins,hours
;
;	storage for current date
;
DATE$	EQU	$
	DEFS	3		;day,month,year
;
;	lookup table for maximum TIME values
;
TIMETBL	DEFB	@TICKS
	DEFB	@SECS
	DEFB	@MINS
	DEFB	@HOURS
;
;	lookup table for month lengths
;
$MONTHS	DEFB	@DAYS+1		;jan
	DEFB	@DAYS-2		;feb
	DEFB	@DAYS+1		;mar
	DEFB	@DAYS		;april
	DEFB	@DAYS+1		;may
	DEFB	@DAYS		;june
	DEFB	@DAYS+1		;july
	DEFB	@DAYS+1		;aug
	DEFB	@DAYS		;sept
	DEFB	@DAYS+1		;oct
	DEFB	@DAYS		;nov
	DEFB	@DAYS+1		;dec
;
;
;	real time clock interrupt service
;
$NMISER	PUSH	AF		;save registers
	PUSH	BC
	PUSH	DE
	PUSH	HL
	PUSH	IX
;
;	force select bank 0
;
	LD	A,($VMASK)	;get video mask
	PUSH	AF		;save on stack
	AND	01110000B	;no video, bank 0
	OR	00000001B	;set bank 1
	LD	($VMASK),A	;reset mask
	OUT	($LBANK),A	;load bank select reg
;
;	clear interrupt latch
;
	IN	A,($RDRTC)	;clear RTC latch
	XOR	A		;init table pointer
;
NMILOOP	PUSH	AF		;save counter
	CALL	NMIEXEC		;execute task
	POP	AF		;restore counter
	INC	A		;next position
	AND	7		;done?
	JR	NZ,NMILOOP	;go for length
;
;	check for motor time out delay
;
	LD	HL,$DTIME	;drive time out counter
	OR	(HL)		;already off?
	JR	Z,NMIXIT	;yes, exit NMI service
	DEC	(HL)		;else dec counter
	JR	NZ,NMIXIT	;go if not time
;
;	de-select all drives
;
	LD	A,01001111B	;select mask
	OUT	($DRSL),A	;de-select drives
;
;	exit NMI interrupt service
;
NMIXIT	POP	AF		;restore bank select
	LD	($VMASK),A	;reset mask
	OUT	($LBANK),A	;reset bank
	POP	IX		;unstack
	POP	HL
	POP	DE
	POP	BC
	POP	AF
	RETN			;return vector
;
;	execute interrupt task
;
NMIEXEC	LD	HL,$RTCTBL	;start RTC task table
	ADD	A,A		;*2
	ADD	A,L		;offset from start
	LD	L,A		;HL => next task slot
	LD	E,(HL)		;get indirect pointer
	INC	L		;bump pointer
	LD	D,(HL)		;get msb pointer
	PUSH	DE		;pass to IX
	POP	IX		;IX => task control block
	JP	(IX)		;go interrupt task!
;
;	nil interrupt task
;
$NOTASK	RET			;done!
;
	PAGE
;
;	$TMTASK - update system clock
;
$TMTASK	LD	HL,TIME$	;point to current time
	LD	DE,TIMETBL	;time maximum table
	LD	B,4		;4 bytes of time
;
TMTASK1	INC	(HL)		;bump counter
	LD	A,(DE)		;get max value
	SUB	(HL)		;compare to new count
	RET	NZ		;not time to change yet
;
	LD	(HL),A		;reset count to zero
	INC	HL		;bump time
	INC	DE		;bump table
	DJNZ	TMTASK1		;go for length time$
;
;	optional date adjust for each 24 hour period
;	leap years adjusted automatically
;
	PUSH	HL		;save day pointer
	INC	HL		;point to month
	LD	A,(HL)		;get it (0-11)
	ADD	A,E		;offset to month table
	LD	E,A		;(DE) = max days/month
	JR	NC,$+3		;go if no overflow
	INC	D		;bump msb
	INC	HL		;point to year
	LD	A,(HL)		;get the year
	AND	3		;check for leap year
	LD	A,@DAYS-2	;28 days for february
	JR	NZ,$+3		;go if not leap year
	INC	A		;else 29 feb leap year
	LD	($MONTHS+1),A	;update FEB count
	POP	HL		;restore day pointer
;
	INC	(HL)		;bump day
	LD	A,(DE)		;get max days this month
	DEC	A		;adjust for test
	SUB	(HL)		;compare to current
	RET	NZ		;not at end of month yet
	LD	(HL),A		;set first day of month
	INC	HL		;point to month
	INC	(HL)		;bump month number
	LD	A,(HL)		;get result
	SUB	12		;end of year yet?
	RET	NZ		;nope, done!
	LD	(HL),A		;set first month
	INC	HL		;point to year
	INC	(HL)		;bump year
	RET			;done!
;
	PAGE
;
;	$PRTASK - real time clock printer spooler
;
$PRTASK	LD	A,@PR		;printer DCB #
	CALL	$$LOCDEV+1	;fetch control block
	BIT	5,(IX+5)	;re-entry interrupt?
	RET	NZ		;yes, ignore output!
;
;	attempt to de-spool character from buffer
;
$SPOOL	LD	C,@PRMAX	;max chars / interrupt
;
SPOOL1	CALL	$BUFTAK		;get a character
	RET	NC		;empty buffer!
	LD	B,@PRTIME	;init time out count
;
SPOOL2	CALL	PRIN		;get status byte
	JR	Z,SPOOL3	;go if ready for byte
	DJNZ	SPOOL2		;go for time out count
	RET			;done, wait next int.
;
SPOOL3	LD	A,(HL)		;get buffer character
	CALL	PROUT		;send character
	LD	(IX+14),E	;update ring pointer
	LD	(IX+15),D
	DEC	C		;less char counter
	JR	NZ,SPOOL1	;go if more to check
	RET			;else done!
;
;	send character to printer device
;
PROUT	BIT	7,(IX+5)	;parallel/serial?
	JR	NZ,PROUTS	;go serial!
	OUT	($PIOBD),A	;send parallel
	RET			;done
PROUTS	OUT	($SIOBD),A	;send serial
	RET			;done
;
;	fetch printer status, return Z if ready
;
PRIN	BIT	7,(IX+5)	;parallel/serial?
	JR	NZ,PRINS	;go serial!
	IN	A,($PIOAD)	;get status
	AND	0F0H		;top 4 bits only
	RET			;done!
PRINS	LD	A,@BIT4		;reset
	OUT	($SIOBC),A	;issue command
	IN	A,($SIOBC)	;get status
	CPL			;reverse bits
	AND	@BIT2		;TX buffer empty?
	RET			;return with status
;
	PAGE
;
;	$CLTASK - real time clock to display service
;
$CLTASK	JR	CLKTASK		;go driver
	DEFB	@TICKS		;# beats / second
;
CLKTASK	DEC	(IX+2)		;time to display?
	RET	NZ		;nope, return
	LD	(IX+2),@TICKS	;reset counter
;
;	setup loop to load ascii time to video
;
	LD	HL,$VSTORE	;video storage block
	LD	DE,TIME$+3	;point to hour
	LD	B,3		;count
;
;	check if 12 or 24 hour clock to be displayed
;
	LD	A,($FLAG2)	;system flag 2
	RLCA			;bit 7 set?
	LD	A,(DE)		;get first char
	JR	NC,CLKTSK3	;go if 24 hour clock
	CP	13		;>12?
	JR	NC,CLKTSK0	;yep, subtract 12
	OR	A		;1-11?
	JR	NZ,CLKTSK3	;go if yes
	ADD	A,24		;change 00 => 12
CLKTSK0	SUB	12		;make 13-24 => 1-12
	JR	CLKTSK3		;go!
;
CLKTSK1	INC	HL		;next video slot
	LD	(HL),':'	;time separator
	INC	HL		;next video slot
;
CLKTSK2	LD	A,(DE)		;get time byte
CLKTSK3	DEC	DE		;move back pointer
	CALL	CLKASC		;quick ascii convert
	LD	(HL),C		;load MSB
	INC	HL		;bump pointer
	LD	(HL),A		;load LSB
	DJNZ	CLKTSK1		;go for 3 loops
;
;	move clock text to video display
;
	LD	BC,4<8+8	;B=offset, C=count
	JR	TOVIDEO		;move to video memory!
;
	PAGE
;
;	$ALTASK - alive to video real time clock service
;
$ALTASK	JR	ALTSK1		;go driver
	DEFB	@ARATE		;time counter
	DEFB	@ACHAR1		;alive character
;
ALTSK1	DEC	(IX+2)		;time?
	RET	NZ		;nope, done!
	LD	(IX+2),@ARATE	;reset counter
	LD	A,(IX+3)	;get char
	XOR	@ACHAR1.XOR.@ACHAR2
	LD	(IX+3),A	;update next char
	LD	HL,$VSTORE	;video storage buffer
	LD	(HL),A		;load char in buffer
	LD	BC,1<8+1	;B=offset, C=count
	JR	TOVIDEO		;move to video memory
;
	PAGE
;
;	$TRTASK - real time clock trace display to video
;
$TRTASK	LD	HL,16		;offset to top of RTC stk
	ADD	HL,SP		;HL => return address
	LD	C,(HL)		;get LSB address
	INC	HL		;bump pointer
	LD	B,(HL)		;get MSB address
	LD	HL,$VSTORE	;video storage
	LD	A,B		;get MSB
	CALL	B2HEX		;convert 2 chars
	LD	A,C		;get LSB
	CALL	B2HEX		;convert 2 chars
	DEC	HL		;point to last char
	LD	BC,13<8+4	;B=offset, C=count
;
;	move characters to video memory from buffer
;
TOVIDEO	LD	A,($FLAG1)	;get system flag
	BIT	5,A		;bank select OK?
	RET	NZ		;go if not!
;
;	compute video location for display
;
	LD	D,$VIDEO<-8	;get MSB video
	LD	A,($DODCB+8)	;get # video columns
	SUB	B		;less video offset
	LD	E,A		;DE => video location
;
;	enable video memory, move in display buffer
;
	CALL	$VSEL		;select video
	LD	B,0		;init MSB count
	LDDR			;move text to video
;
;	restore RTC/VIDEO
;
$$NMION	LD	A,($VMASK)	;get video/bank mask
	OUT	($LBANK),A	;de-select video
	EI			;enable Mode 2 interrupts
	RET			;done!
;
$$NMIOFF
	LD	A,($VMASK)	;get video mask
	AND	01000000B	;no VIDEO/RTC
	OUT	($LBANK),A	;issue command
	DI			;disable Mode 2 interrupts
	RET			;done!
;
	PAGE
;
;	$UTTASK - user real time clock timer task
;
$UTTASK	JR	TMTSK1		;go vector
	DEFB	@TICKS		;# ticks / second
;
TMTSK1	DEC	(IX+2)		;one second passed?
	RET	NZ		;nope, not time yet!
	LD	(IX+2),@TICKS	;reset tick counter
;
;	get # seconds remaining till vector
;
	LD	HL,($UCCNT)	;user timer counter
	DEC	HL		;less this second
	LD	($UCCNT),HL	;update counter
	LD	A,H		;check if time yet
	OR	L		;HL = 0000?
	RET	NZ		;nope, return!
;
;	disable interrupt task and go vector
;
	LD	C,@SLOTUT	;slot # for user timer
	CALL	RESNMI		;disable NMI
	LD	HL,($UCVEC)	;get user vector
	JP	(HL)		;go user vector!
;
;	quick conversion from binary to decimal ascii
;
CLKASC	LD	C,'0'		;init MSB
;
CLKASC1	SUB	10		;check 10's place
	JR	C,CLKASC2	;go if digit found
	INC	C		;else bump ascii digit
	JR	CLKASC1		;go till found
;
CLKASC2	ADD	A,10+'0'	;last sub + ascii
	RET			;CA = ascii chars
;
;	quick conversion from binary to hex ascii
;
B2HEX	PUSH	AF		;save char
	RRCA			;align high bits to low
	RRCA
	RRCA
	RRCA
	CALL	B2HLP		;go for hex digit
	POP	AF		;restore char
;
B2HLP	AND	0FH		;low 4 bits only
	ADD	A,'0'		;add ascii
	CP	'9'+1		;0-9?
	JR	C,$+4		;go if yes
	ADD	A,7		;A-F
	LD	(HL),A		;to buffer
	INC	HL		;bump pointer
	RET			;done
;
	PAGE
;
;	$SOTASK - send data to internal speaker
;
$SOTASK	JR	SOTASK		;continue
	DEFB	0		;counter
;
SOTASK	LD	A,0		;get sound bits
	OUT	($SOUND),A	;issue a 'peep'
	DEC	(IX+2)		;done?
	RET	NZ		;nope, continue
	LD	C,@SLOTSO	;slot number
	JP	RESNMI		;remove task & return
;
