; sys0math/asm - 05/04/83 - kjw/bqsd
;
;	created 02/25/83	- kjw
;	revised 05/05/83	- dwh
;	revised 06/01/83	- kjw
;
;
;	contains the following subroutines
;
;	$MULT	- 24 bit X 8 bit multiply = 32 bit
;	$DIVID	- 24 bit / 8 bit divide = 32 bit + 8 rem.
;	$ADD24	- 24 bit + 24 bit = 24 bit
;	$SUB24	- 24 bit - 24 bit = 24 bit
;	$INC24	- 24 bit + 1 = 24 bit
;	$DEC24	- 24 bit - 1 = 24 bit
;	$CMP24	- 24 bit compared to 24 bit
;	$EXPDEC	- 8/16/24 bits to decimal ascii
;	$EXPHEX	- 8/16/24 bits to hex ascii
;	$VALUE	- 8/16/24 bits to binary from ascii
;	$BINASC	- 8/16/24 bits to ascii in any base
;
	PAGE
;
;	$MULT - SVC 68 - triple precision multiply
;
;	ENT	BHL = multiplicand
;		C   = multiplier
;
;	EXIT	ABHL = result
;
$$MULT	PUSH	IX		;save
	PUSH	DE		;save
;
	PUSH	BC		;save
	LD	A,C		;get multiplier
	LD	C,B		;pass MSB
	EX	DE,HL		;CDE = multiplicand
	LD	HL,0		;init MSB's
	PUSH	HL		;pass to IX
	POP	IX		;HLIX = 00000000
	LD	B,8		;multiplier precision
;
MULT1	ADD	IX,IX		;shift LSB's left
	ADC	HL,HL		;shift MSB's left
	RLCA			;catch overflow
	JR	NC,MULT2	;go if none
	PUSH	BC		;save count/MSB
	ADD	IX,DE		;result + multiplicand
	LD	B,0		;init MSB
	ADC	HL,BC		;catch overflow
	POP	BC		;restore
;
MULT2	DJNZ	MULT1		;for for precision
	POP	BC		;restore C register
	LD	A,H		;get MSB
	LD	B,L		;get NSB
	PUSH	IX		;pass LSB's to HL
	POP	HL		;ABHL = result
	POP	DE		;unstack
	POP	IX		;unstack
	RET			;done, C unchanged
;
	PAGE
;
;	$DIVID - SVC 69 - triple precision divide
;
;	ENT	BHL = dividend
;		C   = divisor
;
;	EXIT	BHL = result
;		A   = remainder
;
$$DIVID	LD	A,C		;get divisor
	OR	A		;/0?
	JR	NZ,DIVD0	;go if not
;
;	attempt to divide by 0 - assume divide by 256
;
	LD	A,L		;shift left one byte
	LD	L,H
	LD	H,B
	LD	B,C
	RET			;BHL+A = BHL/256
;
DIVD0	PUSH	DE		;save it
	LD	D,C		;D = divisor
	LD	E,24		;precision
	XOR	A		;init LSB bits
;
DIVD1	ADD	HL,HL		;shift dividend left
	RL	B		;shift dividend
	RLA			;shift low 8 bits
	JR	C,DIVD2		;go if overflow
	CP	D		;at divisor?
	JR	C,DIVD3		;go if not
;
DIVD2	SUB	D		;less divisor
	INC	L		;quotient +1
;
DIVD3	DEC	E		;less precision
	JR	NZ,DIVD1	;go for 24 bits
	POP	DE		;unstack
	RET			;BHL+A = result
;
	PAGE
;
;	$ADD24 - SVC 81 - triple precision addition
;
;	ENT	BHL = factor 1
;		CDE = factor 2
;
;	EXIT	BHL = sum
;
$$ADD24	LD	A,L		;get LSB
	ADD	A,E		;add LSB
	LD	L,A		;update
	LD	A,H		;get NSB
	ADC	A,D		;add NSB
	LD	H,A		;update
	LD	A,B		;get MSB
	ADC	A,C		;add MSB
	LD	B,A		;update
	RET			;BHL = sum
;
	PAGE
;
;	$SUB24 - SVC 90 - triple precision subtract
;
;	ENT	BHL = factor 1
;		CDE = factor 2
;
;	EXIT	BHL = difference
;
$$SUB24	LD	A,L		;get LSB
	SUB	E		;less LSB
	LD	L,A		;update
	LD	A,H		;get NSB
	SBC	A,D		;less NSB
	LD	H,A		;update
	LD	A,B		;get MSB
	SBC	A,C		;less MSB
	LD	B,A		;update
	RET			;BHL = difference
;
	PAGE
;
;	$INC24 - SVC 93 - triple precision increment
;
;	ENT	BHL = value
;
;	EXIT	BHL = BHL +1
;
$$INC24	INC	L		;bump LSB
	RET	NZ		;not FF => 00
	INC	H		;bump NSB
	RET	NZ		;not FF => 00
	INC	B		;bump MSB
	RET			;BHL = BHL + 1
;
	PAGE
;
;	$DEC24 - SVC 102 - triple precision decrement
;
;	ENT	BHL = value
;
;	EXIT	BHL = BHL -1
;
$$DEC24	LD	A,-1		;init for test
	DEC	L		;dec LSB
	CP	L		;00 => FF?
	RET	NZ		;go if not
	DEC	H		;dec NSB
	CP	H		;00 => FF?
	RET	NZ		;go if not
	DEC	B		;dec MSB
	RET			;BHL = BHL - 1
;
	PAGE
;
;	$CMP24 - SVC 103 - triple precision compare
;
;	ENT	BHL = source value
;		CDE = test value
;
;	EXIT	Z     = BHL = CDE
;		NZ/C  = BHL < CDE
;		NZ/NC = BHL > CDE
;
$$CMP24	LD	A,B		;get MSB
	CP	C		;compare
	RET	NZ		;go if not equal
	LD	A,H		;get NSB
	CP	D		;compare
	RET	NZ		;go if not equal
	LD	A,L		;get LSB
	CP	E		;compare
	RET			;return with status
;
	PAGE
;
;	$EXPDEC	- SVC 72 - convert binary => ascii string
;
;	ENT	DE => string to place ascii
;		C  = precision
;			1 = L   = value, DE => 3 digits
;			2 = HL  = value, DE => 5 digits
;			3 = BHL = value, DE => 8 digits
;
;	EXIT	string loaded with decimal ascii chars
;
$$EXPDEC
	CALL	$$SAVREG	;save registers
	DEC	C		;C=1, prec = L?
	LD	A,3		;3 chars
	JR	Z,EXPDEC1	;go if yes
	DEC	C		;C=2, prec = HL?
	LD	A,5		;5 chars
	JR	Z,EXPDEC2	;go if yes
	DEC	C		;C=3, prec = BHL?
	LD	A,8		;8 chars
	JR	Z,EXPDEC3	;go if yes
;
EXPDEC0	LD	A,_ERR06	;'invalid SVC data'
	OR	A		;set NZ
	RET			;go error!
;
EXPDEC1	LD	H,0		;init NSB
EXPDEC2	LD	B,0		;init MSB
EXPDEC3	LD	C,10		;init base
	JR	DECHEX		;go common
;
	PAGE
;
;	$BINASC - binary to ascii convert
;
;	ENTRY	IX =>	string to contain ascii chars
;		BHL =	binary value to convert
;		D  =	desired length of ascii chars
;		E  =	base to convert binary to
;
;	EXIT	IX =>	ascii string of length D
;
$$BINASC
	CALL	$$SAVREG		;save input registers
	LD	A,D			;get length of string
	LD	C,E			;pass numeric base
	PUSH	IX			;pass string start to DE
	POP	DE			;DE => string to hold ascii
	JR	DECHEX			;go common
;
	PAGE
;
;	$EXPHEX	- SVC 71 - convert binary to hex ascii
;
;	ENT	DE => string to load ascii
;		C  = precision
;			1 = L   = value, DE => 2 digits
;			2 = HL  = value, DE => 4 digits
;			3 = BHL = value, DE => 6 digits
;
$$EXPHEX
	CALL	$$SAVREG	;save registers
	DEC	C		;C=1, prec = L?
	LD	A,2		;# digits
	JR	Z,EXPHEX1	;go if yes
	DEC	C		;C=2, prec = HL?
	LD	A,4		;# digits
	JR	Z,EXPHEX2	;go if yes
	DEC	C		;C=3, prec = BHL?
	LD	A,6		;# digits
	JR	Z,EXPHEX3	;go if yes
	JR	EXPDEC0		;else go error!
;
EXPHEX1	LD	H,0		;init NSB
EXPHEX2	LD	B,0		;init MSB
EXPHEX3	LD	C,16		;init base
;
;	$DECHEX - decimal/hex => ascii
;
;	ENTRY	DE =>	text to load ascii
;		BHL =	value to convert
;		C  =	base of number to convert
;		A  =	count of characters
;
;	EXIT	(DE) =  ascii representation of BHL
;		leading zeroes are stripped
;
DECHEX	PUSH	AF		;save count
	EX	DE,HL		;HL => string
;
DECHEX1	DEC	A		;less count
	JR	Z,DECHEX2	;go if at end
	LD	(HL),' '	;load nil char
	INC	HL		;bump string
	JR	DECHEX1		;go for length
;
DECHEX2	POP	AF		;restore count
	EX	DE,HL		;DE => last character
;
DECHEX3	PUSH	AF		;save char count
	CALL	$$DIVID		;divide BHL/C
	ADD	A,'0'		;make remainder ascii
	CP	'9'+1		;0-9?
	JR	C,$+4		;go if yes
	ADD	A,7		;adjust to A-F
	LD	(DE),A		;char to string
	DEC	DE		;move to next position
;
;	check for value completed
;
	LD	A,B		;get msb
	OR	H		;or nsb
	OR	L		;or lsb
	JR	Z,DECHEX4	;go if result = 000000H
;
	POP	AF		;restore char count
	DEC	A		;less counter
	JR	NZ,DECHEX3	;go if more chars!
	PUSH	AF		;setup for exit
;
DECHEX4	POP	AF		;restore stack
	XOR	A		;set NO error
	RET			;done!
;
	PAGE
;
;	$VALUE - SVC 89 - fetch numeric value from string
;
;	ENT	HL => string to parse
;
;	EXIT	NZ = A = error code (invalid char)
;		Z  = OK, CDE = value
;		HL => terminating character
;
;	NOTE:	HEX/OCTAL/DECIMAL/BINARY may all be
;			interpreted by appending
;			H/O or Q/D/B to the number
;		default base is DECIMAL
;		case is independent
;
$$VALUE	PUSH	BC		;save B from use
	PUSH	HL		;save input pointer
	CALL	POSEND		;find last valid char
;
	LD	C,16		;base
	CP	'H'		;hex?
	JR	Z,GOVAL		;yes, go!
;
	LD	C,8		;base
	CP	'O'		;octal?
	JR	Z,GOVAL		;yes, go!
	CP	'Q'		;octal?
	JR	Z,GOVAL		;yes, go!
;
	LD	C,2		;base
	CP	'B'		;binary?
	JR	Z,GOVAL		;yes, go!
;
	LD	C,10		;base
	CP	'D'		;decimal?
	JR	Z,GOVAL		;yes, go!
	XOR	A		;default decimal
;
GOVAL	LD	(ADDTERM),A	;pass term character
	POP	DE		;restore string start
	LD	B,0		;init MSB
	LD	H,B		;init NSB
	LD	L,B		;init LSB
;
;	loop to evaluate numeric input
;
VALLP	LD	A,(DE)		;get string char
	CALL	$UCASE		;make upper case
	CALL	$CKTERM		;terminator?
	JR	Z,VALEND	;yes, go!
	INC	DE		;bump string pointer
	CP	'$'		;base specifier?
ADDTERM	EQU	$-1
	JR	Z,VALEND	;yes, go!
	CP	' '		;space?
	JR	Z,VALEND	;yes, go!
	CP	','		;comma?
	JR	Z,VALEND	;yes, go!
;
;	convert character
;
	CALL	CONVCHR		;convert to binary
	JR	NZ,VALEND	;error, go!
;
	JR	VALLP		;go next character
;
VALEND	EX	DE,HL		;DE = LSB's, HL=>string
	EX	AF,AF'		;save error code
	LD	A,B		;get MSB value
	POP	BC		;restore BC
	LD	C,A		;pass MSB
	EX	AF,AF'		;get error back
	RET	NZ		;go if error!
	XOR	A		;else set NO error
	RET			;done, CDE = value
;
;	digit to binary conversion
;
CONVCHR	PUSH	AF		;save new digit
	CALL	$$MULT		;BHL = BHL * C
	POP	AF		;restore new digit
;
	SUB	'0'		;remove ascii
	JR	C,CHBAD		;go if <'0'
	CP	10		;0-9?
	JR	C,CHOK		;yes, go!
	CP	17		;between 9&A?
	JR	C,CHBAD		;yes, invalid!
	SUB	7		;A-F?
CHOK	CP	C		;test to base
	JR	NC,CHBAD	;>= base
;
;	add new digit to subtotal
;
	PUSH	BC		;save
	PUSH	DE		;save
	LD	E,A		;pass digit
	LD	D,0		;init NSB
	LD	C,D		;init MSB
	CALL	$$ADD24		;BHL = BHL + CDE
	POP	DE		;unstack
	POP	BC
	XOR	A		;set Z flag
	RET			;done!
;
CHBAD	LD	A,_ERR91	;illegal data range
	OR	A		;set NZ
	RET			;return
;
;	position to last char for base specifier
;
	INC	HL		;bump pointer
POSEND	LD	A,(HL)		;get a char
	CALL	$CKTERM		;terminator?
	JR	Z,POSHAV	;have it, go!
	CP	' '		;space?
	JR	Z,POSHAV	;yes, go!
	CP	','		;comma?
	JR	NZ,POSEND-1	;go next char if none
POSHAV	DEC	HL		;last valid char
	LD	A,(HL)		;get the char
	JP	$UCASE		;make upper case for test
;
	PAGE
;
;	$BINDEC - SVC 21 - binary to ascii and back
;
;	ENTRY	B  =	0 = binary to ascii
;		DE =	binary number to convert
;		HL =>	5 byte string area
;
;		B  <>	0 = ascii to binary
;		HL =>	5 byte ascii string to convert
;
;	EXIT	Z  =	ok (set if bin > ascii)
;		NZ =	A = error code (invalid chars)
;	if B <> 0, DE =	value of string
;
$$BINDEC
	XOR	A		;see if B = 0
	CP	B
	JR	NZ,BINDEC1	;ascii to binary
;
;	convert binary to ascii
;
	CALL	$$SAVREG	;save registers
	EX	DE,HL		;HL=value, DE=>string
	LD	BC,0<8+10	;BHL=value, C=base
	LD	A,5		;# digits to convert
	JP	DECHEX		;go common
;
;	setup for common call
;
BINDEC1	PUSH	BC		;save
	LD	BC,5<8+10	;B=count, C=base
	JR	DHCOMM		;go dec/hex common
;
	PAGE
;
;	$BINHEX - SVC 24 - convert binary > hex
;
;	ENTRY	B  =	0 = binary to ascii hex
;		DE =	binary number to convert
;		HL =>	4 byte string area
;
;		B  <>	0 = ascii hex to binary
;		HL =>	4 byte string to convert
;
;	EXIT	Z =	OK (binary to ascii ALWAYS Z)
;		NZ =	A = error code (invalid chars)
;		if B <> 0, DE = value of string
;
$$BINHEX
	XOR	A		;see if B = 0
	CP	B
	JR	NZ,BINHEX1	;go hex to binary
;
;	convert binary to hex
;
	CALL	$$SAVREG	;save registers
	EX	DE,HL		;HL=value, DE=>string
	LD	BC,0<8+16	;BHL=value, C=base
	LD	A,4		;# digits to convert
	JP	DECHEX		;go common
;
;	hex to binary conversion
;
BINHEX1	PUSH	BC		;save
	LD	BC,4<8+16	;B=count, C=base
;
;	$DHCOMM - common converter for decimal/ascii
;
;	ENTRY	B  =	char count
;		C  =	base of number
;		HL =	string to load
;		DE = 	value to convert
;
;	EXIT	(HL) =	converted value in ascii
;
DHCOMM	PUSH	HL		;save string start
	EX	DE,HL		;DE=>string
	LD	HL,0		;init value
;
DHC1	PUSH	BC		;save
	LD	B,0		;init MSB
	CALL	$$MULT		;BHL = BHL * C
	LD	A,(DE)		;get a char
	CALL	CONVCHR		;convert char and add
	JR	NZ,DHC2		;go if error
	POP	BC		;restore counter
	INC	DE		;bump string
	DJNZ	DHC1		;go for count
;
DHC2	POP	HL		;restore string start
	POP	BC		;restore BC
	RET			;return Z=ok, NZ=error
;
	PAGE
;
;	$MPYDIV - SVC 23 - double multiply/divide
;
;	ENTRY	B = 0 = multiply
;		HL = multiplicand
;		C = multiplier
;
;	EXIT	HL = result (product HL * C)
;		A = overflow byte
;		C flag = overflow
;		Z flag = result is 0000
;
; divide
;	ENTRY	B <> 0 = divide
;		HL = dividend
;		C = divisor
;
;	EXIT	HL = result (quotient HL / C)
;		C = remainder
;		C flag if divide by 0 (not attempted)
;		Z flag = result is 0000
;
; (NOTE) calls may be made directly to MULT and DIVID
;
$$MPYDIV
	XOR	A		;check for way to go
	CP	B		;B = 0?
	JR	NZ,DIVID	;go divide
;
;	multiply routine
;
MULT	PUSH	BC		;save from use
	CALL	$$MULT		;triple
	LD	A,B		;get MSB
	POP	BC		;restore BC
	OR	A		;overflow?
	SCF			;carry = yes
	RET	NZ		;go if overflow
	OR	H
	OR	L
	RET			;return Z/NZ & NC
;
;	divide routine
;
DIVID	LD	A,C		;get divisor
	OR	A		;zero?
	SCF			;carry if yes
	RET	Z		;cannot divide
	PUSH	BC		;save B
	LD	B,0		;MSB
	CALL	$$DIVID		;triple
	POP	BC		;restore B
	LD	C,A		;remainder
	LD	A,H		;get flags on HL
	OR	L
	RET			;done
;
