; sys0ki/asm - kjw/bqsd - 04/27/83
;
;	created 04/28/83	- kjw/bqsd
;	revised 06/02/83	- kjw
;
	PAGE
;
;	system keyboard driver
;
;	ENTRY	IX =>	keyboard DCB
;
;	EXIT	Z  =	OK, B = character
;		NZ =	A = error code (02 'not avail')
;
$KIDVR	BIT	1,(IX+5)	;chaining?
	JR	NZ,KBCHAIN	;yes, get char from file
;
;	check if KSM char pending
;
	BIT	0,(IX+20)	;KSM char pending?
	JR	NZ,KBKSM	;yes, get from buffer
;
;	fetch character from keyboard buffer
;
	CALL	$BUFTAK		;character available?
	JR	NC,KBDEMP	;no chars available!
	LD	(IX+14),E	;update spool pointer
	LD	(IX+15),D
;
;	check for translation
;
	LD	B,A		;pass char
	CALL	$XLATE		;translate character
	LD	A,B		;get xlated char
;
;	check for new KSM character
;
	BIT	1,(IX+20)	;KSM active?
	JR	Z,KI1		;go if not
	CP	20H		;control code?
	JR	C,KSMINT	;locate KSM char
;
;	check for screen printer control
;
KI1	CP	_CANCEL		;control -?
	JR	Z,KI3		;go screen print if yes
;
KEYRET	LD	B,A		;pass key to B
	XOR	A		;return no error
	RET			;done, B=key
;
KI3	LD	A,@PR		;printer DCB #
	CALL	$$LOCDEV+1	;locate DCB
	PUSH	IX		;pass to DE
	POP	DE		;DE => DCB
	CALL	$$SCREEN	;send screen to printer
;
KBDEMP	LD	A,_ERR02	;'char not available'
	OR	A		;set NZ/NC
	RET			;return nil chars
;
;	CHAIN file handler
;
KBCHAIN	LD	E,(IX+16)	;get do FCB address
	LD	D,(IX+17)
	CALL	$$GET		;get char from file
	RET	Z		;go if no error
;
;	error on file or completed
;	turn off chaining and reclaim buffer space
;
	RES	1,(IX+5)	;turn off chaining
	EX	DE,HL		;HL => FCB
	DEC	H		;point to buffer
	LD	DE,@DCBLEN+@BUFLEN
	LD	B,1		;bank #1
	CALL	MEMCTL7		;reclaim memory
	JR	$KIDVR		;check for keyboard keys
;
;	locate KSM key string
;
KSMINT	LD	B,A		;save char
	LD	L,(IX+21)	;get KSM table address
	LD	H,(IX+22)
	INC	A		;adjust 0-31 => 1-32
	LD	E,A		;pass key posit to E
	JR	KSMNXT		;locate entry
;
KSMLOOK	LD	A,(HL)		;get a char
	INC	HL		;bump pointer
	RLCA			;shift bit 7
	JR	NC,KSMLOOK	;look for high bit
;
KSMNXT	DEC	E		;less char count
	JR	NZ,KSMLOOK	;go for count
;
;	HL => ksm character string, check for NIL
;
	LD	A,(HL)		;get char start
	INC	A		;anything?
	LD	A,B		;get original char
	JR	Z,KI1		;use original key if nil
	SET	0,(IX+20)	;set KSM pending
	JR	KSMGET		;else get key
;
;	fetch char from current KSM buffer
;
KBKSM	LD	L,(IX+23)	;get KSM char pointer
	LD	H,(IX+24)	;HL => current char
;
KSMGET	LD	A,(HL)		;get character from buff
	OR	A		;check if last char
	RES	7,A		;turn off high bit
	INC	HL		;point to next char
	LD	(IX+23),L	;update pointer
	LD	(IX+24),H
	JP	P,KEYRET	;not last, return char
;
	RES	0,(IX+20)	;turn off KSM pending
	JR	KEYRET		;return with last char
;
	PAGE
;
;	$KBPUT - SVC 30 - add char to type ahead buffer
;
;	ENTRY	B  =	character to add
;
;	EXIT	Z  =	character added OK
;		NZ =	A = error code
;
$$KBPUT
	CALL	$$SAVREG	;save registers
	LD	A,@KI		;keyboard DCB
	CALL	$$LOCDEV+1	;locate DCB
	LD	A,B		;get character
	DI			;disable key interrupt
	CALL	KBTASK1		;to type ahead buffer
	OR	A		;clear carry flag
	BIT	7,(IX+5)	;buffer overflow?
	LD	A,_ERR33	;'buffer overflow'
	RET	NZ		;go if no room
	XOR	A		;else OK
	RET			;done!
;
	PAGE
;
;	$KBINT - keyboard interrupt vector
;
$KBINT	PUSH	AF		;save
	PUSH	IX		;save
	LD	A,@KI		;keyboard DCB #
	CALL	$$LOCDEV+1	;locate DCB
	IN	A,($RDKBD)	;get keyboard key
	CALL	KBTASK1		;add to spool buffer
	POP	IX		;unstack
	POP	AF		;unstack
	RET			;done
;
;	$KBTASK1 - add character to type-ahead buffer
;
KBTASK1	PUSH	HL		;save
	PUSH	DE		;save
	RES	7,(IX+5)	;assume key handled
;
;	check for strip of high bit
;
	BIT	7,(IX+20)	;strip high bit?
	JR	NZ,$+4		;go if no strip
	AND	@BIT7.XOR.-1	;remove bit 7
;
;	check for HOLD key
;
CKHLD	CP	_HOLD		;hold key?
	JR	NZ,CKBRK	;nope, continue
	SET	2,(IX+5)	;set HOLD pending
	BIT	4,(IX+5)	;HOLD processor ON?
	JR	NZ,KBDRET	;go if yes!
;
;	check for BREAK key
;
CKBRK	CP	_BREAK		;break key?
	JR	NZ,PUTKEY	;nope, go!
	BIT	6,(IX+5)	;break key enabled?
	JR	NZ,KBDRET	;nope, discard it!
;
;	check for debugger
;
	LD	HL,$FLAG2	;system flag #2
	BIT	0,(HL)		;debug on?
	JR	Z,NOTDBG	;nope, go!
	BIT	2,(HL)		;debug trigger?
	JR	NZ,NOTDBG	;nope, go!
;
;	immediate entry to debugger
;
	LD	HL,$$DEBUG	;debug vector
	JR	KBRET1		;go debug!
;
NOTDBG	BIT	5,(IX+5)	;break processor on?
	JR	Z,PUTKEY	;nope, continue
;
;	immediate entry to user break vector
;
	LD	L,(IX+18)	;get processor vector
	LD	H,(IX+19)
;
KBRET1	POP	DE		;restore DE
	EX	(SP),HL		;get HL, leave vector
	EI			;enable interrupts
	RETI			;return from interrupt
;
;	add key to type-ahead buffer
;
PUTKEY	CALL	$BUFADD		;add to buffer
	SET	7,(IX+5)	;set key lost
	JR	NC,KBDRET	;go if no room to add
	LD	(IX+12),E	;update ring pointer
	LD	(IX+13),D
	RES	7,(IX+5)	;key added to buffer
;
KBDRET	POP	DE		;unstack
	POP	HL		;restore
	EI			;enable interrupts
	RETI			;return from interrupt
;
	PAGE
;
;	$KBLINE - SVC 5 - fetch string from keyboard
;
;	ENTRY	HL =>	key input buffer
;		B  =	max keys to input
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;		HL =>	input buffer
;		B  =	actual # keys input
;		C  =	line termination (0/0D)
;		Cy =	line terminated with BREAK
;
$$KBLINE
	LD	A,($KIDCB+25)	;get prompt char
	CALL	FILCLR		;clear buffer
	LD	C,B		;pass maximum length
	LD	B,0		;pass current length
;
;	$KBEDIT - SVC 68 - edit text string from keyboard
;
;	ENTRY	HL =>	prompt text/input buffer
;		B  =	current length of input
;		C  =	maximum length of input
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;		HL =>	input buffer start
;		B  =	actual number of chars input
;		C  =	line term flag (0/0D)
;		Cy =	line terminated with BREAK
;
$$KBEDIT
	LD	(KBSTART),HL	;save buffer start
	PUSH	DE		;save from use
	PUSH	BC		;save from init
	LD	B,_ENQ		;store cursor
	CALL	$$VDCHAR	;save cursor
	JP	NZ,KBERR	;go if error!
	LD	B,-1		;set ON flag
	CALL	$$CURSOR	;cursor ON
	JP	NZ,KBERR	;go if error!
	POP	BC		;restore length
	LD	D,0		;init cursor pointer
;
KBEDIT0	CALL	KBDRAW		;draw prompt, set cursor
	JP	NZ,KBERR+1	;go if error!
;
KBEDIT1	PUSH	BC		;save counters
	CALL	$$KBDW		;get key character
	JP	NZ,KBERR	;go if error!
	LD	A,B		;get input char
	POP	BC		;restore counters
;
	PUSH	HL		;save buff pointer
	LD	HL,KBEDIT0	;return vector
	EX	(SP),HL		;leave, get HL
;
;	check for control keys
;
	PUSH	HL		;save HL
	LD	HL,KBTBL	;keyboard lookup table
	PUSH	BC		;save count
	LD	B,A		;pass char
	CALL	$$LOOKUP	;locate in table
	LD	A,B		;restore char
	POP	BC		;restore counters
	EX	(SP),HL		;leave vector, get HL
	RET	Z		;go if valid key
	EX	(SP),HL		;dummy pop vector
	POP	HL		;restore
;
;	check for displayable character
;
	JR	KEYRCM		;go common
;
;	cursor right
;
KEYRHT	LD	A,(HL)		;get buffer byte
;
;	load character, move cursor right
;
KEYRCM	EX	AF,AF'		;save key
	LD	A,D		;get current pointer
	CP	C		;at max length?
	RET	Z		;yes, do not change
	INC	A		;+ one
	CP	B		;at input length?
	JR	C,$+3		;go if not
	LD	B,A		;else set new max
	LD	D,A		;update current pointer
	EX	AF,AF'		;get char back
	LD	(HL),A		;to buffer
	INC	HL		;bump buffer pointer
	RET			;done, redraw!
;
;	move cursor to end of significant text
;
KEYUNR	LD	A,B		;get max length
	CP	D		;pointer there?
	RET	Z		;yes, at end!
	CALL	KEYRHT		;move cursor right!
	JR	KEYUNR		;continue
;
;	cursor left
;
KEYLEF	LD	A,D		;get pointer offset
	OR	A		;at beginning?
	RET	Z		;yes, no adjust
	DEC	D		;pointer left
	DEC	HL		;buffer left
	RET			;done!
;
;	cursor left with destruct
;
KEYLDS	LD	A,D		;get pointer offset
	OR	A		;at beginning?
	RET	Z		;yes, do not change!
	DEC	D		;else move pointer back
	DEC	HL		;move buffer back
	EX	AF,AF'		;save pointer
	LD	A,($KIDCB+25)	;get prompt char
	LD	(HL),A		;to buffer
	EX	AF,AF'		;get pointer
	CP	B		;pointer at end?
	RET	NZ		;nope, go!
	DEC	B		;else dec B also
	RET			;done
;
;	delete mode
;
KEYDEL	PUSH	HL		;save string start
	LD	HL,BUFLFT	;vector
	JR	KEYINDE		;go common
;
;	insert mode
;
KEYINS	PUSH	HL		;save string
	LD	HL,BUFRHT	;vector
;
KEYINDE	LD	(KEYCAL),HL	;pass vector
	POP	HL		;restore buff pointer
	LD	A,C		;get max keys input
	SUB	D		;less pointer
	RET	Z		;nothing
	DEC	A		;less one
	RET	Z		;only one char!
;
	PUSH	BC		;save counters
	LD	C,A		;C = count
	LD	B,0		;BC = count
	CALL	$		;call insert/delete
KEYCAL	EQU	$-2
	POP	BC		;restore count
	PUSH	HL		;save HL
	LD	HL,(KEYCAL)	;get vector
	INC	HL		;bump
	INC	HL		;bump
	EX	(SP),HL		;get HL, leave vector
	RET			;go update!
;
;	move down for delete
;
BUFLFT	JR	LFTBUF		;go move
;
;	update cursor pointers
;
	LD	A,B		;get current length
	SUB	D		;less position
	RET	Z		;at current
	DEC	B		;else less deleted char
	RET			;done!
;
LFTBUF	PUSH	BC		;save
	PUSH	DE		;save
	PUSH	HL		;save
;
	LD	D,H		;pass start to DE
	LD	E,L		;DE = start
	INC	HL		;HL = start +1
	LDIR			;move buffer
	JR	BUFRL		;continue
;
;	move buffer right for insert
;
BUFRHT	JR	RHTBUF		;continue
;
;	update cursor pointers
;
	LD	A,C		;get max length
	SUB	B		;at max?
	RET	Z		;yes, cannot change
	INC	B		;bump max length
	RET			;done!
;
RHTBUF	PUSH	BC		;save
	PUSH	DE
	PUSH	HL
;
	ADD	HL,BC		;HL => end
	LD	D,H		;pass to DE
	LD	E,L		;DE => end
	DEC	HL		;HL => end-1
	LDDR			;shift right
;
BUFRL	LD	A,($KIDCB+25)	;get cursor char
	LD	(DE),A		;nil first/last char
;
	POP	HL		;unstack
	POP	DE
	POP	BC
	RET			;done!
;
;	reset pointer to start and clear line
;
KEYRES	LD	A,D		;get current posit
	OR	A		;at beginning?
	RET	Z		;yes, go!
	CALL	KEYLEF		;move cursor left
	JR	KEYRES		;continue!
;
;	clear to end of line
;
KEYESC	LD	A,C		;get max length
	SUB	D		;less pointer
	RET	Z		;nothing to clear
	LD	B,A		;pass length
	LD	A,($KIDCB+25)	;get prompt char
	CALL	FILCLR		;clear buffer
	LD	B,D		;reset max length
	RET			;done!
;
;	clear buffer block
;
FILCLR	PUSH	HL		;save start
	PUSH	BC		;save length
;
FILCLR1	LD	(HL),A		;char to buffer
	INC	HL		;bump pointer
	DJNZ	FILCLR1		;go for length
;
	POP	BC		;unstack
	POP	HL
	RET			;clear!
;
;	exit vectors
;
KEYBRK	SCF			;carry = break
KEYENT	EX	(SP),HL		;remove return vector
	POP	HL		;done!
	PUSH	AF		;save flags
;
;	blank to end of line
;
	CALL	KEYUNR		;cursor to max length
	LD	A,($KIDCB+25)	;get prompt char
	PUSH	AF		;save on stack
	LD	A,' '		;load blank
	LD	($KIDCB+25),A	;set new char
	CALL	KEYESC		;clear to end
	POP	AF		;get prompt char
	LD	($KIDCB+25),A	;save char
;
;	redraw new line and turn off cursor
;
	PUSH	BC		;save
	CALL	KBDRAW		;display resulting line
	LD	B,0		;command
	CALL	$$CURSOR	;cursor OFF
	LD	B,_CR		;carriage return
	CALL	Z,$$VDCHAR	;do it
	POP	BC		;restore
;
	LD	A,C		;get input length
	SUB	B		;less current length
	JR	Z,KEYMAX	;at maximum
	LD	A,_CR		;else load CR
	LD	(HL),A		;to buffer
KEYMAX	LD	C,A		;pass term flag
	POP	AF		;get flags back
;
;	set Z flag for no error, leave carry
;
	LD	A,0		;set no error
	INC	A		;set Z flag
	DEC	A
	PUSH	BC		;setup for exit
;
KBERR	POP	BC		;restore BC
	POP	DE		;restore DE
	LD	HL,$		;get string start
KBSTART	EQU	$-2
	RET			;return with status
;
;	re-draw current string
;
KBDRAW	PUSH	HL		;save current pointer
	PUSH	BC		;save lengths
	PUSH	DE		;save cursor pointer
;
;	reset cursor to entry point
;
	LD	B,0		;command
	CALL	$$CURSOR	;cursor OFF
	JR	NZ,KBXIT	;go if error
	LD	B,_ACK		;restore cursor
	CALL	$$VDCHAR	;display it
	JR	NZ,KBXIT	;go if error!
	LD	HL,(KBSTART)	;start prompt string
	CALL	VDDRAW		;redraw video!
	JR	NZ,KBXIT	;go if error
	LD	B,_ACK		;restore cursor
	CALL	$$VDCHAR	;display it
	JR	NZ,KBXIT	;go if error
	POP	AF		;get cursor posit
	PUSH	AF		;save again
	INC	A		;adjust position
	LD	C,A		;pass count
	LD	B,_GS		;cursor right
;
KBFIX	DEC	C		;less count
	JR	Z,KBREST	;go if done!
	CALL	$$VDCHAR	;move cursor
	JR	NZ,KBXIT	;go if error
	JR	KBFIX		;continue
;
KBREST	LD	B,-1		;set command
	CALL	$$CURSOR	;cursor ON
;
KBXIT	POP	DE		;restore stack
	POP	BC
	POP	HL
	RET			;done!
;
;	re-display string, convert control chars
;
VDDRAW	LD	A,(HL)		;get a char
	INC	HL		;bump to next
	CP	20H		;displayable?
	JR	NC,$+4		;go if yes
	LD	A,_CANCEL	;else convert char
	LD	B,A		;pass to B
	CALL	$$VDCHAR	;display char
	RET	NZ		;go if error
	DEC	C		;less counter
	JR	NZ,VDDRAW	;go for count
	RET			;done!
;
;	lookup table for $KBEDIT editing commands
;
KBTBL	DEFB	_UP		;up arrow?
	DEFW	KEYINS		;insert mode
	DEFB	_DOWN		;down arrow?
	DEFW	KEYDEL		;delete mode
	DEFB	_LEFT		;left arrow?
	DEFW	KEYLEF		;cursor left
	DEFB	_RIGHT		;right arrow?
	DEFW	KEYRHT		;cursor right
	DEFB	_ESCAPE		;escape key?
	DEFW	KEYESC		;clear to end of line
	DEFB	_BACKSP		;backspace key?
	DEFW	KEYLDS		;move cursor left
	DEFB	_BREAK		;break key?
	DEFW	KEYBRK		;terminate
	DEFB	_ENTER		;enter key?
	DEFW	KEYENT		;terminate
	DEFB	_F1		;F1 key?
	DEFW	KEYRES		;reset to beginning
	DEFB	_F2		;F2 key?
	DEFW	KEYUNR		;cursor to end
	DEFB	_ETBL		;end of table
;
