; sys0init/asm - kjw/bqsd - 05/10/83
;
;	created 05/10/83	- kjw/bqsd
;	revised 06/01/83	- kjw
;
	PAGE
;
;	PowerDOS Cold start initialization
;
CKSUM	EQU	000H		;title checksum
DCTSAV	EQU	2200H		;DCT from BOOT storage
;
ENTRY	DI			;no interrupts
	LD	SP,$STAK	;init stack
	IM	2		;interrupt MODE 2
	LD	A,$M2DATA<-8	;MSB interrupt table
	LD	I,A		;set interrupt register
	LD	HL,$$JP2DOS	;dos exit vector
	PUSH	HL		;to the stack
;
;	save current cylinder # to DCT0
;
	EXX			;swap registers
	LD	A,D		;get current cylinder
	LD	($0DCT+9),A	;save it
;
;	locate memory banks and hi/lo memory
;
	LD	B,15		;init bank #
TEST1	CALL	TESTB		;locate HIMEM in bank#
	JR	NZ,TEST2	;go if no memory!
;
;	set memory bank available
;
	PUSH	BC		;save bank #
	LD	HL,$BANKA	;available banks
	CALL	BSETUP		;setup for bank select
	LD	A,(HL)		;get bank flag
	OR	C		;set bank as available
	LD	(HL),A		;update bank bit
	POP	BC		;restore bank
;
TEST2	DJNZ	TEST1		;go for 16 banks
	INC	B		;set bank 1
	CALL	TESTB		;get highmem bank 1
	LD	($HIMEM),HL	;top available memory
	LD	($PHYMEM),HL	;top physical memory
;
;	init vectors and flags
;
	LD	HL,$CMDBUFF	;command buffer
	LD	($IPOINT),HL	;init cmd pointer
	LD	(HL),_CR	;force end of text
;
;	save AUTO command
;
	LD	HL,DCTSAV+32	;auto command here
	LD	DE,AUTOSAV	;store it here
	LD	BC,80		;maximum length
	LDIR			;saved!
;
;	pass LOGO/DATE/TIME flags
;
	LD	A,(DCTSAV+24)	;LOGO flag
	LD	(LOGO@),A
	LD	A,(DCTSAV+25)	;DATE flag
	LD	(DATE@),A
	LD	A,(DCTSAV+26)	;TIME flag
	LD	(TIME@),A
;
;	initialize system DCT
;
	LD	HL,DCTSAV+7	;HL => DCT data
	BIT	4,(HL)		;rigid drive?
	LD	DE,$0DCT+10	;DE => perishable DCT
	LD	BC,17		;data length
	LDIR			;init DCT data
	JR	Z,SETUP1	;go if floppy drive
;
;	booting from rigid drive
;
	LD	IY,$0DCT	;IY => 0 dct
	SET	5,(IY+5)	;set rigid bit
	LD	(IY+7),0	;default step rate
	LD	A,8		;new device init count
	LD	(IDATA),A	;don't re-init rigid
;
;	initialize support chips
;
SETUP1	LD	HL,IDATA	;initialization data
	LD	E,(HL)		;device count
	INC	HL		;point to data
;
SETUP2	LD	B,(HL)		;get device port address
	INC	HL		;bump table
	LD	C,(HL)		;get byte count
	INC	HL		;bump table
	OTIR			;send data to port
	DEC	E		;less device counter
	JR	NZ,SETUP2	;go if more
;
;	initialize NMI/INT routines
;
	IN	A,($DMA)	;clear DMA
	IN	A,($RDRTC)	;clear RTC
	IN	A,($RDNMI)	;clear NMI
	IN	A,($RDKBD)	;clear KBD
	EI			;enable M2 interrupts
;
	PAGE
;
;	check for checksum on header display
;
	LD	HL,LOGO1	;header message
	LD	BC,LOGO1L<8+0	;length + checksum
;
SETUP3	LD	A,(HL)		;get data byte
	ADD	A,C		;add to checksum
	LD	C,A		;put it back
	INC	HL		;bump pointer
	DJNZ	SETUP3		;go for length
	CP	CKSUM		;is it OK?
	JR	SETUP4		;yes, go!
;
;	title changed! copyright violated!
;
	DI			;turn off interrupts
	JP	$		;just hold here
;
;	display title/copyright
;
SETUP4	LD	HL,LOGO1	;block 1 (text)
	CALL	$$DSPLY		;display
;
;	optional graphic logo display
;
	LD	A,0		;flag for LOGO
LOGO@	EQU	$-1
	INC	A		;logo on?
	JP	NZ,SCAN 	;don't display it
;
	LD	HL,LOGO2	;graphic logo data
	LD	BC,4<8+0	;row + column to start
	LD	DE,@COLS2<8+6	;row length + # rows
;
SETUP5	CALL	$$VDGRAF	;display row
	PUSH	BC		;save cursor
	LD	BC,@COLS2	;length of video line
	ADD	HL,BC		;new data offset
	POP	BC		;restore cursor
	INC	B		;bump row position
	DEC	E		;less row counter
	JR	NZ,SETUP5	;finish 5 rows
	LD	B,_CR		;send C/R
	CALL	$$VDCHAR	;send CR
	JP	SCAN		;skip to high overlay
;
;	select memory bank and test memory block
;
TESTB	LD	A,($VMASK)	;get video/bank mask
	AND	11110000B	;drop bank #
	OR	B		;set bank #
	LD	($VMASK),A	;save mask
	OUT	($LBANK),A	;load bank sel register
;
	LD	HL,-1		;init highmemory
TESTC	LD	A,(HL)		;get data byte
	CPL			;reverse bits
	LD	(HL),A		;update buffer
	CP	(HL)		;memory there?
	CPL			;reset to original
	LD	(HL),A		;update
	RET	Z		;go if memory there!
	LD	A,H		;get MSB
	SUB	20H		;less 8K
	LD	H,A		;update address
	CP	80H		;HL > 7FFFH?
	JR	NC,TESTC	;go if yes
	OR	-1		;set NZ for NO memory
	RET			;done!
;
	PAGE
;
;	init data for Z80 support chips
;
IDATA	DEFB	9		;device count
;
;	init for Z80 PIO
;
	DEFB	5		;data count
	DEFB	$PIOAC		;PIOA config port
	DEFB	00H		;interrupt vector
	DEFB	11001111B	;bit mode
	DEFB	11110111B	;I/O mask
	DEFB	00110111B	;interrupt off
	DEFB	11111110B	;interrupt mask
;
	DEFB	3		;data count
	DEFB	$PIOBC		;PIOB config port
	DEFB	00H		;interrupt vector
	DEFB	00001111B	;output mode
	DEFB	00000111B	;no interrupt
;
;	init for Z80 SIO
;
	DEFB	9		;data count
	DEFB	$SIOAC		;device address port
	DEFB	00011000B	;channel reset
	DEFB	4		;WR4
	DEFB	01000100B	;X16, S=1
	DEFB	3		;WR3
	DEFB	11100001B	;W=8, auto, RX
	DEFB	5		;WR5
	DEFB	11101010B	;DTR, W=8, TX, RTS
	DEFB	1+00010000B	;RESET, int,WR1
	DEFB	00011000B	;int on all RX chars
;
	DEFB	11		;data count
	DEFB	$SIOBC		;device address port
	DEFB	00011000B	;channel reset
	DEFB	4		;WR4
	DEFB	01000100B	;X16, S=1
	DEFB	3		;WR3
	DEFB	11100001B	;W=8, auto, RX
	DEFB	5		;WR5
	DEFB	11101010B	;DTR, W=7, TX, RTS
	DEFB	2		;WR2
	DEFB	$M2DATA		;interrupt vector
	DEFB	1+00010000B	;reset, int, WR1
	DEFB	00011100B	;int on all RX chars
;
;	init for Z80 CTC
;
	DEFB	3		;data count
	DEFB	$CTC0		;device address port
	DEFB	00000111B	;reset, TC follows
	DEFB	00110100B	;time constant 300 baud
	DEFB	$M2DATA+16 	;interrupt vector
;
	DEFB	2		;data count
	DEFB	$CTC1		;device address
	DEFB	00000111B	;reset, TC follows
	DEFB	00110100B	;time constant 300 baud
;
	DEFB	2		;data count
	DEFB	$CTC2		;device address port
	DEFB	00000111B	;reset, TC follows
	DEFB	00110100B	;time constant 300 baud
;
	DEFB	2		;data count
	DEFB	$CTC3		;device address port
	DEFB	11000111B	;RESET, TC follows
	DEFB	00000001B	;time constant
;
;	init for rigid I/O
;
	DEFB	3		;data count
	DEFB	0C1H		;device address port
	DEFB	00000000B
	DEFB	00010000B
	DEFB	00001100B
;
	PAGE
;
;	block of LOGO data here (max 5 pages)
;	insert graphic portion of display
;
LOGO2	EQU	$		;start
;
	DC	80,0A0H
	DC	80,0A0H
	DC	80,0A0H
	DC	80,0A0H
	DC	80,0A0H
	DC	80,0A0H
;
LOGO2L	EQU	$-LOGO2
;
	PAGE
;
;	messages and text strings
;
LOGO1	DEFM	'PowerDOS - '
	DEFM	'PowerSOFT''s Disk Operating System - '
	DEFM	'Models II/12/16'
	DEFB	_CR
	DEFM	'Copyright (C) 1983 by '
	DEFM	'Breeze/QSD, Inc. - '
	DEFM	'Dallas, Texas - '
	DEFM	'Series B.00/Z80'
	DEFB	_CR
	DEFB	_CR
	DEFB	_ETX
LOGO1L	EQU	$-LOGO1
;
	PAGE
;
;	check keyboard for override commands
;
	ORG	$HISYS		;upper system overlay
;
SCAN	CALL	$$KBCHAR	;scan keyboard
	LD	A,0		;assume nil
	JR	NZ,$+3		;go if no key
	LD	A,B		;else get key
	CALL	$UCASE		;make upper case
	LD	(KEY),A 	;save input key
;
;	check for valid date
;
	LD	HL,DATEPMT	;prompt for date
	CALL	$$DSPLY		;display to video
;
CKDATE	LD	HL,RESDT	;reset cursor
	CALL	$$DSPLY		;display it
;
	LD	HL,DATE$	;start date storage
	LD	DE,DATECHK	;maximum values
	CALL	VALDATI		;valid?
	JR	Z,DSPDATE	;yes, display it
;
;	check if user to be prompted for date
;
	LD	A,0		;flag for DATE
DATE@	EQU	$-1
	INC	A		;prompt for date?
	JR	Z,ASKDATE	;yes, prompt for it!
;
;	no prompt, reset to initial values
;
CLRDATE	LD	HL,DATE$	;point to date$
	CALL	VALCLR		;clear to zeroes!
	JR	CKDATE		;re-display date
;
;	optional date$ prompt
;
ASKDATE	LD	HL,TBUFF	;temp key buffer
	LD	B,10		;max key input length
	CALL	$$KBLINE	;fetch user input
	JR	C,CLRDATE	;break, clear it!
;
;	fetch date from input
;
	LD	B,1		;command
	CALL	$$DATE		;load it
	JR	Z,CKDATE	;go if OK!
	LD	HL,RESDT	;reset cursor
	CALL	$$DSPLY		;reset
	JR	ASKDATE		;re-prompt user
;
;	display current date
;
DSPDATE	LD	IY,DATE$	;point to date
	LD	HL,DSPDT	;display text
	PUSH	HL		;save text start
	LD	B,'/'		;init separator
	LD	A,(IY+1)	;get month
	INC	A		;adjust to actual
	CALL	ASCDT		;date/time ascii
	LD	(HL),B		;separator
	INC	HL		;bump
	LD	A,(IY+0)	;get day
	INC	A		;correct
	CALL	ASCDT		;date/time ascii
	LD	(HL),B		;separator
	INC	HL		;bump
	LD	A,($BYEAR)	;get base year
	ADD	A,(IY+2)	;add to current year
	CALL	ASCDT		;to decimal ascii
	POP	HL		;restore text start
	CALL	$$DSPLY		;display date!
;
	PAGE
;
;	check for TIME input
;
	LD	HL,TIMEPMT	;time prompt
	CALL	$$DSPLY		;display prompt
;
CKTIME	LD	HL,RESDT	;reset cursor
	CALL	$$DSPLY		;display it
;
	LD	HL,TIME$+1	;start time storage
	LD	DE,TIMECHK	;maximum values
	CALL	VALDATI		;valid entry?
	JR	Z,DSPTIME	;yes, display time
;
;	check if user to be prompted for time
;
	LD	A,0		;flag for TIME
TIME@	EQU	$-1
	INC	A		;time prompt?
	JR	Z,ASKTIME	;yes, prompt for it
;
;	reset time$ to initial values
;
CLRTIME	LD	HL,TIME$+1	;start time$
	CALL	VALCLR		;clear to zeroes
	JR	CKTIME		;display time
;
;	optional TIME$ prompt
;
ASKTIME	LD	HL,TBUFF	;temp key buffer
	LD	B,8		;input length
	CALL	$$KBLINE	;get input from user
	JR	C,CLRTIME	;break, clear it!
;
;	fetch input data from string
;
	LD	B,2		;command
	CALL	$$DATE		;load TIME$
	JR	Z,CKTIME	;OK, display new time
	LD	HL,RESDT	;reset cursor
	CALL	$$DSPLY		;display
	JR	ASKTIME		;re-prompt user
;
;	display time to video
;
DSPTIME	LD	IY,TIME$+1	;point to time$
	LD	HL,DSPDT	;text start
	PUSH	HL		;save start
	LD	B,':'		;separator
;
	LD	A,(IY+2)	;get hour
	CALL	ASCDT		;to decimal ascii
	LD	(HL),B		;separator
	INC	HL		;bump
	LD	A,(IY+1)	;get minute
	CALL	ASCDT		;to decimal ascii
	LD	(HL),B		;separator
	INC	HL		;bump
	LD	A,(IY+0)	;get seconds
	CALL	ASCDT		;to decimal ascii
	POP	HL		;get text start
	CALL	$$DSPLY		;display to video
;
	PAGE
;
;	check for AUTO information
;
CKAUTO	LD	HL,AUTOSAV	;start AUTO command
	LD	BC,80<8+0	;B=max length, C=flags
;
IAUTO1	LD	A,(HL)		;get char
	CP	'!'             ;non-breakable?
	JR	NZ,IAUTO2	;go if not
	SET	0,C		;set non-break
	JR	IAUTO3		;continue
IAUTO2	CP	'#'             ;invisible display?
	JR	NZ,IAUTO4	;go if not
	SET	1,C		;set invisible
IAUTO3	INC	HL		;bump pointer
	DJNZ	IAUTO1		;go till data
	RET			;nothing, abort auto!
;
;	check for characters
;
IAUTO4	BIT	0,C		;non-breakable?
	JR	NZ,IAUTO5	;yes, cannot DEBUG
	LD	A,(KEY) 	;get saved key
	CP	_ENTER		;no auto?
	RET	Z		;abort AUTO if yes
	SUB	'D'             ;DEBUG?
	JP	Z,$$DEBUG 	;go if yes
;
;	attempt to execute AUTO command
;
IAUTO5	BIT	1,C		;invisible auto?
	JP	NZ,$$DOSCMD	;go if no display
;
;	display auto command
;
	PUSH	HL		;save start
	PUSH	BC		;save length
IAUTO6	LD	B,(HL)		;get a char
	CALL	$$VDCHAR	;display it
	INC	HL		;bump pointer
	LD	A,B		;get char
	CP	_CR		;terminator?
	JR	NZ,IAUTO6	;go for count
	POP	BC		;restore length
	POP	HL		;restore start
	JP	$$DOSCMD	;execute & return
;
;	reset time/date to initial values (000000)
;
VALCLR	LD	B,3		;3 chars to clear
	XOR	A		;load with zeroes
	JP	FILCLR		;clear and return
;
;	check for valid time/date
;
VALDATI	LD	B,3		;max chars to check
VALDT	LD	A,(DE)		;get maximum value
	CP	(HL)		;>=?
	JR	C,INVDT		;out of range!
	INC	DE		;bump
	INC	HL		;bump
	DJNZ	VALDT		;go for count
	XOR	A		;OK!
	RET			;done
;
INVDT	OR	-1		;set NOT OK!
	RET			;done
;
;	convert A to decimal ascii and place in string
;
ASCDT	CALL	CLKASC		;convert to ascii
	LD	(HL),C		;load msb
	INC	HL		;bump pointer
	LD	(HL),A		;load lsb
	INC	HL		;bump pointer
	RET			;done
;
DATEPMT DEFM	'Date: '
	DEFB	_ENQ		;store cursor
	DEFB	_ETX
;
TIMEPMT DEFM	'Time: '
	DEFB	_ENQ
	DEFB	_ETX
;
RESDT	DEFB	_ACK		;restore cursor
	DEFB	_CAN		;clear EOF
	DEFB	_ETX		;end text
;
DSPDT	DEFM	'..:..:..'
	DEFB	_CR
	DEFB	_ETX
;
;	maximum values for TIME$/DATE$
;
DATECHK	DEFB	30		;max days (0-30)
	DEFB	11		;max months (0-11)
	DEFB	07		;max years (0-7)
;
TIMECHK	DEFB	60		;max seconds
	DEFB	60		;max minutes
	DEFB	24		;max hours
;
KEY	DEFS	1		;override key storage
TBUFF	DEFS	12		;temp key input buffer
AUTOSAV	DEFS	80		;auto storage
;
