; sys0equ/asm - kjw/bqsd - 04/27/83
;
;	created 04/28/83	- kjw/bqsd
;	revised 04/28/83	- kjw/bqsd
;
;	dos system equivalences
;
*GET	DOSEQU			;general equivalences
;
;	memory assignments
;
$CODE	EQU	00000H		;start load code
;
@ROWS2	EQU	24		;# video rows Mod II
@COLS2	EQU	80		;# video cols Mod II
@VSIZ2	EQU	@ROWS2*@COLS2	;video size Mod II
@ROWS2H	EQU	24		;# video rows half size
@COLS2H	EQU	40		;# video cols half size
@VSIZ2H	EQU	@ROWS2H*@COLS2H	;video size double wide
;
@ROWS3	EQU	16		;# video rows Mod III
@COLS3	EQU	64		;# video cols Mod III
@VSIZ3	EQU	@ROWS3*@COLS3	;video size Mod III
@ROWS3H	EQU	16		;# video rows half size
@COLS3H	EQU	32		;# video cols half size
@VSIZ3H	EQU	@ROWS3H*@COLS3H	;video size double wide
;
;	I/O port assignments
;
@HBASE	EQU	0C8H		;HDC base port
$HDCD	EQU	@HBASE+0	;HDC data register
$HDCE	EQU	@HBASE+1	;HDC error register
$HDCW	EQU	@HBASE+1	;HDC write precomp
$HDCX	EQU	@HBASE+2	;HDC sector count
$HDCS	EQU	@HBASE+3	;HDC sector register
$HDCL	EQU	@HBASE+4	;HDC cylinder low
$HDCH	EQU	@HBASE+5	;HDC cylinder high
$HDCQ	EQU	@HBASE+6	;HDC size/head/drive
$HDCC	EQU	@HBASE+7	;HDC command/status
;
@PBASE	EQU	0E0H		;printer/fdc
$PIOAD	EQU	@PBASE+0	;printer & FDC int stat
$PIOBD	EQU	@PBASE+1	;printer data
$PIOAC	EQU	@PBASE+2	;config port A
$PIOBC	EQU	@PBASE+3	;config port B
$FDCC	EQU	@PBASE+4	;FDC command/status
$FDCT	EQU	@PBASE+5	;FDC track register
$FDCS	EQU	@PBASE+6	;FDC sector register
$FDCD	EQU	@PBASE+7	;FDC data register
$DRSL	EQU	@PBASE+15	;drive/mode/select
;
@CBASE	EQU	0F0H		;CTC/CRTC/NMI
$CTC0	EQU	@CBASE+0	;CTC channel 0
$CTC1	EQU	@CBASE+1	;CTC channel 1
$CTC2	EQU	@CBASE+2	;CTC channel 2
$CTC3	EQU	@CBASE+3	;CTC channel 3
$SIOAD	EQU	@CBASE+4	;SIO channel A data
$SIOBD	EQU	@CBASE+5	;SIO channel B data
$SIOAC	EQU	@CBASE+6	;SIO channel A command
$SIOBC	EQU	@CBASE+7	;SIO channel B comand
$DMA	EQU	@CBASE+8	;DMA command/status
$ROM	EQU	@CBASE+9	;ROM enable/disable
$RDKBD	EQU	@CBASE+12	;read keyboard data
$LCRTA	EQU	@CBASE+12	;load CRTC add reg
$LCRTD	EQU	@CBASE+13	;load CRTC data reg
$RCRTD	EQU	@CBASE+13	;read CRTC data reg
$RDRTC	EQU	@CBASE+14	;clear RTC interrupt
$RDNMI	EQU	@CBASE+15	;read NMI int latch
$LBANK	EQU	@CBASE+15	;load bank sel register
;
$SOUND	EQU	00		;load sound register
;
