; sys0dsk/asm - kjw/bqsd - 05/05/83
;
;	created 05/05/83	- kjw/bqsd
;	revised 06/07/83	- kjw
;
@DCTLOC	EQU	0<8+3		;track/sector DCT id
;
@FCHK	EQU	13000		;floppy disk check time
@HTIME	EQU	02400		;head load time (15ms)
@STIME	EQU	00014		;head settle time (140us)
@MTIME	EQU	00000		;motor on delay (852ms)
@FTIME	EQU	00090		;time out delay (3secs)
;
@DMAON	EQU	10000111B	;dma ON
@DMAOFF	EQU	10000011B	;dma OFF
;
@RTRIES	EQU	05		;read retries
@WTRIES	EQU	05		;write retries
@VTRIES	EQU	01		;verify retries
@FTRIES	EQU	02		;format retries
;
@FREST	EQU	00001000B	;restore and hdld
@FSEEK	EQU	00011000B	;seek and hdld
@FREAD	EQU	10000000B	;read sector
@FWRIT	EQU	10100000B	;write sector
@FFMT	EQU	11110000B	;write track
@FCLR	EQU	11010000B	;clear FDC
;
;
	PAGE
;
;	resident disk I/O drivers / floppy & rigid
;
;	ENTRY	C  =	drive # (0-7)
;		A  =	disk command
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
;	I/O types supported (command in A register)
;
;	00	@DTEST		test if drive assigned
;	01	@DCHECK		check if drive ready
;	02	@DHOME		home head to cyl 0
;	03	@DSEEK		seek desired cylinder
;	04	@DREAD		read data sector
;	05	@DVERF		verify data sector
;	06	@SREAD		read directory sector
;	07	@DWRIT		write data sector
;	08	@SWRIT		write directory sector
;	09	@AWRIT		write data sec w/AM
;	10	@WRCYL		write cylinder
;	11	@FORMAT		format device
;
	PAGE
;
;	$DISKIO - RST 10H - resident disk I/O
;
;	ENTRY	A  =	command number
;		C  =	drive # (0-7)
;		D  =	cylinder (if needed)
;		BE =	sector (if needed)
;		HL =>	I/O buffer (if needed)
;
;	EXIT	Z  =	OK, A = 0
;		NZ =	A = error code
;
$DISKIO	CP	@FORMAT+1	;command 0-11?
	JR	C,GODSKIO	;go if in range
;
	LD	A,_ERR39	;illegal I/O attempt
	OR	A		;set NZ/NC
	RET			;return in error
;
GODSKIO	EX	AF,AF'		;save command #
	CALL	$$SAVREG	;save registers
	CALL	$$LOCDRV	;locate DCT
	RET	NZ		;drive out of range!
	EX	AF,AF'		;restore command
;
DISKIO0	BIT	3,(IY+0)	;nil drive?
	JR	Z,DISKIO1	;go if available
;
	LD	A,_ERR67	;drive not in system!
	RET			;return in error!
;
;	check for routed DCT
;
DISKIO1	BIT	4,(IY+0)	;routed?
	JR	Z,DISKIO2	;go if not
;
	PUSH	HL		;save HL
	LD	L,(IY+03)	;get routed DCT
	LD	H,(IY+04)	;HL = routed DCT
	PUSH	HL		;pass to IY
	POP	IY		;IY => new DCT
	POP	HL		;restore HL
	JR	DISKIO0		;go next driver
;
DISKIO2	PUSH	HL		;save HL
	LD	L,(IY+01)	;get driver address
	LD	H,(IY+02)	;HL = driver address
	EX	(SP),HL		;leave address, get HL
	RET			;go driver!
;
	PAGE
;
;	resident floppy driver
;
$FDDVR	PUSH	HL		;save HL
	LD	HL,DTABLE	;disk I/O table
	ADD	A,A		;*2
	ADD	A,L		;add to LSB offset
	LD	L,A		;L = LSB pointer
	JR	NC,$+3		;go if no page cross
	INC	H		;bump MSB pointer
	CALL	$GETHL		;load HL with (HL)
	EX	(SP),HL		;leave vector, get HL
	RET			;go driver!
;
;	resident I/O disk jump table
;
DTABLE	DEFW	$DTEST		;test drive assigned
	DEFW	$DCHECK		;check drive ready
	DEFW	$DHOME		;home/init drive
	DEFW	$DSEEK		;seek cylinder
	DEFW	$DREAD		;read data sector
	DEFW	$DVERF		;verify data sector
	DEFW	$SREAD		;read dir sector
	DEFW	$DWRIT		;write data sector
	DEFW	$SWRIT		;write dir sector
	DEFW	$AWRIT		;write with AM
	DEFW	$WRCYL		;write cylinder
	DEFW	$FORMAT		;format device
;
	PAGE
;
;	$DTEST - check drive assigned
;
;	ENTRY	C  =	drive # to test
;
;	EXIT	Z  =	OK, A=0, drive assigned
;		NZ =	A = error code
;
$DTEST	LD	A,(IY+05)	;get flags 1
	AND	10111010B	;size/flpy/dden/alien/rem
	SUB	00011000B	;must be dden/rem
	RET	Z		;OK, go!
	LD	A,_ERR16	;DCB modified!
	RET			;return error!
;
	PAGE
;
;	$DCHECK - check if drive ready
;
;	ENTRY	C  =	drive number
;
;	EXIT	Z  =	OK, A=0, drive ready
;		NZ =	A = error code
;		Cy =	drive write protected
;
$DCHECK	CALL	DSEL		;select drive
	CALL	DCLR		;reset FDC
	LD	HL,@FCHK	;one revolution + 1 sec
;
DCHECK1	CALL	DCHECK4		;check for index
	JR	NZ,DCHECK1	;wait for one
;
DCHECK2	CALL	DCHECK4		;check for index
	JR	Z,DCHECK2	;wait for it to go away
;
;	check for WP status with drive ready
;
DCHECK3	OR	(IY+05)		;combine with soft WP
	RLCA			;move to bit 7
	AND	@BIT7		;keep bit 7 only
	ADD	A,A		;load zero, bit 7 = Cy
	RET			;return Z, Cy = WP
;
;	dec counter, check for index hole status
;
DCHECK4	DEC	HL		;less count
	LD	A,H		;time out?
	OR	L		;HL = 0000?
	JR	Z,DCHECK5	;go if time out!
	IN	A,($FDCC)	;else get FDC status
	BIT	1,A		;check for index
	RET			;return with Z/NZ
;
DCHECK5	POP	HL		;remove caller return
	OR	_ERR08		;drive not available
	RET			;return in error
;
	PAGE
;
;	$DHOME - home head to cylinder 0
;
;	ENTRY	C  =	drive #
;
;	EXIT	Z  =	OK, A=0, head homed
;		NZ =	A = error code
;
$DHOME	LD	(IY+09),0	;set head at cyl 0
	CALL	DSEL		;select drive
	LD	A,(IY+07)	;get step rate
	OR	@FREST		;floppy 'restore'
	JP	DFCNW		;go disk common
;
	PAGE
;
;	$DSEEK - seek cylinder
;
;	ENTRY	C  =	drive #
;		D  =	cylinder
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$DSEEK	LD	A,(IY+09)	;get current cylinder
	OR	A		;on cyl 0?
	JR	NZ,DSEEK1	;go if not
;
;	head supposedly on cyl 0, HOME drive
;
	CALL	$DHOME		;home/init drive
	RET	NZ		;go if error
;
DSEEK1	CALL	DSEL		;select drive
;
;	check if side 0/1 to be selected
;
	PUSH	DE		;save sector
	PUSH	HL		;save buffer
	LD	A,D		;get track
	OR	A		;on track 0?
	LD	HL,$SELMSK	;drive select mask
	SET	6,(HL)		;set side 0
	LD	A,E		;get sector #
	JR	NZ,DSEEK1A	;go if not track 0
	SUB	(IY+26)		;secs / track 0
	JR	DSEEK1B		;continue
DSEEK1A	SUB	(IY+18)		;less sectors / track
DSEEK1B	JR	C,DSEEK2	;go if side 0
	RES	6,(HL)		;set side 1
	LD	E,A		;correct sector #
;
DSEEK2	LD	A,E		;get logical sector
	ADD	A,(IY+16)	;lsb sector offset
	OUT	($FDCS),A	;issue sector # to FDC
	CALL	DSELX		;select side #
	POP	HL		;restore buffer
	POP	DE		;restore track/sector
;
;	seek track if needed
;
	IN	A,($FDCT)	;read FDC track register
	SUB	D		;on desired track?
	RET	Z		;yes, seek OK!
;
;	move head to desired track
;
	BIT	2,(IY+06)	;skip drive?
	JR	Z,DSEEK3	;go if not
	IN	A,($FDCT)	;read track register
	ADD	A,A		;*2
	OUT	($FDCT),A	;update FDC track reg.
;
DSEEK3	LD	A,D		;get desired track
	BIT	2,(IY+06)	;skip?
	JR	Z,DSEEK4	;go if not
	ADD	A,A		;*2
;
DSEEK4	OUT	($FDCD),A	;issue desired track
	LD	A,(IY+07)	;get step rate
	OR	@FSEEK		;floppy seek
	CALL	DFCNW		;call common I/O
;
	PUSH	AF		;save I/O result
	LD	(IY+09),D	;update current cyl
	LD	A,D		;get desired cyl
	OUT	($FDCT),A	;update track register
	POP	AF		;restore status
	RET			;done!
;
	PAGE
;
;	$DREAD - read data sector
;
;	ENTRY	C  =	drive #
;		D  =	cylinder
;		BE =	sector
;		HL =>	I/O buffer
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$DREAD	CALL	DIOP		;disk I/O operation
	DEFB	@FREAD		;floppy read command
	DEFB	@RTRIES		;# read retries
	DEFB	_ERR51		;error offset
	DEFB	00000001B	;I/O type
;
	PAGE
;
;	$DVERF - verify disk sector
;
;	ENTRY	C  =	drive #
;		D  =	cylinder
;		BE = 	sector
;		HL =>	I/O buffer
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$DVERF	CALL	DIOP		;disk I/O operation
	DEFB	@FREAD		;floppy read command
	DEFB	@VTRIES		;verify retry count
	DEFB	_ERR51		;error offset
	DEFB	00000001B	;I/O type
;
	PAGE
;
;	$SREAD - read directory sector
;
;	ENTRY	C  =	drive #
;		BE =	sector #
;		HL =>	I/O buffer
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$SREAD	BIT	0,(IY+05)	;disk logged?
	CALL	NZ,SREAD3	;log it if not
	RET	NZ		;go if cannot log it
;
	LD	D,(IY+22)	;get dir cylinder
	LD	A,@DVERF	;convert to DREAD
	RST	$DIO		;read sector
	SUB	_ERR56		;have directory?
	RET	Z		;if yes, return!
	SET	0,(IY+05)	;force log next access
	ADD	A,_ERR56	;reset error
	OR	A		;set NZ/NC
	RET			;return in error
;
;	attempt to log in disk by reading DCT info
;
SREAD3	CALL	$$SAVREG	;save registers
	LD	DE,@DCTLOC	;DCT track/sector
	LD	B,D		;MSB sector = 0
	LD	A,@DVERF	;verify sector
	RST	$DIO		;read sector
	JR	Z,SREAD4	;go if OK
	LD	A,@BIT6		;track 0 den bit
	XOR	(IY+10)		;reverse density
	LD	(IY+10),A	;update table
	LD	A,@DVERF	;verify sector
	RST	$DIO		;read sector
	RET	NZ		;go if disk error
;
;	check for DCT identity string
;
SREAD4	LD	DE,$DCTID	;DCT ID string
	LD	B,@DCTIDL	;length ID string
;
SREAD5	CALL	$COMPAR		;compare strings
	JR	NZ,SREAD6	;go if error
;
;	disk identified, load DCT information
;
	RES	0,(IY+05)	;set disk logged!
	LD	BC,10		;offset to data
	ADD	IY,BC		;IY => perish data
	PUSH	IY		;pass to DE
	POP	DE		;DE => data
	LD	C,17		;data count
	LDIR			;move it!
	XOR	A		;no error
	RET			;return logged!
;
SREAD6	LD	A,_ERR90	;diskette unknown
	OR	A		;set NZ
	RET			;return in error
;
	PAGE
;
;	$DWRIT - write data sector
;
;	ENTRY	C  =	drive #
;		D  =	cylinder
;		BE = 	sector
;		HL =>	I/O buffer
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$DWRIT	CALL	DIOP		;disk I/O operation
	DEFB	@FWRIT		;floppy write command
	DEFB	@WTRIES		;# write retries
	DEFB	_ERR59		;error offset
	DEFB	00000010B	;I/O type
;
	PAGE
;
;	$SWRIT - write directory sector
;	$AWRIT - write sector with address marks
;
;	ENTRY	C  =	drive #
;		D  =	cylinder
;		BE =	sector
;		HL =>	I/O buffer
;
;	EXIT	Z  =	OK, A=0
;		NZ = 	A = error code
;
$SWRIT	LD	D,(IY+22)	;get dir cylinder
;
$AWRIT	CALL	DIOP		;disk I/O operation
	DEFB	@FWRIT+@BIT0	;floppy write command
	DEFB	@WTRIES		;# write retries
	DEFB	_ERR59		;error offset
	DEFB	00000010B	;I/O type flag
;
	PAGE
;
;	$WRCYL - write track routine
;
;	ENTRY	C  =	drive #
;		D  =	cylinder
;		BE =	logical sector (for head select)
;		HL =>	I/O buffer
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$WRCYL	CALL	DIOP		;disk I/O operation
	DEFB	@FFMT		;floppy format command
	DEFB	@FTRIES		;# format retries
	DEFB	_ERR59		;error offset
	DEFB	00000100B	;I/O type flag
;
	PAGE
;
;	$FORMAT - format device
;
;	ENTRY	C  =	drive #
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
;  NOTE:	internal driver will not format device
;		but will return Z status
;
$FORMAT	XOR	A		;load NO error
	RET			;return OK
;
	PAGE
;
;	$DFCNW - issue floppy disk command and wait
;
;	ENTRY	A  =	disk function
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
DFCNW	CALL	DFCN		;issue disk command
;
DFCNW1	IN	A,($FDCC)	;get FDC status
	RRCA			;busy?
	CALL	C,DSELX		;select drive/get status
	JR	C,DFCNW1	;wait till not busy
;
	CALL	WAIT		;delay for status
;
	IN	A,($FDCC)	;read FDC status
	AND	10011000B	;ready/seek/crc
	RET	Z		;go if no error
	LD	A,_ERR58	;'device not avail'
	RET			;done!
;
	PAGE
;
;	clear FDC and get status
;
;	ENTRY	none
;
;	EXIT	A  =	floppy disk controller status
;
DCLR	LD	A,@FCLR		;force clear command
	CALL	DFCN		;issue command
	CALL	DFCN		;issue command
	IN	A,($FDCC)	;get status
	RET			;done!
;
;	issue FDC command and delay
;
;	ENTRY	A  =	disk I/O command
;
;	EXIT	command issued and status delay waited
;
DFCN	OUT	($FDCC),A	;issue FDC command
;
WAIT	PUSH	BC		;save BC
	LD	B,@STIME	;140 us status delay
	DJNZ	$		;wait for count
	POP	BC		;restore BC
	RET			;done!
;
	PAGE
;
;	$DIOP - disk I/O operation
;
;	ENTRY	IY =>	DCT
;		D  =	cylinder
;		BE =	sector
;		HL =>	I/O buffer
;		(SP+0)	=	FDC function
;		(SP+1)	=	retry count
;		(SP+2)	=	error offset
;		(SP+3)	=	I/O operation flag
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
DIOP	POP	IX		;IX => table
	BIT	0,(IX+3)	;input operation?
	JR	NZ,DIOP6	;go if yes
;
;	check for write protect
;
	LD	A,(IY+05)	;get flags
	AND	@BIT6		;soft write protect?
	JR	NZ,DIOERR	;go if error!
;
;	floppy disk I/O service
;
DIOP6	LD	B,(IX+01)	;get retry counter
	LD	(DMARD+9),HL	;DMA buffer 1
	LD	(DMAWR+3),HL	;DMA buffer 2
;
;	initialize DMA for read/write transfer
;
DIOP7	PUSH	BC		;save counter/drive
	LD	HL,DMARD	;DMA read data
	BIT	0,(IX+03)	;input operation?
	JR	NZ,$+5		;go if yes
	LD	HL,DMAWR	;DMA write data
	LD	BC,15<8+$DMA	;B=count, C=DMA port
	OTIR			;issue DMA command
	POP	BC		;restore count/drive
;
;	seek requested track
;
	CALL	$DSEEK		;seek track
	RET	NZ		;go if error
;
;	floppy disk transfer
;
	PUSH	HL		;save HL
	LD	HL,$FLAG1	;sys flag #1
	CALL	DCLR		;reset controller
	BIT	5,A		;head loaded?
	LD	A,(IX+00)	;get FDC command
	JR	NZ,$+4		;go if head loaded
	OR	@BIT2		;15 ms delay
	SET	5,(HL)		;no RTC video select
	OUT	($FDCC),A	;issue FDC command
	LD	A,@DMAON	;DMA command
	OUT	($DMA),A	;issue DMA command
	CALL	WAIT		;140 us delay
;
DIOP8	IN	A,($FDCC)	;read FDC status
	AND	81H		;ready/busy?
	DEC	A		;busy?
	JR	Z,DIOP8		;wait if yes
	LD	A,@DMAOFF	;DMA command
	OUT	($DMA),A	;terminate DMA
	RES	5,(HL)		;enable video RTC
	POP	HL		;restore HL
;
;	fetch floppy disk error status
;
	IN	A,($FDCC)	;read status
	AND	0FDH		;I/O error?
	JR	Z,DIOP8A	;go if no error!
;
;	check for remaining retries
;
	DEC	B		;last try?
	JR	Z,DIOERR	;yes, interpret error
	BIT	2,A		;lost data?
	JR	NZ,DIOP7	;yes, try again!
	CP	@BIT5		;DAM or write fault?
	JR	Z,DIOERR	;yes, ignore retry
	CP	@BIT6		;write protect?
	JR	Z,DIOERR	;yes, ignore retry
	AND	@BIT4		;not found error?
	CALL	NZ,$DHOME	;home drive if yes
	RET	NZ		;go if error
	JR	DIOP7		;else retry more
;
;	check if read with not read prot directory
;
DIOP8A	LD	A,(IX+03)	;get I/O type
	AND	00000001B	;read?
	RET	Z		;nope, write, OK
;
	BIT	5,(IY+10)	;protected dir?
	JR	Z,DIOP9		;go if not!
;
DIOP8B	XOR	A		;set NO error
	RET			;return OK
;
DIOP9	LD	A,(IY+22)	;get dir cylinder
	SUB	D		;dir requested?
	JR	NZ,DIOP8B	;go if not
	OR	_ERR56		;set DIR read error
	RET			;done!
;
;	convert error code
;
DIOERR	LD	C,A		;C = error bits
	LD	A,(IX+02)	;get error offset
DIOERR1	LD	B,8		;check 8 bits
;
DIOERR2	RRC	C		;bit to carry
	JR	C,DIOERR3	;go if found
	INC	A		;bump error code
	DJNZ	DIOERR2		;check all 8
;
;	unknown error!
;
	LD	A,_ERR49	;hardware fault
;
DIOERR3	OR	A		;set NZ
	RET			;return in error!
;
	PAGE
;
;	DMA initialization tables
;
DMARD	DEFB	11000011B	;WR6 - reset
	DEFB	10001011B	;WR6 - clear status
	DEFB	01101001B	;WR0 - PORTA add follows
	DEFB	$FDCD		;FDC data register
	DEFW	10672		;block length
	DEFB	00111100B	;WR1 - PORTA fixed, I/O
	DEFB	00010000B	;WR2 - PORTB inc, memory
	DEFB	10001101B	;WR4 - byte, PORTB follow
	DEFW	0000H		;buffer address
	DEFB	10001010B	;WR5 - stop, ready, high
	DEFB	11001111B	;WR6 - load, start, clear
	DEFB	00000101B	;WR0 - PORTA -> PORTB
	DEFB	11001111B	;WR6 - load start, clear
;
;	DMA write initialization data
;
DMAWR	DEFB	11000011B	;WR6 - master reset
	DEFB	10001011B	;WR6 - clear EOB status
	DEFB	01111001B	;WR0 - PORTA follows
	DEFW	0000H		;buffer address
	DEFW	10672		;block length
	DEFB	00010100B	;WR1 - PORTA inc, memory
	DEFB	00101000B	;WR2 - PORTB, fixed, I/O
	DEFB	10000101B	;WR4 - byte, PORTB follow
	DEFB	$FDCD		;FDC data register
	DEFB	10001010B	;WR5 - stop, ready, high
	DEFB	11001111B	;WR6 - load, start, clear
	DEFB	00000101B	;WR0 - PORTA => PORTB
	DEFB	11001111B	;WR6 - load start, clear
;
	PAGE
;
;	$DSEL - select floppy drive
;
;	ENTRY	IY =>	DCT
;
;	EXIT	drive selected
;
DSEL	PUSH	BC		;save
	CALL	DCONV		;get select/density
	LD	BC,$CURDRV	;current drive
	LD	A,(BC)		;get drive
	CP	(IY+08)		;at drive?
	JR	Z,DSEL2		;go if yes
	LD	A,(IY+08)	;get binary drive
	LD	(BC),A		;update new drive
	LD	A,(IY+09)	;get current cylinder
	OUT	($FDCT),A	;set track register
;
;	optional head load delay
;
	BIT	1,(IY+06)	;head load?
	JR	Z,DSEL2		;go if not
	CALL	DSELX		;select drive
	CALL	DCLR		;reset FDC
	BIT	5,A		;head loaded?
	LD	BC,@HTIME	;15 ms delay
	CALL	NZ,$$DELAY	;head load on select
;
;	optional motor on delay
;
DSEL2	BIT	0,(IY+06)	;motor on delay?
	JR	Z,DSEL3		;go if not
	CALL	DSELX		;select drive
	IN	A,($FDCC)	;get status
	RLCA			;drive ready?
	JR	NC,DSEL3	;go if yes!
	LD	BC,@MTIME	;motor on delay
	CALL	$$DELAY		;426 ms
	CALL	$$DELAY		;852 ms
;
DSEL3	CALL	DSELX		;select drive
	POP	BC		;restore BC
	RET			;done!
;
DSELX	LD	A,@FTIME	;time-out factor
	LD	($DTIME),A	;disk time out delay
	LD	A,($SELMSK)	;drive select mask
	OUT	($DRSL),A	;select drive
	RET			;done!
;
;	$DCONV - select drive / modes
;
;	ENTRY	IY =>	DCT
;
;	EXIT	drive select mask loaded ($SELMSK)
;
DCONV	LD	A,(IY+08)	;get binary drive
	AND	3		;drive # only
	RLCA			;shift bits left
	RLCA
	RLCA
	OR	87H		;create opcode
	LD	(CONVBIT),A	;pass opcode
	INC	D		;on track 0?
	DEC	D
	LD	A,(IY+10)	;get flags
	JR	NZ,$+3		;go if not track 0
	RLCA			;else shift left
	AND	@BIT7		;density only
	OR	@BIT7.XOR.-1	;nil drive
	RES	0,A		;reset drive bit
CONVBIT	EQU	$-1
	LD	($SELMSK),A	;drive select mask
	RET			;done!
;
;	$COMPAR - compare 2 strings
;
;	ENTRY	HL =>	source string
;		DE =>	dest string
;		B  =	char count
;
;	EXIT	Z  =	identical, A=0
;		NZ/Cy =	DE < HL
;		NZ/Nc = HL > DE
;
$COMPAR	LD	A,(DE)		;get first byte
	CP	(HL)		;match?
	RET	NZ		;nope, go!
	INC	HL		;bump source
	INC	DE		;bump dest
	DJNZ	$COMPAR		;go for length
	XOR	A		;set MATCH
	RET			;return match
;
$DCTID	DEFM	'DCTBQSD'	;DCT identity string
@DCTIDL	EQU	$-$DCTID	;length identity string
;
