; sys0do/asm - kjw/bqsd - 04/27/83
;
;	created 04/28/83	- kjw/bqsd
;	revised 05/26/83	- kjw
;
	PAGE
;
;	system video driver
;
;	ENTRY	B  =	character to display (0-255)
;		IX =>	video DCB
;
;	EXIT	Z  =	OK, character displayed
;		NZ =	A = error code
;
$DODVR	PUSH	BC		;save char/C reg
	LD	E,(IX+10)	;get cursor offset
	LD	D,(IX+11)
;
;	check for translate
;
	CALL	$XLATE		;translate if on
;
;	enable video memory and display char/command
;
	CALL	$VSEL		;select video memory
	LD	HL,VCHRET	;return address
	PUSH	HL		;leave on temp stack
;
;	check for displayable / control code
;
	LD	A,B		;get char back
	CP	20H		;control char?
	JR	NC,VOCHAR	;go if displayable!
;
;	display control code to video
;
	LD	HL,VOCHTBL	;video char table
	CALL	$$LOOKUP	;search for character
	RET	NZ		;go if not found
	JP	(HL)		;else go char driver!
;
;	video character return vector
;
VCHRET	CALL	$VDSEL		;de-select video
	CALL	POSCUR		;position cursor
	LD	(IX+10),E	;update cursor offset
	LD	(IX+11),D
	POP	BC		;restore char/C reg
	XOR	A		;set NO error
	RET			;done!
;
	PAGE
;
;	execute video commands
;
;	$VOCHAR - display character to video
;
VOCHAR	LD	A,(IX+5)	;get video flags
	AND	@BIT7		;keep high bit only
	OR	B		;set normal/reverse
	LD	(DE),A		;character to video mem
;
;	$VOCH1D - cursor right
;
VOCH1D	INC	DE		;bump cursor offset
;
;	$VOCURCK - check for cursor in lower boundary
;
VOCURCK	LD	L,(IX+14)	;get end of scroll area
	LD	H,(IX+15)	;HL = end video +1
	SCF			;adjust for compare
	SBC	HL,DE		;compare for valid cursor
	RET	NC		;go if scroll not needed
;
;	$VOSCRL - scroll video memory
;
VOSCRL	LD	L,(IX+12)	;get start scroll area
	LD	H,(IX+13)	;HL = top of scroll
	PUSH	HL		;save first line
	LD	E,(IX+08)	;get # video cols
	LD	D,0		;DE = video row length
	ADD	HL,DE		;HL => next second row
	LD	C,(IX+16)	;get scroll count
	LD	B,(IX+17)	;BC = scroll count
	POP	DE		;DE = first line
	LDIR			;scroll video
	JR	VOCH18		;clear to end of frame
;
;	$VOCH0C - home scroll area and clear screen
;
VOCH0C	CALL	VOCH14		;home to scroll area
;
;	$VOCH18 - clear to end of frame
;
VOCH18	LD	L,(IX+14)	;get video end
	LD	H,(IX+15)	;HL = video end +1
	OR	A		;clear carry for sub
	SBC	HL,DE		;HL = count to clear
;
;	clear video block, start DE for length HL
;
VOCH18A	PUSH	DE		;save current cursor
	LD	B,H		;pass length to BC
	LD	C,L		;BC = clear count
	EX	DE,HL		;HL = cursor
	LD	A,(IX+5)	;get char mode
	AND	@BIT7		;keep normal/reverse
	OR	' '		;combine with blank
;
;	clear video block, start HL for length BC with A
;
VOCH18B	LD	(HL),A		;load char to video
	CPI			;HL=HL+1, BC=BC-1
	JP	PE,VOCH18B	;go if BC <> 0000
;
	POP	DE		;restore cursor start
	RET			;done!
;
;	$VOCH17 - clear to end of line
;
VOCH17	CALL	CURBOL		;cursor to begin of line
	LD	C,(IX+08)	;get # video cols
	LD	B,0		;BC = # columns
	ADD	HL,BC		;HL => end blank area
	SBC	HL,DE		;HL = blank count
	JR	VOCH18A		;clear area!
;
;	$VOCH08 - backspace cursor
;
VOCH08	CALL	VOCH1C		;move cursor left
	LD	A,(IX+5)	;get normal/rev mode
	AND	@BIT7		;bit 7 only
	OR	' '		;normal/reverse blank
	LD	(DE),A		;blank character
	RET			;update cursor!
;
;	$VOCH1C - move cursor left
;
VOCH1C	DEC	DE		;move cursor back
	JR	VOCKCUR		;check cursor in bounds
;
;	$VOCH0B - move cursor up
;
VOCH0B	CALL	CURBOL		;move to line beginning
	LD	E,(IX+08)	;get # cols
	LD	D,0		;DE = # columns
	OR	A		;clear carry flag
	SBC	HL,DE		;move up a row
	EX	DE,HL		;DE => new cursor
;
;	$VOCKCUR - check for cursor in upper boundary
;
VOCKCUR	LD	L,(IX+12)	;get start scroll area
	LD	H,(IX+13)
	PUSH	HL		;save start
	SCF			;set for compare
	SBC	HL,DE		;cursor +1 > start?
	POP	HL		;get start
	RET	C		;yes, cursor OK!
	EX	DE,HL		;else reset to start
	RET			;done, DE = cursor
;
;	$VOCH09 - move cursor to next tab position
;
VOCH09	LD	A,E		;get LSB video
	AND	0F8H		;make MOD 8
	LD	E,A		;cursor at LAST tab
	LD	L,8		;offset to next tab
	JR	VOCH0AA		;move cursor to +L
;
;	$VOCH0D - send carriage return
;
VOCH0D	CALL	VOCH16		;cursor to line beginning
;
;	$VOCH0A - send linefeed
;
VOCH0A	LD	L,(IX+08)	;get line length
;
VOCH0AA	LD	H,0		;HL = cursor offset
	ADD	HL,DE		;HL => new cursor
	EX	DE,HL		;DE = new cursor
	JP	VOCURCK		;check for cursor in vid
;
;	$VOCH16 - move cursor to beginning of line
;
VOCH16	CALL	CURBOL		;cursor to line beginning
	EX	DE,HL		;DE = new cursor
	RET			;done!
;
CURBOL	PUSH	DE		;save DE
	LD	HL,$VIDEO	;start video memory
	LD	C,(IX+08)	;get video columns
	LD	B,0		;BC = col length
;
VOCH16A	PUSH	HL		;save current
	ADD	HL,BC		;HL => next line
	SCF			;set for test
	SBC	HL,DE		;compare to end
	POP	HL		;restore HL
	JR	NC,VOCH16B	;go if found!
	ADD	HL,BC		;HL => next line
	JR	VOCH16A		;go till found
;
VOCH16B	POP	DE		;restore old cursor
	RET			;done!
;
;	$VOCH05 - store cursor position
;
VOCH05	LD	(IX+18),E	;save cursor
	LD	(IX+19),D
	RET			;done!
;
;	$VOCH06 - restore cursor position
;
VOCH06	LD	E,(IX+18)	;get old cursor
	LD	D,(IX+19)
	RET			;done!
;
;	$VOCHCU - video cursor controls
;
VOCHCU	JP	CURSOR2		;go SVC handler
;
;	$VOCHN/$VOCHR - set normal/reverse modes
;
VOCHN	RES	7,(IX+5)	;set NORMAL mode
	RET			;done!
;
VOCHR	SET	7,(IX+5)	;set REVERSE mode
	RET			;done!
;
;	$VOCH40/$VOCH80 - set video size
;
VOCH80	LD	C,00000000B	;80 cols
	LD	HL,CRTD80	;CRT data 80 col
	LD	DE,CRDCB80	;DCB data 80 col
	JR	VOSIZE		;go common
;
VOCH40	LD	C,00010000B	;40 cols
	LD	HL,CRTD40	;CRT data 40 col
	LD	DE,CRDCB40	;DCB data 40 col
;
VOSIZE	PUSH	BC		;save init mask
	PUSH	HL		;save table1
	PUSH	DE		;save table2
	CALL	VOCH1B		;clear video
	POP	DE		;restore DCB table
	POP	HL		;restore CRTC table
	LD	BC,4<8+$LCRTD	;byte count + CRT port
	XOR	A		;start register
;
VOSIZE1	OUT	($LCRTA),A	;set CRT register
	INC	A		;bump to next register
	OUTI			;send byte of data
	JR	NZ,VOSIZE1	;go for table count
	POP	BC		;restore mask
;
;	init DCB for new video size information
;
	LD	A,(IX+05)	;get video flags
	AND	11001111B	;drop size bits
	OR	C		;combine with new
	LD	(IX+05),A	;update flags
	LD	A,($VMASK)	;get video mask
	AND	11101111B	;drop size bit
	BIT	4,C		;double wide?
	JR	Z,$+4		;go if not
	OR	00010000B	;set size bit
	LD	($VMASK),A	;set video size
	OUT	($LBANK),A	;setup video size
;
;	load DCB with new data
;
	PUSH	IX		;pass IX to HL
	POP	HL		;HL => start DCB
	LD	BC,8		;offset to video data
	ADD	HL,BC		;HL => new data
	EX	DE,HL		;HL=>data, DE=>DCB
	LD	C,10		;byte count
	LDIR			;move 9 bytes to DCB
;
;	$VOCH14 - home cursor to scroll area
;
VOCH14	LD	E,(IX+12)	;get start scroll area
	LD	D,(IX+13)
	RET			;done!
;
;	$VOCH1B - clear video screen and home cursor
;
VOCH1B	LD	DE,$VIDEO	;start video
	LD	HL,@VSIZ2	;max length of video
	JP	VOCH18A		;clear from cursor to end
;
;	table of video control codes/vectors
;
VOCHTBL	DEFB	_SOH		;01
	DEFW	VOCHCU		;slow blink on
	DEFB	_STX		;02
	DEFW	VOCHCU		;cursor off
	DEFB	_ETX		;03
	DEFW	VOCHCU		;fast blink on
	DEFB	_EOT		;04
	DEFW	VOCHCU		;non-blinking cursor
	DEFB	_ENQ		;05
	DEFW	VOCH05		;store cursor
	DEFB	_ACK		;06
	DEFW	VOCH06		;restore cursor
	DEFB	_BS		;08
	DEFW	VOCH08		;backspace
	DEFB	_HT		;09
	DEFW	VOCH09		;horizontal tab
	DEFB	_LF		;0A
	DEFW	VOCH0A		;linefeed
	DEFB	_VT		;0B
	DEFW	VOCH0B		;vertical tab
	DEFB	_FF		;0C
	DEFW	VOCH0C		;home scroll & cls
	DEFB	_CR		;0D
	DEFW	VOCH0D		;carriage return
	DEFB	_DC4		;14
	DEFW	VOCH14		;home to scroll area
	DEFB	_SYN		;16
	DEFW	VOCH16		;begin of line
	DEFB	_ETB		;17
	DEFW	VOCH17		;erase to end of line
	DEFB	_CAN		;18
	DEFW	VOCH18		;erase to end of frame
	DEFB	_EM		;19
	DEFW	VOCHN		;normal mode
	DEFB	_SUB		;1A
	DEFW	VOCHR		;reverse mode
	DEFB	_ESC		;1B
	DEFW	VOCH1B		;clear screen
	DEFB	_FS		;1C
	DEFW	VOCH1C		;cursor left
	DEFB	_GS		;1D
	DEFW	VOCH1D		;cursor right
	DEFB	_RS		;1E
	DEFW	VOCH80		;80 char mode
	DEFB	_US		;1F
	DEFW	VOCH40		;40 char mode
	DEFB	_ETBL		;end of table
;
;	CRTC initialization data for 40/80 cols
;
CRTD80	DEFB	@COLS2+19	;horiz total
	DEFB	@COLS2		;total displayed
	DEFB	@COLS2+4	;horiz sync posit
	DEFB	@COLS2/10	;horiz sync width
;
CRTD40	DEFB	@COLS2H+9	;horiz total
	DEFB	@COLS2H		;horiz displayed
	DEFB	@COLS2H+3	;horiz sync posit
	DEFB	@COLS2H/10	;horiz sync width
;
;	DCB initialization data for 40/80 columns
;
CRDCB80	DEFB	@COLS2		;video columns
	DEFB	@ROWS2		;video rows
	DEFW	$VIDEO		;cursor address
	DEFW	$VIDEO		;start scroll protect
	DEFW	@VSIZ2+$VIDEO	;end scroll area
	DEFW	@VSIZ2-@COLS2	;scroll length
;
CRDCB40	DEFB	@COLS2H		;video columns
	DEFB	@ROWS2H		;video rows
	DEFW	$VIDEO		;cursor address
	DEFW	$VIDEO		;start scroll area
	DEFW	@VSIZ2H+$VIDEO	;end scroll area
	DEFW	@VSIZ2H-@COLS2H	;scroll length
;
	PAGE
;
;	$VDGRAF - SVC 10 - video graphic display
;
;	ENTRY	B  =	row number
;		C  =	column number
;		D  =	byte count
;		HL =>	display buffer
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$$VDGRAF
	CALL	$$SAVREG	;save registers
	LD	A,@DO		;display DCB #
	CALL	$$LOCDEV+1	;locate DCB
;
	CALL	CVCR2		;convert row/col > offset
	LD	A,D		;get length
	EX	DE,HL		;DE => text buffer
	LD	H,B		;pass to HL
	LD	L,C
	OR	A		;any length?
	JR	Z,VDGRF3	;none, set cursor!
;
	LD	B,A		;pass count
	LD	A,(IX+05)	;get char mask
	AND	@BIT7		;keep high bit only
	LD	C,A		;pass here
	CALL	$VSEL		;select video
	CALL	FVCUR		;force valid cursor
;
VDGRF1	LD	A,(DE)		;get character
	CP	0F9H		;control code?
	JR	NC,VDGRF4	;go if yes!
;
	OR	C		;set norm/rev bit
	LD	(HL),A		;to video
	INC	HL		;bump video
;
VDGRF2	CALL	FVCUR		;force valid cursor
	INC	DE		;bump buffer
	DJNZ	VDGRF1		;go for count
	CALL	$VDSEL		;de-select video
;
VDGRF3	EX	DE,HL		;DE => cursor
	CALL	POSCUR		;move cursor there
	LD	(IX+10),E	;update cursor in DCB
	LD	(IX+11),D
	XOR	A		;no error
	RET			;done!
;
;	handle special control codes
;
VDGRF4	PUSH	HL		;save
	LD	HL,VDGRF2	;exit vector
	EX	(SP),HL		;to stack, get HL
;
	SUB	0F9H		;normal mode?
	JR	Z,VDGRF7	;go if yes
	DEC	A		;reverse mode?
	JR	Z,VDGRF8	;go if yes
	DEC	A		;home cursor?
	JR	Z,VDGRF11	;go if yes
	DEC	A		;cursor left?
	JR	Z,VDGRF9	;go if yes
	DEC	A		;cursor right?
	JR	Z,VDGRF10	;go if yes
	DEC	A		;cursor up?
	JR	Z,VDGRF6	;go if yes
;
;	cursor down
;
VDGRF5	PUSH	DE		;save
	LD	E,(IX+08)	;get video columns
	LD	D,0		;DE = video columns
	ADD	HL,DE		;HL => next line
	POP	DE		;restore
	RET			;done!
;
;	cursor up
;
VDGRF6	PUSH	DE		;save
	LD	E,(IX+08)	;get video columns
	LD	D,0		;DE = columns
	OR	A		;clear carry
	SBC	HL,DE		;HL => last line
	POP	DE		;restore
	RET			;done!
;
;	set character modes
;
VDGRF7	RES	7,C		;normal mode
	RET			;done!
;
VDGRF8	SET	7,C		;reverse mode
	RET			;done!
;
;	cursor left/right
;
VDGRF9	DEC	HL		;cursor left
	RET			;done
;
VDGRF10	INC	HL	;cursor right
	RET			;done
;
;	home cursor
;
VDGRF11	LD	HL,$VIDEO	;start video
	RET			;done
;
	PAGE
;
;	$VDREAD - SVC 11 - read video data
;
;	ENTRY	B  =	row number
;		C  =	column number
;		D  =	byte count
;		HL =>	buffer
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$$VDREAD
	PUSH	DE		;save DE
	PUSH	HL		;save HL
	PUSH	IX		;save IX
;
	LD	A,@DO		;display DCB #
	CALL	$$LOCDEV+1	;locate DCB
	INC	D		;length = 0?
	DEC	D		;yes?
	JR	Z,VDREAD2	;go if yes, get cursor
;
	CALL	CVCR2		;cursor row/col > offset
	EX	DE,HL		;DE => buffer
	PUSH	BC		;save cursor
	LD	C,H		;C = count
	LD	B,0		;BC = count
	POP	HL		;HL = cursor
	CALL	$VSEL		;select video
;
VDREAD1	CALL	FVCUR		;force valid cursor
	LDIR			;move buffer
	CALL	$VDSEL		;de-select video
;
VDREAD2	LD	C,(IX+10)	;get cursor
	LD	D,(IX+11)
	CALL	CVCR1		;cursor offset > row/col
;
	POP	IX		;unstack
	POP	HL
	POP	DE
	XOR	A		;set no error
	RET			;done!
;
	PAGE
;
;	$SCREEN - SVC 91 - output video to device
;
;	ENTRY	DE =>	device DCB
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$$SCREEN
	CALL	$$SAVREG	;save registers
	LD	A,@DO		;display DCB #
	CALL	$$LOCDEV+1	;locate DCB address
	LD	HL,$VIDEO	;start video memory
	LD	B,(IX+09)	;get # video rows
;
SCREEN1	LD	C,(IX+08)	;get # video columns
;
SCREEN2	CALL	$VSEL		;select video
	PUSH	BC		;save counters
	LD	B,(HL)		;get video char
	CALL	$VDSEL		;de-select video
	CALL	$$PUT		;send character
	POP	BC		;restore count
	RET	NZ		;go if error!
;
	INC	HL		;bump video
	DEC	C		;less row count
	JR	NZ,SCREEN2	;go for row
;
	PUSH	BC		;save
	LD	B,_CR		;send carriage return
	CALL	$$PUT		;send character
	POP	BC		;restore count
	RET	NZ		;go if error!
;
	DJNZ	SCREEN1		;go for row count
	XOR	A		;set NO error
	RET			;done!
;
	PAGE
;
;	$CVCR1 - convert cursor to row/column
;
;	ENTRY	BC =	offset of cursor in video
;
;	EXIT	B  =	cursor row #
;		C  =	cursor column #
;
CVCR1	PUSH	HL		;save
	LD	L,C		;LSB cursor
	LD	A,B		;MSB cursor
	AND	07H		;ignore address, get off.
	LD	H,A		;HL = cursor offset
;
	LD	B,0		;BHL = offset
	LD	C,(IX+08)	;get video columns
	CALL	$$DIVID		;divide offset / columns
	LD	C,A		;pass remainder (col)
	LD	B,L		;pass LSB (row)
	POP	HL		;restore
	RET			;done, BC=row/col
;
;	$CVCR2 - convert cursor row/col to offset
;
;	ENTRY	B  =	video row
;		C  =	video column
;
;	EXIT	BC =	video offset
;
CVCR2	PUSH	HL		;save
	PUSH	BC		;save column #
	LD	L,B		;pass row #
	LD	H,0		;HL = row #
	LD	B,H		;BHL = row #
	LD	C,(IX+08)	;get video columns
	CALL	$$MULT		;HL = rows*col size
	POP	BC		;restore BC
	LD	A,C		;get column
	ADD	A,L		;add to result
	LD	C,A		;pass to C
	LD	A,$VIDEO<-8	;MSB video
	ADC	A,H		;add to result
	LD	B,A		;pass to B
	POP	HL		;restore
	RET			;BC = video offset
;
	PAGE
;
;	$POSCUR - position hardware cursor
;
;	ENTRY	DE =	cursor position
;
;	EXIT	CRTC set with new cursor
;
POSCUR	LD	A,14		;register #
	OUT	($LCRTA),A	;load CRTC address reg
	LD	A,D		;get MSB
	AND	07H		;offset only
	OUT	($LCRTD),A	;load CRTC data reg
	LD	A,15		;register #
	OUT	($LCRTA),A	;load CRTC address reg
	LD	A,E		;get LSB
	OUT	($LCRTD),A	;load CRTC data reg
	RET			;done!
;
	PAGE
;
;	$FVCUR - force cursor into valid video memory
;
;	ENTRY	HL =	cursor address
;
;	EXIT	HL =	adjust cursor address
;
FVCUR	PUSH	DE		;save cursor
;
FVCUR1	EX	DE,HL		;DE = cursor
	LD	HL,$VIDEO	;start video
	SCF			;setup for compare
	SBC	HL,DE		;cursor +1 > video?
	JR	C,FVCUR2	;go if yes
	LD	HL,@VSIZ2	;max video size
	ADD	HL,DE		;HL = new cursor
	JR	FVCUR1		;try again
;
FVCUR2	LD	HL,$VIDEO+@VSIZ2-1 ;end video -1
	SBC	HL,DE		;past end?
	JR	NC,FVCUR3	;go if not
	LD	HL,0-@VSIZ2	;-video
	ADD	HL,DE		;cursor < start?
	JR	FVCUR1		;test again
;
FVCUR3	EX	DE,HL		;HL = cursor
	POP	DE		;restore
	RET			;done!
;
	PAGE
;
;	$VIDRAM - SVC 94 - video<>ram transfer
;
;	ENTRY	B  =	0 = video => ram
;		B  =	1 = ram => video
;		HL =>	buffer
;
;	EXIT	Z  =	OK, A=0, data moved
;		NZ =	A = error code
;
$$VIDRAM
	CALL	$$SAVREG	;save registers
	LD	A,@DO		;display device #
	CALL	$$LOCDEV+1	;locate DCB address
;
	EX	DE,HL		;DE => ram
	LD	A,B		;get code
	LD	L,(IX+14)	;get end scroll
	LD	H,(IX+15)	;HL = video end
	LD	BC,$VIDEO	;start video memory
	PUSH	BC		;save start
	OR	A		;clear carry
	SBC	HL,BC		;HL = video length
	LD	B,H		;pass to BC
	LD	C,L		;BC = vid length
	POP	HL		;HL => video start
	OR	A		;to/from video?
	JR	NZ,$+3		;go if video to ram
	EX	DE,HL		;ram to video
	CALL	$VSEL		;select video
	LDIR			;move data!
	CALL	$VDSEL		;de-select video
	XOR	A		;set NO error
	RET			;return
;
