; sys0dev/asm - kjw/bqsd - 04/27/83
;
;	created 04/28/83	- kjw/bqsd
;	revised 06/01/83	- kjw
;
	PAGE
;
;	low memory assignments/vectors
;
$RST00	JP	$$EX2DOS	;RST 00 - warm dos entry
;
$$KBCHAR
	LD	A,_GET+@KI	;command/device
	JP	RESOLVE		;go char I/O
;
$RST08	JP	$EXESVC		;RST 08 - execute SVC
;
$$VDCHAR
	LD	A,_PUT+@DO	;command/device
	JP	RESOLVE		;go char I/O
;
$RST10	JP	$DISKIO		;RST 10 - disk I/O
;
$$PRCHAR
	LD	A,_PUT+@PR	;command/device
	JP	RESOLVE		;go char I/O
;
$RST18	JP	$OVERLY		;RST 18 - overlay loader
;
$$KBDW
	LD	A,_CTL+@KI	;command/device
	JP	RESOLVE		;go char I/O
;
$RST20	JP	$$JPINIT	;RST 20
;
$$PRSTAT
	LD	A,_GET+@PR	;command/device
	JP	RESOLVE		;go char I/O
;
$RST28	RET			;RST 28
	NOP
	NOP
;
$$CLAI
	LD	A,_GET+@CA	;command/device
	JP	RESOLVE		;go char I/O
;
$RST30	RET			;RST 30
	NOP
	NOP
;
$$CLAO
	LD	A,_PUT+@CA	;command/device
	JP	RESOLVE		;go char I/O
;
$RST38	JP	$$DEBUG		;RST 38 - debug break
;
$$CLAW
	LD	A,_CTL+@CA	;command/device
	JP	RESOLVE		;go char I/O
;
;	Interrupt Mode 2 vectors
;
$M2DATA	DEFW	-1		;SIO B TX
	DEFW	-1		;SIO B ETX
	DEFW	$CLINTB		;SIO B RX
	DEFW	$CLINTB		;SIO B SPCL
;
	DEFW	-1		;SIO A TX
	DEFW	-1		;SIO A ETX
	DEFW	$CLINTA		;SIO A RX
	DEFW	$CLINTA		;SIO A SPCL
;
	DEFW	-1		;CTC 0
	DEFW	-1		;CTC 1
	DEFW	-1		;CTC 2
	DEFW	$KBINT		;CTC 3 - keyboard
;
$$CLBI
	LD	A,_GET+@CB	;command/device
	JR	RESOLVE		;go char I/O
;
$$CLBO
	LD	A,_PUT+@CB	;command/device
	JR	RESOLVE		;go char I/O
;
$$CLBW
	LD	A,_CTL+@CB	;command/device
;
;	$RESOLVE - resolve DCB address
;
;	ENTRY	A  =	I/O mask - DCB number
;
;	EXIT	control passed to DCB driver
;
RESOLVE	PUSH	IX		;save IX
	JR	RESCONT		;continue
;
	JP	$NMISER		;NMI service @ 0066H
;
RESCONT	PUSH	AF		;save I/O mask
	AND	0FH		;get device #
	CALL	$$LOCDEV+1	;locate device block
	POP	AF		;restore mask
	RLCA			;align high to low bits
	RLCA
	RLCA
	AND	07H		;low 3 bits = command
	JR	CHIO		;go char I/O
;
;	$GET/$PUT - general purpose char I/O
;
;	ENTRY	B  =	I/O character (if output)
;		DE =>	device DCB
;
;	EXIT	B  =	I/O character
;		Z  =	no error else A = error code
;
$$GET
	LD	A,_CTL<-5	;I/O type
	JR	GOIO		;go I/O
;
$$PUT
	LD	A,_PUT<-5	;I/O type
;
GOIO	PUSH	IX		;save IX
	PUSH	DE		;pass DE => IX
	POP	IX		;IX => DCB
;
;	$CHIO - device character I/O driver
;
;	ENTRY	A  =	I/O type
;		B  =	char to output
;		IX =>	device DCB
;
;	EXIT	B  =	I/O character
;		Z  =	no error, else A = error code
;
CHIO	PUSH	HL		;save registers
	PUSH	DE
;
;	looper for $CTL calls
;
CHIO0	PUSH	AF		;save type
	PUSH	IX		;save DCB
	LD	HL,CHIO8	;return vector
	PUSH	HL		;to stack
;
CHIO1	LD	E,(IX+0)	;get DCB type
	LD	D,A		;D = I/O type flags
;
;	check if GET/PUT to file
;
	BIT	7,E		;file?
	JP	NZ,CHIOF	;yes, go!
;
;	check if ROUTE/LINK
;
	LD	L,(IX+3)	;get link/route DCB
	LD	H,(IX+4)	;HL => DCB
	BIT	4,E		;ROUTE?
	JR	NZ,CHIO4	;go if yes
	BIT	5,E		;LINK?
	JR	Z,CHIO2		;go if not
;
;	setup vector for LINKING
;
	PUSH	AF		;I/O type to stack
	PUSH	HL		;link DCB to stack
	LD	HL,CHIO5	;return vector
	PUSH	HL		;leave on stack
;
;	check for NIL device
;
CHIO2	BIT	3,E		;NIL device?
	JR	NZ,CHIO3	;go if yes
;
;	make sure that DCB supports desired I/O type
;
	LD	A,E		;get DCB type
	AND	D		;mask type flags
	CP	D		;device supported?
	JR	NZ,CHIO3	;go nil device handler
;
;	setup entry to driver address
;
	LD	L,(IX+1)	;fetch driver address
	LD	H,(IX+2)
	CP	_PUT<-5		;set flags for driver
	JP	(HL)		;go driver!
;
;	NIL device handler
;
CHIO3	LD	A,D		;get I/O type
	AND	1		;input?
	RET	Z		;yes, go if output
	LD	A,_ERR02	;'char not available'
	RET			;return NZ
;
;	ROUTED device handler
;
CHIO4	PUSH	HL		;pass HL to IX
	POP	IX		;IX => routed DCB
	JR	CHIO1		;go new driver
;
;	LINKED device handler
;
CHIO5	POP	IX		;IX => link DCB
	POP	DE		;D = I/O type flags
	JR	NZ,CHIO6	;go if char error
	BIT	0,D		;output?
	JR	Z,CHIO6+4	;do link if not
	CP	A		;else no error
	RET			;done, return Z
;
;	check LINKING to input/output device
;
CHIO6	BIT	0,D		;output?
	JR	Z,CHIO7		;terminate if yes
	LD	A,D		;A = I/O type
	JR	CHIO1		;go linked driver
CHIO7	OR	A		;set flags on status
	RET			;return with status
;
;	device I/O termination
;
CHIO8	POP	IX		;get DCB
	POP	DE		;get flag type
	JR	Z,CHIO9+1	;go if no error
	CP	_ERR02		;char not available?
	JR	NZ,CHIO9+1	;go if not
	BIT	2,D		;_CTL call for wait?
	JR	Z,CHIO9		;go if not
	LD	A,D		;get I/O type
	JR	CHIO0		;try again for char
;
CHIO9	OR	A		;set flags on result
	POP	DE		;restore registers
	POP	HL
	POP	IX
	RET			;return with status
;
;	real time clock interrupt task table
;
$RTCTBL	DEFW	$NOTASK		;0 - nil
	DEFW	$NOTASK		;1 - sound (@SOTASK)
	DEFW	$TMTASK		;2 - internal clock upd.
	DEFW	$PRTASK		;3 - printer spooler
	DEFW	$CLTASK		;4 - clock (@CLTASK)
	DEFW	$TRTASK		;5 - trace (@TRTASK)
	DEFW	$ALTASK		;6 - alive (@ALTASK)
	DEFW	$NOTASK		;7 - user timer (@UTTASK)
;
