; sys0dcb/asm - kjw/bqsd - 04/27/83
;
;	created 04/27/83	- kjw/bqsd
;	revised 06/02/83	- kjw
;
	PAGE
;
;	device control block table
;
;	+0/1	- DCB/DCT address
;	+2/3	- DCB/DCT 2 char name
;
$DCBTBL	DEFW	$KIDCB		;keyboard DCB
	DEFM	'KI'		;device name
	DEFW	$DODCB		;display DCB
	DEFM	'DO'		;device name
	DEFW	$PRDCB		;printer DCB
	DEFM	'PR'		;device name
	DEFW	$CADCB		;serial channel A DCB
	DEFM	'CA'		;device name
	DEFW	$CBDCB		;serial channel B DCB
	DEFM	'CB'		;device name
	DEFW	$U1DCB		;user 1 DCB
	DEFM	'U1'		;device name
	DEFW	$U2DCB		;user 2 DCB
	DEFM	'U2'		;device name
	DEFW	$U3DCB		;user 3 DCB
	DEFM	'U3'		;device name
;
$DCTTBL	DEFW	$0DCT		;drive 0 DCT
	DEFM	'0 '		;device name
	DEFW	$1DCT		;drive 1 DCT
	DEFM	'1 '		;device name
	DEFW	$2DCT		;drive 2 DCT
	DEFM	'2 '		;device name
	DEFW	$3DCT		;drive 3 DCT
	DEFM	'3 '		;device name
	DEFW	$4DCT		;drive 4 DCT
	DEFM	'4 '		;device name
	DEFW	$5DCT		;drive 5 DCT
	DEFM	'5 '		;device name
	DEFW	$6DCT		;drive 6 DCT
	DEFM	'6 '		;device name
	DEFW	$7DCT		;drive 7 DCT
	DEFM	'7 '		;device name
;
;	device control blocks
;
	PAGE
;
;	@KI	- keyboard DCB
;
$KIDCB	DEFB	00000101B	;+0	- flags
; 7 (DCB/FCB)		0=DCB	1=FCB
; 6 (DCB/DCT)		0=DCB	1=DCT
; 5 (LINKED)		0=no	1=yes
; 4 (ROUTED)		0=no	1=yes
; 3 (NIL)		0=no	1=yes
; 2 (@CTL)		0=no	1=yes
; 1 (@PUT)		0=no	1=yes
; 0 (@GET)		0=no	1=yes
	DEFW	$KIDVR		;+1/2	- driver address
	DEFW	0000H		;+3/4	- link/route DCB
	DEFB	00000000B	;+5	- flags
; 7 (buffer overflow)	0=no	1=yes
; 6 (break key enable)	0=on	1=off
; 5 (break processor)	0=off	1=on
; 4 (hold processor)	0=off	1=on
; 3 (break pending)	0=no	1=yes
; 2 (hold pending)	0=no	1=yes
; 1 (chaining)		0=no	1=yes
; 0 (translate)		0=no	1=yes
	DEFW	0000H		;+6/7	- xlate table
	DEFW	$KIBUFF		;+8/9	- spool buffer
	DEFW	@KISIZE		;+10/11	- buffer size
	DEFW	0000H		;+12/13	- add offset
	DEFW	0000H		;+14/15	- take offset
	DEFW	0000H		;+16/17	- DO FCB address
	DEFW	0000H		;+18/19	- break vector
	DEFB	00000000B	;+20	- flags
; 7 (strip high bit)	0=yes	1=no
; 6 (unused)
; 5 (unused)
; 4 (unused)
; 3 (unused)
; 2 (unused)
; 1 (KSM active)	0=no	1=yes
; 0 (KSM char pending)	0=no	1=yes
	DEFW	0000H		;+21/22	- KSM table addr
	DEFW	0000H		;+23/24	- KSM char pointr
	DEFB	'.'		;+25	- KBLINE prompt
;
	PAGE
;
;	@DO	- video DCB
;
$DODCB	DEFB	00000110B	;+0	- flags
; 7 (DCB/FCB)		0=DCB	1=FCB
; 6 (DCB/DCT)		0=DCB	1=DCT
; 5 (LINKED)		0=no	1=yes
; 4 (ROUTED)		0=no	1=yes
; 3 (NIL)		0=no	1=yes
; 2 (@CTL)		0=no	1=yes
; 1 (@PUT)		0=no	1=yes
; 0 (@GET)		0=no	1=yes
	DEFW	$DODVR		;+1/2	- driver address
	DEFW	0000H		;+3/4	- link/route DCB
	DEFB	00000000B	;+5	- flags
; 7 (NORMAL/REVERSE)	0=norm	1=reverse
; 6 (unused)
; 5 (80/64 cols)	0=80	1=64
; 4 (width)		0=norm	1=double
; 3 (unused)
; 2 (unused)
; 1 (unused)
; 0 (TRANSLATE)		0=no	1=yes
	DEFW	0000H		;+6/7	- XLATE table
	DEFB	@COLS2		;+8	- # video columns
	DEFB	@ROWS2		;+9	- # video rows
	DEFW	$VIDEO		;+10/11	- cursor offset
	DEFW	$VIDEO		;+12/13	- st scroll area
	DEFW	@VSIZ2+$VIDEO	;+14/15	- end scroll area
	DEFW	@VSIZ2-@COLS2	;+16/17	- scroll count
	DEFW	$VIDEO		;+18/19	- cursor saver
	DEFB	01011001B	;+20	- cursor st/end
;
	PAGE
;
;	@PR	- printer DCB
;
$PRDCB	DEFB	00000101B	;+0	- flags
; 7 (DCB/FCB)		0=DCB	1=FCB
; 6 (DCB/DCT)		0=DCB	1=DCT
; 5 (LINKED)		0=no	1=yes
; 4 (ROUTED)		0=no	1=yes
; 3 (NIL)		0=no	1=yes
; 2 (@CTL)		0=no	1=yes
; 1 (@PUT)		0=no	1=yes
; 0 (@GET)		0=no	1=yes
	DEFW	$PRDVR		;+1/2	- driver address
	DEFW	0000H		;+3/4	- link/route DCB
	DEFB	00000000B	;+5	- flags
; 7 (parallel/serial)	0=par	1=serial
; 6 (LF / CR)		0=no	1=yes
; 5 (interrupting)	0=no	1=yes
; 4 (lower case)	0=no	1=yes
; 3 (transparent mode)	0=no	1=yes
; 2 (form feeds)	0=real	1=interpreted
; 1 (tabs)		0=real	1=interpreted
; 0 (TRANSLATE)		0=no	1=yes
	DEFW	0000H		;+6/7	- XLATE table
	DEFW	$PRBUFF		;+8/9	- buffer address
	DEFW	@PRSIZE		;+10/11	- buffer size
	DEFW	0000H		;+12/13	- add offset
	DEFW	0000H		;+14/15	- take offset
	DEFB	66		;+16	- page length
	DEFB	60		;+17	- lines/page
	DEFB	00		;+18	- line counter
	DEFB	132		;+19	- chars/line
	DEFB	00		;+20	- char counter
;
	PAGE
;
;	@CA	- serial channel A
;
$CADCB	DEFB	00000111B	;+0	- flags
; 7 (DCB/FCB)		0=DCB	1=FCB
; 6 (DCB/DCT)		0=DCB	1=DCT
; 5 (LINKED)		0=no	1=yes
; 4 (ROUTED)		0=no	1=yes
; 3 (NIL)		0=no	1=yes
; 2 (@CTL)		0=no	1=yes
; 1 (@PUT)		0=no	1=yes
; 0 (@GET)		0=no	1=yes
	DEFW	$CLDVR		;+1/2	- driver address
	DEFW	0000H		;+3/4	- link/route DCB
	DEFB	00000000B	;+5	- flags
; 7 (unused)
; 6 (unused)
; 5 (unused)
; 4 (unused)
; 3 (unused)
; 2 (unused)
; 1 (channel init)	0=yes	1=no
; 0 (TRANSLATE)		0=no	1=yes
	DEFW	0000H		;+6/7	- XLATE table
	DEFW	$CABUFF		;+8/9	- buffer address
	DEFW	@CASIZE		;+10/11	- buffer size
	DEFW	0000H		;+12/13	- add offset
	DEFW	0000H		;+14/15	- take offset
	DEFB	$SIOAC		;+16	- base I/O port
	DEFB	$CTC0		;+17	- CTC @1
	DEFB	$CTC1		;+18	- CTC @2
	DEFB	11111111B	;+19	- word len mask
	DEFB	1		;+20	- stop bits
	DEFB	0		;+21	- CTC R5 mask
	DEFB	00101100B	;+22	- baud/word/par.
; 7 (buffer overflow)	0=no	1=yes
; 6/4 (baud config)
; 3/2 (word config)
; 1/0 (parity config)
;	baud	0 = 110 bps
;		1 = 150 bps
;		2 = 300 bps
;		3 = 600 bps
;		4 = 1200 bps
;		5 = 2400 bps
;		6 = 4800 bps
;		7 = 9600 bps
;	word	0 = 5 bits
;		1 = 6 bits
;		2 = 7 bits
;		3 = 8 bits
;	parity	0 = none
;		1 = ODD
;		2 = none
;		3 = EVEN
;
	PAGE
;
;	@CB	- serial channel B
;
$CBDCB	DEFB	00000111B	;+0	- flags
; 7 (DCB/FCB)		0=DCB	1=FCB
; 6 (DCB/DCT)		0=DCB	1=DCT
; 5 (LINKED)		0=no	1=yes
; 4 (ROUTED)		0=no	1=yes
; 3 (NIL)		0=no	1=yes
; 2 (@CTL)		0=no	1=yes
; 1 (@PUT)		0=no	1=yes
; 0 (@GET)		0=no	1=yes
	DEFW	$CLDVR		;+1/2	- driver address
	DEFW	0000H		;+3/4	- link/route DCB
	DEFB	00000000B	;+5	- flags
; 7 (unused)
; 6 (unused)
; 5 (unused)
; 4 (unused)
; 3 (unused)
; 2 (unused)
; 1 (channel init)	0=yes	1=no
; 0 (TRANSLATE)		0=no	1=yes
	DEFW	0000H		;+6/7	- XLATE table
	DEFW	$CBBUFF		;+8/9	- buffer address
	DEFW	@CBSIZE		;+10/11	- buffer size
	DEFW	0000H		;+12/13	- add offset
	DEFW	0000H		;+14/15	- take offset
	DEFB	$SIOBC		;+16	- base I/O port
	DEFB	$CTC2		;+17	- CTC @1
	DEFB	0		;+18	- CTC @2
	DEFB	11111111B	;+19	- word len mask
	DEFB	1		;+20	- stop bits
	DEFB	0		;+21	- CTC R5 mask
	DEFB	00101100B	;+22	- flags
; 7 (buffer overflow)	0=no	1=yes
; 6/4 (baud config)
; 3/2 (word config)
; 1/0 (parity config)
;	baud	0 = 110 bps
;		1 = 150 bps
;		2 = 300 bps
;		3 = 600 bps
;		4 = 1200 bps
;		5 = 2400 bps
;		6 = 4800 bps
;		7 = 9600 bps
;	word	0 = 5 bits
;		1 = 6 bits
;		2 = 7 bits
;		3 = 8 bits
;	parity	0 = none
;		1 = ODD
;		2 = none
;		3 = EVEN
;
	PAGE
;
;	@U1	- user defined DCB's #1/#2/#3
;
$U1DCB	DEFB	00001000B	;+0	- flags
; 7 (DCB/FCB)		0=DCB	1=FCB
; 6 (DCB/DCT)		0=DCB	1=DCT
; 5 (LINKED)		0=no	1=yes
; 4 (ROUTED)		0=no	1=yes
; 3 (NIL)		0=no	1=yes
; 2 (@CTL)		0=no	1=yes
; 1 (@PUT)		0=no	1=yes
; 0 (@GET)		0=no	1=yes
	DEFW	0000H		;+1/2	- driver address
	DEFW	0000H		;+3/4	- link/route DCB
	DEFB	00000000B	;+5	- flags
	DEFW	0000H		;+6/7	- XLATE table
	DEFW	0000H		;+8/9	- buffer address
	DEFW	0000H		;+10/11	- buffer length
	DEFW	0000H		;+12/13	- add offset
	DEFW	0000H		;+14/15	- take offset
	DEFB	00H		;+16	- flags
;
;	@U2	- user defined DCB #2
;
$U2DCB	DEFB	00001000B	;+0	- flags
	DEFW	0000H		;+1/2	- driver address
	DEFW	0000H		;+3/4	- link/route DCB
	DEFB	00000000B	;+5	- flags
	DEFW	0000H		;+6/7	- XLATE table
	DEFW	0000H		;+8/9	- buffer address
	DEFW	0000H		;+10/11	- buffer length
	DEFW	0000H		;+12/13	- add offset
	DEFW	0000H		;+14/15	- take offset
	DEFB	00H		;+16	- flags
;
;	@U3	- user defined DCB #3
;
$U3DCB	DEFB	00001000B	;+0	- flags
	DEFW	0000H		;+1/2	- driver address
	DEFW	0000H		;+3/4	- link/route DCB
	DEFB	00000000B	;+5	- flags
	DEFW	0000H		;+6/7	- XLATE table
	DEFW	0000H		;+8/9	- buffer address
	DEFW	0000H		;+10/11	- buffer length
	DEFW	0000H		;+12/13	- add offset
	DEFW	0000H		;+14/15	- take offset
	DEFB	00H		;+16	- flags
;
	PAGE
;
;	drive control tables
;
;	@DRIVE 0 DCT
;
$0DCT	DEFB	01000000B	;+0	- flags
; 7 (DCB/FCB)		0=DCB	1=FCB
; 6 (DCB/DCT)		0=DCB	1=DCT
; 5 (LINKED)		not implemented
; 4 (ROUTED)		0=no	1=yes
; 3 (NIL)		0=no	1=yes
; 2 (@CTL)		not implemented
; 1 (@PUT)		not implemented
; 0 (@GET)		not implemented
	DEFW	$FDDVR		;+1/2	- floppy driver
	DEFW	0000H		;+3/4	- link/route DCB
	DEFB	00011000B	;+5	- flags 1
; 7 (5"/8")		0=8"	1=5"
; 6 (soft write prot)	0=no	1=yes
; 5 (rigid/floppy)	0=flpy	1=rigid
; 4 (fix/removable)	0=fix	1=remov
; 3 (DDEN available)	0=no	1=yes
; 2 (reserved)
; 1 (alien driver)	0=no	1=yes
; 0 (disk logged)	0=yes	1=no
	DEFB	00000000B	;+6	- flags 2
; 7 (available)
; 6 (available)
; 5 (available)
; 4 (sector size disk)	0=256	1=512
; 3 (sector size 0)	0=128	1=256
; 2 (double step)	0=no	1=yes
; 1 (head load)		0=no	1=yes
; 0 (motor delay)	0=no	1=yes
	DEFB	2		;+7	- step rate
	DEFB	0		;+8	- binary drive #
	DEFB	000		;+9	- current cyl.
;
;	perishable DCT data
;
	DEFB	10100000B	;+10	- flags 3
; 7 (DDEN disk)		0=no	1=yes
; 6 (DDEN track 0)	0=no	1=yes
; 5 (protected dir)	0=no	1=yes
; 4 (reserved)
; 3 (available)
; 2 (available)
; 1 (available)
; 0 (available)
	DEFB	000		;+11	- head offset
	DEFB	001		;+12	- head count
	DEFW	00000		;+13/14	- cyl offset
	DEFB	077		;+15	- cyl count
	DEFW	00000		;+16/17	- sector offset
	DEFW	00030		;+18/19	- sectors/track
	DEFW	00030		;+20/21	- sectors/cyl
	DEFB	038		;+22	- dir cylinder
	DEFB	030		;+23	- dir length
	DEFB	005		;+24	- sectors/gran
	DEFB	006		;+25	- grans/cylinder
	DEFB	027		;+26	- secs/track 0
;
;	@DRIVE 1 DCT
;
$1DCT	DEFB	01000000B	;+0	- flags
	DEFW	$FDDVR		;+1/2	- floppy driver
	DEFW	0000H		;+3/4	- link/route DCB
	DEFB	00011001B	;+5	- flags 1
	DEFB	00000000B	;+6	- flags 2
	DEFB	2		;+7	- step
	DEFB	1		;+8	- binary drive
	DEFB	000		;+9	- current cyl.
;
	DEFB	10100000B	;+10	- flags 3
	DEFB	000		;+11	- head offset
	DEFB	001		;+12	- head count
	DEFW	00000		;+13/14	- cyl offset
	DEFB	077		;+15	- cyl count
	DEFW	00000		;+16/17	- sector offset
	DEFW	00030		;+18/19	- sectors/track
	DEFW	00030		;+20/21	- sectors/cyl
	DEFB	038		;+22	- dir cylinder
	DEFB	030		;+23	- dir length
	DEFB	005		;+24	- sectors/gran
	DEFB	006		;+25	- grans/cylinder
	DEFB	027		;+26	- secs/tk 0
;
;	@DRIVE 2 DCT
;
$2DCT	DEFB	01000000B	;+0	- flags
	DEFW	$FDDVR		;+1/2	- floppy driver
	DEFW	0000H		;+3/4	- link/route DCB
	DEFB	00011001B	;+5	- flags 1
	DEFB	00000000B	;+6	- flags 2
	DEFB	2		;+7	- step rate
	DEFB	2		;+8	- binary drive #
	DEFB	000		;+9	- curr cylinder
;
	DEFB	10100000B	;+10	- flags 3
	DEFB	000		;+11	- head offset
	DEFB	001		;+12	- head count
	DEFW	00000		;+13/14	- cyl offset
	DEFB	077		;+15	- cyl count
	DEFW	00000		;+16/17	- sector offset
	DEFW	00030		;+18/19	- sectors/track
	DEFW	00030		;+20/21	- sectors/cyl
	DEFB	038		;+22	- dir cylinder
	DEFB	030		;+23	- dir length
	DEFB	005		;+24	- sectors/gran
	DEFB	006		;+25	- grans/cylinder
	DEFB	027		;+26	- secs / track 0
;
;	@DRIVE 3 DCT
;
$3DCT	DEFB	01000000B	;+0	- flags
	DEFW	$FDDVR		;+1/2	- floppy driver
	DEFW	0000H		;+3/4	- link/route DCB
	DEFB	00011001B	;+5	- flags 1
	DEFB	00000000B	;+6	- flags 2
	DEFB	2		;+7	- step rate
	DEFB	3		;+8	- binary drive #
	DEFB	000		;+9	- current cyl.
;
	DEFB	10100000B	;+10	- flags 3
	DEFB	000		;+11	- head offset
	DEFB	001		;+12	- head count
	DEFW	00000		;+13/14	- cyl offset
	DEFB	077		;+15	- cyl count
	DEFW	00000		;+16/17	- sector offset
	DEFW	00030		;+18/19	- sectors/track
	DEFW	00030		;+20/21	- sectors/cyl
	DEFB	038		;+22	- dir cylinder
	DEFB	030		;+23	- dir length
	DEFB	005		;+24	- sectors/gran
	DEFB	006		;+25	- grans/cylinder
	DEFB	027		;+26	- secs / track 0
;
	PAGE
;
;	@DRIVE 4 DCT
;
$4DCT	DEFB	01001000B	;+0	- flags
	DEFW	$FDDVR		;+1/2	- floppy driver
	DEFW	0000H		;+3/4	- link/route DCB
	DEFB	00011001B	;+5	- flags 1
	DEFB	00000000B	;+6	- flags 2
	DEFB	2		;+7	- step rate
	DEFB	0		;+8	- binary drive #
	DEFB	000		;+9	- current cyl.
;
	DEFB	10100000B	;+10	- flags 3
	DEFB	000		;+11	- head offset
	DEFB	001		;+12	- head count
	DEFW	00000		;+13/14	- cyl offset
	DEFB	077		;+15	- cyl count
	DEFW	00000		;+16/17	- sector offset
	DEFW	00030		;+18/19	- sectors/track
	DEFW	00030		;+20/21	- sectors/cyl
	DEFB	038		;+22	- dir cyl.
	DEFB	030		;+23	- dir length
	DEFB	005		;+24	- sectors/gran
	DEFB	006		;+25	- grans/cylinder
	DEFB	027		;+26	- secs / track 0
;
;	@DRIVE 5 DCT
;
$5DCT	DEFB	01001000B	;+0	- flags
	DEFW	$FDDVR		;+1/2	- floppy driver
	DEFW	0000H		;+3/4	- link/route DCB
	DEFB	00011001B	;+5	- flags 1
	DEFB	00000000B	;+6	- flags 2
	DEFB	2		;+7	- step rate
	DEFB	1		;+8	- binary drive #
	DEFB	000		;+9	- current cyl.
;
	DEFB	10100000B	;+10	- flags 3
	DEFB	000		;+11	- head offset
	DEFB	001		;+12	- head count
	DEFW	00000		;+13/14	- cyl offset
	DEFB	077		;+15	- cyl count
	DEFW	00000		;+16/17	- sector offset
	DEFW	00030		;+18/19	- sectors/track
	DEFW	00030		;+20/21	- sectors/cyl
	DEFB	038		;+22	- dir cylinder
	DEFB	030		;+23	- dir length
	DEFB	005		;+24	- sectors/gran
	DEFB	006		;+25	- grans/cylinder
	DEFB	027		;+26	- secs/track 0
;
;	@DRIVE 6 DCT
;
$6DCT	DEFB	01001000B	;+0	- flags
	DEFW	$FDDVR		;+1/2	- floppy driver
	DEFW	0000H		;+3/4	- link/route DCB
	DEFB	00011001B	;+5	- flags 1
	DEFB	00000000B	;+6	- flags 2
	DEFB	2		;+7	- step rate
	DEFB	2		;+8	- binary drive #
	DEFB	000		;+9	- current cyl.
;
	DEFB	10100000B	;+10	- flags 3
	DEFB	000		;+11	- head offset
	DEFB	001		;+12	- head count
	DEFW	00000		;+13/14	- cyl offset
	DEFB	077		;+15	- cyl count
	DEFW	00000		;+16/17	- sector offset
	DEFW	00030		;+18/19	- sectors/track
	DEFW	00030		;+20/21	- sectors/cyl
	DEFB	038		;+22	- dir cylinder
	DEFB	030		;+23	- dir length
	DEFB	005		;+24	- sectors/gran
	DEFB	006		;+25	- grans/cylinder
	DEFB	027		;+26	- secs/track 0
;
;	@DRIVE 7 DCT
;
$7DCT	DEFB	01001000B	;+0	- flags
	DEFW	$FDDVR		;+1/2	- floppy driver
	DEFW	0000H		;+3/4	- link/route DCB
	DEFB	00011001B	;+5	- flags 1
	DEFB	00000000B	;+6	- flags 2
	DEFB	2		;+7	- step rate
	DEFB	3		;+8	- binary drive #
	DEFB	000		;+9	- current cyl.
;
	DEFB	10100000B	;+10	- flags 3
	DEFB	000		;+11	- head offset
	DEFB	001		;+12	- head count
	DEFW	00000		;+13/14	- cyl offset
	DEFB	077		;+15	- cyl count
	DEFW	00000		;+16/17	- sector offset
	DEFW	00030		;+18/19	- sectors/track
	DEFW	00030		;+20/21	- sectors/cyl
	DEFB	038		;+22	- dir cylinder
	DEFB	030		;+23	- dir length
	DEFB	005		;+24	- sectors/gran
	DEFB	006		;+25	- grans/cylinder
	DEFB	027		;+26	- secs/track 0
;
