; sys0cl/asm - kjw/bqsd - 04/27/83
;
;	created 04/28/83	- kjw/bqsd
;	revised 05/09/83	- dwh
;
	PAGE
;
;	system communications line driver
;
;	ENTRY	IX =>	@CA/@CB DCB
;		B  =	character (if output)
;		Cy =	input a byte
;		Z  =	output a byte
;
;	EXIT	Z  =	OK, B = character
;		NZ =	A = error code
;		Cy =	carrier lost
;
$CLDVR	EX	AF,AF'		;save I/O type flag
	OR	A		;clear carry flag
	BIT	1,(IX+5)	;channel initialized?
	LD	A,_ERR36	;'not inited'
	RET	NZ		;exit if not!
	EX	AF,AF'		;get I/O flags back
	JR	Z,ABTX		;go transmit if Z
;
;	SIO receive services
;
ABRX	CALL	$BUFTAK		;fetch char from spooler
	JR	C,RXIN		;have a char, get it!
	LD	A,_ERR02	;char not available
	OR	A		;set NZ/NC
	RET			;done!
;
;	fetch character from SIO spool buffer
;
RXIN	PUSH	BC		;save C register
	AND	(IX+19)		;word length mask
	LD	C,(IX+10)	;buffer size
	LD	B,(IX+11)
	ADD	HL,BC		;HL => status byte
	LD	C,(HL)		;fetch status
	LD	(IX+14),E	;update ring pointer
	LD	(IX+15),D
	LD	B,A		;pass char
	CALL	$XLATE		;translate character
	LD	A,B		;get resulting char
	LD	L,C		;L = status byte
;
	POP	BC		;restore C reg
	LD	B,A		;pass input char to B
	LD	A,L		;get status byte
	BIT	3,A		;carrier
	JR	Z,RXINCT	;no carry
	SCF			;carry
RXINCT	INC	A		;setup
	DEC	A		;set Z
	RET			;return with status
;
;	SIO transmit services
;
ABTX	PUSH	BC		;save character
	LD	A,B		;get character
	AND	(IX+19)		;word length mask
	LD	E,A		;save char
;
;	wait for ready to transmit
;
ABTXWT	CALL	RSTATUS		;get RS232 status
	AND	@BIT2		;TX buffer empty?
	JR	NZ,ABTXWT	;wait till ready
;
	LD	C,(IX+16)	;get SIO base port
	DEC	C		;point to data port
	DEC	C
	OUT	(C),E		;send char to RS232
	LD	A,B		;get status byte
	POP	BC		;restore char
	BIT	3,A		;carrier
	JR	Z,ABTXCT	;no carry
	SCF			;carry
ABTXCT	INC	A		;setup
	DEC	A		;set Z
	RET			;done, return!
;
;	fetch status of RS232 port
;
RSTATUS	LD	C,(IX+16)	;get SIO base port
	IN	B,(C)		;fetch status byte
	LD	A,1		;set for reg 1 select
	OUT	(C),A		;select register 1
	IN	C,(C)		;fetch status byte
	LD	A,@BIT5+@BIT4	;error mask
	OUT	(C),A		;clear any errors
	LD	A,B		;RR 0 status
	AND	@BIT7+@BIT2	;BREAK/TX
	XOR	@BIT2		;reverse TX
	LD	B,A		;B = RR 0 status
	LD	A,C		;RR 1 status
	AND	@BIT6+@BIT5+@BIT4 ;FRAME/OVERRUN/PARITY
	OR	B		;combine status bytes
	LD	B,A		;B = status result
	RET			;done!
;
	PAGE
;
;	SIO Mode 2 Interrupt Service
;
$CLINTA	PUSH	AF		;save it
	LD	A,@CA		;comm A channel #
	JR	RSINTC		;go common driver
;
$CLINTB	PUSH	AF		;save
	LD	A,@CB		;comm B channel #
;
RSINTC	PUSH	BC		;save needed
	PUSH	DE
	PUSH	HL
	PUSH	IX
;
	CALL	$$LOCDEV+1	;locate DCB address
	LD	C,(IX+16)	;get base port
	DEC	C		;point to data port
	DEC	C
	IN	B,(C)		;fetch data byte
	CALL	$$NMIOFF	;no video/rtc
	CALL	$BUFADD		;room to add to buffer?
	LD	A,0		;no overrun
	JR	C,RSINT1	;go if OK
;
	LD	E,(IX+12)	;get buff add offset
	LD	D,(IX+13)
	LD	L,(IX+08)	;get buff start address
	LD	H,(IX+09)
	ADD	HL,DE		;HL => last char
	LD	A,@BIT5		;overrun mask
;
RSINT1	LD	(HL),B		;char to buffer
	LD	C,(IX+10)	;get buffer size
	LD	B,(IX+11)
	ADD	HL,BC		;HL => status
	LD	(HL),A		;overrun status to buffer
	CALL	RSTATUS		;fetch RS232 status
	OR	(HL)		;merge with overrun
	LD	(HL),A		;update error byte
	CALL	$$NMION		;enable video/rtc
	LD	(IX+12),E	;update ring pointer
	LD	(IX+13),D
;
	POP	IX		;unstack everything
	POP	HL
	POP	DE
	POP	BC
	POP	AF
	EI			;enable interrupts
	RETI			;return from interrupt
;
