; dosequ/asm - kjw/bqsd - 04/27/83
;
*LIST	OFF
;
;	created 04/28/83	- kjw/bqsd
;	revised 06/01/83	- dwh
;
;	dos system equivalences
;
;	system device numbers
;
@KI	EQU	0		;@KI
@DO	EQU	1		;@DO
@PR	EQU	2		;@PR
@CA	EQU	3		;@CA
@CB	EQU	4		;@CB
@U1	EQU	5		;@U1
@U2	EQU	6		;@U2
@U3	EQU	7		;@U3
@D0	EQU	8		;:0
@D1	EQU	9		;:1
@D2	EQU	10		;:2
@D3	EQU	11		;:3
@D4	EQU	12		;:4
@D5	EQU	13		;:5
@D6	EQU	14		;:6
@D7	EQU	15		;:7
@DRVS	EQU	08		;number of drives
@DRVOFF	EQU	08		;drive device offset
@DEVS	EQU	16		;number of devices
;
;	restart equivalences
;
$XIT	EQU	00H		;normal dos exit
$SVC	EQU	08H		;execute SVC
$DIO	EQU	10H		;disk I/O manager
$OVL	EQU	18H		;overlay loader
$BAS1	EQU	20H		;basic use
$BAS2	EQU	28H		;basic use
$BAS3	EQU	30H		;basic use
$BRK	EQU	38H		;debug breakpoint
;
;	resident disk I/O types
;
@DTEST	EQU	00		;check drive assigned
@DCHECK	EQU	01		;check drive ready
@DHOME	EQU	02		;home/init drive
@DSEEK	EQU	03		;seek cylinder
@DREAD	EQU	04		;read data sector
@DVERF	EQU	05		;verify data sector
@SREAD	EQU	06		;read system sector
@DWRIT	EQU	07		;write data sector
@SWRIT	EQU	08		;write system sector
@AWRIT	EQU	09		;write data W/AM
@WRCYL	EQU	10		;write cylinder
@FORMAT	EQU	11		;format device
;
;	memory assignments
;
$SBUFF	EQU	01E00H		;system I/O buffer
$UBUFF	EQU	01F00H		;user I/O buffer
$LOSYS	EQU	02000H		;low system overlay
$HISYS	EQU	02600H		;high system overlay
$USER	EQU	03000H		;begin user memory
$VIDEO	EQU	0F800H		;start video memory
;
;	system supervisor call equates
;
@INITIO	EQU	000		;init I/O drivers
@KBINIT	EQU	001		;init keyboard
@SETUSR	EQU	002		;setup user SVC
@SETBRK	EQU	003		;setup break processor
@KBCHAR	EQU	004		;keyboard character
@KBLINE	EQU	005		;keyboard string
@DELAY	EQU	006		;delay program execution
@VDINIT	EQU	007		;init video device
@VDCHAR	EQU	008		;display char to video
@VDLINE	EQU	009		;string to video
@VDGRAF	EQU	010		;video graphics
@VDREAD	EQU	011		;video read
@VIDKEY	EQU	012		;video/keyboard strings
@KBEDIT	EQU	013		;keyboard string edit
@DSPLY	EQU	014		;line to video
@DISKID	EQU	015		;read disk ID
@PRINT	EQU	016		;line to printer
@PRINIT	EQU	017		;init printer device
@PRCHAR	EQU	018		;char to printer
@PRLINE	EQU	019		;string to printer
@RANDOM	EQU	020		;generate random number
@BINDEC	EQU	021		;binary to decimal
@STCMP	EQU	022		;string compare
@MPYDIV	EQU	023		;multiply / divide
@BINHEX	EQU	024		;binary to hex
@TIMER	EQU	025		;user timer
@CURSOR	EQU	026		;cursor control
@SCROLL	EQU	027		;scroll protect video
@LOOKUP	EQU	028		;table lookup
@HLDKEY	EQU	029		;hold key processor
@KBPUT	EQU	030		;char to type buffer
@ABORT	EQU	031		;exit to dos
@RDDIR	EQU	032		;read disk record by LFN
@LOCATE	EQU	033		;locate record
@READNX	EQU	034		;read next record
@DIRRD	EQU	035		;read with position
@JP2DOS	EQU	036		;abort to dos
@DOSCMD	EQU	037		;dos command and exit
@RETCMD	EQU	038		;dos command and return
@ERROR	EQU	039		;display error message
@OPEN	EQU	040		;open file/device
@KILL	EQU	041		;kill file/device
@CLOSE	EQU	042		;close file/device
@WRITNX	EQU	043		;write next record
@DIRWR	EQU	044		;direct record write
@DATE	EQU	045		;fetch/load date$/time$
@PARSER	EQU	046		;string parser
@RENAME	EQU	047		;rename file/device
@REWIND	EQU	048		;rewind file
@STSCAN	EQU	049		;scan string
@BOOT	EQU	050		;boot
@WILD	EQU	051		;wild card parser
@ERRMSG	EQU	052		;fetch error message
@RAMDIR	EQU	053		;ram directory
@INIT	EQU	054		;init
@RS232C	EQU	055		;RS232 init
@SORT	EQU	056		;sort memory block
@CLRXIT	EQU	057		;exit and clear memory
@FILPTR	EQU	058		;fetch file pointers
@DIRSET	EQU	059		;setup for RDDIR
@SOUND	EQU	060		;generate tone
@VIDON	EQU	061		;video on
@VIDOFF	EQU	062		;video off
@INTON	EQU	063		;interrupts on
@INTOFF	EQU	064		;interrupts off
@MEMCTL	EQU	065		;memory control
@RDLFN	EQU	066		;read LFN
@WRLFN	EQU	067		;write LFN
@MULT	EQU	068		;multiply
@DIVID	EQU	069		;divide
@BINASC	EQU	070		;binary to ascii
@EXPHEX	EQU	071		;binary to hex
@EXPDEC	EQU	072		;binary to decimal
@KBDW	EQU	073		;keyboard with wait
@PRSTAT	EQU	074		;printer status
@CLAW	EQU	075		;comm A with wait
@CLBW	EQU	076		;comm B with wait
@GET	EQU	077		;input byte from device
@PUT	EQU	078		;output byte to device
@POSN	EQU	079		;position file
@BKSP	EQU	080		;backspace file
@ADD24	EQU	081		;24 bit add
@PEOF	EQU	082		;posit to end of file
@EVAL	EQU	083		;evaluate input commands
@FSPEC	EQU	084		;fetch filespec
@RUN	EQU	085		;run program
@LOAD	EQU	086		;load program
@PARAM	EQU	087		;fetch user parameters
@FEXT	EQU	088		;add default extension
@VALUE	EQU	089		;convert from ASCII
@SUB24	EQU	090		;24 bit subtract
@SCREEN	EQU	091		;screen to device
@NMICTL	EQU	092		;add/kill NMI vectors
@INC24	EQU	093		;24 bit increment
@VIDRAM	EQU	094		;ram/video transfer
@PRCTRL	EQU	095		;printer control
@CLAI	EQU	096		;comm A input
@CLAO	EQU	097		;comm A output
@CLBI	EQU	098		;comm B input
@CLBO	EQU	099		;comm B output
@ACTRL	EQU	100		;comm A control
@BCTRL	EQU	101		;comm B control
@DEC24	EQU	102		;24 bit decrement
@CMP24	EQU	103		;24 bit compare
@SAVREG	EQU	104		;save registers
@POSHL	EQU	105		;position HL
@VALCHR	EQU	106		;valid character
@DPOINT	EQU	107		;get pointer
@LOCDRV	EQU	108		;locate DCT
@LOCDEV	EQU	109		;locate DCB
@LOCNAM	EQU	110		;get device number
@GETNAM	EQU	111		;get device name
@SORT2	EQU	112		;alternate sort
@SPWILD	EQU	113		;special wild
@MSG	EQU	114		;message to device
@DBLOCK	EQU	115		;deblock file
@SAVERN	EQU	116		;FCB setup
;
;	ascii equivalences
;
_NUL	EQU	00H		;null character
_SOH	EQU	01H		;start of header
_STX	EQU	02H		;start of text
_ETX	EQU	03H		;end of text
_EOT	EQU	04H		;end of transmission
_ENQ	EQU	05H		;enquiry
_ACK	EQU	06H		;acknowledge
_BEL	EQU	07H		;bell
_BS	EQU	08H		;backspace
_HT	EQU	09H		;horizontal tab
_LF	EQU	0AH		;linefeed
_VT	EQU	0BH		;vertical tab
_FF	EQU	0CH		;form feed
_CR	EQU	0DH		;carriage return
_SO	EQU	0EH		;shift out
_SI	EQU	0FH		;shift in
_DLE	EQU	10H		;data link escape
_DC1	EQU	11H		;device control 1
_DC2	EQU	12H		;device control 2
_DC3	EQU	13H		;device control 3
_DC4	EQU	14H		;device control 4
_NAK	EQU	15H		;negative acknowledge
_SYN	EQU	16H		;synchronize
_ETB	EQU	17H		;end text block
_CAN	EQU	18H		;cancel
_EM	EQU	19H		;emulate
_SUB	EQU	1AH		;submit
_ESCAPE	EQU	1BH		;escape
_FS	EQU	1CH		;field separator
_GS	EQU	1DH		;group separator
_RS	EQU	1EH		;record separator
_US	EQU	1FH		;unit separator
_ECR	EQU	';'		;embedded carriage return
_EBLOCK	EQU	0		;end of block marker
_ETBL	EQU	-1		;end of table marker
;
;	keyboard equivalences
;
_HOLD	EQU	00H		;hold key
_F1	EQU	01H		;F1 key
_F2	EQU	02H		;F2 key
_BREAK	EQU	03H		;break key
_BACKSP	EQU	08H		;backspace key
_TAB	EQU	09H		;tab key
_ENTER	EQU	0DH		;enter key
_ESC	EQU	1BH		;escape key
_LEFT	EQU	1CH		;left arrow key
_RIGHT	EQU	1DH		;right arrow key
_UP	EQU	1EH		;up arrow key
_DOWN	EQU	1FH		;down arrow key
_SPACE	EQU	20H		;spacebar key
_LBRAK	EQU	5BH		;left square bracket
_BSLASH	EQU	5CH		;backslash
_RBRAK	EQU	5DH		;right square bracket
_CARET	EQU	5EH		;caret char
_ULINE	EQU	5FH		;underline char
_RAPOS	EQU	60H		;reverse apostrophe
_LBRACE	EQU	7BH		;left brace
_VSEP	EQU	7CH		;vertical separator
_RBRACE	EQU	7DH		;right brace
_INEQU	EQU	7EH		;inequality
_CANCEL	EQU	7FH		;+- characters
;
;	misc. equivalences
;
@ZERO	EQU	00000H		;0000
@MINUS	EQU	0FFFFH		;FFFF
@PRESET	EQU	08080H		;param reset
;
@TRUE	EQU	-1		;true
@FALSE	EQU	0		;false
@NIL	EQU	@PRESET<-8	;nil param
@PAGE	EQU	256		;size memory page
@DCBLEN	EQU	40		;DCB length
@BUFLEN	EQU	@PAGE		;buffer length
@PARA	EQU	16		;size memory paragraph
@TICKS	EQU	30		;RTC ticks/second
@SECS	EQU	60		;seconds / minute
@MINS	EQU	60		;minutes / hour
@HOURS	EQU	24		;hours / day
@DAYS	EQU	30		;days / month
@VERSN	EQU	2<4+0		;version # (2.0)
@BYEAR	EQU	0<7+80		;base calendar year
@BANKS	EQU	16		;# memory banks
@SLOTS	EQU	08		;# RTC slots
@SLOTSO	EQU	1		;sound slot
@SLOTCL	EQU	4		;clock slot
@SLOTTR	EQU	5		;trace slot
@SLOTAL	EQU	6		;alive slot
@SLOTUT	EQU	7		;user timer slot
;
;	bit equivalences
;
@BIT0	EQU	00000001B
@BIT1	EQU	00000010B
@BIT2	EQU	00000100B
@BIT3	EQU	00001000B
@BIT4	EQU	00010000B
@BIT5	EQU	00100000B
@BIT6	EQU	01000000B
@BIT7	EQU	10000000B
;
;	error number equivalences
;
_ERR00	EQU	00		;No Error
_ERR01	EQU	01		;bad function code on SVC
_ERR02	EQU	02		;char not available
_ERR03	EQU	03		;parameter error
_ERR04	EQU	04		;CRC error on disk I/O
_ERR05	EQU	05		;sector not found
_ERR06	EQU	06		;Invalid SVC data
_ERR07	EQU	07		;illegal disk change
_ERR08	EQU	08		;disk drive not ready
_ERR09	EQU	09		;invalid data provided
_ERR10	EQU	10		;stack out of range
_ERR11	EQU	11		;file already exists
_ERR12	EQU	12		;no drive to open file
_ERR13	EQU	13		;write to read only file
_ERR14	EQU	14		;write fault on disk I/O
_ERR15	EQU	15		;write protected disk
_ERR16	EQU	16		;DCB modified
_ERR17	EQU	17		;dir read error
_ERR18	EQU	18		;dir write error
_ERR19	EQU	19		;invalid filespec
_ERR20	EQU	20		;GAT read error
_ERR21	EQU	21		;GAT write error
_ERR22	EQU	22		;HIT read error
_ERR23	EQU	23		;HIT write error
_ERR24	EQU	24		;file not found
_ERR25	EQU	25		;file access denied
_ERR26	EQU	26		;directory space full
_ERR27	EQU	27		;disk space full
_ERR28	EQU	28		;end of file encountered
_ERR29	EQU	29		;record out of range
_ERR30	EQU	30		;dir space full/can't ext
_ERR31	EQU	31		;program not found
_ERR32	EQU	32		;invalid drivespec
_ERR33	EQU	33		;buffer Overflow
_ERR34	EQU	34		;load file format error
_ERR35	EQU	35		;memory fault
_ERR36	EQU	36		;Channel Not Initialized
_ERR37	EQU	37		;open attempt to open fil
_ERR38	EQU	38		;I/O attempt to unopen fi
_ERR39	EQU	39		;illegal I/O attempt
_ERR40	EQU	40		;seek error
_ERR41	EQU	41		;lost data on disk I/O
_ERR42	EQU	42		;printer not ready
_ERR43	EQU	43		;printer out of paper
_ERR44	EQU	44		;printer fault
_ERR45	EQU	45		;printer not available
_ERR46	EQU	46		;invalid I/O to VLR file
_ERR47	EQU	47		;required param missing
_ERR48	EQU	48		;invalid command param
_ERR49	EQU	49		;hardward fault on I/O
_ERR50	EQU	50		;data set member not fnd
_ERR51	EQU	51		;CRC error header read
_ERR52	EQU	52		;seek error on read
_ERR53	EQU	53		;lost data on read
_ERR54	EQU	54		;CRC error on read
_ERR55	EQU	55		;not found on read
_ERR56	EQU	56		;system data record
_ERR57	EQU	57		;deleted data record
_ERR58	EQU	58		;device not available
_ERR59	EQU	59		;CRC error header write
_ERR60	EQU	60		;seek error on write
_ERR61	EQU	61		;lost data on write
_ERR62	EQU	62		;CRC error on write
_ERR63	EQU	63		;not found on write
_ERR64	EQU	64		;write fault on drive
_ERR65	EQU	65		;disk write protected
_ERR66	EQU	66		;no function exists
_ERR67	EQU	67		;drive not in system
_ERR68	EQU	68		;invalid devicespec
_ERR69	EQU	69		;no device space avail.
_ERR70	EQU	70		;device not found
_ERR71	EQU	71		;device in use
_ERR72	EQU	72		;protected system device
_ERR73	EQU	73		;modem carrier lost
_ERR74	EQU	74		;xmitter not available
_ERR75	EQU	75		;framing error
_ERR76	EQU	76		;serial data lost
_ERR77	EQU	77		;serial parity error
_ERR78	EQU	78		;CTS not detected
_ERR79	EQU	79		;illegal logical file #
_ERR80	EQU	80		;invalid input channel
_ERR81	EQU	81		;invalid output channel
_ERR82	EQU	82		;insufficient memory
_ERR83	EQU	83		;device already exists
_ERR84	EQU	84		;data set member missing
_ERR85	EQU	85		;terminated
_ERR86	EQU	86		;aborted
_ERR87	EQU	87		;invalid data set member
_ERR88	EQU	88		;function not available
_ERR89	EQU	89		;illegal I/O channel
_ERR90	EQU	90		;cannot establish disk
_ERR91	EQU	91		;illegal data range
_ERR92	EQU	92		;mem bank not available
_ERR93	EQU	93		;bank does not exist
_ERR94	EQU	94		;protected mem bank
_ERR95	EQU	95		;illegal access to file
_ERR96	EQU	96		;completed
_ERR97	EQU	97		;memory bank table exists
_ERR98	EQU	98		;bank table doesn't exist
_ERR99	EQU	99		;illegal directory record
_ERR100	EQU	100		;undefined error
;
;	character command qquivalences
;
_GET	EQU	1<5		;@GET
_PUT	EQU	2<5		;@PUT
_CTL	EQU	5<5		;@CTL
;
;	$PARAM equivalences
;
_STRING	EQU	@BIT7		;PARAM string
_SWITCH	EQU	@BIT6		;PARAM switch
_VALUE	EQU	@BIT5		;PARAM value
;
;	file access levels
;
_FULL	EQU	0
_KILL	EQU	1
_RENAME	EQU	2
_WRITE	EQU	3
_UPDATE	EQU	4
_READ	EQU	5
_EXEC	EQU	6
_NONE	EQU	7
;
;	system overlay equates
;
_SYS01	EQU	0<4
_SYS02	EQU	1<4
_SYS03	EQU	2<4
_SYS04	EQU	3<4
_SYS05	EQU	4<4
_SYS06	EQU	5<4
_SYS07	EQU	6<4
_SYS08	EQU	7<4
_SYS09	EQU	8<4
_SYS10	EQU	9<4
_SYS11	EQU	10<4
_SYS12	EQU	11<4
_SYS13	EQU	12<4
_SYS14	EQU	13<4
_SYS15	EQU	14<4
_SYS16	EQU	15<4
;
_CMD01	EQU	0
_CMD02	EQU	1
_CMD03	EQU	2
_CMD04	EQU	3
_CMD05	EQU	4
_CMD06	EQU	5
_CMD07	EQU	6
_CMD08	EQU	7
_CMD09	EQU	8
_CMD10	EQU	9
_CMD11	EQU	10
_CMD12	EQU	11
_CMD13	EQU	12
_CMD14	EQU	13
_CMD15	EQU	14
_CMD16	EQU	15
;
*LIST	ON
;
