; dosboot/asm - kjw/bqsd - 05/11/83
;
;	created 05/11/83	- kjw/bqsd
;	revised 05/11/83	- kjw/bqsd
;
	TITLE	'<PowerDOS - BOOT/SYS>'
;
	SUBTTL	'<Copyright (C) 1983 - Breeze/QSD, Inc. - Dallas, Texas>'
;
;	disk image assignments
;
;	ROM loads boot data @ E00H starting at sector 1
;	Each sector is 128 bytes in length
;
;	Tr 0, Se 0 		nil, holds DIR track
;	Tr 0, Se 1 @ E00H	nil, holds DIR track
;	Tr 0, Se 2 @ E80H	nil
;	Tr 0, Se 3 @ F00H	DCT/flags/AUTO command
;	Tr 0, Se 4 @ F80H	nil
;	Tr 0, Se 5 @ 1000H	boot code
;	Tr 0, Se 6 @ 1080H	boot code
;	Tr 0, Se 7 @ 1100H	boot code
;	Tr 0, Se 8 @ 1180H	boot code
;	Tr 0, Se 9 & up		nil
;
;	memory assignments
;
DCTSAV	EQU	2200H		;DCT storage (up)
STACK	EQU	2300H		;STACK (down)
IOBUFF	EQU	2300H		;disk I/O buffer
BOOTEXE	EQU	2400H		;actual boot execution
ROMLOAD	EQU	0E00H		;ROM will load boot here
VIDEO	EQU	0F800H		;start video memory
;
FDCCMD	EQU	0E4H		;FDC command
FDCSTA	EQU	0E4H		;FDC status
FDCTRK	EQU	0E5H		;FDC track register
FDCSEC	EQU	0E6H		;FDC sector register
FDCDAT	EQU	0E7H		;FDC data register
FDCSEL	EQU	0EFH		;FDC select register
DMA	EQU	0F8H		;DMA command register
ROME	EQU	0F9H		;ROM enable register
RDKBD	EQU	0FCH		;keyboard read port
;
FSEEK	EQU	00011110B	;FDC seek/H/V/10ms
FREAD	EQU	10001000B	;FDC read sector
FCLEAR	EQU	11010000B	;FDC force clear
;
OFFL	EQU	07		;offset to DCT flags
OFST	EQU	15		;offset secs/track
OFSC	EQU	17		;offset secs/cyl
OFD	EQU	19		;offset dir cyl
OFSG	EQU	21		;offset secs/gran
;
	ORG	ROMLOAD+200H	;offset to Tr 0, Se 5
;
START	DEFM	'BOOT'		;ROM will look for this!
;
ENTRY	LD	HL,ROMLOAD+100H	;Tr 0, Se 2 is here!
	LD	DE,DCTSAV	;save DCT here
	LD	BC,80H		;sector length
	XOR	A		;load zero
	OUT	(ROME),A	;disable boot rom!
	LDIR			;move code!
;
;	relocate boot code to free area in SYS0
;
	LD	HL,BOOTLOC	;start boot code
	LD	BC,BOOTL	;length boot code
	LD	DE,BOOTEXE	;move it here
	PUSH	DE		;leave vector on stack
	LDIR			;move code up
	RET			;go boot code!
BOOTLOC	EQU	$
;
;	actual SYS0/SYS loader
;
	ORG	BOOTEXE		;execute boot here
;
BOOT	LD	SP,STACK	;temp load stack
	LD	A,(DCTSAV+OFD)	;get directory track
	LD	D,A		;pass to D
	LD	E,4		;LFN #2 (SYS0/SYS)
	LD	HL,IOBUFF	;I/O buffer
	CALL	DREAD		;read disk sector
;
	LD	A,(HL)		;get flag byte
	CPL			;reverse bits
	AND	50H		;active system file?
	JR	NZ,SYSERR	;go if system error
;
;	convert segment descriptor to disk address
;
	EXX			;alternate set
	LD	HL,(IOBUFF+16H)	;HL = SD pair
	LD	D,L		;pass track
	LD	A,H		;get offset/grans
	RLCA			;align high 3 bits to low
	RLCA
	RLCA
	AND	7		;low 3 bits
	LD	C,A		;E = gran offset
	LD	A,(DCTSAV+OFSG)	;get sectors / gran
	LD	B,A		;pass to B
	XOR	A		;init zero
;
BOOT0	ADD	A,C		;add gran offset
	DJNZ	BOOT0		;go till sector found
	LD	E,A		;E = start sector
	LD	HL,IOBUFF+0FFH	;end of I/O buffer
	EXX			;done, registers setup
;
;	loop to load file
;
BOOT1	CALL	GETBYTE		;fetch single byte
	DEC	A		;01 header
	JR	Z,BOOT01	;yes, get it!
	DEC	A		;02 entry?
	JR	Z,BOOT02	;yes, go program!
	CP	20H-2		;valid range?
	JR	NC,SYSERR	;load file format error
;
;	remove remark block
;
	CALL	GETBYTE		;get length byte
	LD	B,A		;pass to B
BOOT03	CALL	GETBYTE		;get remark byte
	DJNZ	BOOT03		;go for count
	JR	BOOT1		;go next block
;
;	program entry point!
;
BOOT02	CALL	GETADDR		;get entry address
	JP	(HL)		;go sys0!
;
;	loader block
;
BOOT01	CALL	GETADDR		;get length/address
BOOT00	CALL	GETBYTE		;get a byte
	LD	(HL),A		;to buffer
	CP	(HL)		;still there?
	JR	NZ,MEMERR	;nope, memory error!
	INC	HL		;bump pointer
	DJNZ	BOOT00		;go for length
	JR	BOOT1		;go next block
;
;	fetch length byte / address
;
GETADDR	CALL	GETBYTE		;get a byte
	SUB	2		;less address length
	LD	B,A		;pass to B
	CALL	GETBYTE		;get LSB address
	LD	L,A		;pass to L
	CALL	GETBYTE		;get MSB address
	LD	H,A		;pass to H
	RET			;done!
;
;	read one byte from file
;
GETBYTE	EXX			;get alternate set
	INC	L		;bump LSB buffer
	JR	NZ,HAVBYTE	;go if in buffer
;
;	read sector from file
;
	CALL	DREAD		;read the disk
	LD	A,(DCTSAV+OFSC)	;get sectors/cylinder
	INC	E		;bump to next sector
	SUB	E		;end of track?
	JR	NZ,HAVBYTE	;nope, continue
	LD	E,A		;reset sector 0
	INC	D		;bump track
;
HAVBYTE	LD	A,(HL)		;get byte from buffer
	EXX			;swap back
	RET			;done, A=char
;
;	error services
;
DSKERR	LD	HL,MSGDSK	;'disk error'
	JR	ERROR		;go common
;
SYSERR	LD	HL,MSGSYS	;'non-system disk'
	JR	ERROR		;go common
;
MEMERR	LD	HL,MSGMEM	;'memory error'
;
;	display error message, wait for key, reboot
;
ERROR	LD	DE,VIDEO+990	;offset to video
ERROR1	LD	A,(HL)		;get string byte
	OR	A		;terminator byte?
	JR	Z,ERROR2	;go if yes
	LDI			;else move to string
	JR	ERROR1		;go next byte
ERROR2	LD	A,4FH		;de-select drives
	OUT	(FDCSEL),A	;de-selected!
;
;	wait for a key
;
ERROR3	IN	A,(RDKBD)	;read keyboard
	OR	A		;anything?
	JP	P,ERROR3	;go if not
	LD	A,01H		;rom select code
	OUT	(ROME),A	;enable ROM!
	RST	0		;re-boot
;
;	read sector from disk
;
DREAD	LD	B,5		;retry count
;
DREAD1	PUSH	BC		;save counter
	CALL	DREAD2		;try to read it
	POP	BC		;restore count
	RET	Z		;go if no error
	DJNZ	DREAD1		;go for retry count
	JR	DSKERR		;else go disk error
;
DREAD2	PUSH	HL		;save buffer
	LD	(DMARD+9),HL	;pass to DMA setup
	LD	HL,DMARD	;DMA setup table
	LD	BC,15<8+DMA	;count + DMA port
	OTIR			;setup DMA command
;
;	seek track and select side
;
	CALL	DSEEK		;seek track
	JR	NZ,DREAD4	;go if error
;
;	transfer sector data
;
	CALL	DCLR		;clear FDC
	BIT	5,A		;head loaded?
	LD	A,FREAD		;read command
	JR	NZ,DREAD3	;go if loaded
	SET	2,A		;else set head load
DREAD3	OUT	(FDCCMD),A	;issue disk command
	LD	A,87H		;DMA start command
	OUT	(DMA),A		;issue DMA command
	CALL	WAIT		;wait for termination
	LD	A,83H		;DMA end command
	OUT	(DMA),A		;issue DMA command
	IN	A,(FDCSTA)	;read FDC status
	AND	9DH		;check for error
;
DREAD4	POP	HL		;restore I/O buffer
	RET			;done!
;
;	seek head to requested cylinder
;
DSEEK	PUSH	DE		;save track/sector
	LD	A,(DCTSAV+OFFL)	;get DCT flags
	AND	80H		;get density
	OR	7EH		;select drive 0
	LD	D,A		;C = mode and select
	LD	BC,(DCTSAV+OFST) ;get sectors/track
	LD	A,E		;get sector #
	SUB	C		;on side 0?
	JR	C,DSEEK1	;go if yes
	RES	6,D		;set side 1
	LD	E,A		;E = sector
;
DSEEK1	LD	A,E		;get sector
	OUT	(FDCSEC),A	;to FDC sector register
	LD	A,D		;get select code
	OUT	(FDCSEL),A	;select drive/modes
	POP	DE		;restore track/sector
;
	IN	A,(FDCTRK)	;read track register
	SUB	D		;at requested track?
	RET	Z		;yes, no need to seek!
;
	LD	A,D		;get cylinder
	OUT	(FDCDAT),A	;requested cylinder
	LD	A,FSEEK		;seek command
	OUT	(FDCCMD),A	;issue command
	CALL	WAIT		;wait for not busy
	IN	A,(FDCSTA)	;read status
	AND	98H		;ready/seek/crc
	RET			;return with status
;
;	wait for command completion
;
WAIT	CALL	DELAY		;wait 140 ms
WAIT1	IN	A,(FDCSTA)	;read status
	AND	81H		;ready/busy
	DEC	A		;busy?
	JR	Z,WAIT1		;yes, wait
	RET			;else completed
;
;	clear FDC and get status
;
DCLR	LD	A,FCLEAR	;get RESET command
	OUT	(FDCCMD),A	;issue command
	CALL	DELAY		;wait 140 ms
	IN	A,(FDCSTA)	;read status register
	RET			;return with status
;
;	delay 140 ms for valid FDC status
;
DELAY	PUSH	BC		;save
	LD	B,14		;140 ms
	DJNZ	$		;wait
	POP	BC		;restore
	RET			;done!
;
;	DMA read initialization data
;
DMARD	DEFB	0C3H		;WR6 - reset
	DEFB	08BH		;WR6 - clear status
	DEFB	069H		;WR0 - port A follows
	DEFB	FDCDAT		;fdc data register
	DEFW	256		;block length
	DEFB	03CH		;WR1 - port A fixed,I/O
	DEFB	010H		;WR2 - port B, inc/mem
	DEFB	08DH		;WR4 - byte/port B follow
	DEFW	0000		;buffer address
	DEFB	08AH		;WR5 - stop/ready/high
	DEFB	0CFH		;WR6 - load/start/clear
	DEFB	005H		;WR0 - PortA => PortB
	DEFB	0CFH		;WR6 - load/start/clear
;
;	error text
;
MSGSYS	DEFM	'No System'
	DEFB	0
;
MSGDSK	DEFM	'Disk Error'
	DEFB	0
;
MSGMEM	DEFM	'Memory Error'
	DEFB	0
;
BOOTL	EQU	$-BOOT		;length of boot code
;
	END
;
