; smove/asm - kjw/bqsd - revised 04/20/83
;
	ORG	4000H
;
RST8	JP	START		;program entry
RST10	JP	READ		;sector read
RST18	JP	WRITE		;sector write
RST20	JP	PRINT		;display to video
RST28	JP	FLASH		;flash text
RST30	JP	FILECOM		;common file driver
RST38	JP	TASK		;interrupt processor
;
;	data storage
;
CURSOR	DEFW	3C00H		;cursor address
SAVEDIR	DEFW	0		;directory posit saver
RESULT	DEFB	0		;disk I/O result
SGRANS	DEFB	0		;# source grans
DGRANS	DEFB	0		;# dest grans
SFILES	DEFB	0		;# source files
DFILES	DEFB	0		;# dest files
GRANS	DEFB	0		;# grans current
STRSPC	DEFB	0,0,0,0,0,0,0	;keyboard work mask
CTRACK	DEFB	0,0,0,0		;current track table
;
	DEFS	60H		;stack area
STACK	EQU	$
;
;	program entry point
;
ENTRY	DI			;disable interrupts
	IM	1		;set interrupt mode 1
	LD	SP,STACK	;init stack pointer
;
;	port initialization Mod III
;
	LD	A,4		;enable RTC
	OUT	(0E0H),A	;issue command
	LD	A,0C3H		;JP opcode
	LD	(4049H),A	;setup jumps for NMI
	LD	HL,NMIRET	;non-disk NMI vector
	LD	(404AH),HL	;save into jump vector
	XOR	A		;load zero
	OUT	(0E4H),A	;disable NMI's
	LD	A,28H		;video waits/64 char mode
	OUT	(0ECH),A	;issue command
	LD	A,0D0H		;FDC reset command
	OUT	(0F0H),A	;reset FDC
;
;	locate top memory
;
	LD	H,80H		;start 8000H
	CALL	TMEM		;test byte
	JR	NZ,HAVMEM	;go if memory not there
	LD	H,0C0H		;start C000H
	CALL	TMEM		;test byte
	JR	NZ,HAVMEM	;go if memory not there
	LD	H,0		;else topmem @ 0000H
HAVMEM	LD	A,H		;get MSB
	SUB	4		;less needed buffer size
	LD	(TOPMEM),A	;save MSB topmem pointer
;
;	check for SPACEBAR to skip EOFS increment
;
	LD	A,(3840H)	;read keyboard
	AND	80H		;space pressed?
	JR	Z,NOTCEPT	;go if not pressed
	XOR	A		;load zero
	LD	(INCEPT),A	;load NOP opcode
;
;	delay factor when using opening graphics
;
NOTCEPT	LD	BC,0		;init zero
	CALL	DELAY		;countdown
	CALL	DELAY
	CALL	DELAY
	CALL	DELAY
	CALL	DELAY
	CALL	DELAY
	CALL	DELAY
	CALL	DELAY
	CALL	DELAY
	CALL	DELAY
;
;	begin program execution
;
START	LD	SP,STACK	;reset stack pointer
	EI			;can enable interrupts
	LD	HL,MSG1		;sign on message
	RST	20H		;display message
;
;	init data block
;
	XOR	A		;load zero
	LD	(SGRANS),A	;source grans
	LD	(SFILES),A	;source files
	LD	(FLAG),A	;clear prompting flag
	LD	(DENSITY),A	;single density
	CALL	DRIVSET		;setup for drive 0
;
;	read source directory
;
	LD	DE,1100H	;track 17 / sector 0
	LD	A,10		;10 sectors to read
	LD	BC,SDIRBUF	;source dir buffer
	CALL	SMREAD		;read multiple source
	LD	HL,MSG7		;'invalid disk'
	JP	NZ,ERROR	;go if disk error
	LD	HL,SDIRBUF+0D0H	;name stored here
	CALL	PUTNMDT		;move into text string
	LD	A,1		;mod I flag
	LD	(GFLAG),A	;get gran flag to Mod I
	LD	HL,PRTFILE	;subroutine vector
	RST	30H		;display all files
	LD	A,(SGRANS)	;get # source grans
	CALL	ASCII		;convert to ascii
	LD	(SGRANSA),A	;to text string
	LD	(SGRANSA+1),BC	;remainder text
	LD	A,(SFILES)	;get # source files
	CALL	ASCII		;to decimal ascii
	LD	(SFILESA),A	;to the string
	LD	(SFILESA+1),BC	;rest
	LD	HL,FILMSG	;start of message
	RST	20H		;display message to video
;
BAD1	LD	HL,MSG6		;'destination drive?'
	RST	20H		;display prompt
	CALL	INKEY		;get single input key
	SUB	'0'		;remove ascii
	JR	C,BAD1		;go if invalid
	CP	4		;0-3?
	JR	NC,BAD1		;go if out of range
	LD	(DEST),A	;save as dest drive
	LD	(SOURCE),A	;for forced prompt
	LD	HL,MSG00	;prompt to mount dest
	RST	20H		;display prompt
	CALL	DMOUNT		;setup for dest activity
	XOR	A		;load drive 0
	LD	(SOURCE),A	;reset source drive
;
;	read dest boot to locate directory track
;
	LD	DE,0001H	;track 0 / sector 1
	LD	BC,DDIRBUF	;dest directory buffer
	LD	A,80H		;double density bit
	LD	(DENSITY),A	;pass density
	RST	10H		;read the sector
	LD	HL,MSG8		;error message
	JP	NZ,ERROR	;go if disk error
	LD	A,(DDIRBUF+1)	;get directory track
	LD	D,A		;pass to D
	LD	E,1		;sector 1
	LD	(DESDIR),DE	;dest dir location
	LD	A,18		;18 sectors in directory
	LD	BC,DDIRBUF	;dest directory buffer
	CALL	DMREAD		;read multiple dest secs
	LD	HL,MSG8		;error message
	JP	NZ,ERROR	;go if disk error
;
;	check for correct read-protect status
;
	LD	A,(RESULT)	;get I/O result
	BIT	5,A		;read protected?
	LD	HL,MSG11	;error message
	JP	NZ,ERROR	;go if wrong DAM type
	LD	HL,DDIRBUF	;dest directory buffer
	LD	BC,2800H	;40 tracks / gran counter
GRNLOOP	LD	A,(HL)		;get a byte
	CPL			;reverse bits
	AND	3FH		;low 5 only
	PUSH	BC		;save counter/totaler
	LD	BC,0600H	;6 bits / clear counter
GHNLP	RRA			;check a bit
	CALL	C,BUMPC		;count if clear
	DJNZ	GHNLP		;go for 6 bits
	LD	A,C		;get result
	POP	BC		;restore BC
	ADD	A,C		;add to subtotal
	LD	C,A		;update subtotal
	INC	HL		;bump GAT pointer
	DJNZ	GRNLOOP		;go for track count
	LD	(DGRANS),A	;save # dest grans
	CALL	ASCII		;convert to ascii
	LD	(MSG18),A	;to text string
	LD	(MSG18+1),BC	;rest of it
	LD	HL,DDIRBUF+0D0H	;start disk name/date
	CALL	PUTNMDT		;move into text
	LD	HL,MSG18	;start message
	RST	20H		;display message
	LD	A,(DGRANS)	;get dest grans
	LD	C,A		;save it
	LD	A,(SGRANS)	;get source grans
	CP	C		;compare
	JR	Z,DOLOOP	;go if enough
	JR	C,DOLOOP	;go if enough
	LD	A,1		;else set flag
	LD	(FLAG),A	;set prompting flag
	LD	HL,MSG28	;message
	RST	20H		;display it
;
DOLOOP	LD	HL,MSG19	;message
	RST	28H		;display it
	JP	COPYALL		;copy the files!
;
BUMPC	INC	C		;bump counter
	RET			;done!
;
;	error, restart program
;
TASKERR	LD	A,(SOURCE)	;get source drive
	LD	(DEST),A	;as dest to force prompt
	CALL	SMOUNT		;mount source disk!
	RST	8		;restart program
;
;	test memory address
;
TMEM	LD	A,(HL)		;fetch a byte
	CPL			;reverse bits
	LD	(HL),A		;update memory
	CP	(HL)		;still there?
	CPL			;reverse back
	LD	(HL),A		;restore original
	RET			;done, Z=memory there
;
;	display control code to video
;
CONTROL	CP	10		;linefeed?
	JR	Z,LINFEED
	CP	11		;tab?
	JR	Z,TAB
	CP	1DH		;cursor to begin of line?
	JR	Z,BOL
	CP	1EH		;clear to end of line?
	JR	Z,EOL
	CP	31		;clear screen?
	JR	Z,CLS		;do it
	RET
;
LINFEED	LD	DE,40H		;# bytes / row
	CALL	BOL		;move to begin of line
	ADD	HL,DE		;begin of next line
	JR	OFFVID		;check if in video range
;
TAB	LD	A,L		;get LSB
	AND	0E0H		;reset to last tab bound
	LD	L,A		;update LSB
	LD	DE,20H		;offset to next tab
	ADD	HL,DE		;HL => next tab stop
	JR	OFFVID		;check if still on video
;
BOL	LD	A,L		;get LSB video
	AND	0C0H		;reset to begin of line
	LD	L,A		;update
	RET			;done!
;
EOL	CALL	BOL		;cursor to begin of line
	PUSH	BC		;save it
	LD	BC,3FH		;length of line -1
FIXCON	PUSH	HL		;save start
	LD	D,H		;pass start to DE
	LD	E,L
	INC	DE		;start +1
	LD	(HL),' '	;load space
	LDIR			;clear area
	POP	HL		;restore start
	POP	BC		;restore BC counter
;
;	check if video in correct memory addresses
;
OFFVID	LD	A,H		;get MSB video
	CP	3CH		;< video?
	JR	NC,OFFAOK	;nope, go!
	LD	HL,3C00H	;reset to first video
	RET			;done
OFFAOK	CP	40H		;> video?
	RET	C		;nope, in range!
;
;	scroll video screen
;
	PUSH	BC		;save
	LD	DE,3C00H	;video start
	LD	HL,3C40H	;video start + next row
	LD	BC,3C0H		;length -row
	LDIR			;scroll video
	POP	BC		;restore BC
	LD	HL,3FC0H	;cursor to bottom row
	JR	EOL		;clear current line
;
;	clear video screen
;
CLS	LD	HL,3C00H	;start video
	PUSH	BC		;save it
	LD	BC,1023		;length video -1
	JR	FIXCON		;fill block!
;
;	strobe keyboard
;
KEY	PUSH	HL		;save registers
	PUSH	DE
	PUSH	BC
	LD	HL,GET		;return vector
	PUSH	HL		;leave on stack
;
	LD	HL,STRSPC	;keyboard work mask
	LD	BC,3801H	;start keyboard memory
	LD	D,0		;init row counter
;
NEXROW	LD	A,(BC)		;get key byte
	LD	E,A		;save it here
	XOR	(HL)		;reverse with mask
	LD	(HL),E		;save new key
	AND	E		;same as last key?
	JR	NZ,HAVEIT	;have a new one
	INC	D		;bump row count
	INC	L		;bump mask byte
	RLC	C		;move key memory
	JP	P,NEXROW	;go for 7 rows
	RET			;done, no keys!
;
HAVEIT	LD	E,A		;save masked byte
	LD	A,D		;get row count
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	LD	D,A		;row * 8
	LD	C,1		;column mask bit
;
MKT1	LD	A,C		;get mask
	AND	E		;this the right key?
	JR	NZ,MKT2		;yup, go!
	INC	D		;bump row*8
	RLC	C		;shift mask bit left
	JR	MKT1		;continue
;
MKT2	LD	HL,KEYTABL	;look up key table
	LD	C,D		;pass key offset
	LD	B,0		;bc=displacement
	ADD	HL,BC		;HL => key
	LD	A,(HL)		;get the char
;
;	add keybounce delay
;
GOTKEY	LD	BC,1000H	;debounce delay
DELAY	PUSH	AF		;countdown
	DEC	BC		;less counter
	LD	A,A		;time adjust mod III
	LD	A,B		;done?
	OR	C		;BC = 0000?
	JR	NZ,DELAY+1	;go if more to do
	POP	AF		;restore input key
	RET			;done!
;
;	keyboard unstacker
;
GET	POP	BC		;unstack 'em
	POP	DE
	POP	HL
	OR	A		;set flags on input key
	RET			;restore 'em all
;
;	keyboard lookup table
;
KEYTABL	DEFB	'@ABCDEFG'
	DEFB	'HIJKLMNO'
	DEFB	'PQRSTUVW'
	DEFB	'XYZ*****'
	DEFB	'01234567'
	DEFB	'89:+<->?'
	DEFB	13,3,1,5BH,5CH,5DH,5EH,20H
;
;	convert binary A to decimal ascii ACB
;
ASCII	LD	B,'0'		;init MSB
ASCI1	SUB	100		;check 100's place
	JR	C,ASCI2		;go if found
	INC	B		;else bump ascii digit
	JR	ASCI1		;continue
;
ASCI2	PUSH	BC		;save MSB on stack
	ADD	A,100		;add back last subtract
	LD	C,'0'		;init NSB
;
ASCI3	SUB	10		;check 10's place
	JR	C,ASCI4		;go if found
	INC	C		;bump ascii
	JR	ASCI3		;go more
;
ASCI4	ADD	A,10+'0'	;last sub + ascii
	LD	B,A		;pass LSB
	POP	AF		;get MSB
	CP	'0'		;nil MSB?
	RET	NZ		;nope, go!
	LD	A,' '		;else reset to space
	RET			;done!
;
;	common driver for file subroutines
;
FILECOM	LD	(CMDADDR),HL	;common looper
;
FILLOOP	LD	IX,SDIRBUF+200H	;init directory pointer
	LD	B,64		;# files to check
;
FILELP	BIT	4,(IX+0)	;active file?
	JR	Z,NEXFILE	;skip dead ones
	BIT	6,(IX+0)	;system file?
	JR	NZ,NEXFILE	;skip if yes
	BIT	3,(IX+0)	;invisible ?
	JR	NZ,NEXFILE	;skip them too
;
	PUSH	BC		;save counter
	CALL	$		;set from calling routine
CMDADDR	EQU	$-2
	POP	BC		;restore counter
;
NEXFILE	LD	DE,20H		;offset to next file
	ADD	IX,DE		;IX => next file
	DJNZ	FILELP		;go for file count
	RET			;done with all!
;
;	print/count current filespec
;
PRTFILE	PUSH	BC		;save loop counter
	LD	HL,SFILES	;# source files
	INC	(HL)		;add this file
	LD	B,8		;8 chars in name
	PUSH	IX		;IX => IY
	POP	IY		;IY+5 => filespec
	LD	HL,FILENAM	;name string
	PUSH	HL		;save on stack
;
PF1	LD	B,8		;8 chars in name
	CALL	PFPUT		;put in string
	LD	A,(IY+5)	;get next byte
	CP	' '		;any extension?
	JR	Z,PF2		;go if not
	LD	(HL),'/'	;for extension
	INC	HL		;bump string pointer
	LD	B,3		;3 char extension
	CALL	PFPUT		;move it in
;
PF2	LD	(HL),0		;terminate message
	POP	HL		;filename message
	RST	20H		;display it
	CALL	MNYGRNS		;how many grans this file
	LD	A,(HL)		;get file gran count
	CALL	ASCII		;to decimal ascii
	LD	(GRANMSG),A	;to the string
	LD	(GRANMSG+1),BC	;to the string
	LD	HL,GRANMSG-3	;start of message
	RST	20H		;display it
	POP	BC		;restore counter
	RET			;done
;
;	compute # grans in current file
;
MNYGRNS	PUSH	IX		;IX => IY
	POP	IY		;IY => start file record
	LD	HL,GRANS	;how many grans
	LD	(HL),0		;start with 0
;
MGRLP	LD	A,(IY+22)	;get extent element
	INC	A		;FF terminator?
	RET	Z		;done if yes!
	INC	A		;FE extension?
	JR	Z,MGREXT	;yes, fetch it
;
	LD	A,(IY+23)	;get # grans
	AND	1FH		;low 5 bits only
	CALL	GRAN13		;compute offset factor
	RET	Z		;go if nil file
	LD	B,A		;give here for count
	CALL	ADDCNT		;bump counter B times
	PUSH	HL		;save counter pointer
	LD	HL,SGRANS	;add to total
	CALL	ADDCNT		;bump this one
	POP	HL		;restore pointer
	INC	IY		;bump position
	INC	IY		;to next extry pair
	JR	MGRLP		;continue
;
;	fetch extension of file
;
MGREXT	LD	A,(IY+23)	;get DEC of extension
	LD	IY,SDIRBUF+200H	;start source dir recs
	LD	C,A		;pass DEC to C
	AND	7		;get sector offset
	LD	B,A		;pass to MSB
	LD	A,C		;get original DEC
	AND	0E0H		;get byte offset
	LD	C,A		;BC = offset to entry
	ADD	IY,BC		;IY => extension entry
	JR	MGRLP		;fetch # grans here!
;
;	increment counter
;
ADDCNT	LD	C,B		;save the count
ADDCLP	INC	(HL)		;bump the counter
	DJNZ	ADDCLP		;till B = 0
	LD	B,C		;get count back
	RET			;done
;
;	reset counter
;
INITCNT	LD	(HL),' '	;load blank
	INC	HL		;bump pointer
	LD	(HL),' '	;second byte
	INC	HL
	LD	(HL),'0'	;init lsb
	RET			;cleared
;
;	move filespec data to name string
;
PFPUT	LD	A,(IY+5)	;get name byte
	CP	' '		;space ?
	JR	Z,PFPUTX	;skip them
	LD	(HL),A		;else put in string
	INC	HL		;bump string pointer
PFPUTX	INC	IY		;get next byte
	DJNZ	PFPUT		;go for length of field
	RET			;done, text moved!
;
;	fetch current track from table
;
GETTRK	PUSH	HL		;save HL
	PUSH	AF		;save C flag
	LD	HL,CTRACK	;current track table
	LD	A,0		;binary drive
DRIVE	EQU	$-1
	ADD	A,L		;point to right byte
	LD	L,A		;HL => track byte
	POP	AF		;restore C flag
	JR	C,PUTIN		;C = put in table
	LD	A,(HL)		;get the byte
PUTIN	LD	(HL),A		;put byte in table
	POP	HL		;restore HL
	OR	A		;set flags this byte
	RET			;done
;
;	fetch char from keyboard with cursor flash
;
INKEY	LD	HL,(CURSOR)	;get cursor address
	LD	BC,400H		;delay count
	LD	A,(HL)		;get cursor byte
	CP	95		;cursor on?
	LD	A,95		;set ON char
	JR	NZ,CUPUT	;go if not on
	LD	A,140		;set OFF char
CUPUT	LD	(HL),A		;char to video
INKI	CALL	KEY		;scan keyboard
	JR	NZ,KEYIN	;have a key, go
	DEC	C		;decrement flash counter
	JR	NZ,INKI		;go for count
	DJNZ	INKI		;16 bit counter
	JR	INKEY+3		;reverse cursor
KEYIN	CP	'a'		;lowercase input?
	JR	C,INKEYOK	;nope
	AND	5FH		;make it uppercase
INKEYOK	LD	(HL),A		;display it
	RET			;done
;
;	author name checker
;
KIM2	DEFB	'K'+80H,'i'+80H,'m'+80H,' '+80H
	DEFB	'W'+80H,'a'+80H,'t'+80H,'t'+80H
;
;	interrupt task processor
;
TASK	PUSH	AF		;save needed registers
	PUSH	BC
	PUSH	DE
	PUSH	HL
;
	IN	A,(0E0H)	;read interrupt latch
	BIT	2,A		;RTC interrupt?
	JR	NZ,TASKDON	;nope, go!
;
;	check for author name change
;
	LD	HL,KIM		;name in program
	LD	DE,KIM2		;checker string
	LD	B,8		;name length
;
CHKIM	LD	A,(DE)		;get a byte
	AND	7FH		;drop high bit
	CP	(HL)		;match?
	CALL	NZ,KILLPGM	;nope, kill program!
	INC	HL		;bump source
	INC	DE		;bump test
	DJNZ	CHKIM		;go for length
;
;	check for BREAK key
;
	LD	A,(3840H)	;read keyboard
	AND	4		;break pressed?
	JR	Z,NOTBRK	;go if not
	LD	A,(3880H)	;get shift key
	OR	A		;pressed?
	JR	Z,NOTBRK	;go if not
	RST	8		;restart on SHIFT/BREAK
;
NOTBRK	LD	A,3		;get task counter
TASKCNT	EQU	$-1
	DEC	A		;less this interrupt
	LD	(TASKCNT),A	;update counter
	JR	NZ,TASKDON	;go if not time
	LD	A,3		;reset counter
	LD	(TASKCNT),A	;update for next pass
	CALL	ALIVE		;change 'alive'
;
TASKDON	IN	A,(0ECH)	;clear RTC interrupt
	POP	HL		;restore stack
	POP	DE
	POP	BC
	POP	AF
	EI			;enable interrupts
	RET			;return from interrupt
;
;	author name changed!  kill program!
;
KILLPGM	LD	HL,3C00H	;start memory
	LD	DE,3C01H	;start +1
	LD	BC,-1-3C00H	;length of memory -1
	LD	(HL),0C7H	;RST 00 opcode
	LDIR			;fill memory with 'em
	RST	0		;failer!
;
ERROR	RST	20H		;display error message
	LD	HL,MSG10	;termination
	RST	20H		;display prompt
;
;	clear current track table for 'restore'
;
	LD	HL,CTRACK	;current track table
	LD	B,4		;4 bytes long
FIXTRK	LD	(HL),0		;load zero
	INC	HL		;bump pointer
	DJNZ	FIXTRK		;fill table
	JP	TASKERR		;remount disk
;
;	multiple sector read on source disk
;
SMREAD	PUSH	AF		;save sector count
	XOR	A		;load zero
	LD	(DENSITY),A	;single density
	LD	(LOSEC),A	;lowest sector
	LD	A,10		;highest sector +1
	LD	(TPSEC),A	;top sector
	JR	MREAD		;go common
;
;	multiple read on destination disk
;
DMREAD	PUSH	AF		;save sector count
	LD	A,80H		;set bit 7
	LD	(DENSITY),A	;set double density
	LD	A,19		;highest sector +1
	LD	(TPSEC),A	;top sector
	LD	A,1		;lowest sector
	LD	(LOSEC),A	;save low sector
	JR	MREAD		;go common
;
;	multiple sector write on dest disk directory
;
MDWRITE	LD	HL,DWRITE	;directory write
	JR	MWRITE+3	;go common
;
MREAD	LD	HL,READ		;read routine
	LD	(RDWRT),HL	;pass read/write vector
	LD	A,(DRIVE)	;get drive #
	PUSH	BC		;save it
	CALL	DRIVSET		;setup for drive activity
	POP	BC		;restore BC
	POP	AF		;restore sector count
	JR	MCOMM		;go common
;
MWRITE	LD	HL,WRITE	;sector write driver
	LD	(RDWRT),HL	;save in code
	PUSH	AF		;save sector count
	LD	A,80H		;set bit 7
	LD	(DENSITY),A	;set double density
	LD	A,19		;highest sector +1
	LD	(TPSEC),A	;save top sector
	LD	A,1		;lowest sector
	LD	(LOSEC),A	;save low sector
	LD	A,(DRIVE)	;get drive #
	PUSH	BC		;save
	CALL	DRIVSET		;setup for I/O
	POP	BC		;restore BC
	POP	AF		;restore sector count
;
MCOMM	LD	L,A		;L = counter
MLOOP	PUSH	HL		;save counter
	CALL	$		;do the command
RDWRT	EQU	$-2
	POP	HL		;restore count
	RET	NZ		;bad I/O, go!
	INC	E		;bump sector
	LD	A,E		;check for end of track
	SUB	0		;10/18 secs/track
TPSEC	EQU	$-1
	JR	NZ,XLOOP	;go loop
	LD	E,0		;0/1 lowest sector
LOSEC	EQU	$-1
	INC	D		;bump track
XLOOP	DEC	L		;reduce counter
	RET	Z		;all done, go!
	JR	MLOOP		;else more, continue
;
;	move name/date text into display string
;
PUTNMDT	LD	DE,MSG2		;use this message string
	LD	BC,8		;8 chars in name & date
	PUSH	BC		;save 8
	LDIR			;move into text string
	INC	DE		;skip a space
	LD	A,'-'		;load separator
	LD	(DE),A		;to string
	INC	DE		;skip a space
	INC	DE
	POP	BC		;get 8 back
	LDIR			;move in date field
	LD	HL,MSG2AA	;start message
	JP	PRINT		;display/return
;
;	single sector write driver
;
WRITE1	LD	A,0FFH		;error mask
	LD	(MASK),A	;save it
	LD	(SPPASS),SP	;save stack pointer
	CALL	SETNMI		;setup for disk NMI
	RET	NZ		;go if error
	LD	A,0A0H		;write command
IOTYPE	EQU	$-1
	OUT	(0F0H),A	;issue command
	CALL	DSKSLO		;wait for FDC ready
;
W1	IN	A,(0F0H)	;read FDC status
	AND	E		;ready for byte?
	JR	Z,W1		;wait if not
	OUTI			;else send the byte
	LD	B,60H		;delay count
	DJNZ	$		;wait for 2nd byte
	LD	A,D		;get 'wait' command
	DEC	B		;B = 255 bytes remaining
W2	OUT	(0F4H),A	;issue 'wait' command
	OUTI			;write a byte
	JR	NZ,W2		;go for sector length
	JR	$		;wait here for interrupt
;
;	sector read routine
;
READ	LD	HL,READ1	;sub vector
	JR	DOBOTH-3	;go common
;
;	directory sector write
;
DWRITE	LD	A,0A0H		;write FDC command
	JR	WRITXX		;go common
;
;	data sector write
;
WRITE	LD	A,0A1H		;write FDC command
WRITXX	LD	(IOTYPE),A	;pass I/O command
	LD	HL,WRITE1	;subroutine vector
	LD	(READ1X+1),HL	;pass it
DOBOTH	LD	A,10		;init retry counter
	LD	(R1COUNT),A	;set pass counter
READ1X	CALL	$		;call driver
	RET	Z		;go if OK
;
;	check for NOT FOUND error to restore drive
;
	PUSH	AF		;save error
	BIT	4,A		;'not found' error?
	JR	Z,READ1Y	;go if not
	XOR	A		;load zero
	SCF			;set carry flag
	CALL	GETTRK		;update track table
READ1Y	POP	AF		;restore status
	EX	AF,AF'		;save it
	LD	A,0		;get remain retry count
R1COUNT	EQU	$-1
	DEC	A		;less this try
	LD	(R1COUNT),A	;update counter
	JR	NZ,READ1X	;go if more tries left
	EX	AF,AF'		;get original error
	RET			;return NZ
;
;	read single disk sector
;
READ1	LD	A,9FH		;set error mask
	LD	(MASK),A	;save error mask
	LD	(SPPASS),SP	;save stack pointer
	CALL	SETNMI		;setup for disk NMI
	RET	NZ		;go if error
	LD	A,80H		;sector read command
	OUT	(0F0H),A	;issue command
	CALL	DSKSLO		;wait for valid status
;
R1	IN	A,(0F0H)	;read FDC status
	AND	E		;byte ready?
	JR	Z,R1		;wait if not
	INI			;read byte from FDC
	LD	A,D		;get 'wait' command
;
R2	OUT	(0F4H),A	;issue 'wait' command
	INI			;read a byte
	JR	NZ,R2		;go for sector length
	JR	$		;wait for interrupt
;
;	setup for disk NMI
;
SETNMI	LD	(BUFSAVE),BC	;pass buffer pointer
	LD	(SECSAVE),DE	;pass track/sector
	CALL	SEEK		;move head to track
	RET	NZ		;go if error
	CALL	SELECT		;re-select drive
	LD	A,(DRIV)	;get binary drive
	OR	40H		;set 'wait' bit
	LD	D,A		;pass to D
	LD	E,2		;bit 1 transfer mask
	LD	HL,RETNMI	;disk NMI return vector
	LD	(404AH),HL	;pass vector
	LD	A,0C0H		;enable disk NMI
	OUT	(0E4H),A	;NMI engaged!
	LD	H,B		;pass buffer to BC
	LD	L,C		;HL => I/O buffer
	LD	BC,0F3H		;B=counter, C=xfer port
	IN	A,(0F0H)	;clear status register
	DI			;disable for transfer
	XOR	A		;load ZERO / no error
	RET			;NMI engaged!
;
;	return vector for disk NMI
;
RETNMI	XOR	A		;load zero
	OUT	(0E4H),A	;disable disk NMI
	LD	HL,NMIRET	;non-disk vector
	LD	(404AH),HL	;pass vector
	LD	SP,$		;reset stack
SPPASS	EQU	$-2
	LD	DE,$		;reset track/sector
SECSAVE	EQU	$-2
	LD	BC,$		;reset buffer
BUFSAVE	EQU	$-2
	INC	B		;bump MSB buffer
;
	IN	A,(0F0H)	;read FDC status
	LD	(RESULT),A	;save non-masked result
	AND	0		;check for error
MASK	EQU	$-1
	EI			;can enable now
	RET	Z		;go if no error
;
	PUSH	AF		;save error code
	LD	A,0D0H		;FDC reset command
	OUT	(0F0H),A	;reset FDC for retry
	DEC	B		;restore buffer pointer
	POP	AF		;restore flags
	RET			;return in error
;
;	non-disk NMI vector
;
NMIRET	RETN
;
;	fetch ascii drive #
;
DRVASC	LD	A,(DRIVE)	;get binary drive
	ADD	A,'0'		;add ascii
	RET			;that's all
;
;	short delay to wait for valid FDC status
;
DSKSLO	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	RET
;
;	move head to desired track
;
SEEK	CALL	SELECT		;select drive
	OR	A		;clear carry flag
	CALL	GETTRK		;get current track
	JR	NZ,SEEK1	;continue if not 0
	CALL	RESTORE		;restore to track 0
	RET	NZ		;bad one
;
SEEK1	OUT	(0F1H),A	;load current track reg
	PUSH	AF		;save track
	LD	A,D		;get desired track
	OUT	(0F3H),A	;FDC xfer register
	LD	A,E		;get sector
	OUT	(0F2H),A	;FDC sector register
	LD	A,D		;get track back
	CP	16H		;need write pre-comp?
	LD	A,(DRIV)	;get drive #
	RES	5,A		;reset precomp
	JR	C,SEEKX		;go if <16H
	SET	5,A		;set precomp
SEEKX	LD	(DRIV),A	;update drive select
	POP	AF		;restore track
	CP	D		;already on the track?
	JR	Z,SEEK2		;don't bother with it
	LD	A,18H		;seek command
	CALL	MOVE		;move the head
	RET	NZ		;error in move
SEEK2	IN	A,(0F1H)	;get current head loc.
	SCF			;carry = put in table
	CALL	GETTRK		;put it in table
	XOR	A		;set Z flag for no error
	RET			;done OK
;
;	restore head to track 0
;
RESTORE	LD	A,08H		;drive restore command
	CALL	MOVE		;move the head
	RET	NZ		;bad, return in error
	IN	A,(0F0H)	;get FDC status
	CPL			;reverse the bits
	BIT	2,A		;head over track 0 ?
	LD	A,0		;set track 0
	RET			;Z = OK
;
;	common subroutine to move drive head
;
MOVE	AND	0FCH		;drop low 3 bits
	OR	3		;set SLOW step rate
SPEED	EQU	$-1
	OUT	(0F0H),A	;issue head command
	CALL	DSKSLO		;wait for valid status
MOVEWT	CALL	SELECT		;select the drive
	IN	A,(0F0H)	;read status
	BIT	0,A		;command pending?
	JR	NZ,MOVEWT	;wait for it if yes
	AND	18H		;check for seek error
	RET			;return with status
;
;	setup for drive activity
;
DRIVSET	AND	3		;drive 0-3 only
	LD	(DRIVE),A	;pass binary drive #
	LD	B,1		;which bit to set
	OR	A		;set flags
	JR	DRVCK		;have it
DRVSET	SLA	B		;move drive bit left
	DEC	A		;binary - 1
DRVCK	JR	NZ,DRVSET	;continue loop
	LD	A,B		;get bit
	OR	80H		;combine with density
DENSITY	EQU	$-1
	LD	(DRIV),A	;save for drive select
	RET			;done
;
;	display string to video
;
PRINT	LD	A,(HL)		;get data byte
	INC	HL		;bump pointer
	OR	A		;check for terminator
	RET	Z		;done if yes
	CP	20H		;control byte ?
	PUSH	HL		;save data pointer
	LD	HL,(CURSOR)	;get cursor position
	JR	C,DOCTL		;do control byte
	LD	(HL),A		;display the byte
	CP	(HL)		;still there ?
	JR	Z,PRTOK		;lower case if yes
	SUB	20H		;make it upper case
	LD	(HL),A		;put it back
PRTOK	INC	HL		;bump the cursor
	LD	(CURSOR),HL	;update where it is
	POP	HL		;get data address back
	JR	PRINT		;do next byte
;
;	execute control byte call
;
DOCTL	CALL	CONTROL		;display control code
	JR	PRTOK+1		;continue
;
;	flash message text on video
;
FLASH	EXX			;swap registers
	LD	HL,MSG0		;clear line text
	EXX			;swap back
	JR	WAIT2		;go flasher
;
;	mount SOURCE disk
;
SMOUNT	LD	HL,MSG4		;mount source diskette
	XOR	A		;load zero
	LD	(DENSITY),A	;set single density
	LD	A,(SOURCE)	;source drive
	JR	MOUNT		;go common routine
;
;	mount DESTINATION disk
;
DMOUNT	LD	HL,MSG5		;mount destination disk
	LD	A,80H		;set bit 7
	LD	(DENSITY),A	;set double density
	LD	A,(DEST)	;dest drive
;
MOUNT	CALL	DRIVSET		;set up for select
	EXX			;alternate HL
	LD	HL,MSG0		;clear line code
	EXX			;back to this
	LD	A,0		;get source drive
SOURCE	EQU	$-1
	CP	0		;same as destination ?
DEST	EQU	$-1
	JR	NZ,MOUNTDN	;no need to prompt!
;
WAIT2	PUSH	HL		;save message pointer
	RST	20H		;print it
	POP	HL		;restore start
LOOP2	CALL	KEY		;get a key
	CP	13		;have enter key?
	JR	Z,MOUNTDN	;terminate if yes
	LD	A,0		;get counter
COUNT1	EQU	$-1
	DEC	A		;less 1
	LD	(COUNT1),A	;put updated one back
	JR	NZ,LOOP2	;go if not time to change
	EXX			;other message
	JR	WAIT2		;print this message/wait
;
MOUNTDN	LD	HL,MSG0		;clear line text
	RST	20H		;print it
	RET			;done!
;
*GET	SMOVE2			;part 2
;
	END	ENTRY
