;ldcopy4/asm - kjw/bqsd - revised 12/82
;
	PAGE
;
	SUBTTL	'<LDCOPY4/ASM - Format Image Creation>'
;
;	convert binary in HL to ascii in (IY)
;
;	define decimal places
;
TENTBL	DEFW	10000
	DEFW	1000
	DEFW	100
	DEFW	10
	DEFW	1
;
WRLNO	PUSH	DE		;save registers
	PUSH	IX
	LD	IX,TENTBL	;lookup table
;
WRL1	LD	E,(IX)		;get LSB
	LD	D,(IX+1)	;get MSB decimal place
	LD	A,'0'		;start digit
;
WRL2	OR	A		;clear carry
	SBC	HL,DE		;remove this place
	JR	C,WRL3		;go if place found
	INC	A		;bump ascii digit
	JR	WRL2		;continue
;
WRL3	ADD	HL,DE		;add last subtract back
	LD	(IY),A		;place ascii in string
	INC	IY		;bump text pointer
	INC	IX		;bump table pointer
	INC	IX		;word table (2 bytes)
	DEC	E		;see if at last posit
	JR	NZ,WRL1		;go next digit if more
;
	POP	IX		;unstack
	POP	DE		;this too
	RET			;string loaded!
;
	PAGE
;
;	create format track image in memory buffer
;
BUILD	LD	A,(IY+8)	;fetch current track
	OR	A		;on track zero?
	CALL	Z,ZBUFF		;clear buffer if first
	JP	BUILDIT		;build it!
;
;	test memory for 48K
;
;	fill all memory with all bits on
;	this will allow a short settling time to test
;	for delayed errors
;
TESTMEM	LD	HL,PGMEND	;end of program
	LD	DE,PGMEND+1	;end +1
	LD	(HL),-1		;all bits on
	LD	BC,0-PGMEND	;length of buffer
	PUSH	HL		;save test start
	LDIR			;fill with all bits on
	POP	HL		;buffer start
;
TESTLP	LD	A,-1		;load all bits on
	CP	(HL)		;all bits still on?
	JR	NZ,BADMEM	;nope, go!
;
	LD	IX,TESTBL	;test pattern table
	LD	A,(IX)		;get test byte
;
TESTER	LD	(HL),A		;load test byte to RAM
	CP	(HL)		;still there?
	JR	NZ,BADMEM	;nope, go!
	INC	IX		;bump test table
	LD	A,(IX)		;fetch a byte
	CP	80H		;terminator
	JR	NZ,TESTER	;test all possible combos
;
	INC	L		;increment LSB pointer
	JR	NZ,TESTLP	;go if not page boundary
;
	INC	H		;bump MSB buffer
	JR	NZ,TESTLP	;go till 0000H
	JP	ALVBAK		;restore 'alive'
;
;	table of test bytes for quick mem test
;
TESTBL	DEFB	10101010B	;alternate bits
	DEFB	01010101B	;opposite
	DEFB	11001100B	;bit pairs
	DEFB	00110011B	;opposite
	DEFB	11110000B	;nybbles
	DEFB	00001111B	;opposite
	DEFB	00000000B	;leave all off
	DEFB	80H		;table terminator
;
;	bad memory!
;
BADMEM	LD	HL,MSG37	;'faulty memory'
	CALL	DISPLAY		;display it
;
DEAD	JP	DEAD		;BREAK will retry again
;
;	compare buffer BC points to with (VBUFF)
;
COMPARE	PUSH	HL		;save registers
	PUSH	DE
	PUSH	BC
;
	LD	HL,VBUFF	;start of ver buffer
	LD	D,0		;init count
;
COMPLP	LD	A,(BC)		;fetch a byte
	CP	(HL)		;match?
	JR	NZ,COMPRET	;nope, return
	INC	BC		;bump pointer A
	INC	HL		;pointer B
	DEC	D		;less byte counter
	JR	NZ,COMPLP	;go for 256 bytes
;
COMPRET	POP	BC		;unstack
	POP	DE
	POP	HL
	RET			;Z = match else NZ
;
;	create track to track 'skewing' on sector table
;
ORDNEW	PUSH	BC		;save registers
	PUSH	DE
	PUSH	HL
;
	EX	DE,HL		;HL => sector order table
	LD	B,3		;3 rotations
	DEC	C		;# sectors / track -1
	LD	A,(IY+19)	;get density
	OR	A		;single?
	JR	Z,ORDNEW1	;yes, go!
	LD	B,4		;4 rotations double den
;
ORDNEW1	PUSH	BC		;save counters
	LD	A,(HL)		;fetch table byte
	PUSH	HL		;save table start
	INC	HL		;bump to next sector
;
ORDNEW2	LD	E,(HL)		;fetch sector #
	LD	(HL),A		;load last #
	LD	A,E		;fetch new number
	INC	HL		;bump table
	DEC	C		;less # sectors -1
	JR	NZ,ORDNEW2	;go for # sectors -1
	POP	HL		;restore table start
	LD	(HL),A		;last byte => first byte
	POP	BC		;restore counters
	DJNZ	ORDNEW1		;go for # 'skews'
;
	POP	HL		;unstack
	POP	DE
	POP	BC
	RET			;table ready for next trk
;
;	create format track image in RAM
;
BUILDIT LD	HL,SORDER	;single order table
	LD	A,(IY+19)	;get current density
	OR	A		;single?
	JR	Z,FIGBLD	;yes, go!
	LD	HL,DORDER	;double density table
;
FIGBLD	LD	C,(HL)		;get # sectors / track
	INC	HL		;bump table
	LD	E,(HL)		;get sector table pointer
	INC	HL		;bump table
	LD	D,(HL)		;get MSB sector table
	INC	HL		;bump table
	CALL	ORDNEW		;rotate track/track skew
	PUSH	DE		;save table pointer
	LD	DE,BUFFER	;I/O buffer to use
	EX	DE,HL		;HL => buff, DE => table
;
;	load post index gap to buffer
;
	CALL	MOVEIN		;load post index gap
	CALL	MOVEIN		;post index sync
	CALL	MOVEIN		;post index sync
	LD	(HL),0FCH	;index marker
	INC	HL		;bump buffer
	LD	(DESVE),DE	;save table pointer
;
;	loop here for each sector
;
SECLP	LD	DE,0		;fetch table pointer
DESVE	EQU	$-2
	CALL	MOVEIN		;pre-ID gap
	CALL	MOVEIN		;move in pre-ID sync A
	CALL	MOVEIN		;move in pre-ID sync B
;
;	create ID field for current sector in buffer
;
	LD	(HL),0FEH	;ID header
	INC	HL		;bump buffer
	LD	A,(IY+8)	;get current track
	LD	(HL),A		;to buffer
	INC	HL		;bump buffer
	LD	(HL),0		;head # (side 0)
	INC	HL		;bump buffer
	EX	(SP),HL		;fetch sector table
	LD	A,(HL)		;fetch sector #
	INC	HL		;bump table
	EX	(SP),HL		;save, get buffer back
	LD	(HL),A		;sector # to buffer
	INC	HL		;bump pointer
	LD	(HL),1		;sector length (256 bytes
	INC	HL		;bump pointer
	LD	(HL),0F7H	;generate CRC
	INC	HL		;bump buff
;
	CALL	MOVEIN		;pre data gap field
	CALL	MOVEIN		;pre data sync A
	CALL	MOVEIN		;pre data sync B
;
;	create DATA field
;
	LD	(HL),0FBH	;DATA header
	INC	HL		;bump pointer
	CALL	FILLDAT		;load data into sector
	LD	(HL),0F7H	;generate CRC
	INC	HL		;bump pointer
;
	DEC	C		;less this sector
	JR	NZ,SECLP	;finish all sectors
	POP	AF		;remove table from stack
	JR	MOVEIN		;fill 256 more bytes
;
;	single density table
;
SORDER	DEFB	10		;10 sectors / track
	DEFW	ORDERS		;sector order table
;
	DEFB	16,0FFH		;post index gap
	DEFB	03,000H		;post index sync
	DEFB	03,000H		;post index sync
;
	DEFB	12,0FFH		;pre-id gap
	DEFB	03,000H		;pre-id sync A
	DEFB	03,000H		;pre-id sync B
;
	DEFB	10,0FFH		;pre-data gap
	DEFB	02,000H		;pre-data sync A
	DEFB	02,000H		;pre-data sync B
	DEFB	0E5H,0E5H	;data fill bytes
;
	DEFB	00,0FFH		;pre-index gap
;
;	sector order table for single density
;
ORDERS	DEFB	0,5,1,6,2,7,3,8,4,9
;
;	double density definition table
;
DORDER	DEFB	18		;18 sectors/track
	DEFW	ORDERD		;sector order table
;
	DEFB	32,04EH		;post index gap
	DEFB	12,000H		;post index sync
	DEFB	03,0F6H		;post index sync
;
	DEFB	22,04EH		;pre-id gap
	DEFB	12,000H		;pre-id sync A
	DEFB	03,0F5H		;pre-id sync B
;
	DEFB	24,04EH		;pre-data gap
	DEFB	08,000H		;pre-data sync A
	DEFB	03,0F5H		;pre-data sync B
	DEFB	6DH,0B6H	;data fill codes
;
	DEFB	00,04EH		;pre-index gap
;
;	sector order table for double density
;
ORDERD	DEFB	00,06,12,01,07,13,02,08,14
	DEFB	03,09,15,04,10,16,05,11,17
;
;	move bytes from table into buffer
;
MOVEIN	LD	A,(DE)		;fetch table byte
	INC	DE		;bump pointer
	LD	B,A		;pass # bytes to fill
	LD	A,(DE)		;fetch fill byte
	INC	DE		;bump pointer
;
;	fill block memory
;
FILL	LD	(HL),A		;load byte into buffer
	INC	HL		;bump pointer
	DJNZ	FILL		;go for B # bytes
	RET			;done!
;
;	fill actual sector data
;
FILLDAT	PUSH	BC		;save
	EX	DE,HL		;HL => table
	LD	B,(HL)		;get entry
	INC	HL		;bump table
	LD	C,(HL)		;get second byte
	INC	HL		;bump table
	EX	DE,HL		;HL=>buffer, DE=> table
	LD	A,80H		;1/2 length of buffer
;
FILLA	LD	(HL),B		;load byte into buffer
	INC	HL		;bump buffer
	LD	(HL),C		;load second byte
	INC	HL		;bump buffer
	DEC	A		;less byte counter
	JR	NZ,FILLA	;fill the sector
;
	POP	BC		;unstack
	RET			;and return
;
;	special write track code for Mod III only
;
	IF	MODIII
;
WW101	LD	A,D		;get 'wait' command
	OUT	(0F4H),A	;issue command
	IN	A,(0F0H)	;read FDC status
	AND	B		;check error mask
	JP	PO,WW101	;go if not ready
	OUTI			;send byte to FDC
;
WW102	LD	A,D		;get 'wait' command
	OUT	(0F4H),A	;issue command
	IN	A,(0F0H)	;read FDC status
	AND	B		;byte ready?
	JR	Z,WW102		;nope, wait more
	OUTI			;send to FDC
;
	LD	A,D		;fetch select code
WW103	OUT	(0F4H),A	;select FDC and wait
	OUTI			;send byte
	JP	WW103		;go till interrupts out
	ENDIF
;
;	clear memory buffer prior to first format build
;	this clears and extraneous data that may have
;	been left over
;
ZBUFF	LD	HL,BUFFER	;start of I/O buffer
	LD	DE,BUFFER+1	;start +1
	LD	BC,0-BUFFER	;length
	LD	(HL),0		;load one zero
	LDIR			;load lots of zeroes
	RET			;buffer clear!
;
;	convert binary digit in A to ascii decimal in CA
;
ASCII	LD	C,'0'		;start MSB digit
;
ASC1	SUB	10		;remove 10's place
	JR	C,ASC2		;go if place found
	INC	C		;bump ascii
	JR	ASC1		;continue
;
ASC2	ADD	A,10+'0'	;ascii + last subtract
	RET			;done, CA = ascii
;
;	compute/request serial #'s for each drive
;
SERIALNOS
	LD	A,(IY+6)	;serial #'s on?
	CP	'*'		;yes?
	RET	Z		;nope, skip it!
	CP	'Y'		;auto serial #'s?
	JR	Z,DOAUTO	;yes, go automatic
;
	XOR	A		;load zero
	LD	(IY+7),A	;set as current drive
;
SERLP	LD	HL,DRIVES	;active drive table
	ADD	A,L		;add offset to table
	LD	L,A		;HL => entry
	LD	A,(HL)		;fetch entry
	INC	A		;active?
	CALL	Z,GETSER	;yes, get user serial #
	INC	(IY+7)		;bump drive pointer
	LD	A,(IY+7)	;fetch result
	CP	4		;0-3?
	JR	C,SERLP		;yes, get next
	RET			;all fetched, return
;
;	compute automatic serial #
;
DOAUTO	XOR	A		;load zero
	LD	(IY+7),A	;set current drive
;
AUTOLP	LD	HL,DRIVES	;active drive table
	ADD	A,L		;add offset to drive
	LD	L,A		;HL => table entry
	LD	A,(HL)		;fetch byte
	INC	A		;active drive?
	CALL	Z,ASERIAL	;yes, compute number
	INC	(IY+7)		;bump drive
	LD	A,(IY+7)	;get next
	CP	4		;0-3?
	JR	C,AUTOLP	;yes, get next #
	RET			;else done
;
;	fetch auto serial #
;
ASERIAL	CALL	FSER		;load DE with drive ptr
	LD	HL,SERX		;current temp number
	LD	C,(IY+21)	;get serial # length
	LD	B,0		;BC = length
	PUSH	BC		;save length
	LDIR			;move # into drive ptr
	POP	BC		;restore length
;
;	advance temp serial # to next number
;
	LD	HL,SERX		;start of serial #
	DEC	BC		;BC = length -1
	ADD	HL,BC		;HL => last char
	LD	B,C		;B = length -1
;
NEWSER	LD	A,(HL)		;fetch a character
	INC	A		;increment ascii
	LD	(HL),A		;update
	CP	'9'+1		;past 0-9?
	RET	C		;nope, ok, return
	LD	(HL),'0'	;reset to zero
	DEC	HL		;go to next MSB digit
	DJNZ	NEWSER		;go for length
	RET			;done, at max number
;
;	get serial number from user
;
GETSER	LD	A,(IY+7)	;get current drive
	ADD	A,'0'		;make it ascii
	LD	(MSG42A),A	;ascii drive to string
	LD	HL,MSG42	;start of message
	CALL	DISPLAY		;display message
	LD	B,(IY+21)	;get serial # length
	CALL	GETSTR		;get key input
	LD	A,B		;get real input length
	CP	(IY+21)		;correct length input?
	JR	NZ,GETSER	;nope, ask again
	CALL	FSER		;load DE with serial #
	LD	C,B		;pass length to C
	LD	B,0		;BC = length
	LDIR			;move into to drive ptr
	RET			;have serial #, return
;
;	install serial #'s on diskettes
;
PUTSERIAL
	LD	A,(IY+6)	;is serial #'s on?
	CP	'*'		;no?
	RET	Z		;nope, skip it!
;
	LD	HL,MSG43	;'installing serial #'
	CALL	DISPLAY		;display message
	XOR	A		;load zero
	LD	(IY+7),A	;set current drive
;
PUTSLP	LD	HL,XDRIVES	;active drives this pass
	ADD	A,L		;add drive offset
	LD	L,A		;HL => entry
	LD	A,(HL)		;fetch entry
	INC	A		;active?
	CALL	Z,THISONE	;yes, install serial #
	INC	(IY+7)		;bump drive counter
	LD	A,(IY+7)	;fetch result
	CP	4		;0-3?
	JR	C,PUTSLP	;yes, go next drive
	RET			;all installed
;
;	install number on single drive
;
THISONE	LD	A,(IY+7)	;fetch drive #
	CALL	SETDRV		;setup for I/O
	LD	BC,BUFFER	;I/O buffer to use
	LD	D,(IY+16)	;track serial #
	LD	E,(IY+17)	;sector serial #
	LD	(IY+8),D	;save as current track
	CALL	READ		;read the sector
	JP	NZ,REMREAD	;read error!
	CALL	DOTHIS		;move serial # to buffer
	LD	A,(IY+30)	;get DAM type
	LD	(DAMBUFF),A	;save for verify
	LD	A,(IY+25)	;get checksum
	LD	(DAMBUFF+1),A	;save for verify
;
	IF	MODI
	OR	0A8H		;create write command
	ENDIF
;
	IF	MODIII
	OR	0A0H		;command mod III
	ENDIF
;
	LD	(WRTYPE),A	;save write type
	CALL	WRITE		;write the sector
	JP	NZ,REMWRITE	;error, exit
	LD	A,(IY+4)	;verify flag on?
	CP	'Y'		;yes?
	RET	NZ		;nope, return
;
	PUSH	BC		;save buffer address
	LD	BC,VBUFF	;verify buffer
	CALL	READ		;read back the sector
	POP	BC		;unstack
;
	JP	NZ,REMREAD	;go if disk error
	CALL	COMPARE		;compare data
	LD	HL,MSG38	;'data mismatch'
	JR	NZ,SKSBB	;error, go!
;
	LD	A,(DAMBUFF)	;get dam type
	CP	(IY+30)		;match?
	LD	HL,MSG53	;'dam mismatch'
	JR	NZ,SKSBB	;nope, error!
;
	LD	A,(DAMBUFF+1)	;get checksum byte
	CP	(IY+25)		;match?
	RET	Z		;yes, return
	LD	HL,MSG39	;'checksum mismatch'
;
SKSBB	PUSH	HL		;setup stack
	JP	REMDRIVE	;remove drive
;
;	move serial # into I/O buffer
;
DOTHIS	PUSH	DE		;save
	PUSH	BC		;save
	CALL	FSER		;load DE with serial #
	EX	DE,HL		;HL => serial #
	LD	DE,BUFFER	;I/O buffer
	LD	E,(IY+18)	;byte offset serial #
	LD	C,(IY+21)	;serial # length
	LD	B,0		;BC = length
	LDIR			;move serial # in
	POP	BC		;restore buffer
	POP	DE		;restore track/sector
	RET			;serial # in buffer
;
;	convert binary A to hex ascii in CA
;
HEXCV	LD	B,A		;save digit
	RRCA			;align high>low bits
	RRCA
	RRCA
	RRCA
	CALL	HEXTST		;adjust to hex digit
	LD	C,A		;save MSB
	LD	A,B		;get byte again
;
HEXTST	AND	0FH		;low 4 bits only
	ADD	A,'0'		;make it ascii
	CP	'9'+1		;0-9?
	RET	C		;yes, return
	ADD	A,7		;adjust for A-F
	RET			;A = digit
;
;	move verify buffer to (BC)
;
MOVBUF	PUSH	HL		;save
	PUSH	DE		;save
	PUSH	BC		;save
;
	LD	D,B		;pass buffer to DE
	LD	E,C		;DE = buffer
	LD	HL,VBUFF	;verify buffer
	LD	BC,100H		;256 bytes
	LDIR			;move it
;
	POP	BC		;unstack
	POP	DE
	POP	HL
	RET
;
;	re-write dest sector with inner retry level
;
REWRITE	CALL	WRITE		;write the sector
	JP	NZ,REMWRITE	;error, abort
	RET			;else re-verify
;
;	GAT being used to skip unused tracks, read it
;
READGAT	LD	A,(IY+5)	;get source drive
	CALL	SETDRV		;setup for I/O
	CALL	STAT		;check if drive ready
	JP	NZ,ABORT	;nope, abort
	LD	BC,BUFFER	;I/O buffer
	LD	DE,0		;track 0/ sector 0
	LD	(IY+8),D	;save current track
	CALL	READ		;read the sector
	JP	NZ,TERMIN	;error, go!
;
	PUSH	BC		;save buffer pointer
	LD	BC,VBUFF	;verify buffer
	CALL	READ		;read again
	POP	BC		;restore buffer
	JP	NZ,TERMIN	;go disk error
	CALL	COMPARE		;compare data
	JR	NZ,READGAT	;bad, read again
;
	LD	A,(VBUFF+2)	;get directory track
	LD	D,A		;pass to track
	LD	E,0		;sector 0
	LD	BC,GATBUFF	;GAT table buffer
	LD	(IY+8),D	;save current track
	CALL	READ		;read the sector
	JP	NZ,TERMIN	;abort if disk error
;
	PUSH	BC		;save buffer
	LD	BC,VBUFF	;verify buffer
	CALL	READ		;read it again
	POP	BC		;restore pointer
	JP	NZ,TERMIN	;go if disk error
	CALL	COMPARE		;compare sectors
	JR	NZ,READGAT	;error, start over
	RET			;else GAT in memory
;
	PAGE
;
	SUBTTL	'<LDCOPY4/ASM - I/O Buffer Areas>'
;
PGMEND	EQU	$		;end of program
;
DBUFF	EQU	$&0FF00H	;last even page
GATBUFF	EQU	DBUFF+100H	;first even free page
DAMBUFF	EQU	GATBUFF+100H	;address mark storage
VBUFF	EQU	DAMBUFF+200H	;verify buffer
BUFFER	EQU	VBUFF+100H	;start of data buffer
;
