;ldcopy0/asm - kjw/bqsd - revised 12/82
;
	SUBTTL	'<LDCOPY0/ASM - Equivalences/Data>'
;
;	system equivalences
;
LF	EQU	0AH		;linefeed
CR	EQU	0DH		;carriage return
ETX	EQU	03H		;end of text
BOL	EQU	1DH		;beginning of line
EOL	EQU	1EH		;clear to end of line
HOME	EQU	1CH		;home cursor
EOF	EQU	1FH		;clear to end of frame
;
;	data block
;
DRIVES	DEFB	0,0,0,0		;dest drive table
XDRIVES	DEFB	0,0,0,0		;dest drive current loop
CTRACK	DEFB	0,0,0,0		;current head location
;
COPIES	DEFW	0		;# copies requested
COUNT	DEFW	0		;# copies completed
;
;	storage for serial numbers
;
SER0	DEFS	32		;32 chars each
SER1	DEFS	32
SER2	DEFS	32
SER3	DEFS	32
SERX	DEFS	32		;work area for advance
;
;	lookup table for serial # location
;
SERTBL	DEFW	SER0
	DEFW	SER1
	DEFW	SER2
	DEFW	SER3
;
;	data storage table, IY => table for easy access
;
TABLE	DEFB	086H		;+00 - alive 'on'
	DEFB	089H		;+01 - alive 'off'
	DEFB	0		;+02 - current alive pos.
	DEFB	20		;+03 - alive max table
	DEFB	'Y'		;+04 - verify flag
	DEFB	0		;+05 - source drive
	DEFB	'*'		;+06 - auto serial #
	DEFB	1		;+07 - dest drive
	DEFB	0		;+08 - current track
	DEFB	40		;+09 - max track count
	DEFB	0		;+10 - outer loop retry
	DEFB	3		;+11 - outer loop reset
	DEFB	0		;+12 - inner loop retry
	DEFB	0		;+13 - inner loop reset
	DEFB	0		;+14 - I/O error retry
	DEFB	4		;+15 - I/O error reset
	DEFB	0		;+16 - track serial #
	DEFB	0		;+17 - sector serial #
	DEFB	0		;+18 - byte serial #
	DEFB	0		;+19 - diskette density
	DEFB	0		;+20 - init byte
	DEFB	0		;+21 - serial # length
	DEFB	0		;+22 - step rate
	DEFB	0		;+23 - format
	DEFB	0		;+24 - copy
	DEFB	0		;+25 - checksum adder
	DEFB	0		;+26 - break key enable
	DEFB	0		;+27 - GAT to skip tracks
	DEFB	0		;+28 - GAT skip mask
	DEFB	0		;+29 - # sectors in buff
	DEFB	0		;+30 - DAM storage
	DEFB	0		;+31 - # sectors to dump
;
	PAGE
;
	SUBTTL	'<LDCOPY0/ASM - Message Text>'
;
;	message text
;
MSG0	DEFB	BOL		;begin of line
	DEFB	EOL		;clear line
	DEFB	LF		;next line
	DEFB	CR		;next line and end
;
MSG1	DEFB	BOL		;begin of line
	DEFB	EOL		;clear it
	DEFB	ETX		;end
;
MSG2	DEFM	'Use GAT to skip tracks (default yes) ? '
	DEFB	ETX
;
MSG3	DEFM	'GAT track mask byte (default '
MSG3A	DEFM	'xxH) ? '
	DEFB	ETX
;
HELLO	DEFB	HOME
	DEFB	EOF
	DEFM	'LDOS Copy Utility - by '
KIM	DEFB	'Kim Watt - Version 1.5'
	DEFB	LF
	DEFM	'(c)(p) Copyright 1982 '
	DEFM	'Breeze/QSD, Inc. - '
	DEFM	'Dallas, Texas'
	DEFB	LF
	DEFB	CR
;
MSG4	DEFM	'Number of Copies (default 100) ? '
	DEFB	ETX
;
MSG5	DEFM	'Byte for Byte Verify (default Yes) ? '
	DEFB	ETX
;
MSG6	DEFM	'Source Drive (default 0) ? '
	DEFB	ETX
;
MSG8	DEFB	LF
	DEFM	'Mount all disks, key <ENTER>'
	DEFM	' to begin: '
	DEFB	ETX
;
MSG9	DEFM	'All Copies Completed - '
	DEFM	'Key <ENTER> to restart: '
	DEFB	ETX
;
MSG10	DEFB	BOL
	DEFM	'Formatting Drive '
MSG10A	DEFM	'x '
	DEFB	EOL
	DEFB	ETX
;
MSG11	DEFM	'Source and Destination '
	DEFM	'SAME DRIVE !'
	DEFB	CR
;
MSG12	DEFM	'No DESTINATION Drives !'
	DEFB	CR
;
MSG13	DEFB	LF
	DEFM	'Drive NOT READY on Write - '
	DEFB	ETX
;
MSG14	DEFB	LF
	DEFM	'Diskette WRITE PROTECTED - '
	DEFB	ETX
;
MSG15	DEFB	LF
	DEFM	'Hardware WRITE FAULT - '
	DEFB	ETX
;
MSG16	DEFB	LF
	DEFM	'Sector NOT FOUND on Write - '
	DEFB	ETX
;
MSG17	DEFB	LF
	DEFM	'CRC Error on Write - '
	DEFB	ETX
;
MSG18	DEFB	LF
	DEFM	'LOST DATA on Write - '
	DEFB	ETX
;
MSG19	DEFB	LF
	DEFM	'Drive NOT READY on Read - '
	DEFB	ETX
;
MSG20	DEFB	LF
	DEFM	'Sector NOT FOUND on Read - '
	DEFB	ETX
;
MSG21	DEFB	LF
	DEFM	'CRC Error on Read - '
	DEFB	ETX
;
MSG22	DEFB	LF
	DEFM	'LOST DATA on Read - '
	DEFB	ETX
;
MSG23	DEFB	LF
	DEFM	'Program Error - '
	DEFB	ETX
;
MSG24	DEFM	'Drive '
MSG24A	DEFM	'x Removed From Que !'
	DEFB	CR
;
MSG25	DEFB	LF
	DEFM	'NO DISKETTE in Drive - '
	DEFB	ETX
;
MSG26	DEFB	LF
	DEFM	'DOOR NOT CLOSED on Drive - '
	DEFB	ETX
;
MSG27	DEFB	LF
	DEFM	'Drive NOT READY - '
	DEFB	ETX
;
MSG28	DEFB	BOL
	DEFM	'Reading    Drive '
MSG28A	DEFM	'x '
	DEFB	EOL
	DEFB	ETX
;
MSG29	DEFB	BOL
	DEFM	'Writing    Drive '
MSG29A	DEFM	'x '
	DEFB	EOL
	DEFB	ETX
;
MSG30	DEFB	BOL
	DEFM	'Verifying  Drive '
MSG30A	DEFM	'x '
	DEFB	EOL
	DEFB	ETX
;
MSG31	DEFB	LF
	DEFM	'Drive NOT IN SYSTEM - '
	DEFB	ETX
;
MSG32	DEFM	'SOURCE ERROR - cannot continue!'
	DEFB	CR
;
MSG33	DEFM	'Drive '
MSG33A	DEFM	'x Copied OK'
	DEFB	ETX
;
MSG34	DEFM	'Drive '
MSG34A	DEFM	'x BAD COPY - Do Not Use'
	DEFB	ETX
;
MSG35	DEFB	LF
MSG35A	DEFM	'xxxxx Copies Completed of '
MSG35B	DEFM	'xxxxx'
	DEFB	CR
;
MSG36	DEFM	'Testing Buffer Memory ...'
	DEFB	CR
;
MSG37	DEFM	'FAULTY MEMORY - 48K Required'
	DEFB	CR
;
MSG38	DEFB	LF
	DEFM	'Data Mismatch - '
	DEFB	ETX
;
MSG39	DEFB	LF
	DEFM	'Sector Checksum Mismatch !'
	DEFB	LF
	DEFM	'Faulty system memory!'
	DEFB	LF
	DEFM	'Key <ENTER> to restart program:'
	DEFB	ETX
;
	DEFB	ETX
;
MSG40	DEFM	'Auto Serial Number (default yes) ? '
	DEFB	ETX
;
MSG41	DEFM	'Starting Serial Number ? '
	DEFB	ETX
;
MSG42	DEFM	'Serial Number for Drive '
MSG42A	DEFB	'x ? '
	DEFB	ETX
;
MSG43	DEFB	BOL
	DEFM	'Installing Serial Numbers ...'
	DEFB	EOL
	DEFB	CR
;
MSG44	DEFM	'Density (default '
;
	IF	MODI
	DEFM	'single'
	ENDIF
;
	IF	MODIII
	DEFM	'double'
	ENDIF
;
	DEFM	') ? '
	DEFB	ETX
;
MSG45	DEFM	' - Serial #: '
MSG45A	DEFB	13,13,13,13,13,13,13,13,13,13
	DEFB	13,13,13,13,13,13,13,13,13,13
	DEFB	13,13,13,13,13,13,13,13,13,13
	DEFB	13,13,13,13,13,13,13,13,13,13
;
MSG46	DEFM	'Track Count (default '
MSG46A	DEFM	'xx) ? '
	DEFB	ETX
;
MSG47	DEFM	'Serial Numbering (default no) ? '
	DEFB	ETX
;
MSG48	DEFM	'Serial Number Location:'
	DEFB	LF
	DEFM	'Track, Sector, Byte, Length ? '
	DEFB	ETX
;
MSG49	DEFM	'Step Rate (default 0) ? '
	DEFB	ETX
;
MSG50	DEFM	'Format Destination Disks '
	DEFM	'(default yes) ? '
	DEFB	ETX
;
MSG51	DEFM	'Transfer Data (default yes) ? '
	DEFB	ETX
;
MSG52	DEFM	'Media Tolerance Factor 0-3 '
	DEFM	'(default 1) ? '
	DEFB	ETX
;
MSG53	DEFB	LF
	DEFM	'Address Mark Mismatch - '
	DEFB	ETX
;
	PAGE
;
	SUBTTL	'<LDCOPY0/ASM - Interrupt Processor>'
;
;	begin actual executable code
;
;	interrupt task processor
;
TASK	PUSH	AF		;save needed registers
	PUSH	BC
	PUSH	DE
	PUSH	HL
;
;	read interrupt latch to see if valid RTC
;
	IF	MODIII
	IN	A,(0E0H)	;latch Mod III
	AND	4		;check bit 2
	JR	NZ,TASKDN	;go if set (not time)
	ENDIF
;
	IF	MODI
	LD	A,(37E0H)	;latch Mod I
	BIT	6,A		;FDC making a roster?
	JR	NZ,FDCROST	;yes, clear FDC
	BIT	7,A		;valid RTC?
	JR	Z,TASKDN	;go if not
	ENDIF
;
;	valid RTC, check that my name is unchanged
;
CKNAME	CALL	NAMECK		;check it out
;
;	name OK, see if time for 'alive' task
;
	LD	HL,3C3FH	;upper right corner
	LD	A,(IY+0)	;get on byte
	CP	(HL)		;is it on?
	JR	NZ,TSKNCH	;go if not
	LD	A,(IY+1)	;get off byte
TSKNCH	LD	(HL),A		;update char
;
;	check for break key allowance
;
TASKMOR	LD	A,(IY+26)	;get break flag
	OR	A		;break allowed?
	JR	NZ,BRKCHK	;nope, check if off
;
	LD	A,(3840H)	;read break key row
	AND	4		;check break key bit
	LD	(IY+26),A	;save new flag
	JR	Z,TASKDN	;go if not pressed
;
	LD	A,(3880H)	;read SHIFT key row
	OR	A		;any bits on?
	LD	HL,LOOPER	;looper return, <BREAK>
	JR	Z,TASKRR	;go if not pressed
	LD	HL,START	;start return <SH><BREAK>
;
TASKRR	LD	A,(3840H)	;read key
	AND	4		;still pressed?
	JR	NZ,TASKRR	;wait till released
	JP	(HL)		;go vector!
;
;	break key disabled, check if off to reset
;
BRKCHK	LD	A,(3840H)	;get break key row
	AND	4		;bit 2 on for break?
	JR	NZ,TASKDN	;go if still pressed
	LD	(IY+26),A	;save it
	JR	TASKDN		;continue
;
;	clear interrupt latch before exiting
;
	IF	MODI
FDCROST	LD	A,(37ECH)	;clear FDC
TASKDN	LD	A,(37E0H)	;clear interrupt
	ENDIF
;
	IF	MODIII
TASKDN	IN	A,(0ECH)	;clear interrupt
	ENDIF
;
;	task service complete, unstack and go vector
;
	POP	HL
	POP	DE
	POP	BC
	POP	AF
	EI			;enable interrupts
	RET			;return from interrupt
;
;	somebody messed with the program, erase it
;
KILL	LD	HL,3000H	;start of possible RAM
	LD	DE,3001H	;start +1
	LD	BC,0-3000H	;length to FFFFH
	LD	(HL),76H	;one HALT opcode
	LDIR			;lots of HALT opcodes
	RST	0		;never gets here!
;
NAMECK	LD	HL,KIM		;my name in the header
	LD	DE,KIM2		;name 'comparor'
	LD	B,8		;8 chars to check
;
TSTKIM	LD	A,(DE)		;fetch table byte
	AND	7FH		;remove high bit
	CP	(HL)		;match?
	JP	NZ,KILL		;nope, kill the program!
	INC	DE		;bump table pointer
	INC	HL		;bump string pointer
	DJNZ	TSTKIM		;go for all 8
;
	LD	HL,0		;load nop's
	LD	(CKNAME),HL	;save it
	LD	(CKNAME+1),HL	;all 3 bytes
	RET			;done
;
