; idtask/asm - kjw/bqsd - 06/83 - version 1.0 - 06/83
;
;	revised 06/03/83	- dwh
;	revised 06/07/83	- kjw
;
	PAGE
;
;	$TASK	- interrupt processor
;
;	interrupts each 'real time clock' beat
;
;	fetch interrupted Program Counter for trace
;	save all registers to be used
;
TASK	PUSH	AF		;save registers
	PUSH	BC
	PUSH	DE
	PUSH	HL
;
;	check for valid RTC interrupt
;
;i*
	IF	MODI
	LD	A,(RDINT)	;read int latch I
	BIT	6,A		;FDC making roster?
	JP	NZ,FDCROST	;clear it if yes
	BIT	7,A		;valid interrupt?
	JP	Z,TSKNOT	;nothing if not set
	ENDIF
;i*
;m*
	IF	MAX80
	LD	A,(RDINT)	;read interrupt latch
	BIT	7,A		;RTC interrupt?
	JP	Z,TSKNOT	;go if not
	ENDIF
;m*
;iii*
	IF	MODIII
	IN	A,(RDINT)	;read int latch III
	BIT	2,A		;valid interrupt?
	JP	NZ,TSKNOT	;nothing if set
	ENDIF
;iii*
;
;	check for BREAK key
;
	LD	A,(KBDR6)	;check for break key
	AND	4		;bit 2 set?
	JP	NZ,ENTRY	;abort if yes
;
;	check to see if a valid serial number is present
;
TASKCH	LD	A,0		;get counter
SERCNT	EQU	$-1		;once about each 8 secs
	DEC	A		;less one
	LD	(SERCNT),A	;put it back
	JR	NZ,TSKNOT	;skip this time around
;
;	check to make sure my name has not been changed
;
	LD	HL,KIM		;my name in the program
	LD	DE,KIMCHK	;'checker' string
	LD	B,8		;length to check
;
TSKCK1	LD	A,(DE)		;fetch check byte
	XOR	'%'		;adjust to normal
	CP	(HL)		;same?
	JR	NZ,KILLPGM	;nope, kill the program
;
	INC	DE		;bump checker
	INC	HL		;bump string
	DJNZ	TSKCK1		;go for 8
	JR	TSKNOT		;OK, continue
;
;	either my name or the serial name is corrupt
;	destroy the program
;
KILLPGM	LD	HL,BASE		;start of writable memory
	LD	DE,BASE+1	;start + 1
	LD	BC,0FFFFH-BASE	;length of ALL RAM
	LD	(HL),0C7H	;RST 00H opcodes
	LDIR			;fill ALL memory
	RST	@00
;
;	completed, clear interrupt latch and return
;
TSKNOT	EQU	$
;i*
	IF	MODI.OR.MAX80
	LD	A,(WRINT)	;clear interrupt latch
	ENDIF
;i*
;iii*
	IF	MODIII
	IN	A,(WRINT)	;clear latch III
	ENDIF
;iii*
	POP	HL		;unstack
	POP	DE
	POP	BC
	POP	AF		;restore AF
	EI			;re-enable
	RET			;done, return from int
;i*
	IF	MODI
FDCROST	LD	A,(FDCSTA)	;clear FDC
	JR	TSKNOT		;clear latch and return
	ENDIF
;i*
;
