; idtape/asm - kjw/bqsd - 05/83 - version 1.0
;
;	revised 05/24/83	- dwh
;	revised 06/07/83	- kjw
;
	PAGE
;
;	copy tape entry point
;
TCOPY	CALL	ASKDECK		;prompt and wait
;
	CALL	MOTORO		;motor on/interrupts off
	LD	HL,(CURSOR)	;fetch cursor
	LD	(HL),99H	;fill with block
;
;	wait for a pulse, check keyboard
;	if pulse detected, immediately send one out
;
CTAPEL	CALL	BITIN		;clear key pressed?
;
	LD	B,30H		;settling delay
	DJNZ	$		;count here
;
	CALL	BITOUT		;send a bit
;
;	change block
;
	LD	A,(HL)		;fetch from video
	XOR	3FH		;reverse bits
	LD	(HL),A		;new block to video
	JR	CTAPEL		;go looper
;
BITCAN	CALL	MOTORF		;turn off cassette motor
	JP	ENTRY		;done!
;
;	ask deck 1 or 2 on Mod I only
;
ASKDECK	EQU	$
;i*
	IF	MODI
	LD	HL,DECKMSG	;'deck 1 or 2?'
	CALL	DISPLAY		;display prompt
	LD	B,1		;one key input
	CALL	GETSTR		;from keyboard
	JR	NZ,$+4		;go if any input
	LD	A,'1'		;else default 1
	SUB	'1'		;remove ascii
	JR	Z,DECK2		;go if dec 1
	CP	1		;dec 2?
	JR	NZ,ASKDECK	;go if neither
;
DECK2	LD	(CASSEL),A	;select cassette drive
	ENDIF
;i*
;
	LD	HL,BEGMSG	;'key to begin'
	CALL	DISPLAY		;display it
	LD	B,1		;one key input
	CALL	GETSTR		;from keyboard
	LD	HL,TRMMSG	;'clear to terminate'
	JP	DISPLAY		;display & return
;
	PAGE
;
BITOUT	JR	NC,BITOUT0	;send 0 bit
;i*
	IF	MODI
	LD	A,05		;low output mod I
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	A,01		;low output mod III
	ENDIF
;iii*
	OUT	(CASDAT),A	;issue pulse
;i*
	IF	MODI
	LD	B,0AH		;pulse length I
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	B,0DH		;pulse length III
	ENDIF
;iii*
	DJNZ	$
	INC	A		;adjust to high output
	OUT	(CASDAT),A	;issue pulse
;i*
	IF	MODI
	LD	B,0AH		;pulse length I
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	B,0DH		;pulse length III
	ENDIF
;iii*
	DJNZ	$
	CALL	BITNIL		;clear latch
;i*
	IF	MODI
	LD	B,6CH		;pulse gap I
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	B,78H		;pulse gap III
	ENDIF
;iii*
	DJNZ	$
	RET			;bit sent
;
BITOUT0	EQU	$
;i*
	IF	MODI
	LD	B,87H		;gap mod I
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	B,98H		;gap mod III
	ENDIF
;iii*
	DJNZ	$
	RET			;bit sent
;
BITNIL	EQU	$
;i*
	IF	MODI
	LD	A,4
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	A,0
	ENDIF
;iii*
;
	OUT	(CASDAT),A	;send to cassette port
	RET			;done!
;
;	$BITIN - read one bit from tape
;
;	EXT	carry flag is data bit
;		if <CLEAR> key is pressed, exit is
;		made via (VECTOR1)
;		AB destroyed
;
BITIN	PUSH	HL		;save HL
	LD	HL,KBDR6	;point to keyboard
;
BITINL	IN	A,(CASDAT)	;read cassette port
	RLA			;have sync bit?
	JR	C,BITINH	;have it, go!
	BIT	1,(HL)		;CLEAR pressed?
	JR	Z,BITINL	;go if not
	JR	BITCAN		;else abort!
;
BITINH	EQU	$
;i*
	IF	MODI
	LD	B,41H		;delay for reset
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	B,6EH		;delay for reset
	ENDIF
;iii*
	DJNZ	$
	CALL	BITNIL		;reset latch
;i*
	IF	MODI
	LD	B,72H		;delay for data
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	B,98H		;delay for data
	ENDIF
;iii*
	DJNZ	$
;
	IN	A,(CASDAT)	;read data bit
	RLA			;move into carry flag
	POP	HL		;restore HL
;
	JP	BITNIL		;clear latch and return
;
;	$MOTORO - turn cassette motor on
;
MOTORO	EQU	$
;i*
	IF	MODI
	LD	A,4		;motor on, latch clear
	OUT	(CASMOT),A	;turn cassette on
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	A,2AH		;motor on
	OUT	(CASMOT),A	;turn cassette on
	ENDIF
;iii*
	DI			;disable for transfer
	RET			;done
;
;	$MOTORF - turn cassette motor off
;
MOTORF	EQU	$
;i*
	IF	MODI
	LD	A,0		;clear all bits
	OUT	(CASMOT),A	;turn motor off
	ENDIF
;i*
;iii*
	IF	MODIII
	LD	A,28H		;motor off
	OUT	(CASMOT),A	;do it
	ENDIF
;iii*
	EI			;can enable now
	RET			;done
;
DECKMSG	DEFB	LF
	DEFM	'Deck 1 or 2 ? '
	DEFB	ETX
;
BEGMSG	DEFB	LF
	DEFM	'<ENTER> when tape deck ready: '
	DEFB	ETX
;
TRMMSG	DEFB	LF
	DEFM	'<CLEAR> to terminate: '
	DEFB	ETX
;
