; idsub3/asm - kjw/bqsd - 06/83 - version 1.0 - 06/83
;
;	revised 06/06/83	- dwh
;	revised 06/07/83	- kjw
;
	PAGE
;
;	$EXIT	- exit program
;
;	ENT	none
;
;	EXT	exit made to bootstrap in ROM
;
;	NOTE	user is prompted to mount a system
;		system disk and press enter
;
EXIT	EQU	$
;
;	on a mod I, do not jump to 0000 while the
;	disk drive is turning or a the ROM will not
;	detect the correct drive status
;
;i*
	IF	MODI
FDCWAIT	LD	A,(FDCSTA)	;get FDC status byte
	RLCA			;check bit 7
	JR	NC,FDCWAIT	;wait for motor to go off
	HALT			;boot Mod I
	ENDIF
;i*
;m*
	IF	MAX80
	LD	A,(VLATCH)	;get system functions
	AND	0F8H		;enable ROM
	DI			;disable
	LD	(VLATCH),A	;rom enabled!
	RST	@00		;go boot-rom!
	ENDIF
;m*
;iii*
	IF	MODIII
	RST	@00		;boot Mod III
	ENDIF
;iii*
	JR	$		;fail trap!
;
;	checker string to be sure my name stays
;	in the program for at least an hour
;	(damn whiz kids!)
;
KIMCHK	DEFB	'K'.XOR.'%'
	DEFB	'i'.XOR.'%'
	DEFB	'm'.XOR.'%'
	DEFB	' '.XOR.'%'
	DEFB	'W'.XOR.'%'
	DEFB	'a'.XOR.'%'
	DEFB	't'.XOR.'%'
	DEFB	't'.XOR.'%'
;
	PAGE
;
;	$MOVEIN - move data into buffer
;
;	ENT	HL => buffer
;		A  = fill character
;		B  = fill length
;
MOVEIN	LD	A,(DE)		;get table byte
	LD	B,A		;# bytes to go
	INC	DE		;bump table
	LD	A,(DE)		;byte to fill with
	INC	DE		;point to next one
;
FILL	LD	(HL),A		;put in buffer
	INC	HL		;bump buffer
	DJNZ	FILL		;go for B loops
	RET			;buffer filled
;
	PAGE
;
;	$CLRBUFF - clear out format buffer
;
;	fill buffer with zeroes in perparation for format
;
CLRBUFF	CALL	SAVEREG		;save registers
;
	LD	HL,(FMTBUFF)	;get format buff start
	LD	D,H		;pass start to DE
	LD	E,L		;DE = buffer start
	INC	DE		;DE = start +1
	LD	BC,17FFH	;length to fill
	LD	(HL),0		;load one zero
	LDIR			;load all zeroes
	RET			;done, buffer cleared
;
