; idsub2/asm - kjw/bqsd - 06/83 - version 1.0 - 06/83
;
;	revised 06/03/83	- dwh
;	revised 06/07/83	- kjw
;
	PAGE
;
;	$SAVEREG - save registers on stack
;
;	ENT	none
;
;	EXT	all registers EXCEPT AF saved on stack
;
;	AF' destoryed
;
SAVEREG	EX	AF,AF'		;save AF
	POP	AF		;get caller address
;
	PUSH	IY		;push 'em
	PUSH	IX
	PUSH	BC
	PUSH	DE
	PUSH	HL
;
;	leave return address on stack
;
	PUSH	HL		;push again
	LD	HL,REGFIX	;return vector
	EX	(SP),HL		;leave on stack, fetch HL
;
	PUSH	AF		;put caller back
	EX	AF,AF'		;restore AF
	RET			;back to caller
;
;	unstacker
;
REGFIX	POP	HL		;unstack & return
	POP	DE
	POP	BC
	POP	IX
	POP	IY
	RET			;done
;
	PAGE
;
;	$COMPARE - compare two strings
;
;	ENT	DE => first string
;		HL => second string
;		B  = length to compare
;
;	EXT	Z = strings equal
;		C = (DE) string less than (HL) string
;
COMPARE	LD	A,(DE)		;get a byte first string
	CP	(HL)		;compare to second string
	RET	NZ		;not equal, return NZ
	INC	HL		;bump pointers
	INC	DE
	DJNZ	COMPARE		;go for specified length
	RET			;match! return Z
;
	PAGE
;
;	$SMOUNT - $DMOUNT - disk mount prompts
;
;	ENT	(MFLAG) setting indicates prompting
;
;	EXT	user prompted to mount associated disk
;		if mount flag is true (00)
;
SMOUNT	PUSH	HL		;save HL
	LD	HL,MNTSRC	;mount source
	JR	MOUNTC		;go common
;
DMOUNT	PUSH	HL		;save it
	LD	HL,MNTDES	;mount destination
;
MOUNTC	PUSH	BC		;save
	CALL	DISPLAY		;display prompt
	LD	B,1		;one key input
	CALL	GETSTR		;get from keyboard
	POP	BC		;unstack
	POP	HL		;unstack
	RET			;done
;
;	$DRVSAME - check if source and dest drives same
;
;	ENT	(SDRIVE) (DDRIVE) already set
;
;	EXT	Z = both the same drive
;
DRVSAME	PUSH	BC		;save to use
	LD	BC,(SDCT+3)	;get source drive
	LD	A,(DDCT+3)	;dest drive
	CP	C		;same?
	POP	BC		;restore it
	RET			;return Z if yes
;
;	$BUFFEND - check for BC at topmem
;
;	ENT	BC = buffer
;		(TOPMEM) = top of memory
;
;	EXT	Z = yes, no more room
;
BUFFEND	LD	A,(TOPMEM+1)	;get MSB topmem
	CP	B		;test for buffer end
	SCF			;must clear carry
	CCF
	RET			;back with Z flag status
;
MNTSRC	DEFB	LF
	DEFM	'Mount SOURCE Diskette'
	DEFB	ETX
;
MNTDES	DEFB	LF
	DEFM	'Mount DESTINATION Diskette'
	DEFB	ETX
;
