; idsub1/asm - kjw/bqsd - 06/83 - version 1.0 - 06/83
;
;	revised 03/16/83	- dwh
;	revised 06/07/83	- kjw
;
	PAGE
;
;	$GETSEL	- prompt for user input, go jump table
;
;	ENT	DE => lookup table of valid responsed
;
;	EXT	exit vectored to correct table response
;
;
GETSEL	CALL	DISPLAY		;display prompt
	LD	HL,CHMSG	;'choice?'
	CALL	DISPLAY		;display prompt
	LD	B,2		;two keys to input
	CALL	GETSTR		;from keyboard
	JR	NZ,$+4		;go if any input
	LD	A,'1'		;else set default
	SUB	'1'		;remove ascii
	RET	C		;go if invalid
	LD	C,A		;save selection
	LD	A,(DE)		;get # choices
	CP	C		;test to LSB
	RET	C		;out of range!
;
	EX	DE,HL		;DE=HL, HL=>table
	INC	HL		;bump past length byte
	LD	A,C		;get LSB value
	ADD	A,A		;two byte table
	ADD	A,L		;add to LSB table
	LD	L,A		;update
	JR	NC,$+3		;go if not carry
	INC	H		;bump page cross
	LD	A,(HL)		;fetch LSB vector
	INC	HL		;bump table
	LD	H,(HL)		;fetch MSB vector
	LD	L,A		;HL = vector
	POP	AF		;remove caller address
	JP	(HL)		;go vector
;
	PAGE
;
;	$ADDR20	- read 20 ID sectors into buffer
;
;	ENT	none
;
;	EXT	NZ = disk error, A = I/O status byte
;		Z = OK
;		HL => buffer containing 20 sector #'s
;
;	NOTE	this is used to locate the highest and
;		lowest sector #'s on a track
;
ADDR20	LD	B,20		;20 iterations
	LD	IX,DAMBUFF	;load into this buffer
;
ADDR20A	CALL	ADDR		;read ID field
	RET	NZ		;error, return NZ
;
	INC	HL		;head
	INC	HL		;sector
	LD	A,(HL)		;fetch sector number
	LD	(IX),A		;put into buffer
	INC	IX		;bump buffer pointer
	DJNZ	ADDR20A		;go for B # times
	XOR	A		;return ZERO
	RET			;back to caller
;
	PAGE
;
;	$ONEDRIV - prompt and setup for one drive
;
;	ENT	none
;
;	EXT	drive setup for activity
;		IY => DCT
;
ONEDRIV	CALL	DISPLAY		;display prompt
	LD	B,2		;2 chars input
	CALL	GETSTR		;get input
	SUB	'0'		;remove ascii
	JR	C,ONEDRIV	;go if invalid
	CP	4		;0-3?
	JR	NC,ONEDRIV	;go if invalid
	LD	(IY+3),A	;save binary drive
;
;	compute select address
;
	LD	C,1		;select bit
SETBIT	OR	A		;drive found?
	LD	(IY+5),C	;save select bit
	RET	Z		;go if yes
	SLA	C		;shift select bit
	DEC	A		;less count
	JR	SETBIT		;continue
;
CHMSG	DEFB	LF
	DEFB	LF
	DEFM	'Selection? '
	DEFB	ETX
;
