; idequ/asm - kjw/bqsd - 06/83 - version 1.0 - 06/83
;
;	revised 06/06/83	- dwh
;	revised 06/07/83	- kjw
;
	PAGE
;
;	equates for RST vectors
;
@00	EQU	00H		;RST 00H
;
;	base I/O address assignment / video definition
;
;i/iii*
	IF	MODI.OR.MODIII
BASE	EQU	3000H		;I/O address base
ROWS	EQU	16		;# video rows
COLS	EQU	64		;# video columns
	ENDIF
;i/iii*
;m*
	IF	MAX80
BASE	EQU	0000H		;I/O address base
ROWS	EQU	16		;# video rows
COLS	EQU	64		;# video columns
	ENDIF
;m*
;
;	local equivalences
;
ETX	EQU	00H		;end of text
CR	EQU	0DH		;carriage return
LF	EQU	0AH		;line feed
BOL	EQU	1DH		;cursor to line beginning
EOL	EQU	1EH		;clear to end of line
HOME	EQU	1FH		;home and cls
ETBL	EQU	00H		;end of table
TAB	EQU	09H		;tab
BACKSP	EQU	08H		;backspace
UFEED	EQU	0BH		;up linefeed
PROMPT	EQU	5FH		;prompt char
ULINE	EQU	5FH		;underlined space
CURCHR	EQU	98H		;cursor on character
CURCHRO	EQU	0A4H		;cursor off char
BLOCK	EQU	0BFH		;block character
;
ENTER	EQU	0DH		;enter key
SENTER	EQU	0EH		;shift enter key
CLEAR	EQU	03H		;clear key
SCLEAR	EQU	04H		;shift clear key
BREAK	EQU	01H		;break key
SBREAK	EQU	02H		;shift break key
UARR	EQU	5BH		;up arrow
SUARR	EQU	1BH		;shift up arrow
DARR	EQU	5CH		;down arrow
SDARR	EQU	1AH		;shift down arrow
LARR	EQU	5DH		;left arrow
SLARR	EQU	18H		;shift left arrow
RARR	EQU	5EH		;right arrow
SRARR	EQU	19H		;shift right arrow
SPACE	EQU	20H		;space bar
SSPACE	EQU	80H		;shift space bar
;
;	machine addresses
;
VIDEO	EQU	BASE+0C00H	;start video memory
VIDEND	EQU	ROWS*COLS+VIDEO	;end video memory +1
KBDR0	EQU	BASE+801H	;@abcdefg
KBDR1	EQU	BASE+802H	;hijklmno
KBDR2	EQU	BASE+804H	;pqrstuvw
KBDR3	EQU	BASE+808H	;xyz.....
KBDR4	EQU	BASE+810H	;01234567
KBDR5	EQU	BASE+820H	;89:;,-./
KBDR6	EQU	BASE+840H	;cr/cl/br/up/dn/lf/rt/sp
KBDR7	EQU	BASE+880H	;sh/f1/f2/f3/f4/es/../ct
;
;	I/O addresses
;
;i*
	IF	MODI
RDINT	EQU	BASE+7E0H	;read interrupt register
WRINT	EQU	BASE+7E0H	;clear interrupt
FDCSEL	EQU	BASE+7E1H	;fdc select register
FDCCMD	EQU	BASE+7ECH	;fdc command register
FDCSTA	EQU	BASE+7ECH	;fdc status register
FDCTRK	EQU	BASE+7EDH	;fdc track register
FDCSEC	EQU	BASE+7EEH	;fdc sector register
FDCDAT	EQU	BASE+7EFH	;fdc data register
RDPRT	EQU	BASE+7E8H	;read printer status
WRPRT	EQU	BASE+7E8H	;write to printer
CASSEL	EQU	BASE+7E4H	;select cassette
CASDAT	EQU	0FFH		;cassette data port
CASMOT	EQU	0FFH		;cassette motor control
	ENDIF
;i*
;m*
	IF	MAX80
RDINT	EQU	BASE+7E1H	;read interrupt register
WRINT	EQU	BASE+7E0H	;clear interrupt
FDCSEL	EQU	BASE+7D8H	;fdc select register
FDCCMD	EQU	BASE+7ECH	;fdc command register
FDCSTA	EQU	BASE+7ECH	;fdc status register
FDCTRK	EQU	BASE+7EDH	;fdc track register
FDCSEC	EQU	BASE+7EEH	;fdc sector register
FDCDAT	EQU	BASE+7EFH	;fdc data register
RDPRT	EQU	BASE+7E8H	;read printer status
WRPRT	EQU	BASE+7E8H	;write to printer
VLATCH	EQU	BASE+7DCH	;system latch
MLATCH	EQU	BASE+7D8H	;system latch
CRTREG	EQU	BASE+7E0H	;crt register
CRTBYT	EQU	BASE+7E1H	;crt register byte
DIPSW	EQU	BASE+7F8H	;dip switches
USTAT	EQU	BASE+7F4H	;universal FDC controller
	ENDIF
;m*
;iii*
	IF	MODIII
RDINT	EQU	0E0H		;read interrupt register
WRINT	EQU	0ECH		;clear interrupt
FDCSEL	EQU	0F4H		;fdc select register
FDCCMD	EQU	0F0H		;fdc command register
FDCSTA	EQU	0F0H		;fdc status register
FDCTRK	EQU	0F1H		;fdc track register
FDCSEC	EQU	0F2H		;fdc sector register
FDCDAT	EQU	0F3H		;fdc data register
RDPRT	EQU	0F8H		;read printer status
WRPRT	EQU	0F8H		;write to printer
CASDAT	EQU	0FFH		;cassette data port
CASMOT	EQU	0ECH		;cassette motor control
	ENDIF
;iii*
;
