; iddvrs/asm - kjw/bqsd - 06/83 - version 1.0 - 06/83
;
;	revised 06/03/83	- dwh
;	revised 06/07/83	- kjw
;
	PAGE
;
;	$DISPLAY - display string to video
;
;	ENT	HL =>	display string (term 00)
;
DISPLAY	PUSH	HL		;save pointer
	PUSH	DE		;save this
	EX	DE,HL		;de => data
	LD	HL,(CURSOR)	;get cursor addr.
	CALL	OFFVID		;make sure it's in video
;
DISLP	LD	A,(DE)		;get a byte
	INC	DE		;bump the pointer
	CP	ETX		;end of text?
	JR	Z,DISDN		;go if yes!
;
	CP	SPACE		;control code?
	JR	C,DISCTL	;do it if <20H
;
;	automatic lower case recognition
;
	LD	(HL),A		;display the byte
	CP	(HL)		;still there?
	JR	Z,DISOK		;yes, lowercase in
	SUB	20H		;make it uppercase
	LD	(HL),A		;put it back
;
DISOK	INC	HL		;bump the cursor
	CALL	OFFVID		;see if still on video
	JR	DISLP		;continue
;
;	completed, resume at next byte after terminator
;
DISDN	LD	(CURSOR),HL	;put cursor back
	POP	DE		;restore de
	POP	HL		;restore pointer
	RET			;go to it
;
;	setup call to control byte
;
DISCTL	CALL	CONTRL		;make it a call
	JR	DISLP		;continue
;
;	interpret control byte
;
CONTRL	CP	LF		;linefeed?
	JR	Z,LINFEED
;
	CP	BOL		;BOL?
	JR	Z,BOLX
;
	CP	EOL		;EOL?
	JR	Z,EOLX
;
	CP	HOME		;home cursor?
	JP	Z,HOMEIT
	RET			;invalid, ignore it
;
;	move cursor down one row and C/R
;
LINFEED	PUSH	DE		;save it
	LD	DE,COLS		;chars / line
	CALL	BOLX		;get begin of line
	ADD	HL,DE		;go to next line
	POP	DE		;restore it
	JR	OFFVID		;frame it
;
;	move cursor to beginning of line
;
BOLX	LD	A,L		;get lsb byte
	AND	0C0H		;put to beginning of line
	LD	L,A		;put that back
	RET			;no frame needed
;
;	move cursor to beginning of line and clear it
;
EOLX	CALL	BOLX		;go beginning of line
	PUSH	BC		;save these
	LD	BC,COLS-1	;line length
;
;	fill video data area
;
FIXCON	PUSH	HL		;save the rest
	PUSH	DE
	LD	D,H		;give to DE
	LD	E,L
	INC	DE		;start +1
	LD	(HL),SPACE	;clear byte
;
	LDIR			;put spaces all over
;
	POP	DE		;unstack
	POP	HL
	POP	BC		;get 'em all back
;
;	check for cursor in valid video memory area
;
OFFVID	LD	A,H		;check for boundrys
	CP	VIDEO<-8	;less than video?
	JR	NC,OFFAOK	;test one ok
	LD	HL,VIDEO	;top of vid
	RET			;resume
;
OFFAOK	CP	ROWS*COLS+VIDEO<-8
	RET	C		;go if OK
;
AKSCRL	PUSH	DE		;save
	PUSH	BC		;this too
	LD	DE,VIDEO	;start
	LD	HL,VIDEO+COLS	;start 1st row
	LD	BC,COLS*ROWS-COLS
	LDIR			;scroll
	POP	BC		;unstack
	POP	DE
	LD	HL,COLS*ROWS+VIDEO-COLS
	JR	EOLX		;clear this line
;
HOMEIT	LD	HL,VIDEO	;start video
	PUSH	DE		;save
	PUSH	BC
	LD	DE,VIDEO+1	;video start +1
	LD	BC,ROWS*COLS-1
	LD	(HL),' '	;load space
	LDIR			;clear video
	POP	BC		;unstack
	POP	DE
	LD	HL,VIDEO	;new cursor position
	RET			;done
;
	PAGE
;
;	$GETSTR - fetch string from keyboard
;
;	ENT	B = number of characters to fetch
;
;	EXT	Z = no characters input (ENTER alone)
;		NZ = characters present
;		HL => start of input string
;		C  = requested number of characters
;		B  = actual number of characters input
;		A  = first character from buffer
;
;	DE preserved
;
GETSTR	LD	C,B		;fetch requested length
	PUSH	DE		;save from use
	LD	HL,(CURSOR)	;get cursor posit
	LD	DE,STRING	;input buffer
	LD	B,0		;init input length
;
;	loopers for keyboard input
;
CURCUR	LD	(HL),PROMPT	;display it
;
SCAN	CALL	KEY		;scan keyboard
	OR	A		;anything?
	JR	Z,SCAN		;loop till have key
;
	CP	ENTER		;enter key?
	JR	Z,SCDON
;
	CP	LARR		;backspace?
	JR	Z,BAKSPCE
;
	CP	SLARR		;shift back?
	JR	Z,NEWST
;
	CP	CLEAR		;clear?
	JR	Z,NEWST
;
	CP	' '		;valid code?
	JR	NC,SCANXY	;in range, go!
	JR	SCAN		;display block
;
;	have a key
;
SCANXY	LD	(ASVE),A	;save the key
	LD	A,B		;get length
	CP	C		;test for max
	JR	NC,CURCUR	;don't take it, buff full
	LD	A,0
ASVE	EQU	$-1		;get key back
;
;	check for printer output
;
	LD	(HL),A		;display the byte
	LD	(DE),A		;put in buffer
	CP	(HL)		;lower case ?
	JR	Z,CHAROK	;yes if Z
	SUB	20H		;make it uppercase
	LD	(HL),A		;put it back
;
CHAROK	INC	DE		;bump buffer
	INC	B		;bump length
	INC	HL		;bump video pointer
	JR	CURCUR		;continue
;
;	completed, terminate with 13
;
SCDON	LD	A,CR		;C/R terminator
	LD	(DE),A		;put into buffer
	LD	(HL),' '	;clear prompt char
;
;	routine completed, reset stack & set flags
;
	POP	DE		;restore old DE
;
	LD	A,B		;set flags for length
	OR	A		;Z flag = B register
	LD	HL,STRING	;hl => input string
	LD	A,(HL)		;a has first char
	RET			;done
;
;	backspace a character
;
BAKSPCE	LD	A,B		;any length?
	OR	A		;yes?
	JR	Z,SCAN		;don't do it then
;
	LD	(HL),' '	;put to the video
	DEC	HL		;move it back
	DEC	DE		;move buffer back
	DEC	B		;char. count back
	JR	CURCUR		;resume
;
;	clear entire input line and start over
;
NEWST	LD	A,B		;any length?
	OR	A		;yes?
	JR	Z,SCAN		;don't bother
;
NEWSTL	LD	(HL),' '	;to the display
	DEC	HL		;pointer back
	DEC	DE		;move buffer back
	DJNZ	NEWSTL		;go till length 0
	JR	CURCUR		;cursor on, continue
;
	PAGE
;
;	$KEY	- scan keyboard for input character
;
;	ENT	none
;
;	EXT	Z = no key available
;		NZ = A = character
;
;	ALL other registers preserved
;
KEY	CALL	SAVEREG		;save all registers
	LD	HL,KEYBRD	;work area
	LD	BC,KBDR0	;keyboard memory
	LD	E,0		;row counter
;
NEXROW	LD	A,(BC)		;get key byte
	LD	D,A		;save it here
;
;	compare to mask area to see if it's a new key
;
	XOR	(HL)		;compare to last scan
	LD	(HL),D		;save new key in mask
	AND	D		;same as last key?
	JR	NZ,HAVEIT	;have a new one
;
;	not a new key, continue to next matrix row
;
	INC	E		;bump row count
	INC	L		;bump mask byte
	RLC	C		;move key memory
	JP	P,NEXROW	;go for 7 rows
	XOR	A		;set NO key
	RET			;done, Z flag set
;
;	have a new key, decode into ASCII
;
HAVEIT	LD	D,A		;save masked byte
	LD	A,E		;get row counter
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	LD	E,A		;row * 8
	LD	C,1		;column mask bit
;
MKT1	LD	A,C		;fetch mask
	AND	D		;this the right key?
	JR	NZ,MKT2		;yup, go!
;
	INC	E		;bump row*8
	RLC	C		;shift mask bit left
	JR	MKT1		;continue
;
MKT2	LD	HL,KEYS		;start key table
	LD	D,0		;DE = key offset
	ADD	HL,DE		;HL => key
;
;	keybounce delay
;
	LD	BC,1000H	;delay count
	CALL	DELAY		;countdown
	LD	A,(HL)		;fetch input key
	OR	A		;set NZ
	RET			;return with status
;
;	keyboard lookup table
;
KEYS	DEFM	'@ABCDEFG'
	DEFM	'HIJKLMNO'
	DEFM	'PQRSTUVW'
	DEFM	'XYZ     '
	DEFM	'01234567'
	DEFM	'89:;,-./'
	DEFB	CR,CLEAR,BREAK,UARR,DARR,LARR,RARR,' '
;
