; iddiska/asm - kjw/bqsd - 06/83 - version 1.0 - 06/83
;
;	revised 06/03/83	- dwh
;	revised 06/07/83	- kjw
;
	PAGE
;
READ1X	CALL	SELECT		;select drive
	RET	NZ		;go if error
;
	IF	MODI.OR.MAX80
	DI			;must disable for xfer
	LD	HL,FDCCMD	;point to FDC command reg
	LD	A,(RDTYPE)	;get read type
;m*
	IF	MAX80
	CPL			;reverse bits
	ENDIF
;m*
	LD	(HL),A		;give read command to FDC
	PUSH	DE		;save track/sector
	LD	DE,FDCDAT	;data transfer address
	CALL	RXFER		;transfer the data
	POP	DE		;restore track/sector
	ENDIF
;i/m*
;iii*
	IF	MODIII
	CALL	SETNMI		;setup NMI vectors
	LD	A,(RDTYPE)	;get type of read
	OUT	(FDCCMD),A	;issue to FDC
	CALL	RXFER		;transfer the bytes
	ENDIF
;iii*
;
;	common exit vector for Mod I & III
;
	PUSH	AF		;save result
	RRCA			;align data address
	RRCA			;mark bits to low bits
	RRCA
	RRCA
	RRCA
	AND	3		;4 types of marks
	OR	0A0H		;make it a write command
	LD	L,A		;save it here
	LD	A,(RDTYPE)	;get type of read
	AND	8		;IBM or not?
	OR	L		;now have a write command
	LD	(WRTYPE),A	;that will produce the
	EX	AF,AF'		;same as this read.
	POP	AF		;put write byte in af'
;
	AND	9FH		;check for error
	RET			;no error on DAMS
;
;	read new track from FDC and put into DCT
;
IOCOMM	PUSH	AF		;save I/O result
;i*
	IF	MODI
	LD	A,(FDCTRK)	;get track
	ENDIF
;i*
;m*
	IF	MAX80
	LD	A,(FDCTRK)	;get track
	CPL
	ENDIF
;m*
;iii*
	IF	MODIII
	IN	A,(0F1H)	;III track register
	ENDIF
;iii*
	LD	(IY+4),A	;put into table
	POP	AF		;restore result
	RET			;done
;
;	sector write logic
;
;
WRITE1X	CALL	SELECT		;select the drive
	RET	NZ		;error, return
;i*
	IF	MODI.OR.MAX80
	LD	HL,FDCCMD	;point to FDC
	DI			;must disable for xfer
	LD	A,(WRTYPE)	;get type of write
;m*
	IF	MAX80
	CPL			;reverse bits
	ENDIF
;m*
	LD	(HL),A		;issue write command
	PUSH	DE		;save track/sector
	LD	DE,FDCDAT	;data transfer address
	CALL	WXFER		;write data to the disk
	POP	DE		;restore track/sector
	ENDIF
;i*
;iii*
	IF	MODIII
	CALL	SETNMI		;setup NMI return
	LD	A,(WRTYPE)	;write type
	OUT	(FDCCMD),A	;give to FDC
	CALL	WXFER		;transfer the bytes
	ENDIF
;iii*
	AND	0FFH		;any errors?
	RET			;return the status
;
	PAGE
;
;	$SEEK	- move head on drive to desired track
;
;	ENT	D  = track to seek
;
;	EXT	Z = OK
;		NZ = A = FDC status byte
;
;		FDC sector register also loaded
;
SEEK	CALL	SELECT		;select drive
	RET	NZ		;error, return
;
	LD	A,(IY+4)	;get current track
	OR	A		;on track 0?
	JR	NZ,SEKCNT	;continue if not
;
	CALL	RESTORE		;restore drive to trk 0
	RET	NZ		;not in system
	XOR	A		;set track 0
;i*
	IF	MODI
SEKCNT	LD	(FDCTRK),A	;give to FDC track reg
	LD	A,D		;desired track
	LD	(FDCDAT),A	;desired relative track
	LD	A,E		;get desired sector
	LD	(FDCSEC),A	;give to FDC sect reg
	ENDIF
;i*
	IF	MAX80
SEKCNT	CPL			;reverse bits
	LD	(FDCTRK),A	;to FDC track register
	LD	A,D		;desired track
	CPL			;reverse
	LD	(FDCDAT),A	;to FDC data register
	LD	A,E		;get sector
	CPL			;reverse bits
	LD	(FDCSEC),A	;to sector register
	ENDIF
;m*
;iii*
	IF	MODIII
SEKCNT	OUT	(FDCTRK),A	;give to FDC track reg
	LD	A,D		;get track desired
	OUT	(FDCDAT),A	;desired relative track
	LD	A,E		;get sector
	OUT	(FDCSEC),A	;set sector
	ENDIF
;iii*
	JP	DOSEEK		;move the head!
;
	PAGE
;
;	$SELECT	- select a disk drive
;
;	ENT	(DRIVE)
;
;	EXT	Z = drive on and ready to go
;		NZ = don't access, A = error status
;
SELECT	EQU	$
;i*
	IF	MODI
	LD	A,(FDCSTA)	;read FDC status
	ENDIF
;i*
;m*
	IF	MAX80
	LD	A,(RDINT)	;read status
	RLCA			;move bit 5 -> 7
	RLCA
	CPL			;reverse bit 7
	ENDIF
;m*
;iii*
	IF	MODIII
	IN	A,(FDCSTA)	;FDC status III
	ENDIF
;iii*
	AND	80H		;check for motor on
	CALL	RESELEC		;select drive
	RET	Z		;return if motor on
;
;	motor was not on at beginning of command
;
	PUSH	BC		;save it
	LD	BC,0		;one second count
	CALL	DELAY		;countdown till BC=0
	POP	BC		;restore
	JR	SELECT		;see if ready now
;
;	short wait for FDC to place valid status
;	on the bus after a command has been
;	issued to it
;
DSKSLO	PUSH	AF		;save accum
;
	IF	MODI
	LD	A,10		;delay mod I
	ENDIF
	IF	MODIII
	LD	A,13		;delay mod III
	ENDIF
	IF	MAX80
	LD	A,32		;delay max
	ENDIF
;
DSKSLOO	DEC	A		;less count
	JR	NZ,DSKSLOO	;wait for delay
	POP	AF		;restore AF
	RET			;done
;
	PAGE
;
;	$DELAY	- countdown BC till zero
;
;	ENT	BC = value to decrement
;
;	EXT	BC = 0
;
;	NOTE	if high speed clock set, then the
;		delay is actually doubled to adjust
;
;	A is preserved
;
DELAY	DEC	BC		;decrement once
	LD	A,B		;check for zero
	OR	C		;any bits on?
	RET	Z		;done!
;m*
	IF	MAX80
	EX	(SP),HL		;adjust for quick MAX
	EX	(SP),HL
	ENDIF
;m*
;iii*
	IF	MODIII
	LD	A,A		;adjust for mod III speed
	ENDIF
;iii*
	JR	DELAY		;continue
;
	PAGE
;
;	$RESTORE - move a drive head to track 0
;
;	ENT	(DRIVE) setup
;
;	EXT	Z = drive ready, head at track 0
;		NZ = A = error status
;
RESTORE	LD	A,0BH		;slow restore command
	CALL	MOVCOMM		;common head mover
	RET	NZ		;error, return NZ
;i*
	IF	MODI
	LD	A,(FDCSTA)	;fetch the FDC status
	ENDIF
;i*
;m*
	IF	MAX80
	LD	A,(FDCSTA)	;read status
	CPL			;reverse bits
	ENDIF
;m*
;iii*
	IF	MODIII
	IN	A,(FDCSTA)	;FDC status III
	ENDIF
;iii*
	CPL			;reverse the bits
	RRCA			;align for special code
	AND	2		;check for head over 00
	RET			;return NZ
;
;	common head move subroutine, A = command
;
MOVCOMM	PUSH	AF		;save command
	CALL	RESELEC		;turn on drive
	POP	AF		;get disk command
	CALL	MOVHEAD		;move the head to track
	JP	Z,IOCOMM	;no error, update track
;
;	seek error, force a $RESTORE next access
;
SKERR	LD	(IY+4),0	;set curr track to 0
	RET			;ret NZ flag
;
;	issue head motion command to FDC and wait
;
MOVHEAD	EQU	$
;i*
	IF	MODI
	LD	(FDCCMD),A	;give to FDC I
	ENDIF
;i*
;m*
	IF	MAX80
	CPL			;reverse bits
	LD	(FDCCMD),A	;to command register
	ENDIF
;m*
;iii*
	IF	MODIII
	OUT	(FDCCMD),A	;give to FDC III
	ENDIF
;iii*
	CALL	DSKSLO		;wait for valid status
;
MOVWT	CALL	RESELEC		;prevent time-out
;i*
	IF	MODI
	LD	A,(FDCSTA)	;fetch status byte I
	ENDIF
;i*
;m*
	IF	MAX80
	LD	A,(FDCSTA)	;read status reg
	CPL			;reverse bits
	ENDIF
;m*
;iii*
	IF	MODIII
	IN	A,(FDCSTA)	;fetch status III
	ENDIF
;iii*
	BIT	0,A		;command finished?
	JR	NZ,MOVWT	;wait some more if not
;
	AND	18H		;check NF and CRC
	RET			;done, NZ = error
;
	PAGE
;
;	$STEPIN	- step in the head one track
;
STEPIN	LD	A,5BH		;slow step in command
	JR	MOVCOMM		;go common sub
;
;	execute actual seek command here
;
DOSEEK	LD	A,1BH		;slow seek command
	CALL	MOVCOMM		;move the head
	RET	NZ		;error, return
;
	LD	A,D		;fetch track
;i*
	IF	MODI
	LD	(FDCTRK),A	;give to FDC track reg
	ENDIF
;i*
;m*
	IF	MAX80
	CPL			;reverse bits
	LD	(FDCTRK),A	;to fdc track register
	ENDIF
;m*
;iii*
	IF	MODIII
	OUT	(FDCTRK),A	;FDC track reg III
	ENDIF
;
	RET			;done, FDC updated
;
	PAGE
;
;	$SETNMI	- setup for non-maskable disk interrupts
;
;	ENT	BC = disk buffer
;		DE = track sector
;
;	EXT	NMI set for I/O
;		HL = buffer address
;
;	NOTE	this if for the Mod III ONLY!
;
;iii*
	IF	MODIII
SETNMI	LD	(BUFPAS),BC	;save buffer pointer
	LD	(SECPAS),DE	;save track/sector
;
	LD	HL,NMIRET	;non-maskable return
	LD	(404AH),HL	;set NMI vector
;
	LD	H,B		;pass buffer to HL
	LD	L,C
;
	LD	A,(IY+5)	;get drive bits
	AND	0FH		;mask low bits
	LD	C,A		;save it here
;
;	check for double density
;
	LD	A,(FLAGB)	;get system flag B
	BIT	4,A		;double den available?
	JR	NZ,GETNMIB	;go if none
;
	BIT	7,(IY+1)	;double den disk?
	JR	Z,GETNMIB	;go if not
;
SETNMIP	SET	7,C		;double den bit
;
;	check for write pre-comp
;
GETNMIB	LD	A,D		;check track?
	CP	16H		;for write pre-comp
	JR	C,GETNMIC	;go if below
;
	SET	5,C		;set write pre-comp
;
;	save resulting byte
;
GETNMIC	LD	A,C		;get result
	LD	(IY+5),A	;setup for drive select
	OUT	(FDCSEL),A	;give to FDC select
;
;	setup registers for I/O
;
	OR	40H		;set wait states
	LD	D,A		;pass here
	LD	BC,00F3H	;B=counter, C=xfer port
	LD	E,2		;for bit 1 test on I/O
;
	LD	A,0C0H		;activate nmi
	OUT	(0E4H),A	;ON!
;
	IN	A,(FDCSTA)	;clear FDC status reg.
	DI			;disable for transfer
	RET			;done!
;
;	return vector for NMI interrupt on disk I/O
;
NMIRET	XOR	A		;disable NMI
	OUT	(0E4H),A	;OFF!
	LD	(TEMP08),HL	;save last byte address+1
	LD	HL,RETNMI	;point to RETN
	LD	(404AH),HL	;for non-disk NMI's
;
	POP	HL		;dummy to restore stack
	LD	BC,0		;restore buffer
BUFPAS	EQU	$-2
	LD	DE,0		;restore track/sector
SECPAS	EQU	$-2
	INC	B		;bump buffer pointer
;
	IN	A,(FDCSTA)	;read status
	LD	(RESULT),A	;save the direct result
;
	CALL	RESFDC		;reset FDC
	EI			;can enable now
	RET			;done, A = I/O status
	ENDIF
;iii*
;
RESELEC	LD	A,(IY+5)	;get bit pattern
;i/m*
	IF	MODI.OR.MAX80
	LD	(FDCSEL),A	;FDC select reg I
	ENDIF
;i/m*
;iii*
	IF	MODIII
	OUT	(FDCSEL),A	;FDC select reg III
	ENDIF
;iii*
	RET			;done
;
;	assure fdc READ/WRITE command is in range
;
FIXREAD	PUSH	BC		;save
	CALL	FIXSET		;get IBM flag in B
	LD	A,B		;get result
	OR	80H		;create command
	LD	(RDTYPE),A	;save it
	POP	BC		;unstack
	RET			;done
;
FIXWRIT	PUSH	BC		;save
	CALL	FIXSET		;get IBM flag in B
	LD	A,(WRTYPE)	;get write type
	AND	C		;set bit 1/0
	OR	B		;adjust it
	OR	0A0H		;create command
	LD	(WRTYPE),A	;save it
	POP	BC		;unstack
	RET			;done
;
FIXSET	EQU	$
;i*
	IF	MODI
	LD	BC,0803H	;B=IBM bit, C=AM bits
	BIT	7,(IY+1)	;double density disk?
	RET	Z		;nope, return
	ENDIF
;i*
FIXSETD	LD	BC,0001H	;B=IBM bit, C=AM bit
	RET			;done
;
