; idback/asm - kjw/bqsd - 05/83 - version 1.0
;
; revised 05/24/83 - dwh
;
	PAGE
;
;	$UCOPY - special disk copy entry
;
UCOPY	LD	HL,CARRET	;carriage return
	CALL	DISPLAY		;display it
	LD	HL,SMESG	;source message
	LD	IY,SDCT		;source DCT
	CALL	ONEDRIV		;fetch drive to copy
	LD	(IY+1),0	;single den/sides
;
;	fetch track count
;
	LD	HL,CARRET	;carriage return
	CALL	DISPLAY		;display it
;
GETTRK	LD	HL,TRKMSG	;'track count?'
	CALL	DISPLAY		;display it
	LD	B,2		;2 digit track count
	CALL	GETSTR		;get key input
	LD	(IY+0),35	;default
	JR	Z,HAVTRKS	;go if nil input
;
;	fetch input value
;
	EX	DE,HL		;DE => input
	LD	L,0		;init total
TRKLP	LD	A,(DE)		;get a char
	CP	CR		;term?
	JR	Z,SETTKS	;yes, go!
	SUB	'0'		;remove ascii
	JR	C,GETTRK	;invalid!
	CP	10		;0-9?
	JR	NC,GETTRK	;invalid!
	LD	H,A		;save new digit
	LD	A,L		;get subtotal
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,L		;*5
	ADD	A,A		;*10
	ADD	A,H		;add new digit
	LD	L,A		;update subtotal
	INC	DE		;bump string
	JR	TRKLP		;go next digit
;
SETTKS	LD	(IY+0),L	;update track count
HAVTRKS	CALL	DSTAT		;check if drive ready
	JP	NZ,ENTRY	;go if not ready!
	CALL	RESTORE		;move head to track 0
	JP	NZ,ENTRY	;go if not ready
	LD	HL,SCANMSG	;'scanning'
	CALL	DISPLAY		;to video
;
	XOR	A		;load zero
	LD	(TEMP01),A	;save current track
	LD	IX,DAMBUFF	;init table pointer
;
;	looper to build track images in memory
;
;	IX => beginning of current track information
;	DE => pointer for next sector information
;	IX+0 - # sectors defined single den curr track
;	IX+1 - # sectors defined double den curr track
;
;	data follows for each sector
;	+0 - track #
;	+1 - head #
;	+2 - sector #
;	+3 - sector length
;	+4	4 = ID crc error
;		3 = DATA crc error
;		1&0 - address mark
;
UTLOOP	CALL	PERIOD		;send period
	LD	(IX+0),0	;load 0 single den sects
	LD	(IX+1),0	;0 double den sectors
	PUSH	IX		;pass pointer to HL
	POP	DE		;DE => table beginning
	INC	DE		;bump by 2 bytes
	INC	DE		;DE => current sector loc
;
;	build table on current track
;
	LD	A,(IY+2)	;fetch flags
	AND	44H		;keep double step&8 only
	LD	(IY+2),A	;put it back
	LD	(TEMP02),DE	;save current table
;
UTLP1	LD	(IY+1),0	;single density disk
	CALL	UTLOOP1		;fetch single den data
	LD	A,(KBDR2)	;read keyboard
	AND	8		;'S' key?
	JR	NZ,UTLP1	;try more SD if yes
	LD	(TEMP02),DE	;save current table
	LD	A,(FLAGB)	;get system flag
	BIT	4,A		;double den available?
	JR	NZ,UTLP3	;nope, go!
;
UTLP2	LD	(IY+1),0C0H	;double den disk
	CALL	UTLOOP1		;fetch double den data
	LD	A,(KBDR0)	;read keyboard
	AND	10H		;'D' key?
	JR	NZ,UTLP2	;attempt more DD if yes
;
UTLP3	CALL	UCTBL		;advance table
;
;	check if more to do
;
	LD	A,(TEMP01)	;fetch track
	INC	A		;+1
	LD	(TEMP01),A	;reset it
	CP	(IY+0)		;end of disk?
	JP	Z,UTFMT		;go format/copy!
	CALL	STEPIN		;step in a track
	JR	UTLOOP		;go next track
;
;	scan track for readable ID marks
;
UTLOOP1	LD	HL,INPUT	;ID I/O buffer
	LD	B,6		;length
	XOR	A		;load zero
	CALL	FILL		;clear buffer
;i/m*
	IF	MODI.OR.MAX80
	CALL	SELDEN		;select correct doubler
	ENDIF
;i/m*
	CALL	ADDR		;attempt to read ID
	CALL	NZ,ADDR		;2 tries if bad
	JR	Z,UTLOOP2	;go if no error
;
;	check if data was actually read in from
;	a fake sector
;
	LD	BC,0600H	;B=counter, C=checksum
UTCK1	LD	A,(HL)		;fetch ID byte
	ADD	A,C		;add to checksum
	LD	C,A		;update
	INC	HL		;bump pointer
	DJNZ	UTCK1		;check 'em all
	RET	Z		;return if nil data
;
;	allow 50 attempts at locating each new sector
;
UTLOOP2	LD	A,50		;reset counter
	LD	(TEMP03),A	;save counter
;
UTLOOP3	LD	A,(KBDR6)	;scan keyboard
	AND	8		;up arrow?
	RET	NZ		;yes, skip this track
;
	CALL	ADDR		;read ID marks
;
;	have ID field, check if already found
;
UTLOOP4	LD	A,(KBDR6)	;check for clear key hold
	AND	2		;pressed?
	JR	NZ,UTLOOP4	;yes, hold right here!
;
	CALL	IFTHER		;new sector found?
	JR	Z,UTLOOP5	;yes, go!
;
;	current ID already logged into table
;
	LD	A,(TEMP03)	;fetch current attempt
	DEC	A		;less one
	LD	(TEMP03),A	;put it back
	JR	NZ,UTLOOP3	;go if more attempts left
	RET			;track found!
;
;	new sector found, log it in the table
;
UTLOOP5	LD	(TEMP04),DE	;save table pointer
	LD	HL,INPUT	;point to ID buffer
	LD	BC,4		;4 bytes to move in
	LDIR			;move it in!
;
;	read the sector to determine CRC types
;
	PUSH	DE		;save current table end
	EXX			;save registers
	LD	A,(INPUT)	;get track
	LD	D,A		;pass to D for pre-comp
;i*
	IF	MODI
	LD	(FDCTRK),A	;track register
	LD	(FDCDAT),A	;data register
	ENDIF
;i*
;m*
	IF	MAX80
	CPL			;reverse bits
	LD	(FDCTRK),A	;fdc track register
	LD	(FDCDAT),A	;fdc data register
	ENDIF
;m*
;iii*
	IF	MODIII
	OUT	(FDCTRK),A	;track register
	OUT	(FDCDAT),A	;data register
	ENDIF
;iii*
	LD	A,(INPUT+2)	;get sector
;i*
	IF	MODI
	LD	(FDCSEC),A	;sector register
	ENDIF
;i*
;m*
	IF	MAX80
	CPL			;reverse bits
	LD	(FDCSEC),A	;to FDC
	ENDIF
;m*
;iii*
	IF	MODIII
	OUT	(FDCSEC),A	;sector register
	ENDIF
;iii*
	RES	7,(IY+2)	;set READ operation
	CALL	SELECT		;select drive
	CALL	FIXSET		;fetch read type
	LD	A,B		;get IBM bit
	OR	80H		;create read command
	LD	(RDTYPE),A	;save type of read
	POP	BC		;fetch buffer address
;
	PUSH	BC		;leave for restore
	CALL	READ1X		;special reader
	POP	HL		;restore buffer
;i*
	IF	MODI
	JR	Z,SPRD1		;go if no error
	AND	18H		;check for CRC error only
	CP	8		;data CRC error?
	JR	NZ,SPRD1	;go if not
	LD	(VECTOR3),A	;save error bits
	EX	AF,AF'		;get DAM type
	LD	(VECTOR3+1),A	;save it too
	CALL	FIXSET		;fetch IBM bit back
	LD	A,(RDTYPE)	;fetch read type
	XOR	B		;reverse IBM bit if set
	LD	(RDTYPE),A	;put it back
	LD	B,H		;pass buffer back
	LD	C,L		;yes?
	CALL	SELECT		;re-select drive
	CALL	READ1X		;try other density
	JR	Z,SPRD1		;go if no error
	LD	A,(VECTOR3+1)	;fetch original DAM
	EX	AF,AF'		;save here
	LD	A,(VECTOR3)	;fetch original error
	ENDIF
;i*
SPRD1	EXX			;swap back
;
;	save condition flags
;
	AND	18H		;keep not found/CRC
	LD	B,A		;save it
	LD	A,(RDTYPE)	;get read type
	RRCA			;move bit 3 => 2
	AND	4		;save bit 2 only
	OR	B		;combine it
	LD	B,A		;re-save it
	EX	AF,AF'		;get DAM type
	AND	3		;keep low 3 bits
	OR	B		;combine it
	LD	(DE),A		;put in table
	INC	DE		;bump table
;
;	add this sector to table
;
	BIT	7,(IY+1)	;single den?
	JR	Z,UTADDS	;yes, go!
	INC	(IX+1)		;bump double den
	JR	UTADDD		;continue
UTADDS	INC	(IX+0)		;bump single den
UTADDD	JP	UTLOOP2		;try for another!
;
;	check if sector already logged in table
;
IFTHER	BIT	7,(IY+1)	;single den?
	LD	A,(IX+0)	;get # SD secs
	JR	Z,IFTHER1	;go if yes
	LD	A,(IX+1)	;get # DD secs
IFTHER1	OR	A		;anything here?
	RET	Z		;nope, must be new!
;
	LD	C,A		;C = # entries in table
	PUSH	DE		;save DE from test
	LD	DE,(TEMP02)	;get tables start
;
IFTHER2	LD	HL,INPUT	;start of new table
	LD	B,4		;go for 4 chars
;
IFTHER3	LD	A,(DE)		;get a byte
	CP	(HL)		;match?
	JR	NZ,IFTHER4	;nope, try next one
	INC	HL		;bump pointer
	INC	DE		;next
	DJNZ	IFTHER3		;go for length
;
	POP	DE		;unstack pointer
	OR	-1		;set already there!
	RET			;match found!, return
;
IFTHER4	INC	DE		;bump pointer
	DJNZ	IFTHER4		;go till next entry
	INC	DE		;+ 1 for flags
;
	DEC	C		;less this entry
	JR	NZ,IFTHER2	;go if more left
;
	POP	DE		;unstack
	XOR	A		;return Z for NEW
	RET			;done!
;
;	disk image created!
;
UTFMT	INC	D		;bump MSB
	LD	E,0		;next even page
	LD	(FMTBUFF),DE	;save for buffer
;
UTFMORE	LD	HL,CARRET	;linefeed
	CALL	DISPLAY		;to video
	LD	IY,DDCT		;dest DCT
	LD	HL,DMESG	;'dest drive?'
	CALL	ONEDRIV		;fetch drivespec
	LD	A,(SDCT)	;get track count
	LD	(IY+0),A	;save track count
	LD	A,(IY+2)	;get system flags
	AND	44H		;keep double step&8 only
	LD	(IY+2),A	;update DCT
;
	CALL	DRVSAME		;source & dest same?
	CALL	Z,DMOUNT	;yes, mount DEST disk
	CALL	DSTAT		;check disk status
	JR	NZ,UTFMORE	;go if drive not ready
	CALL	RESTORE		;move head to track 0
	JR	NZ,UTFMORE	;go if not in system
;
	XOR	A		;load zero
	LD	(TEMP01),A	;set current track
	LD	HL,FMTMSG	;'formatting'
	CALL	DISPLAY		;display
	LD	IX,DAMBUFF	;start of table
;
UTFMT1	CALL	PERIOD		;period to display
	LD	A,(IX+0)	;get SD sectors
	OR	(IX+1)		;with DD sectors
	JR	Z,UTFMT2	;go if nil cylinder
;
	PUSH	IY		;save DCT
	CALL	SPBUILD		;special builder
	POP	IY		;restore DCT
;
	CALL	SPFMT		;special formatter
UTFMT2	LD	A,(TEMP01)	;get current track
	INC	A		;bump it
	LD	(TEMP01),A	;update track
	CP	(IY+0)		;at disk end?
	JP	Z,UTCOPY	;go copy if done!
	PUSH	AF		;save track
	CALL	UCTBL		;advance table
	CALL	STEPIN		;move in one track
	POP	AF		;A = track
	JP	UTFMT1		;go next track
;
;	special build track routine
;
SPBUILD	PUSH	IX		;pass IX to IY
	POP	IY		;table start
	INC	IY		;bump past length bytes
	INC	IY		;2 of 'em
	LD	HL,(FMTBUFF)	;start of buffer
	CALL	CLRBUFF		;clear out buffer
;
	LD	BC,0		;reset byte count
	CALL	SBUILD		;build single density
	LD	(TEMP05),BC	;save byte count
	LD	(TEMP06),HL	;save DD buffer
	LD	BC,0		;reset counter
	CALL	DBUILD		;build double density
	LD	(TEMP07),BC	;save byte count
	RET			;done, track created!
;
;	build single density portion
;
SBUILD	LD	A,(IX+0)	;get # SD sectors
	OR	A		;anything?
	RET	Z		;nope, no data!
	LD	C,A		;pass # to C
	XOR	A		;allow multi length secs
	LD	DE,GAPSNG	;gaps for single den
	JR	SDBUILD		;go common
;
DBUILD	LD	A,(IX+1)	;get # DD sectors
	OR	A		;anything?
	RET	Z		;nope, done!
	LD	C,A		;pass # to C
	LD	A,-1		;sec len's mod 3
	LD	DE,GAPDBL	;gaps for double den
;
SDBUILD	LD	(TEMP09),HL	;save ptr to comp length
	LD	(LENFLAG),A	;pass length flag
	CALL	MOVEIN		;pre-index gap
	CALL	MOVEIN		;pre-index sync
	CALL	MOVEIN		;pre-index sync
	LD	(HL),0FCH	;index marker
	INC	HL		;bump buffer
	LD	(TEMP10),DE	;save table pointer
;
SDBLDLP	LD	DE,(TEMP10)	;get table for sectors
	CALL	MOVEIN		;pre-id gap
	CALL	MOVEIN		;pre-id sync
	CALL	MOVEIN		;pre-id sync
	LD	(HL),0FEH	;ID header
	INC	HL		;bump buffer
	LD	B,4		;4 bytes to move
;
SDLP0	LD	A,(IY)		;get table byte
	LD	(HL),A		;to buffer
	INC	IY		;bump table
	INC	HL		;bump buffer
	DJNZ	SDLP0		;continue
;
	LD	A,(IY+0)	;get CRC bits
	AND	18H		;check 4/3
	CP	18H		;ID error?
	LD	A,0F7H		;CRC generator
	JR	NZ,$+4		;go if no error
	LD	A,-1		;place false CRC
	LD	(HL),A		;to buffer
	INC	HL		;bump buffer
;
	CALL	MOVEIN		;pre-data gap
	CALL	MOVEIN		;pre-data sync
	CALL	MOVEIN		;pre-data sync
	LD	A,(IY+0)	;get CRC bits again
	AND	18H		;check 4/3
	CP	10H		;DATA error?
	JR	Z,SDSKP		;skip if yes!
;
	LD	A,(IY+0)	;get CRC again
	CPL			;reverse bits
	AND	3		;low 2 bits only
	OR	0F8H		;create proper header
	LD	(HL),A		;install header
	INC	HL		;bump it
	LD	A,(IY+0)	;get CRC again
	AND	18H		;check 4/3
	CP	8		;data CRC?
	JR	Z,SDSKP		;skip if yes!
;
;	fill data field
;
	PUSH	BC		;save sector counter
;i*
	IF	MODI
	CALL	FIXSET		;compute IBM bit
	LD	A,(IY+0)	;get from table
	ADD	A,A		;shift left one bit
	AND	8		;keep bit 3 only
	CP	B		;IBM flag correct?
	JR	Z,SPBLDOK	;yes, go!
;
;	non-ibm, compute length
;
	PUSH	HL		;save it
	LD	HL,16		;16 bytes / sector length
	LD	C,(IY-1)	;get length byte
	JR	SPBLDNI		;go non-ibm compute
	ENDIF
;i*
SPBLDOK	LD	BC,128		;length for 0
	LD	A,(IY-1)	;get length byte
	OR	A		;length = 0?
	JR	Z,SDHLN		;have length, go!
	LD	C,A		;pass to C
	LD	A,'$'		;get length flag
LENFLAG	EQU	$-1
	OR	A		;zero?
	JR	Z,LEN256	;yes, compute length
	LD	A,(IY-1)	;get length back
	AND	3		;3 only
	LD	BC,128		;length 0
	JR	Z,SDHLN		;go if yes
	LD	BC,256		;length 1
	DEC	A		;1?
	JR	Z,SDHLN		;go if yes
	LD	BC,512		;length 2
	DEC	A		;2?
	JR	Z,SDHLN		;go if yes
	LD	BC,1024		;length 3
	JR	SDHLN		;continue
;
LEN256	PUSH	HL		;save it
	LD	HL,256		;length *1
SPBLDNI	CALL	MULT		;HL = length
	LD	B,H		;pass to BC
	LD	C,L
	POP	HL		;restore buffer
SDHLN	LD	(HL),0		;load a zero
	INC	HL		;bump pointer
	DEC	BC		;less byte counter
	LD	A,B		;any more?
	OR	C
	JR	NZ,SDHLN	;go if yes
	POP	BC		;restore sector counter
	LD	(HL),0F7H	;install CRC
	INC	HL		;bump buffer
;
SDSKP	INC	IY		;bump pointer to next
	DEC	C		;less this sector
	JP	NZ,SDBLDLP	;go if more to do
	CALL	MOVEIN		;load gap
	LD	BC,(TEMP09)	;get buffer start
	PUSH	HL		;save buffer
	OR	A		;clear carry
	SBC	HL,BC		;HL = length
	LD	B,H		;pass to BC
	LD	C,L		;BC = byte count
	POP	HL		;restore buffer
	RET			;done!
;
;	gap tables for single/double density
;
GAPSNG	DEFB	16,0FFH		;pre-index gap
	DEFB	03,000H		;pre-index sync
	DEFB	03,000H		;pre-index sync
;
	DEFB	12,0FFH		;pre-id gap
	DEFB	03,000H		;pre-id sync
	DEFB	03,000H		;pre-id sync
;
	DEFB	10,0FFH		;pre-data gap
	DEFB	02,000H		;pre-data sync
	DEFB	02,000H		;pre-data sync
;
	DEFB	16,0FFH		;gap before double den
;
GAPDBL	DEFB	32,04EH		;pre-index gap
	DEFB	12,000H		;pre-index sync
	DEFB	03,0F6H		;pre-index sync
;
	DEFB	22,04EH		;pre-id gap
	DEFB	12,000H		;pre-id sync
	DEFB	03,0F5H		;pre-id sync
;
	DEFB	24,04EH		;pre-data gap
	DEFB	08,000H		;pre-data sync
	DEFB	03,0F5H		;pre-data sync
;
	DEFB	00,04EH		;post data gap
;
;	special write track code
;
;	ENT	(fmtbuff) = start of track image
;		(temp8)   = byte count for single den
;		(temp9)   = byte count for double den
;
SPFMT	CALL	SELECT		;select drive
	RET	NZ		;hardware error!
;
;iii*
	IF	MODIII
	LD	BC,(FMTBUFF)	;get data start
	LD	A,(TEMP01)	;get track
	LD	D,A		;save for pre-comp
	LD	(IY+1),0	;setup for single den
	CALL	SETNMI		;setup for NMI
	INC	E		;bump mask
	LD	BC,(TEMP05)	;get byte count
	LD	A,B		;anything single den?
	OR	C		;yes?
	JR	NZ,SPFM0	;yes, go!
	SET	7,D		;set double density
	LD	BC,(TEMP07)	;get double den bytes
	LD	A,D		;get command
	RES	6,A		;wait off
	OUT	(FDCSEL),A	;set double den!
SPFM0	LD	A,0F0H		;write track command
	OUT	(FDCCMD),A	;issue command
	CALL	DSKSLO		;wait for status
SPFM1	IN	A,(FDCCMD)	;read status
	AND	E		;bit 1 ready?
	JP	PO,SPFM1	;wait for ready
	LD	A,(HL)		;fetch byte from buffer
	OUT	(FDCDAT),A	;give to FDC
	INC	HL		;bump buffer
	DEC	BC		;less this byte
	DEC	E		;less mask
;
SPFM2	IN	A,(FDCCMD)	;read status
	AND	E		;bit 1 ready?
	JR	Z,SPFM2		;wait if not
	LD	A,(HL)		;get buffer byte
	OUT	(FDCDAT),A	;to FDC
	INC	HL		;bump buffer
	DEC	BC		;less this byte
;
SPFM3	LD	A,D		;get wait command
	OUT	(FDCSEL),A	;go wait states
	LD	A,(HL)		;fetch buffer byte
	OUT	(FDCDAT),A	;to controller
	INC	HL		;bump buffer
	DEC	BC		;less byte counter
	LD	A,B		;any more?
	OR	C
	JR	NZ,SPFM3	;go if more
	BIT	7,D		;double now?
	JR	NZ,SPFM5	;go if yes!
	LD	BC,(TEMP07)	;get double den bytes
	LD	A,B		;anything?
	OR	C		;any DD?
	JR	Z,SPFM5		;pad single density
	SET	7,D		;set double density
;
SPFM4	LD	A,D		;get wait command
	OUT	(FDCSEL),A	;to controller
	LD	A,(HL)		;get buffer byte
	OUT	(FDCDAT),A	;to controller
	INC	HL		;bump buffer
	DEC	BC		;less byte counter
	LD	A,B		;any more?
	OR	C
	JR	NZ,SPFM4	;go if yes
;
;	send zeroes in current density till interrupt
;
SPFM5	LD	A,D		;get wait command
	OUT	(FDCSEL),A	;to controller
	XOR	A		;load zero
	OUT	(FDCDAT),A	;data byte 0
	JR	SPFM5		;wait for interrupt!
	ENDIF
;iii*
;i/m*
	IF	MODI.OR.MAX80
	LD	(IY+1),0	;set single density
	CALL	SELDEN		;select chip
	LD	BC,(TEMP07)	;get # bytes DD
	LD	A,B		;anything?
	OR	C
	JR	Z,SPFM1		;go if nil
	LD	(IY+1),0C0H	;set double density
	CALL	SELDEN		;select chip
	LD	HL,(TEMP05)	;get # bytes SD
	LD	A,H		;anything?
	OR	L
	JR	Z,SPFM1		;go if nil!
;
;	since the mod I has 2 separate disk controllers
;	for single and double density, the procedure
;	is quite different.  In the Mod III, we can
;	change density in the middle of the write track
;	command due to the single FDC.  In the Mod I,
;	if we change controllers, the active command
;	is not passed to the new controller and must
;	be reset.  This means that we would overwrite
;	data onto the same portion of the track and
;	would not accomplish the dual track density.
;	Instead, we will compute the number of bytes
;	that are to be written out in single density,
;	and multiply that times the double density
;	compression ratio (1.8), and decrement our
;	buffer pointer by the corresponding amount.
;	Then we will write out the full track in
;	double density, of which the first portion of
;	the track will be dummy data.  Then we
;	will re-format the track in single density,
;	counting the bytes, and interrupt the controller
;	at the precise moment to preserve the
;	back half of the track which is our DD portion.
;
	LD	B,0		;BHL = # bytes
	LD	A,18		;multiply x 18
	CALL	TMULT		;BHLA = BHL x A
	LD	B,H
	LD	H,L
	LD	L,A
	LD	A,10		;divide / 10
	CALL	TDIVD		;BHL / A = BHL:A
	EX	DE,HL		;DE = length
	LD	HL,(TEMP06)	;get DD start
	OR	A		;clear carry flag
	SBC	HL,DE		;HL => dummy data
	LD	B,H		;pass to BC
	LD	C,L		;BC => buffer
;
	CALL	SPFM1A		;format double den
	LD	(IY+1),0	;set single den
	CALL	SELDEN		;select chip
	LD	BC,(TEMP05)	;get # SD bytes
	LD	DE,(FMTBUFF)	;start SD data
	LD	HL,FDCCMD	;FDC command reg
	CALL	SELECT		;re-select drive
	RET	NZ		;return if error
	LD	A,0F4H		;write track command
;m*
	IF	MAX80
	CPL			;reverse bits
	ENDIF
;m*
	LD	(HL),A		;give to FDC
	CALL	DSKSLO		;wait for status
SPFM2	LD	A,(HL)		;get status
;m*
	IF	MAX80
	CPL			;reverse status
	ENDIF
;m*
	BIT	1,A		;ready for byte?
	JR	Z,SPFM2		;wait if not!
	LD	A,(DE)		;get buffer byte
;m*
	IF	MAX80
	CPL			;reverse data
	ENDIF
;m*
	LD	(FDCDAT),A	;to FDC
	INC	DE		;bump buffer
	DEC	BC		;less byte count
	LD	A,B		;any more?
	OR	C		;yes?
	JR	NZ,SPFM2	;go if more
	JP	INTFDC		;immediate interrupt!
;
SPFM1	LD	BC,(FMTBUFF)	;get format buffer
SPFM1A	JP	WRITETR		;write track in full!
	ENDIF
;i*
;
;	perform actual sector transfer here
;
UTCOPY	LD	HL,COPYMSG	;'copying'
	CALL	DISPLAY		;to video
	LD	IX,DAMBUFF	;start of table
	XOR	A		;load zero
	LD	(TEMP01),A	;set current track
;
UTCOPY1	CALL	PERIOD		;period to display
	LD	IY,SDCT		;source DCT
	CALL	DRVSAME		;source/dest same drive?
	CALL	Z,SMOUNT	;yes, mount source disk
;
	LD	A,(TEMP01)	;get track
	LD	D,A		;pass to D
	CALL	SEEK		;move head to track
	LD	(IY+1),0	;set single density
	PUSH	IX		;pass IX to HL
	POP	HL		;HL => table
	INC	HL		;past two byte length
	INC	HL
	LD	A,(IX+0)	;get # SD sectors
	OR	A		;anything?
	LD	BC,(FMTBUFF)	;start of I/O buffer
	CALL	NZ,UTLOAD	;load sectors
	LD	(IY+1),0C0H	;set double density
	LD	A,(IX+1)	;get # DD sectors
	OR	A		;anything?
	CALL	NZ,UTLOAD	;load sectors
;
	LD	IY,DDCT		;dest DCT
	CALL	DRVSAME		;source/dest same?
	CALL	Z,DMOUNT	;mount dest disk
	LD	A,(TEMP01)	;get track
	LD	D,A		;pass for seek
	CALL	SEEK		;move head to track
	LD	(IY+1),0	;set single den
	PUSH	IX		;pass IX to HL
	POP	HL		;HL => table
	INC	HL		;bump past lengths
	INC	HL
	LD	A,(IX+0)	;get # SD secs
	OR	A		;anything?
	LD	BC,(FMTBUFF)	;start of buffer
	CALL	NZ,UTSAVE	;write buffer
	LD	(IY+1),0C0H	;set double density
	LD	A,(IX+1)	;get # DD secs
	OR	A		;anything?
	CALL	NZ,UTSAVE	;write if yes
;
	CALL	UCTBL		;bump table
	LD	A,(TEMP01)	;fetch current track
	INC	A		;+1
	LD	(TEMP01),A	;put it back
	CP	(IY+0)		;end of disk?
	JP	NZ,UTCOPY1	;go next track!
;
;	completed!
;
UTCOPYX	LD	HL,CMPMSG	;'completed'
	CALL	DISPLAY		;to video
;
UTCOPY2	LD	HL,ANOMSG	;'another copy?'
	CALL	DISPLAY		;display prompt
	LD	B,3		;3 char input
	CALL	GETSTR		;from keyboard
	JR	Z,UTCOPY2	;wait for input
	CP	'N'		;no?
	JP	Z,ENTRY		;nope, back to menu
	CP	'Y'		;yes?
	JR	NZ,UTCOPY2	;go if neither
	JP	UTFMORE		;go one more copy
;
;	compute offset to next table position
;
UCTBL	PUSH	HL		;save
	PUSH	DE		;save
	PUSH	BC		;save
	LD	L,(IX+0)	;get # single den
	LD	C,(IX+1)	;get # double den
	LD	H,0		;set MSB to 0
	LD	B,H		;both to 0
	ADD	HL,BC		;HL = # sectors
	LD	C,5		;5 bytes / sector
	CALL	MULT		;HL = table offset
	INC	HL		;+ 2 for length bytes
	INC	HL
	EX	DE,HL		;DE = offset
	ADD	IX,DE		;IX => next location
	POP	BC		;unstack
	POP	DE		;unstack
	POP	HL
	RET			;done, IX => next loc.
;
;	load track from special format
;
UTLOAD	LD	DE,READ1X	;read routine
	JR	UTLDSV		;go common
;
UTSAVE	LD	DE,WRITE1X	;special write
;
UTLDSV	LD	(UTSCALL),DE	;save vector
	LD	E,A		;pass # sectors
;
UTLDSVL	PUSH	DE		;save # sectors
	LD	A,(HL)		;get track
	LD	D,A		;pass to D
;i*
	IF	MODI
	LD	(FDCTRK),A	;to FDC track reg
	LD	(FDCDAT),A	;to FDC data register
	ENDIF
;i*
;m*
	IF	MAX80
	CPL			;reverse bits
	LD	(FDCTRK),A	;to fdc track reg
	LD	(FDCDAT),A	;to fdc data reg
	ENDIF
;m*
;iii*
	IF	MODIII
	OUT	(FDCTRK),A	;to FDC track reg
	OUT	(FDCDAT),A	;to FDC data register
	ENDIF
;iii*
	INC	HL		;bump table
	INC	HL		;twice
	LD	A,(HL)		;get sector
	LD	E,A		;pass to E
;i*
	IF	MODI
	LD	(FDCSEC),A	;to FDC sector reg
	ENDIF
;i*
;m*
	IF	MAX80
	CPL			;reverse bits
	LD	(FDCSEC),A	;to sector reg
	ENDIF
;m*
;iii*
	IF	MODIII
	OUT	(FDCSEC),A	;to FDC sector reg
	ENDIF
;iii*
	INC	HL		;bump table
	INC	HL		;twice to flags
	LD	A,(HL)		;get flags
	AND	18H		;check for errors
	JR	NZ,UTLDSVN	;go next sector if error
;
	PUSH	BC		;save it
	CALL	FIXSET		;load B with IBM bit
	LD	A,(HL)		;get flags again
	ADD	A,A		;shift left 1 bit
	AND	B		;combine with saved bit
	LD	B,A		;save temp
	OR	80H		;create read command
	LD	(RDTYPE),A	;save for read
	LD	A,(HL)		;fetch DAM marks
	AND	C		;mask with saved
	OR	B		;combine with IBM bit
	OR	0A0H		;create write command
	LD	(WRTYPE),A	;save for write
	POP	BC		;restore buffer
	CALL	SELECT		;select drive
;
	PUSH	HL		;save table
	CALL	$		;read/write no seek!
UTSCALL	EQU	$-2
	POP	HL		;restore table
	LD	BC,(TEMP08)	;get new buff pointer
;
UTLDSVN	POP	DE		;restore # sectors
	INC	HL		;bump table
	DEC	E		;less this sector
	JR	NZ,UTLDSVL	;go looper if more
	RET			;else buffer full/empty
;
PERIOD	PUSH	HL		;save all
	PUSH	DE
	PUSH	BC
	LD	HL,PERMSG
	CALL	DISPLAY
	POP	BC
	POP	DE
	POP	HL
	RET
;
CARRET	DEFB	LF
	DEFB	ETX
;
SMESG	DEFB	BOL
	DEFB	EOL
	DEFM	'Source Drive? '
	DEFB	ETX
;
DMESG	DEFB	BOL
	DEFB	EOL
	DEFM	'Destination Drive? '
	DEFB	ETX
;
SCANMSG	DEFB	LF
	DEFM	'Examining  '
	DEFB	ETX
;
FMTMSG	DEFB	LF
	DEFM	'Formatting '
	DEFB	ETX
;
COPYMSG	DEFB	LF
	DEFM	'Copying    '
	DEFB	ETX
;
CMPMSG	DEFB	LF
	DEFM	'Completed!'
	DEFB	LF
	DEFB	ETX
;
ANOMSG	DEFB	BOL
	DEFB	EOL
	DEFM	'Another Copy? '
	DEFB	ETX
;
TRKMSG	DEFB	BOL
	DEFB	EOL
	DEFM	'Diskette Track Count? '
	DEFB	ETX
;
PERMSG	DEFB	'.'
	DEFB	ETX
;
