; archutl3/asm - kjw/bqsd - version 0.00
;
; created 03/30/83 - kjw
; revised 03/30/83 - kjw
;
;	print/list index file
;
$PRINT	EQU	$
$LIST	EQU	$
	LD	BC,PRTREC	;bucket printer
	LD	(VECTOR),BC	;save sub vector
;
;	check for valid params
;
	LD	A,(IX+0)	;get field params
	BIT	0,A		;mask field?
	CALL	SETWILD		;setup wildmask
	JP	NZ,PERROR	;param error if bad
	LD	A,(IX+0)	;get field params back
	AND	6		;source/dest fields
	JP	Z,PERROR	;missing drive
	JP	PE,PERROR	;too much information!
;
;	fetch correct FCB pointer
;
	LD	DE,SFCB		;source file block
	BIT	2,A		;source field?
	JR	NZ,$+5		;go if yes
	LD	DE,DFCB		;dest file block
;
;	check drive number was issued
;
	LD	A,(DE)		;get user type flags
	AND	0E0H		;get flags
	CP	80H		;must be drive only
	JP	NZ,PERROR	;go param error if bad
;
	INC	DE		;bump pointer
	LD	A,(DE)		;get data
	CP	':'		;must be drive #
	JP	NZ,PERROR	;go param error if not
;
;	move user drive # into filespec
;
	INC	DE		;bump pointer
	LD	A,(DE)		;get drive # ascii
	LD	(INAMED),A	;save into text
;
;	check if two char drive #
;
	INC	DE		;bump pointer
	LD	A,(DE)		;get second char
	LD	BC,ETX<8+ETX	;load ETX chars
	CP	B		;done?
	JR	Z,$+3		;go if yes
	LD	C,A		;else pass to C
	LD	(INAMED+1),BC	;load remainder drive #
;
;	move filespec for index into FCB block
;
COMMON	LD	HL,INAME	;index filespec
	LD	DE,SFCB		;source file block
	LD	BC,50		;max length
	PUSH	DE		;save start
	LDIR			;move into FCB
	POP	DE		;restore start
	LD	HL,SBUFF	;use source buffer
	XOR	A		;use LRL 0
	CALL	@OPEN		;locate file
	JP	NZ,$ERROR	;go if error!
	CALL	@READ		;read first sector
	JP	NZ,$ERROR	;go if error
;
;	verify file header
;
	LD	HL,SBUFF	;source buffer
	LD	DE,HEADER	;header text
	LD	B,HEADERL	;header length
	CALL	@COMP		;compare strings
	JP	NZ,IERROR	;identity error!
;
;	check for nil file
;
	LD	IX,SBUFF	;point to buffer start
	LD	A,(IX+20H)	;get # entries
	OR	(IX+21H)
	OR	(IX+22H)	;= 000000H?
	JP	Z,NERROR	;nil file!
;
;	preserve bucket table, move to DBUFF
;
	LD	HL,SBUFF	;start I/O buffer
	LD	DE,DBUFF	;alt I/O buffer
	LD	BC,100H		;buffer length
	LDIR			;move it
;
;	setup loop to fetch filenames
;
	LD	IX,DBUFF	;start of table
	LD	BC,26<8+0	;B=counter, C=bucket #
;
PLOOP	PUSH	BC		;save counter/bucket
	CALL	PBUCKET		;print/copy current buckt
	POP	BC		;restore counter/pointer
	INC	C		;bump bucket #
	DJNZ	PLOOP		;finish loop
	LD	A,CR		;send final CR
	CALL	CHOUT		;send character
	JP	@EXIT		;exit program!@
;
;	setup wildmask
;
SETWILD	LD	HL,MFCB+1	;mask file block text
	LD	B,0		;command
	JP	NZ,@WILD	;setup and return
	LD	HL,ALLWILD	;all files
	JP	@WILD		;setup and return
;
PBUCKET	LD	B,C		;pass bucket #
	LD	C,8		;# bytes / entry
	LD	HL,DBUFF+30H	;start bucket table
	CALL	@POINT		;point to entry
	PUSH	HL		;pass to IY
	POP	IY		;IY => bucket index
;
;	check for nil bucket
;
	LD	A,(IY+0)	;get # entries in bucket
	OR	(IY+1)		;anything?
	RET	Z		;nope, done with it!
;
;	fetch starting thread record #
;
	LD	B,(IY+2)	;get start bucket
	LD	H,(IY+3)
	LD	L,(IY+4)
;
INDLOOP	CALL	READIND		;read index record
	RET	NZ		;go if error
	LD	B,3		;command #
	CALL	@WILD		;matching file?
	CALL	Z,$		;yes, print/copy
VECTOR	EQU	$-2
;
;	fetch next record address
;
	LD	B,(IY+13)	;get next record address
	LD	H,(IY+14)
	LD	L,(IY+15)
	LD	A,B		;check for terminator
	OR	H
	OR	L		;BHL = 000000H?
	JR	NZ,INDLOOP	;not done, continue
	RET			;else completed!
;
PRTREC	LD	DE,KEYBUFF	;use keyboard buffer
	LD	B,2		;command #
	CALL	@WILD		;combine into filespec
	EX	DE,HL		;HL => filespec
;
	CALL	SENDFIL		;send to video/printer
	LD	A,0		;get counter
FCOUNT	EQU	$-1
	INC	A		;bump counter
	LD	(FCOUNT),A	;update counter
	SUB	4		;4 across?
	RET	NZ		;nope, continue
	LD	(FCOUNT),A	;reset counter
	LD	A,CR		;send CR
	JP	CHOUT		;send character
;
;	send current file to video/printer
;
SENDFIL	LD	B,16		;# chars to send
SENLP	LD	A,(HL)		;get a char
	CP	ETX		;terminator?
	JR	Z,SENPAD	;yes, go!
	CALL	CHOUT		;send character
	INC	HL		;bump pointer
	DJNZ	SENLP		;for 16 chars max
	RET			;done!
;
SENPAD	LD	A,' '		;send pad
	CALL	CHOUT		;send character
	DJNZ	SENPAD		;complete padding
	RET			;done!
;
;	send character to video/printer
;
CHOUT	PUSH	AF		;save char
	LD	A,(LPARAM)	;list to video?
	INC	A		;FF?
	JR	NZ,CHOUT1	;nope, go!
	POP	AF		;get char
	PUSH	AF		;back to stack
	CALL	@VDCHAR		;char to video
;
CHOUT1	LD	A,(PPARAM)	;printer?
	INC	A		;FF?
	JR	NZ,CHOUT2	;nope, go!
	POP	AF		;get char
	PUSH	AF		;back to stack
	CALL	@PRCHAR		;char to printer
;
CHOUT2	POP	AF		;restore
	RET			;done!
;
;	read index record
;
READIND	LD	C,16		;# entries / sector
	CALL	@DIVID		;divide BHL / C
	LD	(INDOFF),A	;save remainder
	CALL	@INC		;skip header sector
	LD	IY,RPARAM	;record storage
	LD	(IY+0),B	;pass record #
	LD	(IY+1),H
	LD	(IY+2),L
	PUSH	IY		;pass to BC
	POP	BC		;BC => record
	LD	DE,SFCB		;file block
	CALL	@POSN		;position to record
	RET	NZ		;go if error
	CALL	@READ		;read the sector
	RET	NZ		;go if error
	LD	HL,0		;get index offset
INDOFF	EQU	$-2
	ADD	HL,HL		;*2
	ADD	HL,HL		;*4
	ADD	HL,HL		;*8
	ADD	HL,HL		;*16
	LD	BC,SBUFF	;start I/O buffer
	ADD	HL,BC		;HL => record
	PUSH	HL		;pass to IY
	POP	IY		;IY => record
	XOR	A		;return Z
	RET			;done!
;
;	copy files from drive to drive
;
$COPY	LD	A,(IX+0)	;get params
	BIT	0,A		;mask field?
	CALL	SETWILD		;setup wildmask
	JP	NZ,PERROR	;go param error if bad
	LD	A,(IX+0)	;get params back
	AND	6		;source/dest drives?
	CP	6		;both must be here
	JP	NZ,PERROR	;param error if not both
;
;	check for valid fields
;
	LD	HL,SFCB		;source file block
	LD	A,(HL)		;get source FCB flags
	AND	0E0H		;3 bits only
	CP	80H		;must be drive only
	JP	NZ,PERROR	;param error if not
	INC	HL		;bump to text
	LD	DE,SDRV		;save drive # here
	LD	BC,3		;3 chars max
	LDIR			;save 'em
;
	LD	HL,DFCB		;dest file block
	LD	A,(HL)		;get dest FCB flags
	AND	0E0H		;3 bits only
	CP	80H		;must be drive only
	JP	NZ,PERROR	;param error if not
	LD	DE,DDRV		;dest drive storage
	LD	BC,3		;max length
	INC	HL		;bump to text
	LDIR			;save drive #
;
	LD	IY,NPARAM	;index drive #
	XOR	A		;load zero
	CP	(IY+0)		;must be zero
	JP	NZ,PERROR	;param error
	CP	(IY+1)		;must be zero
	JP	NZ,PERROR	;param error if not
	LD	A,(IY+2)	;get drive #
	CP	'0'		;in range?
	JP	C,PERROR	;param error if not
	CP	'8'		;0-7?
	JP	NC,PERROR	;param error if not
;
	LD	(INAMED),A	;pass drive #
	LD	BC,ETX<8+ETX	;double terminator
	LD	(INAMED+1),BC	;to text
	LD	BC,COPYIT	;subroutine vector
	LD	(VECTOR),BC	;save vector
	JP	COMMON		;common action
;
;	copy current file
;
COPYIT	PUSH	HL		;save filespec
	CALL	MOUNT		;ask for disk mount
	CP	BREAK		;break key?
	JP	Z,@EXIT		;abort if yes
	POP	HL		;restore filespec
	CALL	@VDLINE		;display filespec
;
	LD	BC,SDRV		;source drive #
	LD	DE,SFCB		;source file block
	CALL	MOVNAME		;create filespec
	LD	BC,DDRV		;dest drive #
	LD	DE,DFCB		;dest file block
	CALL	MOVNAME		;create filespec
;
;	open source file
;
	LD	DE,SFCB		;source file block
	LD	HL,SBUFF	;I/O buffer
	XOR	A		;LRL
	CALL	@OPEN		;open file
	JR	NZ,COPYEND	;terminate on error
;
;	open dest file
;
	LD	DE,DFCB		;dest file block
	LD	HL,SBUFF	;same I/O buffer
	XOR	A		;LRL
	CALL	@INIT		;open/create file
	JR	NZ,COPYEND	;go on error
;
;	get LRL and EOFB from source and save
;
	LD	IX,SFCB		;source file block
;
	IF	TRS13
	SET	7,(IX+1)	;sector operations
	LD	A,(IX+8)	;get EOF byte
	LD	(EOFB),A	;save it
	LD	A,(IX+9)	;get LRL
	LD	(LRL),A		;save it
	ENDIF
;
	IF	TRS2
	SET	7,(IX+1)	;sector operations
	LD	A,(IX+14)	;EOFB
	LD	(EOFB),A	;save it
	LD	A,(IX+15)	;LRL
	LD	(LRL),A		;save it
	ENDIF
;
;	set sector operations/LRL=0 on dest FCB
;
	LD	IX,DFCB		;dest file block
;
	IF	TRS13
	SET	7,(IX+1)	;sector operations
	LD	(IX+9),0	;LRL = 0
	ENDIF
;
	IF	TRS2
	SET	7,(IX+1)	;sector operations
	LD	(IX+15),0	;LRL = 0
	ENDIF
;
;	setup loop to transfer file
;
COPYLP	LD	DE,SFCB		;source file block
	CALL	@READ		;read a record
	JR	NZ,COPYEN	;go if error
	LD	DE,DFCB		;dest file block
	CALL	@WRITE		;write a record
	JR	NZ,COPYEND	;go if error
	JR	COPYLP		;continue
;
COPYEN	CP	1CH		;end of file?
	JR	NZ,COPYEND	;go error if not!
;
;	reset EOFB and LRL and close file
;
	LD	IX,DFCB		;dest file block
	LD	BC,0		;get EOFB and LRL
EOFB	EQU	$-2
LRL	EQU	$-1
;
	IF	TRS13
	LD	(IX+8),C	;pass EOFB
	LD	(IX+9),B	;pass LRL
	ENDIF
;
	IF	TRS2
	LD	(IX+14),C	;pass EOFB
	LD	(IX+15),B	;pass LRL
	ENDIF
;
	LD	DE,DFCB		;dest file block
	CALL	@CLOSE		;close the file
	JR	NZ,COPYEND	;go if error
	LD	A,CR		;else send CR to video
	CALL	@VDCHAR		;display CR
	XOR	A		;return Z
	RET			;done!
;
;	error during file copy, abort!
;
COPYEND	CALL	@ERROR		;display error message
	XOR	A		;return Z
	RET			;done!
;
;	create source/dest filespecs
;
MOVNAME	PUSH	HL		;save name pointer
	PUSH	BC		;save drive text
;
MOVNLP	LD	A,(HL)		;get text byte
	CP	ETX		;terminator?
	JR	Z,MOVNDRV	;yes, move in drivespec
	LD	(DE),A		;load char to FCB
	INC	HL		;bump pointers
	INC	DE
	JR	MOVNLP		;continue
;
MOVNDRV	POP	HL		;get drive text
	LD	BC,3		;3 bytes to move max
	LDIR			;move to FCB + etx
	POP	HL		;restore pointer start
	RET			;done!
;
;	request a disk mount
;
MOUNT	LD	H,(IY+11)	;get disk number needed
	LD	L,(IY+12)
	LD	C,2		;convert precision
	LD	DE,MNTDISK	;text to place ascii
	CALL	@BINASC		;convert binary => ascii
;
MOUNTOF	LD	HL,CLRLIN	;clear current line
	JR	MOUNTFL		;display it
;
MOUNTON	LD	HL,MNTMSG	;mount text
;
MOUNTFL	CALL	@VDLINE		;display prompt
MOUNTWT	CALL	@KBCHAR		;scan keyboard
	JR	Z,MOUNTEN	;have one, go!
;
	LD	A,0		;get flash count
FCOUNT2	EQU	$-1
	DEC	A		;less pass
	LD	(FCOUNT2),A	;update count
	JR	NZ,MOUNTWT	;wait for delay
;
;	reverse screen display
;
	LD	A,0		;get flash code
FWHICH	EQU	$-1
	XOR	1		;reverse bit 0
	LD	(FWHICH),A	;update
	JR	Z,MOUNTON	;turn on prompt
	JR	MOUNTOF		;turn off prompt
;
MOUNTEN	CP	BREAK		;break key?
	JR	Z,MOUNTQ	;yes, quit!
	CP	CR		;carriage return?
	JR	NZ,MOUNTWT	;nope, wait more!
MOUNTQ	PUSH	AF		;save inkey
	LD	HL,CLRLIN	;clear line
	CALL	@VDLINE		;clear and return
	POP	AF		;restore inkey
	RET			;done!
;
