; archutl2/asm - kjw/bqsd - version 0.00
;
; created 03/30/83 - kjw
; revised 03/30/83 - kjw
;
;	$MULT	- triple precision multiply
;
;	ENT	BHL = multiplicand
;		C   = multiplier
;
;	EXIT	ABHL = result
;
@MULT	PUSH	IX		;save
	PUSH	DE		;save
;
	PUSH	BC		;save
	LD	A,C		;get multiplier
	LD	C,B		;pass MSB
	EX	DE,HL		;CDE = multiplicand
	LD	HL,0		;init MSB's
	LD	IX,0		;init LSB's
	LD	B,8		;multiplier precision
;
MULT1	ADD	IX,IX		;shift LSB's left
	ADC	HL,HL		;shift MSB's left
	RLCA			;catch overflow
	JR	NC,MULT2	;go if none
	PUSH	BC		;save count/MSB
	ADD	IX,DE		;result + multiplicand
	LD	B,0		;init MSB
	ADD	HL,BC		;catch overflow
	POP	BC		;restore
;
MULT2	DJNZ	MULT1		;for for precision
	POP	BC		;restore C register
	LD	A,H		;get MSB
	LD	B,L		;get NSB
	PUSH	IX		;pass LSB's to HL
	POP	HL		;ABHL = result
	POP	DE		;unstack
	POP	IX		;unstack
	RET			;done, C unchanged
;
	PAGE
;
;	$DIVID	- triple precision divide
;
;	ENT	BHL = dividend
;		C   = divisor
;
;	EXIT	BHL = result
;		A   = remainder
;
@DIVID	PUSH	DE		;save it
	LD	D,C		;D = divisor
	LD	E,24		;precision
	XOR	A		;init LSB bits
;
DIVD1	ADD	HL,HL		;shift dividend left
	RL	B		;shift dividend
	RLA			;shift low 8 bits
	JR	C,DIVD2		;go if overflow
	CP	D		;at divisor?
	JR	C,DIVD3		;go if not
;
DIVD2	SUB	D		;less divisor
	INC	L		;quotient +1
;
DIVD3	DEC	E		;less precision
	JR	NZ,DIVD1	;go for 24 bits
	POP	DE		;unstack
	RET			;BHL/A = result
;
	PAGE
;
;	$ADD	- triple precision addition (BHL=BHL+CDE)
;
;	ENT	BHL = factor 1
;		CDE = factor 2
;
;	EXIT	BHL = sum
;
@ADD	LD	A,L		;get LSB
	ADD	A,E		;add LSB
	LD	L,A		;update
	LD	A,H		;get NSB
	ADC	A,D		;add NSB
	LD	H,A		;update
	LD	A,B		;get MSB
	ADC	A,C		;add MSB
	LD	B,A		;update
	RET			;BHL = sum
;
	PAGE
;
;	$SUB	- triple precision subtract (BHL=BHL-CDE)
;
;	ENT	BHL = factor 1
;		CDE = factor 2
;
;	EXIT	BHL = difference
;
@SUB	LD	A,L		;get LSB
	SUB	E		;less LSB
	LD	L,A		;update
	LD	A,H		;get NSB
	SBC	A,D		;less NSB
	LD	H,A		;update
	LD	A,B		;get MSB
	SBC	A,C		;less MSB
	LD	B,A		;update
	RET			;BHL = difference
;
	PAGE
;
;	$INC	- triple precision increment (BHL=BHL+1)
;
;	ENT	BHL = value
;
;	EXIT	BHL = BHL +1
;
@INC	INC	L		;bump LSB
	RET	NZ		;not FF => 00
	INC	H		;bump NSB
	RET	NZ		;not FF => 00
	INC	B		;bump MSB
	RET			;BHL = BHL + 1
;
	PAGE
;
;	$DEC	- triple precision decrement (BHL=BHL-1)
;
;	ENT	BHL = value
;
;	EXIT	BHL = BHL -1
;
@DEC	LD	A,-1		;init for test
	DEC	L		;dec LSB
	CP	L		;00 => FF?
	RET	NZ		;go if not
	DEC	H		;dec NSB
	CP	H		;00 => FF?
	RET	NZ		;go if not
	DEC	B		;dec MSB
	RET			;BHL = BHL - 1
;
	PAGE
;
;	$CMP	- triple precision compare (BHL <> CDE)
;
;	ENT	BHL = source value
;		CDE = test value
;
;	EXIT	Z     = BHL = CDE
;		NZ/C  = BHL < CDE
;		NZ/NC = BHL > CDE
;
@CMP	LD	A,B		;get MSB
	CP	C		;compare
	RET	NZ		;go if not equal
	LD	A,H		;get NSB
	CP	D		;compare
	RET	NZ		;go if not equal
	LD	A,L		;get LSB
	CP	E		;compare
	RET			;return with status
;
	PAGE
;
;	$BINASC	- convert binary => ascii string
;
;	ENT	DE => string to place ascii
;		C  = precision
;			1 = L   = value, DE => 3 digits
;			2 = HL  = value, DE => 5 digits
;			3 = BHL = value, DE => 8 digits
;
;	EXIT	string loaded with decimal ascii chars
;
@BINASC	CALL	@SAVREG		;save registers
	PUSH	DE		;pass DE => IX
	POP	IX		;IX => string start
	LD	A,C		;get precision
	LD	IY,TENTBL3	;lookup table for places
	CP	3		;3 bytes?
	JR	Z,BINASC1	;go if yes!
	LD	B,0		;init MSB to nil
	LD	IY,TENTBL2	;2 digits
	CP	2		;2 bytes?
	JR	Z,BINASC1	;yes, go!
	LD	H,B		;init NSB to nil
	LD	IY,TENTBL1	;1 digit
;
BINASC1	LD	(IX+0),'0'	;init digit
	LD	C,(IY+0)	;get MSB
	LD	D,(IY+1)	;get NSB
	LD	E,(IY+2)	;get LSB
;
BINASC2	CALL	@SUB		;subtract CDE from BHL
	JR	C,BINASC3	;go if digit found
	INC	(IX+0)		;bump ascii digit
	JR	BINASC2		;continue
;
BINASC3	CALL	@ADD		;add last subtract
	INC	IX		;bump string
	INC	IY		;bump table
	INC	IY		;3 bytes each entry
	INC	IY
	DEC	E		;at end?
	JR	NZ,BINASC1	;nope, go for length!
	RET			;done!
;
TENTBL3	DEFB	098H,096H,080H	;10,000,000
	DEFB	00FH,042H,040H	;1,000,000
	DEFB	001H,086H,0A0H	;100,000
TENTBL2	DEFB	000H,027H,010H	;10,000
	DEFB	000H,003H,0E8H	;1,000
TENTBL1	DEFB	000H,000H,064H	;100
	DEFB	000H,000H,00AH	;10
	DEFB	000H,000H,001H	;1
;
	PAGE
;
;	$VALUE	- fetch numeric value from user string
;
;	ENT	HL => string to parse
;
;	EXIT	NZ = A = FFH (invalid characters found)
;		Z  = OK &
;		B  = precision of value
;			0 =       value, CDE = 000000H
;			1 = E   = value, CD = 0000H
;			2 = DE  = value, C = 00H
;			3 = CDE = value
;		HL => terminating character
;
;	NOTE:	HEX/OCTAL/DECIMAL/BINARY may all be
;			interpreted by appending
;			H/O or Q/D/B to the number
;		default base is DECIMAL
;		case is independent
;
@VALUE	PUSH	HL		;save input pointer
	CALL	POSEND		;find last valid char
;
	LD	HL,ADDHEX	;HEX adder
	LD	B,16		;base
	CP	'H'		;hex?
	JR	Z,GOVAL		;yes, go!
;
	LD	HL,ADDOCT	;OCTAL adder
	LD	B,8		;base
	CP	'O'		;octal?
	JR	Z,GOVAL		;yes, go!
	CP	'Q'		;octal?
	JR	Z,GOVAL		;yes, go!
;
	LD	HL,ADDBIN	;BINARY adder
	LD	B,2		;base
	CP	'B'		;binary?
	JR	Z,GOVAL		;yes, go!
;
	LD	HL,ADDDEC	;DECIMAL adder
	LD	B,10		;base
	CP	'D'		;decimal?
	JR	Z,GOVAL		;yes, go!
	XOR	A		;default decimal
;
GOVAL	LD	(ADDCALL),HL	;pass call vector
	LD	(ADDTERM),A	;pass term character
	LD	A,B		;get base
	LD	(ADDMAX),A	;for max digit test
	POP	HL		;restore string start
	LD	C,0		;init MSB
	LD	D,C		;init NSB
	LD	E,C		;init LSB
;
;	loop to evaluate numeric input
;
VALLP	LD	A,(HL)		;get string char
	CALL	@UCASE		;make upper case
	CALL	CKTERM		;terminator?
	JR	Z,VALOK		;yes, go!
	INC	HL		;bump string pointer
	CP	'$'		;base specifier?
ADDTERM	EQU	$-1
	JR	Z,VALOK		;yes, go!
	CP	' '		;space?
	JR	Z,VALOK		;yes, go!
	CP	','		;comma?
	JR	Z,VALOK		;yes, go!
	CP	')'		;terminator?
	JR	Z,VALOK		;yes, go!
;
;	convert character
;
	CALL	CONVCHR		;convert to binary
	RET	NZ		;error! invalid char!
	EX	DE,HL		;HL = subtotal
	LD	B,A		;save new digit
	LD	A,C		;get MSB
	CALL	$		;multiply times base
ADDCALL	EQU	$-2
	LD	C,B		;pass new digit
	LD	B,0		;BC = new digit
	ADD	HL,BC		;add new digit
	ADC	A,0		;catch overflow
	LD	C,A		;update MSB
	EX	DE,HL		;DE=NSB/LSB - HL=>string
	JR	VALLP		;go next character
;
VALOK	LD	B,3		;precision
	INC	C		;C = 0?
	DEC	C		;yes?
	JR	NZ,VALRET	;nope, precision CDE
	DEC	B		;precision
	INC	D		;D = 0?
	DEC	D		;yes?
	JR	NZ,VALRET	;nope, precision DE
	DEC	B		;precision
	INC	E		;E = 0?
	DEC	E		;yes?
	JR	NZ,VALRET	;nope, precision E
	DEC	B		;precision 000000H!
VALRET	XOR	A		;return Z
	RET			;done!
;
;	digit to binary conversion
;
CONVCHR	SUB	'0'		;remove ascii
	JR	C,CHBAD		;go if <'0'
	CP	10		;0-9?
	JR	C,CHOK		;yes, go!
	CP	17		;between 9&A?
	JR	C,CHBAD		;yes, invalid!
	SUB	7		;A-F?
CHOK	CP	'$'		;test to base
ADDMAX	EQU	$-1
	JR	NC,CHBAD	;>= base
	CP	A		;set Z flag
	RET			;done!
CHBAD	OR	-1		;set NZ error
	RET			;return
;
;	hex/octal adder
;
ADDHEX	ADD	HL,HL		;*02
	RLA			;catch carry
ADDOCT	ADD	HL,HL		;*04 - *02
	RLA			;catch carry
	ADD	HL,HL		;*08 - *04
	RLA			;catch carry
	ADD	HL,HL		;*16 - *08
	RLA			;catch carry
	RET			;HL = HL * 16/08
;
;	decimal/binary adder
;
ADDDEC	LD	(ADDECX),A	;save current MSB
	PUSH	BC		;save
	LD	B,H		;pass current NSB
	LD	C,L		;pass current LSB
	ADD	HL,HL		;*02
	RLA			;catch carry
	ADD	HL,HL		;*04
	RLA			;catch carry
	ADD	HL,BC		;*05
	ADC	A,'$'
ADDECX	EQU	$-1
	POP	BC		;restore BC
ADDBIN	ADD	HL,HL		;*10 - *02
	RLA			;catch carry
	RET			;done
;
;	position to last char for base specifier
;
	INC	HL		;bump pointer
POSEND	LD	A,(HL)		;get a char
	CALL	CKTERM		;terminator?
	JR	Z,POSHAV	;have it, go!
	CP	' '		;space?
	JR	Z,POSHAV	;yes, go!
	CP	','		;comma?
	JR	NZ,POSEND-1	;go next char if none
POSHAV	DEC	HL		;last valid char
	LD	A,(HL)		;get the char
	JP	@UCASE		;make upper case for test
;
